/*	$OpenBSD: lgamma.c,v 1.1 2009/04/09 01:24:43 martynas Exp $	*/

/*
 * Copyright (c) 2009 Gaston H. Gonnet <gonnet@inf.ethz.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* This program was generated automatically by a program written
   by Gaston H. Gonnet on enigma on 2002-09-01 17:37:23.
   Do not edit, rerun the original maple program.       */
#include "header.h"
#define DBL_MAX_EXP 1024
#define N 1408
#define F lgamma
#define Fs "lgamma"
#define Fn fpaccuracy_lgamma
  /* 11 candidate values discarded */

static struct input_point { double arg_m, val, eps;
	int arg_e, val_e; } input_points[N] = {
 -8787764928624815.,-6199130211160873.,-.499988260571891090812,-51,53,
 -8787764928623695.,-6199130211198751.,-.499886396977245306543,-51,53,
 -8787764928622575.,-6199130211236629.,-.499784291768512373489,-51,53,
 -8787764928622392.,-6199130211242818.,-.494410442685364545824,-51,53,
 -8787764928622381.,-6199130211243191.,.489519133148102590862,-51,53,
 -8787764928622370.,-6199130211243563.,.473448709004875933340,-51,53,
 -8787764928566198.,-6199130213143279.,-.499689626081508382529,-51,53,
 -8567486922694173.,-5365318438847499.,.224189532076725135996,-51,52,
 -8567486922694172.,-5365318438847505.,.224194461750600391370,-51,52,
 -8567486922694037.,-5365318438848315.,.224859967964672563472,-51,52,
 -8567486922683235.,-5365318438913127.,.278111874647707069005,-51,52,
 -8567486922640435.,-5365318439169927.,.489138238296558763660,-51,52,
 -8567486922638247.,-5365318439183055.,.499927513168590592431,-51,52,
 -8567486922638224.,-5365318439183192.,-.499959070569046434817,-51,52,
 -8532219487114820.,-5561324781015164.,-.499779397272539523729,-51,52,
 -8532219487114679.,-5561324781015888.,-.498961990412848858302,-51,52,
 -8532219487114538.,-5561324781016612.,-.498144583096814438597,-51,52,
 -8532219487113640.,-5561324781021224.,.499969128106396028963,-51,52,
 -8532219487050024.,-5561324781347875.,-.499981707112137925951,-51,52,
 -8454022241316495.,-5898533165362690.,-.499964904416217047939,-51,52,
 -8454022241314166.,-5898533165370974.,.497617538094342070007,-51,52,
 -8454022241314042.,-5898533165371415.,.496200719366012568954,-51,52,
 -8454022241314033.,-5898533165371447.,.488033369630264156172,-51,52,
 -8454022241314024.,-5898533165371479.,.479866019895958801955,-51,52,
 -8454022241313679.,-5898533165372705.,-.499882385497840625482,-51,52,
 -8454022241304496.,-5898533165405364.,-.499967422719389211538,-51,52,
 -8454022241208504.,-5898533165746756.,-.499895228788649921173,-51,52,
 -8261235592148156.,-6301586989454378.,.499977008387054434434,-51,52,
 -8261235592143824.,-6301586989457938.,-.499801250003975668766,-51,52,
 -8261235592143161.,-6301586989458484.,.499540185277169627999,-51,52,
 -8261235592143043.,-6301586989458580.,-.499068729177633713053,-51,52,
 -8261235592142998.,-6301586989458617.,-.490063654139172487827,-51,52,
 -8261235592134497.,-6301586989465606.,.499984385970786922254,-51,52,
 -8261235592107179.,-6301586989488061.,-.499994386330877791839,-51,52,
 -7999612650156464.,-6163791505687222.,-.499992307396114301260,-51,52,
 -7999612650131380.,-6163791505643148.,-.499988723902149819431,-51,52,
 -7999612650124613.,-6163791505631259.,.499933458131934930923,-51,52,
 -7999612650123699.,-6163791505629653.,.449383596036576249189,-51,52,
 -7999612650123691.,-6163791505629638.,-.494166074496388099141,-51,52,
 -7999612650123621.,-6163791505629516.,.499774308364173664394,-51,52,
 -7999612650118838.,-6163791505621111.,-.499984857862489644703,-51,52,
 -7983592410851888.,-6134517711035043.,-.499916382556730317019,-51,52,
 -7983592410851508.,-6134517711034322.,-.496313441924442676025,-51,52,
 -7983592410851498.,-6134517711034304.,.477465582846059162088,-51,52,
 -7983592410851469.,-6134517711034248.,-.498575245314549537908,-51,52,
 -7983592410851430.,-6134517711034175.,.499162951308619656043,-51,52,
 -7983592410849676.,-6134517711030846.,-.499996089401050354403,-51,52,
 -7935921591095382.,-6034207703920312.,-.499987041014892364774,-51,52,
 -7935921591049015.,-6034207703813203.,-.499990728167908821097,-51,52,
 -7935921591048257.,-6034207703811452.,-.499882799576735540300,-51,52,
 -7935921591046741.,-6034207703807950.,-.499666927574980348079,-51,52,
 -7318770392349995.,-5620385408500729.,-.499990232839502688554,-51,53,
 -7318770392329306.,-5620385408131419.,-.499984270568311789847,-51,53,
 -7318770392326663.,-5620385408084241.,.499969221586259360778,-51,53,
 -7318770392321377.,-5620385407989883.,.499876929975036204684,-51,53,
 -7318770392321303.,-5620385407988562.,.440473450338657486228,-51,53,
 -7318770392321290.,-5620385407988330.,.497605271503157027888,-51,53,
 -7104888953219483.,-6278374121690242.,-.499900361471716465007,-51,56,
 -7104888953202218.,-6278374117699426.,.498188913372985176840,-51,56,
 -7104888953202198.,-6278374117694802.,-.487622631317215056547,-51,56,
 -7104888953202145.,-6278374117682552.,.499976776482437140449,-51,56,
 -7079054564292958.,-5411280648184932.,-.286880141610978364033,-51,62,
 -7079054564197626.,-5411279130370438.,.492085474611223172177,-51,62,
 -7079054564197623.,-5411279130322673.,-.446686645996164475970,-51,62,
 -7079054564197609.,-5411279130099774.,-.494289869916843126833,-51,62,
 -7079054564197544.,-5411279129064887.,.498980996567741860813,-51,62,
 -7079054564197103.,-5411279122043570.,.499485492124891639137,-51,62,
 -7079054564196662.,-5411279115022253.,.499999107801051796723,-51,62,
 -7033805263259537.,5997748696204556.,.499980263150163458684,-51,55,
 -7033805263259278.,5997748696241719.,.489033376901559215105,-51,55,
 -7033805263259212.,5997748696251190.,-.405648063792226983527,-51,55,
 -7033805263259206.,5997748696252051.,-.486982740113747420858,-51,55,
 -7033805263257619.,5997748696479763.,.499995988407329526631,-51,55,
 -6989023373146411.,6484233875912770.,.499997470636171319888,-51,54,
 -6989023373137600.,6484233876658530.,-.499945611411776470099,-51,54,
 -6989023373137170.,6484233876694925.,-.497104793744292004084,-51,54,
 -6989023373136937.,6484233876714646.,-.483937533645109399229,-51,54,
 -6989023373136912.,6484233876716762.,-.495400272878041893170,-51,54,
 -6989023373135855.,6484233876806225.,.499955307358542021559,-51,54,
 -6989023373116488.,6484233878445440.,-.499928504102137750387,-51,54,
 -6704453698403246.,4562490354869916.,.499929278105675052346,-51,51,
 -6704453698402795.,4562490354850580.,-.498591675458912223902,-51,51,
 -6704453698402755.,4562490354848864.,.468280088855337832926,-51,51,
 -6704453698402731.,4562490354847835.,.448403148111221893872,-51,51,
 -6704453698402642.,4562490354844019.,.499692830554512205823,-51,51,
 -6704453698399171.,4562490354695197.,.499995814388673698407,-51,51,
 -6704453698382267.,4562490353970425.,-.499819504264660095906,-51,51,
 -6676877748528561.,7250706097980839.,-.499833445423211962974,-51,52,
 -6676877748507162.,7250706096811750.,-.498854185940538793336,-51,52,
 -6676877748507143.,7250706096810711.,.476426051357287826880,-51,52,
 -6676877748507132.,7250706096810111.,-.485253811138797170390,-51,52,
 -6676877748506797.,7250706096791808.,.499950418967681631797,-51,52,
 -6676877748505988.,7250706096747611.,-.499959026396790215166,-51,52,
 -6676877748495106.,7250706096153096.,-.499930420646367644884,-51,52,
 -6436965607800170.,6704597177794193.,-.499440241253227848952,-51,54,
 -6436965607800157.,6704597177793632.,.475556256995521172423,-51,54,
 -6436965607798090.,6704597177704588.,.499999884342961128473,-51,54,
 -6198632597789514.,5730520913361978.,-.499940229542432911572,-51,59,
 -6198632597785749.,5730520911421872.,.499680866471512095417,-51,59,
 -6198632597782737.,5730520909869788.,.499400694881976347681,-51,59,
 -6198632597782337.,5730520909663668.,.446244172145898974714,-51,59,
 -6198632597782334.,5730520909662123.,-.454154500415223059715,-51,59,
 -6198632597782114.,5730520909548757.,-.483390433067817693500,-51,59,
 -6198632597781994.,5730520909486921.,-.499337259548293976563,-51,59,
 -6095089651997760.,-4577238332220939.,-.499751361344027232280,-51,56,
 -6095089651963988.,-4577238333536002.,-.499971761417062654721,-51,56,
 -6095089651957118.,-4577238333803517.,.499954445488665053739,-51,56,
 -6095089651950529.,-4577238334060089.,.484463879164672927715,-51,56,
 -6095089651950512.,-4577238334060750.,-.486133064138985525757,-51,56,
 -6095089651950446.,-4577238334063320.,-.489627078724166466638,-51,56,
 -6095089651950248.,-4577238334071031.,.499890883185746764490,-51,56,
 -5543628548500060.,-8327741726048383.,-.499820764057166955247,-51,60,
 -5543628548487799.,-8327741716828666.,-.499824045856446224210,-51,60,
 -5543628548487357.,-8327741716496303.,.492841666116972449311,-51,60,
 -5543628548487335.,-8327741716479760.,.497001509166225347498,-51,60,
 -5543628548487313.,-8327741716463216.,-.498838646719458946701,-51,60,
 -5543628548485877.,-8327741715383410.,.499960754549283929263,-51,60,
 -5532727847747868.,-7411973986997344.,-.190468734239197544179,-51,92,
 -5532727847745645.,-6255817318422089.,-.118903703529426667249,-51,103,
 -5532727847745644.,4558830442637421.,-.171177461512801122604,-51,106,
 -5532727847745635.,7750111739887057.,-.424508400125741118686,-51,100,
 -5532727847745631.,5581473650881526.,-.160936626061717043470,-51,99,
 -5532727847744304.,8932587069970857.,-.253648435404406570639,-51,93,
 -5532727847738503.,5950035076783722.,.474426003094362931635,-51,90,
 -5144474452504162.,7609704634530249.,-.499990146378413213565,-51,54,
 -5144474452489804.,7609704634938321.,-.499585616401402937270,-51,54,
 -5144474452489785.,7609704634938861.,-.496241989384149683184,-51,54,
 -5144474452489735.,7609704634940282.,-.434811391872998682690,-51,54,
 -5144474452489728.,7609704634940481.,-.486211108210181504243,-51,54,
 -5144474452488909.,7609704634963758.,-.499977900576254766530,-51,54,
 -5012999668844666.,5946341991342440.,-.499970697097957388570,-51,53,
 -5012999668808972.,5946341992007538.,-.489971441076637962221,-51,53,
 -5012999668808552.,5946341992015364.,-.492206812147299510993,-51,53,
 -5012999668807142.,5946341992041637.,-.499711219852064087769,-51,53,
 -5012999668807082.,5946341992042754.,.499969445438204291256,-51,53,
 -5012999668800823.,5946341992159380.,.499991648229878672950,-51,53,
 -7917008035365318.,4661777562122917.,-.499999212612348377888,-52,52,
 -7917008035362698.,4661777562116420.,-.499897546971797070438,-52,52,
 -7917008035360866.,4661777562111877.,-.440284455482126108700,-52,52,
 -7917008035360845.,4661777562111824.,.484525519999450190131,-52,52,
 -7917008035360795.,4661777562111700.,.495977842582647504745,-52,52,
 -7917008035360770.,4661777562111639.,-.498295996121520219604,-52,52,
 -7917008035360078.,4661777562109923.,-.499795850332579356703,-52,52,
 -7709021669218857.,8469701007226454.,.499929160899447833707,-52,53,
 -7709021669218694.,8469701007225913.,-.499763483863387793162,-52,53,
 -7709021669217925.,8469701007223355.,.458741771225090963138,-52,53,
 -7709021669217919.,8469701007223336.,-.492167160448723076024,-52,53,
 -7709021669217879.,8469701007223203.,-.498226704934484390928,-52,53,
 -7709021669215557.,8469701007215482.,-.499983243458041641501,-52,53,
 -7709021669147235.,8469701006988301.,-.499971036668176163259,-52,53,
 -6796847593347915.,7691904369739798.,-.499977050408599818809,-52,53,
 -6796847593346177.,7691904369741942.,-.499826971649270605763,-52,53,
 -6796847593345308.,7691904369743014.,-.499751927546244405492,-52,53,
 -6796847593345278.,7691904369743051.,-.491694100881163828279,-52,53,
 -6796847593345265.,7691904369743067.,-.454869042658463438547,-52,53,
 -6796847593334636.,7691904369756179.,-.499980818433706795251,-52,53,
 -6796847593281520.,7691904369821703.,-.499988537761718988657,-52,53,
 -5808188779656299.,5553027521970149.,.499998791892271662160,-52,52,
 -5808188779627318.,5553027522058147.,.499990962744027385784,-52,52,
 -5808188779619956.,5553027522080502.,-.499941561244046497852,-52,52,
 -5808188779616742.,5553027522090260.,.499816288881575370369,-52,52,
 -5808188779616275.,5553027522091679.,-.499907754246672269813,-52,52,
 -5769709794848142.,5672415179569417.,-.499970251147321899297,-52,52,
 -5769709794842157.,5672415179588389.,-.499945460952768185658,-52,52,
 -5769709794739747.,5672415179913021.,-.499501580362226560570,-52,52,
 -5769709794717137.,5672415179984693.,-.499398566151427411209,-52,52,
 -5769709794716984.,5672415179985177.,.499098377717137045981,-52,52,
 -5769709794716931.,5672415179985346.,-.494886341054122303872,-52,52,
 -5769709794716913.,5672415179985403.,-.436239641766622444583,-52,52,
 -5149970467359138.,8593968521160231.,-.499913107351929242889,-52,52,
 -5149970467359136.,8593968521160245.,-.499448663329409490737,-52,52,
 -5149970467358900.,8593968521161897.,-.444644268351661016023,-52,52,
 -5149970467357691.,8593968521170360.,-.163887845130989783142,-52,52,
 -5149970467357614.,8593968521170899.,-.146006748959826491124,-52,52,
 -5149970467354832.,8593968521190374.,-.499965021142837407524,-52,52,
 -5149970467350526.,8593968521220516.,.499983276612641898344,-52,52,
 -5149970467294545.,8593968521612397.,-.499972933600296615649,-52,52,
 -5093673401579016.,9007199254545201.,-.000000399518942935178,-52,52,
 -5093673401561374.,9007199254681049.,-.000021082708345142625,-52,52,
 -5093673401553694.,9007199254740187.,.002465280016297885036,-52,52,
 -5093673401553654.,9007199254740495.,.012894898582183222510,-52,52,
 -5093673401553594.,9007199254740957.,.028539326471685344429,-52,52,
 -5093673401553590.,9007199254740988.,-.170417711667279085172,-52,52,
 -5093673401553589.,4503599627370498.,-.235078485600993148738,-52,51,
 -5093673401553587.,4503599627370505.,.465182254864319976016,-52,51,
 -5093673401552940.,4503599627372996.,.499531796816381101183,-52,51,
 -5093673401552553.,4503599627374486.,.499985079062129550749,-52,51,
 -5000432434638321.,4895414191545395.,.499999709464369033230,-52,51,
 -5000432434625343.,4895414191605031.,.499942498370300786310,-52,51,
 -5000432434622243.,4895414191619276.,.499158532841865520120,-52,51,
 -5000432434622206.,4895414191619447.,-.479883081683326743834,-52,51,
 -5000432434622201.,4895414191619469.,.495922105543988737118,-52,51,
 -5000432434621954.,4895414191620605.,-.499301645133157539320,-52,51,
 -5000432434619474.,4895414191632001.,-.499928745552000618204,-52,51,
 -4855233726016026.,5686119621942949.,-.499966526912948266736,-52,51,
 -4855233725966239.,5686119622267104.,-.499990212723134979407,-52,51,
 -4855233725965593.,5686119622271310.,-.499829533962578576025,-52,51,
 -4855233725962686.,5686119622290237.,-.499106383933577599509,-52,51,
 -4855233725962363.,5686119622292340.,-.499026024273133333230,-52,51,
 -4855233725962361.,5686119622292353.,-.477353700058692799708,-52,51,
 -8242701861728634.,5085176099818261.,-.499996864090108364654,-105,47,
 -8242701861719146.,5085176099818422.,.499953142118391522233,-105,47,
 -8242701861718736.,5085176099818430.,-.499627433072864362202,-105,47,
 -8242701861718033.,5085176099818442.,-.496469248582914677147,-105,47,
 -8242701861718032.,5085176099818442.,-.479395054863867077897,-105,47,
 -8242701861717916.,5085176099818444.,-.498788583454331508078,-105,47,
 -8242701861688105.,5085176099818953.,-.499999623998719968488,-105,47,
 -8178102513366467.,5086283426442688.,.499999401626001998527,-105,47,
 -8178102513319515.,5086283426443496.,.499965466886643061501,-105,47,
 -8178102513290693.,5086283426443992.,.499603864416677824770,-105,47,
 -8178102513290520.,5086283426443995.,.476771911149201924728,-105,47,
 -8178102513290519.,5086283426443995.,.493980975003147333812,-105,47,
 -8178102513290170.,5086283426444001.,.499944260030223623434,-105,47,
 -8003544517553229.,5089319929075037.,.499098043133833425533,-105,47,
 -8003544517553178.,5089319929075038.,.395902189144384314330,-105,47,
 -8003544517553172.,5089319929075039.,-.498591440736726970111,-105,47,
 -8003544517552774.,5089319929075045.,.499997777149734464717,-105,47,
 -6848882081873808.,5111246698737102.,.499990519432316571115,-105,47,
 -6848882081673798.,5111246698741212.,.499945235957423840643,-105,47,
 -6848882081660464.,5111246698741486.,.499942221326674079014,-105,47,
 -6848882081660318.,5111246698741490.,-.499907819178554767602,-105,47,
 -6848882081659442.,5111246698741508.,-.499008062208584787269,-105,47,
 -6848882081658566.,5111246698741526.,-.498108305236312418312,-105,47,
 -6848882081658564.,5111246698741526.,-.457010360585688157600,-105,47,
 -5840746347559651.,5133655885869901.,-.499998068541673856102,-105,47,
 -5840746347518067.,5133655885870902.,.499980621514314477292,-105,47,
 -5840746347517818.,5133655885870908.,.499836207670466532078,-105,47,
 -5840746347511427.,5133655885871062.,.496129585765903922735,-105,47,
 -5840746347509269.,5133655885871114.,.494877999186833722793,-105,47,
 -5840746347509188.,5133655885871116.,.446638250108011948652,-105,47,
 -5840746347509186.,5133655885871116.,.494829861241868543556,-105,47,
 -5301224375153929.,5147296272996242.,.491638482540691929451,-105,47,
 -5301224375153891.,5147296272996244.,-.499533333810281735791,-105,47,
 -5301224375153665.,5147296272996250.,-.499660452108028348581,-105,47,
 -5301224375153100.,5147296272996265.,-.499978247851275823165,-105,47,
 -5301224375105865.,5147296272997519.,-.499997856237210991872,-105,47,
 -4827510902874846.,5160470260926370.,.499796530443161788764,-105,47,
 -4827510902874264.,5160470260926387.,.466970685146326740944,-105,47,
 -4827510902874263.,5160470260926387.,.496123905343412977168,-105,47,
 -4827510902874160.,5160470260926390.,.498905585643327653015,-105,47,
 -4827510902872685.,5160470260926433.,.499905376353017281903,-105,47,
 -4827510902870524.,5160470260926497.,-.499985777708925686328,-105,47,
 -4827510902861537.,5160470260926759.,-.499995866048097115194,-105,47,
 -4508444030595058.,5170093736149651.,.499988306831076669913,-105,47,
 -4508444030595026.,5170093736149652.,.498913789061382431141,-105,47,
 -4508444030594674.,5170093736149663.,.487094093595213755592,-105,47,
 -4508444030594642.,5170093736149664.,.486019575825604598809,-105,47,
 -4508444030594640.,5170093736149665.,-.451547581534995738074,-105,47,
 -4508444030558763.,5170093736150785.,-.499999890207752046733,-105,47,
 -5441089836923577.,5241183041035887.,-.499995173913662261112,-106,47,
 -5441089836921180.,5241183041035949.,-.499960309844253100421,-106,47,
 -5441089836918783.,5241183041036011.,-.499925445747530646250,-106,47,
 -5441089836917855.,5241183041036035.,-.496574442869208448586,-106,47,
 -5441089836917739.,5241183041036038.,-.496155567509130323705,-106,47,
 -5441089836917738.,5241183041036038.,-.470289887549129372119,-106,47,
 -5137347928742250.,5249267340043155.,.487556757778637597406,-106,47,
 -5137347928742249.,5249267340043156.,-.485048273006228081122,-106,47,
 -5137347928742213.,5249267340043157.,-.498829381261388956694,-106,47,
 -5137347928741775.,5249267340043169.,-.499832865031959396082,-106,47,
 -5137347928741702.,5249267340043170.,.499999887673044990033,-106,47,
 -5130840493894316.,5249445724023085.,-.499876032967776098426,-106,47,
 -5130840493893915.,5249445724023095.,.499439361390531340065,-106,47,
 -5130840493893806.,5249445724023098.,.489278209233711132432,-106,47,
 -5130840493893804.,5249445724023099.,-.455862362365495984389,-106,47,
 -5130840493893769.,5249445724023100.,-.495822365351617067184,-106,47,
 -5130840493888410.,5249445724023247.,-.499983965349288964041,-106,47,
 -5130840493850422.,5249445724024288.,.499999084263789618043,-106,47,
 -5010504700979210.,5252785823751432.,.499989085685430900727,-106,47,
 -5010504700967141.,5252785823751771.,.499919897155809180506,-106,47,
 -5010504700963118.,5252785823751884.,.499896834494060270221,-106,47,
 -5010504700962584.,5252785823751899.,.499148061082692205466,-106,47,
 -5010504700961516.,5252785823751929.,.497650514264751760602,-106,47,
 -5010504700961447.,5252785823751931.,.435756009835722699873,-106,47,
 -5010504700961445.,5252785823751931.,.491932980721838197582,-106,47,
 -5010504700895083.,5252785823753796.,-.499996034735463927453,-106,47,
 -7922455085967750.,5383408490025783.,-.499142493669966917579,-108,47,
 -7922455085967694.,5383408490025783.,.495662685075413502808,-108,47,
 -7922455085967692.,5383408490025784.,-.468808558540822780697,-108,47,
 -7922455085967356.,5383408490025790.,-.499977486068391083840,-108,47,
 -7922455085902676.,5383408490026939.,-.499996030410628264798,-108,47,
 -5061503531606603.,5641567757920454.,.499994878075519718297,-110,47,
 -5061503531597576.,5641567757920705.,.499979260467408252934,-110,47,
 -5061503531596569.,5641567757920734.,-.499911702940239209147,-110,47,
 -5061503531596533.,5641567757920735.,-.498914756249644821206,-110,47,
 -5061503531596532.,5641567757920735.,-.471109285508239319911,-110,47,
 -4503599627370497.,6231120794008786.,.239723196303909676642,-1074,43,
 -4503599627370496.,6231120794008786.,.241676321303909676425,-1074,43,
 4503599627370496.,6231120794008786.,.241676321303909676425,-1074,43,
 4503599627370497.,6231120794008786.,.239723196303909676642,-1074,43,
 6842111560909733.,5501593067808421.,.499995928259869882738,-109,47,
 6842111560924804.,5501593067808111.,.499980857065232407076,-109,47,
 6842111560930249.,5501593067808000.,-.499891882641764521852,-109,47,
 6842111560931367.,5501593067807977.,-.496376312932374001164,-109,47,
 6842111560931372.,5501593067807976.,.400777155626263198005,-109,47,
 6842111560931513.,5501593067807974.,-.499495031020136841771,-109,47,
 6842111560935062.,5501593067807901.,-.499963048078989174316,-109,47,
 5635416615580250.,5431347909843357.,-.499997395851632054072,-108,47,
 5635416615593584.,5431347909843024.,-.499986170328462175479,-108,47,
 5635416615604996.,5431347909842738.,.499573460241062596044,-108,47,
 5635416615605036.,5431347909842738.,-.499376558578218489502,-108,47,
 5635416615605116.,5431347909842736.,-.497276596216759389052,-108,47,
 5635416615605154.,5431347909842735.,-.446279114095056380756,-108,47,
 5635416615605156.,5431347909842735.,-.496226615036019203056,-108,47,
 5635416615606918.,5431347909842691.,-.499974944017378615753,-108,47,
 6916394610366713.,5402521558496376.,-.499955372998001267536,-108,47,
 6916394610522401.,5402521558493208.,-.499949759661453954602,-108,47,
 6916394610526480.,5402521558493124.,.498971307126290863509,-108,47,
 6916394610526578.,5402521558493123.,-.495170819731356796036,-108,47,
 6916394610526627.,5402521558493122.,-.492241883160170030011,-108,47,
 6916394610526824.,5402521558493117.,.499125474075080705921,-108,47,
 6916394610528544.,5402521558493082.,.499896308824252177051,-108,47,
 6916394610528888.,5402521558493076.,-.499949524224869076908,-108,47,
 5804122653802441.,5329644728133219.,-.499744169501706555112,-107,47,
 5804122653802482.,5329644728133218.,-.493905969095687593988,-107,47,
 5804122653802485.,5329644728133217.,.433350484592557971578,-107,47,
 5804122653803637.,5329644728133189.,.499828700881634485274,-107,47,
 5804122653810318.,5329644728133027.,.499951064729941817222,-107,47,
 5804122653812545.,5329644728132973.,.499991852720816384287,-107,47,
 4994576600376809.,5253233932607195.,-.499999167806028715401,-106,47,
 4994576600383055.,5253233932607018.,.499826523022174617921,-106,47,
 4994576600383410.,5253233932607008.,.496614566615722497573,-106,47,
 4994576600383692.,5253233932607001.,-.449598874810867956289,-106,47,
 4994576600383694.,5253233932607000.,.494045001491072720758,-106,47,
 4994576600384581.,5253233932606976.,-.499895858596012634755,-106,47,
 4994576600387704.,5253233932606888.,-.499983013072487370260,-106,47,
 7984456451821952.,5187207775310121.,-.499995630871778590635,-106,47,
 7984456451885266.,5187207775309005.,-.499987798229629068810,-106,47,
 7984456451885323.,5187207775309003.,.495305508885906835515,-106,47,
 7984456451885330.,5187207775309003.,.371920476426411739319,-106,47,
 4747578892790082.,5162820043937274.,.499527648075871542756,-105,47,
 4747578892790116.,5162820043937273.,.491629788527292769538,-105,47,
 4747578892792106.,5162820043937214.,.499960950255404017996,-105,47,
 4747578892801349.,5162820043936940.,.499963426887558769796,-105,47,
 4747578892921508.,5162820043933378.,.499995671649252516023,-105,47,
 5359027492704679.,5145770015378166.,-.498900322848597001937,-105,47,
 5359027492704717.,5145770015378165.,-.496847163909365582301,-105,47,
 5359027492705136.,5145770015378153.,.499475825447365828454,-105,47,
 5359027492705631.,5145770015378140.,.499905132683753740116,-105,47,
 5359027492708068.,5145770015378076.,.499998509943841855041,-105,47,
 5488415439764355.,5142412431755011.,-.499995161692557243303,-105,47,
 5488415439823279.,5142412431753500.,-.467205063879457272348,-105,47,
 5488415439823280.,5142412431753500.,-.492847708810114998219,-105,47,
 5488415439823397.,5142412431753497.,-.493037165697036673323,-105,47,
 5488415439826478.,5142412431753418.,-.498026197029623398245,-105,47,
 5488415439827687.,5142412431753387.,-.499983918173332284942,-105,47,
 5668948148605696.,5137857603457198.,-.499995972426741356999,-105,47,
 5668948148611013.,5137857603457065.,.499991685076130751838,-105,47,
 5668948148616330.,5137857603456933.,.499979342702807850107,-105,47,
 5708579506481044.,5136877137314604.,-.499951420259432362740,-105,47,
 5708579506482341.,5136877137314572.,-.475773459630695377211,-105,47,
 5708579506482342.,5136877137314571.,.499572861079121409427,-105,47,
 5708579506485303.,5136877137314499.,-.499971517134434786343,-105,47,
 5708579506489562.,5136877137314394.,-.499991613931099843341,-105,47,
 5708579506540021.,5136877137313150.,-.499994910214436420911,-105,47,
 6402079148376334.,5120741220500864.,-.430355799988577951838,-105,47,
 6402079148376337.,5120741220500864.,-.496305072917055184382,-105,47,
 6402079148376428.,5120741220500862.,-.496766351747516552090,-105,47,
 6402079148377065.,5120741220500848.,-.499995303559949951052,-105,47,
 6402079148383570.,5120741220500704.,.499997896614194738539,-105,47,
 6728987427100881.,5113732230233044.,.499999516916178279028,-105,47,
 6728987427118377.,5113732230232679.,-.430702975493502780930,-105,47,
 6728987427118380.,5113732230232679.,-.493448294850830262475,-105,47,
 6728987427118476.,5113732230232676.,.498701485714705098292,-105,47,
 6728987427118715.,5113732230232671.,.499991043581110269623,-105,47,
 8108726220153573.,5087482420362562.,-.499978654862436945346,-105,47,
 8108726220154322.,5087482420362549.,-.499847674504758378524,-105,47,
 8108726220156569.,5087482420362510.,-.499454733424517919901,-105,47,
 8108726220156972.,5087482420362503.,-.494043805405868563909,-105,47,
 8108726220156975.,5087482420362502.,.453887293313874546244,-105,47,
 8108726220157030.,5087482420362501.,.499290769842501646389,-105,47,
 8108726220168726.,5087482420362299.,-.499999021304542359386,-105,47,
 8488875008830039.,5081034435108701.,.499999249634199531450,-105,47,
 8488875008832512.,5081034435108661.,-.499992897811010804317,-105,47,
 8488875008857242.,5081034435108251.,-.499914371606182127280,-105,47,
 8488875008858569.,5081034435108228.,.499685474940879404725,-105,47,
 8488875008858690.,5081034435108226.,.493620351679704940835,-105,47,
 8488875008858750.,5081034435108225.,.498877315351860439741,-105,47,
 8488875008859715.,5081034435108210.,-.499906518920006056105,-105,47,
 8703077354446139.,5496719022144435.,.499314633303366166667,-60,50,
 8703077354446216.,5496719022144425.,.495501584850349666764,-60,50,
 8703077354446231.,5496719022144424.,-.453293164848279653594,-60,50,
 8703077354446239.,5496719022144423.,-.492650364687547256779,-60,50,
 8703077354446393.,5496719022144402.,.499723538406736820497,-60,50,
 8703077354446647.,5496719022144370.,-.499867556488933430311,-60,50,
 8703077354449010.,5496719022144062.,.499999541043375346985,-60,50,
 7188956797818862.,6690709305721680.,.499998384065855929875,-57,51,
 7188956797824435.,6690709305719892.,-.499988059531023809404,-57,51,
 7188956797841154.,6690709305714525.,-.499947382171234015082,-57,51,
 7188956797842182.,6690709305714194.,.499696246215405578737,-57,51,
 7188956797842241.,6690709305714176.,-.440012922971118248649,-57,51,
 7188956797842263.,6690709305714168.,.497722641061064378795,-57,51,
 9006440473863854.,6169297356385153.,-.499874548069551237513,-57,51,
 9006440473864254.,6169297356385049.,.498816697575085939730,-57,51,
 9006440473870751.,6169297356383377.,-.499940744416269563265,-57,51,
 9006440473877648.,6169297356381600.,.499993060565297975066,-57,51,
 9006440473921962.,6169297356370190.,-.499997246455087278829,-57,51,
 7591484324331334.,4950172656960902.,-.499999146938242667040,-56,51,
 7591484324336030.,4950172656959447.,.499984997217978146615,-56,51,
 7591484324368902.,4950172656949269.,.499874030818979619575,-56,51,
 7591484324373120.,4950172656947964.,-.499288416072411121489,-56,51,
 7591484324373133.,4950172656947959.,.475583771740537205680,-56,51,
 7591484324373359.,4950172656947890.,-.499715117048673806951,-56,51,
 7591484324373598.,4950172656947815.,.499858181977330655324,-56,51,
 8003388475009803.,4825888419155589.,.499993441635249148503,-56,51,
 8003388475029789.,4825888419149711.,.499912370339420204243,-56,51,
 8003388475029806.,4825888419149707.,-.499887558515302449486,-56,51,
 8003388475030673.,4825888419149452.,-.489683930092451235635,-56,51,
 8003388475031846.,4825888419149107.,-.475879021006975963114,-56,51,
 8003388475031863.,4825888419149102.,-.475678949860447867946,-56,51,
 8003388475031870.,4825888419149099.,.465579902964596116876,-56,51,
 8003388475034794.,4825888419148239.,.499992140321951002853,-56,51,
 7429938090810603.,6717807569284082.,-.499996348770151351324,-55,52,
 7429938090848709.,6717807569259644.,.499704701710220688424,-55,52,
 7429938090848801.,6717807569259586.,-.498983890574488881781,-55,52,
 7429938090848971.,6717807569259476.,.481700232379592244747,-55,52,
 7429938090848985.,6717807569259468.,-.496361075141725669303,-55,52,
 7429938090849484.,6717807569259147.,.499882321073729270045,-55,52,
 7429938090850259.,6717807569258651.,-.499940059511140546890,-55,52,
 7429938090855592.,6717807569255230.,.499991870070460743279,-55,52,
 4684840655107122.,5613014568672006.,.498985930537921703001,-54,52,
 4684840655107187.,5613014568671941.,-.487831943085205516919,-54,52,
 4684840655107188.,5613014568671939.,.496986243474445993468,-54,52,
 4684840655107583.,5613014568671539.,-.499830065445873766953,-54,52,
 4684840655112589.,5613014568666457.,-.499988144614594106320,-54,52,
 4684840655150595.,5613014568627874.,-.499989552934145087882,-54,52,
 5261029272888335.,5062278462627670.,-.499997258976106841171,-54,52,
 5261029272896262.,5062278462620530.,.499976577941916317735,-54,52,
 5261029272899129.,5062278462617949.,-.499906730705919784155,-54,52,
 5261029272899471.,5062278462617640.,.497316816110751810626,-54,52,
 5261029272899511.,5062278462617604.,.473600271880147971751,-54,52,
 5261029272899521.,5062278462617595.,.467671135822541658487,-54,52,
 5261029272899632.,5062278462617496.,-.498142274415689125678,-54,52,
 5357701474430687.,4976041322886515.,-.499997931771824299909,-54,52,
 5357701474436272.,4976041322881580.,-.499922860773803914171,-54,52,
 5357701474447442.,4976041322871710.,-.499772702619243630715,-54,52,
 5357701474447674.,4976041322871505.,-.498874328470367158508,-54,52,
 5357701474447708.,4976041322871474.,.458153881534990410294,-54,52,
 5357701474447717.,4976041322871467.,-.494397474640028585006,-54,52,
 5921569018707969.,4503599627399495.,-.499994309232329257151,-54,52,
 5921569018742631.,4503599627371945.,-.499943059993329662435,-54,52,
 5921569018744444.,4503599627370503.,.494058817554909959939,-54,52,
 5921569018744449.,4503599627370500.,-.480033841359085957405,-54,52,
 5921569018744453.,4503599627370496.,.340692031509719895546,-54,52,
 5921569018744454.,9007199254740991.,.091746999453843436131,-54,53,
 5921569018744483.,9007199254740945.,-.007727843948325827824,-54,53,
 5921569018744561.,9007199254740821.,.000581197936694197631,-54,53,
 5921569018750814.,9007199254730881.,.000022728075055625935,-54,53,
 6544763739192154.,8069045669913586.,-.499999046271082659393,-54,53,
 6544763739207503.,8069045669891696.,.451781575733308726042,-54,53,
 6544763739207517.,8069045669891676.,.486528134408392427682,-54,53,
 6544763739207524.,8069045669891667.,-.496098586254048097394,-54,53,
 6544763739207639.,8069045669891503.,-.496394711421031783591,-54,53,
 6544763739208789.,8069045669889863.,-.499355962916455951304,-54,53,
 6544763739209019.,8069045669889535.,-.499948213177487106097,-54,53,
 6544763739212415.,8069045669884692.,-.499997263381419821245,-54,53,
 6750030179322295.,7781276067681555.,.499962877977165410835,-54,53,
 6750030179323810.,7781276067679468.,-.498360930544128244015,-54,53,
 6750030179323839.,7781276067679428.,-.466645676708763889566,-54,53,
 6750030179323847.,7781276067679417.,-.492379399788629803078,-54,53,
 6750030179323966.,7781276067679252.,.499831469400078982371,-54,53,
 6750030179329484.,7781276067671647.,.499995978670252359699,-54,53,
 7262316160906409.,7103725511105703.,-.499999439779431241551,-54,53,
 7262316160953307.,7103725511046172.,.499889885119128836684,-54,53,
 7262316160954599.,7103725511044532.,.499033927477614407394,-54,53,
 7262316160955245.,7103725511043712.,.498605948781522659673,-54,53,
 7262316160955271.,7103725511043679.,.495492748402305219375,-54,53,
 7262316160955349.,7103725511043580.,.486153147265460668667,-54,53,
 7262316160957803.,7103725511040466.,-.499992764805769137921,-54,53,
 7667186625744739.,6605609693943925.,.499639634394366499192,-54,53,
 7667186625744848.,6605609693943796.,-.482041192691016953053,-54,53,
 7667186625744853.,6605609693943790.,-.444503615951762776072,-54,53,
 7667186625744926.,6605609693943703.,-.496454995558136504666,-54,53,
 7667186625745778.,6605609693942686.,.499948080888109642697,-54,53,
 7667186625749108.,6605609693938715.,.499974190793909874658,-54,53,
 7667186625752438.,6605609693934745.,-.499999697293274985636,-54,53,
 7756304500071766.,6500051176756840.,-.499999567127309409608,-54,53,
 7756304500086727.,6500051176739238.,-.496628057694390807486,-54,53,
 7756304500086744.,6500051176739218.,-.497559992992954476083,-54,53,
 7756304500086795.,6500051176739157.,.499644201111662066248,-54,53,
 7756304500087860.,6500051176737905.,-.499915274833590747703,-54,53,
 7756304500090007.,6500051176735379.,-.499966161409311537885,-54,53,
 4851766931887548.,4503599627371154.,-.250163634020963001450,-53,53,
 4851766931887896.,4503599627370533.,-.242221690382635047705,-53,53,
 4851766931887916.,4503599627370497.,.068579570747781856214,-53,53,
 4851766931887917.,9007199254740991.,-.431760732391384454601,-53,54,
 4851766931887947.,9007199254740884.,-.499356948999380294065,-53,54,
 4851766931888687.,9007199254738242.,.499936374945257661683,-53,54,
 4851766931892844.,9007199254723407.,-.499979361658125706537,-53,54,
 4851766931904176.,9007199254682964.,-.499990132595566142958,-53,54,
 4851766931915508.,9007199254642520.,.499999220509993575664,-53,54,
 4889567999011727.,8872977419557002.,.499998387465177242182,-53,54,
 4889567999034320.,8872977419477190.,-.499929407419722173179,-53,54,
 4889567999035285.,8872977419473780.,.499719595492272292260,-53,54,
 4889567999035867.,8872977419471725.,-.498419554653862421203,-53,54,
 4889567999035882.,8872977419471672.,-.488062316251297844475,-53,54,
 4889567999035884.,8872977419471664.,.446651982202393641100,-53,54,
 4889567999037506.,8872977419465934.,.499948029401945253726,-53,54,
 4930099044594220.,8730575250211520.,-.499998843361661120926,-53,54,
 4930099044602329.,8730575250183185.,-.495811881236435344585,-53,54,
 4930099044602335.,8730575250183164.,-.461402567886035993518,-53,54,
 4930099044602503.,8730575250182577.,-.497941794061110074720,-53,54,
 4930099044602677.,8730575250181968.,.499928293142685093669,-53,54,
 4930099044606426.,8730575250168869.,-.499985740591594843091,-53,54,
 5026050879155925.,8399576467583007.,-.499996454876017904315,-53,54,
 5026050879175154.,8399576467517523.,-.499815270079300575144,-53,54,
 5026050879176942.,8399576467511433.,.499629541787441549417,-53,54,
 5026050879177159.,8399576467510695.,-.489811440019468487233,-53,54,
 5026050879177164.,8399576467510677.,.482782085745854593172,-53,54,
 5026050879177196.,8399576467510569.,-.492619349355538663636,-53,54,
 5026050879177307.,8399576467510190.,.498956922643729828997,-53,54,
 5026050879181211.,8399576467496895.,.499981847663922032745,-53,54,
 5035712052396674.,8366717970690738.,-.499995700499541486688,-53,54,
 5035712052415212.,8366717970627769.,.499980899816450525652,-53,54,
 5035712052433750.,8366717970564801.,.499957812038867779795,-53,54,
 5035712052438837.,8366717970547522.,.493802000382144925032,-53,54,
 5035712052438900.,8366717970547309.,-.498214476005781156253,-53,54,
 5035712052439263.,8366717970546076.,-.499833220837465574537,-53,54,
 5388947655809098.,7221403440535126.,-.499997891180020160526,-53,54,
 5388947655827971.,7221403440476738.,.499916009874371737254,-53,54,
 5388947655827992.,7221403440476674.,-.467338894223579236105,-53,54,
 5388947655828003.,7221403440476640.,-.497805748750934595302,-53,54,
 5388947655831483.,7221403440465873.,.499953005704095696097,-53,54,
 5388947655834995.,7221403440455008.,.499990011539172514966,-53,54,
 5842346135984672.,5898482887041997.,.466565499080328625593,-53,54,
 5842346135984688.,5898482887041953.,.475304423737532708764,-53,54,
 5842346135984732.,5898482887041832.,.499336466545782542799,-53,54,
 5842346135985191.,5898482887040571.,-.499965632258799726570,-53,54,
 5842346135996634.,5898482887009109.,-.499995903272593224298,-53,54,
 6083309738851676.,5256162215041380.,.499770801521553009927,-53,54,
 6083309738851981.,5256162215040592.,.498348557405533365530,-53,54,
 6083309738852053.,5256162215040406.,.478340683393745305479,-53,54,
 6083309738852274.,5256162215039836.,-.499739040981976656247,-53,54,
 6083309738860072.,5256162215019688.,.499963736945679975782,-53,54,
 6083309738862171.,5256162215014266.,-.499988021859501194843,-53,54,
 6083309738882563.,5256162214961581.,-.499995618261017128367,-53,54,
 6386112102135678.,4503599627374855.,.499979991289041612433,-53,54,
 6386112102137457.,4503599627370605.,-.499539210412902339620,-53,54,
 6386112102137498.,4503599627370507.,-.470860338703430531290,-53,54,
 6386112102137502.,4503599627370497.,-.029038009756109490216,-53,54,
 6386112102137503.,9007199254740989.,.162835144961444623372,-53,55,
 6386112102137516.,9007199254740927.,.034680283119183703722,-53,55,
 6386112102185680.,9007199254510747.,.000007423949315292103,-53,55,
 6466710109370739.,8625993548742106.,-.499961036677638261271,-53,55,
 6466710109370977.,8625993548740992.,-.499249503405260282917,-53,55,
 6466710109371049.,8625993548740654.,.492562389026767438528,-53,55,
 6466710109371096.,8625993548740435.,-.498893736743388860391,-53,55,
 6466710109387593.,8625993548663218.,-.499993717074881725605,-53,55,
 6466710109390402.,8625993548650070.,-.499999130417287294466,-53,55,
 6683043781664332.,7641212369782655.,-.499995880609601965628,-53,55,
 6683043781680790.,7641212369709814.,.496044176969076951760,-53,55,
 6683043781680797.,7641212369709784.,-.484635596910381295949,-53,55,
 6683043781680844.,7641212369709576.,-.497771221528144115199,-53,55,
 6683043781681309.,7641212369707517.,.499929513773203801730,-53,55,
 6683043781682603.,7641212369701790.,.499982744068867569256,-53,55,
 7467206264095445.,4503599627378914.,.499975424529907408518,-53,55,
 7467206264097624.,4503599627371070.,-.499501979353208464908,-53,55,
 7467206264097644.,4503599627370997.,.494995703973392571926,-53,55,
 7467206264097774.,4503599627370529.,.459230645605725730364,-53,55,
 7467206264097783.,4503599627370497.,.056754603103953536214,-53,55,
 7467206264097784.,9007199254740987.,-.087041025459143747039,-53,56,
 7467206264099080.,9007199254731655.,-.000141264331879535886,-53,56,
 7467206264158691.,9007199254302423.,.000002416082612633057,-53,56,
 7593583889909144.,8112520461222197.,.499942812874013310062,-53,56,
 7593583889909316.,8112520461221001.,-.498865553101726224965,-53,56,
 7593583889909340.,8112520461220833.,.478044907464231428425,-53,56,
 7593583889913345.,8112520461192961.,.499978029614732827015,-53,56,
 7593583889917546.,8112520461163726.,-.499986720381683743492,-53,56,
 7593583889944398.,8112520460976855.,-.499998661780233708787,-53,56,
 7618936725669056.,7936687291731425.,.492997130359946158021,-53,56,
 7618936725669067.,7936687291731349.,.465038030772196598796,-53,56,
 7618936725669090.,7936687291731190.,.497487186180362548307,-53,56,
 7618936725669124.,7936687291730956.,-.498022757997053310960,-53,56,
 7618936725669554.,7936687291727983.,.499939712887405964302,-53,56,
 7618936725674454.,7936687291694116.,.499977196290853869961,-53,56,
 7618936725679354.,7936687291660250.,-.499985275281746447986,-53,56,
 7618936725732360.,7936687291293892.,-.499984595006354944978,-53,56,
 8259236168388673.,7760175117976306.,-.499999215494804258052,-53,57,
 8259236168401361.,7760175117829576.,.499986081311327948743,-53,57,
 8259236168422839.,7760175117581196.,.498228488750651583126,-53,57,
 8259236168422940.,7760175117580028.,.494681722798647881320,-53,57,
 8259236168423367.,7760175117575090.,.499488960187823801116,-53,57,
 8259236168423631.,7760175117572038.,-.499880803746390191128,-53,57,
 8259236168426737.,7760175117536118.,.499958278863420728937,-53,57,
 8460168363162930.,5502760904649730.,-.499994829714209876758,-53,57,
 8460168363172988.,5502760904540007.,.499439470068399028248,-53,57,
 8460168363172999.,5502760904539888.,-.498771528233202950755,-53,57,
 8460168363173010.,5502760904539768.,-.496982526534417196200,-53,57,
 8460168363174668.,5502760904521680.,.499941552134369004694,-53,57,
 8460168363180817.,5502760904454601.,.499993595112752478686,-53,57,
 8791115980677046.,8258614369456463.,-.499963664819336107914,-53,59,
 8791115980759390.,8258614366202834.,.499979895163943942452,-53,59,
 8791115980760063.,8258614366176243.,-.499971651083068356058,-53,59,
 8791115980766120.,8258614365936915.,-.499535320452740755298,-53,59,
 8791115980768812.,8258614365830547.,-.499341253101719700118,-53,59,
 8791115980769087.,8258614365819681.,-.472575509482565959205,-53,59,
 8791115980769089.,8258614365819602.,-.497835394980162693639,-53,59,
 8791115980769208.,8258614365814899.,.499201418000028071691,-53,59,
 8837821264166392.,6426341390423168.,.499834197081058311496,-53,59,
 8837821264166805.,6426341390407082.,.497110422463688947513,-53,59,
 8837821264166982.,6426341390400188.,.495943091112312515144,-53,59,
 8837821264171506.,6426341390223983.,-.499994673942517904523,-53,59,
 8837821264194637.,6426341389323050.,-.499998885792482298619,-53,59,
 9007199154089846.,7797703592459681.,.167726530665721188755,-53,80,
 9007199154131350.,7794488170599980.,-.175806295966180618497,-53,80,
 9007199154133242.,7794341592483208.,-.370732614366268575626,-53,80,
 9007199154136473.,7794091278585063.,-.496521573699845684397,-53,80,
 9007199154136494.,7794089651660933.,.427360404929867406714,-53,80,
 9007199154136513.,7794088179681960.,-.498641823872006166240,-53,80,
 9007199154136553.,7794085080778856.,.499277144240766933115,-53,80,
 9007199154145500.,7793391933627293.,.494243724292261599993,-53,80,
 9007199154389385.,7774497534046185.,-.496051487545322911437,-53,80,
 9007199154389937.,7774454769183367.,-.499869847769099078486,-53,80,
 9007199154389951.,7774453684567281.,-.463637691902508872612,-53,80,
 9007199154408262.,7773035084199422.,-.390743748108708965329,-53,80,
 9007199155140869.,7716278131571353.,-.225056631694483798249,-53,80,
 9007199155184531.,7712895523890369.,.075759600618920778069,-53,80,
 9007199155191310.,7712370337287162.,.499747355725557723709,-53,80,
 9007199155191381.,7712364836734157.,-.493244263824045871825,-53,80,
 9007199155191432.,7712360885632701.,.497781672960683690086,-53,80,
 9007199155192865.,7712249867429074.,-.473407288085002303858,-53,80,
 9007199155197530.,7711888457854807.,-.037255744228236718333,-53,80,
 9007199158376542.,7465602204279318.,.495527898228475215171,-53,80,
 9007199158376559.,7465600887245501.,.486434487476315342055,-53,80,
 9007199158376646.,7465594147131261.,.498832039798188223427,-53,80,
 9007199158377304.,7465543170175286.,-.493348713892296595719,-53,80,
 9007199158379174.,7465398296455415.,-.416229185066667917015,-53,80,
 9007199158397216.,7464000536212686.,-.270346088353214511170,-53,80,
 9007199164817279.,6966621708584093.,-.171273783145066023213,-53,80,
 9007199164856276.,6963600510486627.,-.409299533522103535817,-53,80,
 9007199164858992.,6963390094966646.,.485669289460077093355,-53,80,
 9007199164859040.,6963386376282935.,.498693844905213427989,-53,80,
 9007199164859277.,6963368015282113.,-.498669600380916597396,-53,80,
 9007199164860430.,6963278689400472.,-.474639770697750922827,-53,80,
 9007199164871044.,6962456395464881.,.278979293759429651189,-53,80,
 9007199178624470.,5896943038694171.,.154848235466712447000,-53,80,
 9007199178667656.,5893597307984960.,-.465939119157640455736,-53,80,
 9007199178669216.,5893476450764880.,.499581541796452662484,-53,80,
 9007199178669292.,5893470562849030.,.496861503015911325865,-53,80,
 9007199178669329.,5893467696363682.,.469272725276115493078,-53,80,
 9007199178669330.,5893467618891105.,.495554575378658148893,-53,80,
 9007199178670738.,5893358537502727.,-.475286712410648184781,-53,80,
 9007199178676141.,5892939953169338.,.069858250253567293625,-53,80,
 9007199184602136.,5433837849817348.,-.400538750510303960442,-53,80,
 9007199184604977.,5433617750226579.,-.492233584681093855255,-53,80,
 9007199184604983.,5433617285391118.,-.461594865804373124380,-53,80,
 9007199184605041.,5433612791981662.,-.498708423452441351240,-53,80,
 9007199184605204.,5433600163951639.,-.499120554775200354220,-53,80,
 9007199184606281.,5433516725986395.,-.479341425368334705101,-53,80,
 9007199184625015.,5432065354732099.,.416999718918427505669,-53,80,
 9007199193426413.,4750198372935003.,.321143248190266348692,-53,80,
 9007199193432647.,4749715408892405.,-.416555795450478330460,-53,80,
 9007199193455377.,4747954457226024.,-.393205071896468533347,-53,80,
 9007199193456928.,4747834297259700.,-.476082077451301423023,-53,80,
 9007199193458335.,4747725293344408.,-.484783488794587309430,-53,80,
 9007199193458407.,4747719715318892.,-.492452461755117716014,-53,80,
 9007199193458479.,4747714137293376.,-.499994367473274065486,-53,80,
 9007199193502679.,4744289849407184.,-.258741988203768421881,-53,80,
 9007199193507069.,4743949744795865.,.499849065837121550094,-53,80,
 9007199193507110.,4743946568420224.,.488887016294516046889,-53,80,
 9007199194127225.,4695904661580413.,-.056005349502856300526,-53,80,
 9007199194130230.,4695671856487746.,-.388625267861962671246,-53,80,
 9007199194133235.,4695439051395079.,-.499906379277837317242,-53,80,
 9007199194133240.,4695438664032196.,-.473284794528822363208,-53,80,
 9007199194166966.,4692825823913977.,.436872323293668442599,-53,80,
 9007199198619841.,8695700249313300.,-.466842138011323087066,-53,81,
 9007199198620885.,8695538486573600.,-.499206779627140340354,-53,81,
 9007199198620983.,8695523301948609.,-.495670201265333045122,-53,81,
 9007199198621014.,8695518498648866.,.454526125335028826347,-53,81,
 9007199198621015.,8695518343703713.,.485178404107185122485,-53,81,
 9007199198628878.,8694300009965917.,.019701513968242451054,-53,81,
 9007199204487496.,7786535548610517.,.121405781334876220649,-53,81,
 9007199204491763.,7785874397644025.,-.485350131072080540577,-53,81,
 9007199204492055.,7785829153659442.,-.494944515905878760588,-53,81,
 9007199204492504.,7785759583285888.,-.498117695268117304219,-53,81,
 9007199204492526.,7785756174492529.,-.491337672097311863492,-53,81,
 9007199204492529.,7785755709657070.,.464134169419434664530,-53,81,
 9007199204497647.,7784962700365647.,.141522624556800462960,-53,81,
 9007199204542518.,7778010156419736.,-.253284628660578881280,-53,81,
 9007199234692659.,6212783956322471.,.481650224721673245769,-53,82,
 9007199234699019.,6210813053999197.,-.416927903729967732008,-53,82,
 9007199234699059.,6210800658387101.,-.472922569246414412987,-53,82,
 9007199234699079.,6210794460581052.,.499138925421993612261,-53,82,
 9007199234699221.,6210750456158112.,-.498096740663786139617,-53,82,
 9007199234713486.,6206329870994366.,-.236973212912967342587,-53,82,
 9007199239632554.,4681958402134502.,-.472129186561058101876,-53,82,
 9007199239632566.,4681954683450879.,-.484400695303265316640,-53,82,
 9007199239632578.,4681950964767256.,-.496658085463092305858,-53,82,
 9007199239632663.,4681924624091593.,-.499743738985044038729,-53,82,
 9007199239634291.,4681420122680071.,-.351541669528797616398,-53,82,
 9007199239640803.,4679402117033986.,-.160145555369690802993,-53,82,
 9007199245022901.,6023084288575576.,-.168226388549826984013,-53,83,
 9007199245054411.,6003555001782126.,.458575225316561353892,-53,83,
 9007199245085921.,5984025714988872.,-.219352699649550145543,-53,83,
 9007199245089121.,5982042417060022.,-.483436236259370141928,-53,83,
 9007199245089415.,5981860201562808.,.499267172683315938738,-53,83,
 9007199245089513.,5981799463063737.,.497268166360312037408,-53,83,
 9007199245089530.,5981788926793490.,.486908997689472945597,-53,83,
 9007199245090672.,5981081137345133.,-.373329892980191052268,-53,83,
 9007199250310262.,5492161007259335.,-.057203403101547439859,-53,84,
 9007199250373442.,5413845530424053.,-.457963582787213441843,-53,84,
 9007199250389237.,5394266661215477.,-.451728890335744618691,-53,84,
 9007199250389414.,5394047258882466.,-.480205929891347126417,-53,84,
 9007199250389737.,5393646880613751.,-.489204305282087013161,-53,84,
 9007199250389768.,5393608454216443.,.499700079882284739636,-53,84,
 9007199254740991.,5199096506725914.,-.222054788253108000697,-53,106,
 4503599627370496.,0.,0.000000000000000000000,-52,0,
 4503599627370497.,-5199096506725911.,-.310544111474552478050,-52,105,
 4503599627370560.,-5199096506725808.,.320302099962984354729,-52,99,
 4503599627376904.,-8133742777107448.,.448046414887221003124,-52,93,
 4503599629142780.,-8787417934569841.,.078420141053162276570,-52,85,
 4503599629167746.,-8911205474281152.,.141550238406117533980,-52,85,
 4503599629183306.,-8988355763389671.,-.499824813890124865633,-52,85,
 4503599629183323.,-8988440053551294.,.496958049326008059603,-52,85,
 4503599629184390.,-8993730500754273.,.285944621497854385382,-52,85,
 4503599630028841.,-6590362640165272.,.204464174188472371555,-52,84,
 4503599630041732.,-6622321007014785.,-.233112557010606343226,-52,84,
 4503599630046286.,-6633610930421184.,.433896897584829863474,-52,84,
 4503599630046296.,-6633635721645176.,-.499854478071147064296,-52,84,
 4503599638087619.,-6642264910044693.,-.498351135080695481849,-52,82,
 4503599638087728.,-6642332466129730.,-.490369134332004247064,-52,82,
 4503599638087731.,-6642334325471520.,-.499257871447225365536,-52,82,
 4503599638089081.,-6643171029277024.,-.141018788662215774966,-52,82,
 4503599638155219.,-6684162078378667.,-.296690482104686639580,-52,82,
 4503599645494007.,-5616300236547643.,.103593444643556463583,-52,81,
 4503599645524735.,-5625822545590156.,-.005399290926056497832,-52,81,
 4503599645526776.,-5626455031686080.,-.496359409976742495865,-52,81,
 4503599645526897.,-5626492528412003.,.499203226201498347558,-52,81,
 4503599645526978.,-5626517629526049.,-.460840702529946024938,-52,81,
 4503599645527002.,-5626525066893174.,-.485791828445966754001,-52,81,
 4503599645527018.,-5626530025137925.,.497636836864519087604,-52,81,
 4503599645528696.,-5627050021056082.,-.211583820117970185699,-52,81,
 4503599651583623.,-7503413143052239.,-.009819052118148219384,-52,81,
 4503599651585299.,-7503932519187812.,-.469119302115728251415,-52,81,
 4503599651585722.,-7504063602782888.,-.499777991904884489145,-52,81,
 4503599651585863.,-7504107297314581.,.497799431871156728519,-52,81,
 4503599651590468.,-7505534342126221.,-.417222934651887976697,-52,81,
 4503599651957600.,-7619304986149182.,.064867713708101580623,-52,81,
 4503599651966936.,-7622198121949036.,.483437349220754750984,-52,81,
 4503599651998834.,-7632083002598406.,-.295345978866536545940,-52,81,
 4503599652000240.,-7632518708354029.,-.496494406469989667980,-52,81,
 4503599652000273.,-7632528934733785.,.482814478699707947765,-52,81,
 4503599652000390.,-7632565191898370.,-.497915135307200546776,-52,81,
 4503599656375245.,-8988290299208120.,.478584234201387406274,-52,81,
 4503599656386892.,-8991899591471045.,-.377261304050952476514,-52,81,
 4503599656387700.,-8992149982829200.,-.490120101566393963710,-52,81,
 4503599656387767.,-8992170745478948.,-.494968136474236898779,-52,81,
 4503599656388015.,-8992247598272046.,.420119363672474470113,-52,81,
 4503599656388035.,-8992253796077941.,.494442267721146473509,-52,81,
 4503599657186129.,-4619787690455364.,-.498557120136939156985,-52,80,
 4503599657186207.,-4619799776176853.,-.499776694762814252317,-52,80,
 4503599657190768.,-4620506480993664.,-.444097903728851261937,-52,80,
 4503599657232269.,-4626936859551446.,-.416290964890950695398,-52,80,
 4503599657232345.,-4626948635382640.,-.483932122345916078351,-52,80,
 4503599657236297.,-4627560978604731.,-.220894346846528844827,-52,80,
 4503599657241275.,-4628332295547939.,-.489174631102025322658,-52,80,
 4503599657241389.,-4628349959294730.,-.489762038774094844662,-52,80,
 4503599657241396.,-4628351043910762.,.483927625218169421664,-52,80,
 4503599664816852.,-5802131186802379.,-.442252070478343632178,-52,80,
 4503599664821498.,-5802851061953234.,-.499103228507541252587,-52,80,
 4503599664821941.,-5802919702653154.,-.489786903997803391947,-52,80,
 4503599664822384.,-5802988343353074.,-.461229207036198718959,-52,80,
 4503599664828359.,-5803914140603686.,-.191633804699808600400,-52,80,
 4503599664885894.,-5812828909610025.,-.203513721515801469209,-52,80,
 4503599669039464.,-6456404421078267.,-.204000067044888061778,-52,80,
 4503599669086867.,-6463749285840286.,-.497495871197183509593,-52,80,
 4503599669086898.,-6463754089139816.,-.467772281764659600096,-52,80,
 4503599669086906.,-6463755328700985.,-.492344447425598983493,-52,80,
 4503599669087031.,-6463774696844252.,.499530469081661238080,-52,80,
 4503599669087234.,-6463806150708915.,-.494400528753000876523,-52,80,
 4503599669090123.,-6464253787236079.,.010176974713477744783,-52,80,
 4503599674687277.,-7331505630129837.,.102597480600395480875,-52,80,
 4503599674710362.,-7335082538815501.,-.497447299305518231701,-52,80,
 4503599674710525.,-7335107794874231.,.499245609303040005097,-52,80,
 4503599674710577.,-7335115852021800.,-.488991399552656099676,-52,80,
 4503599674711203.,-7335212847682931.,-.480422564792914293819,-52,80,
 4503599674714404.,-7335708827093922.,.219845113986072980339,-52,80,
 4503599680960619.,-8303529517657273.,-.193309921747171296749,-52,80,
 4503599680961266.,-8303629767166065.,.180989376562681663904,-52,80,
 4503599680979382.,-8306436753412214.,.324753110716182316325,-52,80,
 4503599681002027.,-8309945486219854.,-.495837349678683919397,-52,80,
 4503599681002251.,-8309980193932325.,-.498576867033638669519,-52,80,
 4503599681002276.,-8309984067560949.,-.494113163754800585387,-52,80,
 4503599681002326.,-8309991814818197.,-.485001921492698864768,-52,80,
 4867368130166671.,-5974679820400456.,-.499981558139365397186,-52,57,
 4867368130185424.,-5974679820671497.,-.499966783336803399315,-52,57,
 4867368130222727.,-5974679821210645.,-.498806652742254395511,-52,57,
 4867368130222738.,-5974679821210804.,-.484088993535332111968,-52,57,
 4867368130222758.,-5974679821211094.,.451761295935037129826,-52,57,
 4867368130222930.,-5974679821213579.,-.499926214447326625759,-52,57,
 5048327701446497.,-8422082060457039.,-.499911246427367508963,-52,57,
 5048327701447484.,-8422082060469487.,-.497986609975355979868,-52,57,
 5048327701447497.,-8422082060469651.,-.453381726148122981446,-52,57,
 5048327701447551.,-8422082060470332.,-.498869131770913149702,-52,57,
 5048327701447618.,-8422082060471177.,-.499751653521966686612,-52,57,
 5048327701452169.,-8422082060528574.,-.499995676045978739411,-52,57,
 5095760958848092.,-4504602359862467.,.499981853204825944172,-52,56,
 5095760958848893.,-4504602359867331.,.499801289037169012221,-52,56,
 5095760958859085.,-4504602359929220.,-.499999073636968734464,-52,56,
 5106532173929591.,-4569726118020166.,.499992576867347534616,-52,56,
 5106532173942368.,-4569726118097080.,-.493616186752643168492,-52,56,
 5106532173942373.,-4569726118097111.,.407380288020237035439,-52,56,
 5106532173942419.,-4569726118097388.,.496547855936455531181,-52,56,
 5106532173944035.,-4569726118107116.,.498608509281492967074,-52,56,
 5106532173945146.,-4569726118113803.,-.499974784156008649445,-52,56,
 5106532173991710.,-4569726118394109.,-.499998601916008419085,-52,56,
 5221791327416850.,-5231509736045259.,-.499989864777743958667,-52,56,
 5221791327427272.,-5231509736102232.,.499857510280392896672,-52,56,
 5221791327429004.,-5231509736111700.,.499064588763245735893,-52,56,
 5221791327429332.,-5231509736113493.,.482748147947630748903,-52,56,
 5221791327429407.,-5231509736113903.,.494261156978886556763,-52,56,
 5221791327429437.,-5231509736114067.,.498866360598831287597,-52,56,
 5221791327432050.,-5231509736128351.,.499979612212985867098,-52,56,
 5221791327457239.,-5231509736266047.,.499997223520817607648,-52,56,
 5241359265433015.,-5337575041185282.,-.499916543920823046171,-52,56,
 5241359265598541.,-5337575042074868.,.499101334904987021886,-52,56,
 5241359265598597.,-5337575042075168.,-.461231491306658341093,-52,56,
 5241359265598629.,-5337575042075340.,-.438564534849551702745,-52,56,
 5241359265599249.,-5337575042078672.,-.499392252543049783115,-52,56,
 5241359265600307.,-5337575042084358.,-.499965998886292236086,-52,56,
 5358638315447308.,-5935875701194726.,-.499992098207476818228,-52,56,
 5358638315493654.,-5935875701418649.,-.499419836273539151729,-52,56,
 5358638315493998.,-5935875701420312.,.447505433522883272767,-52,56,
 5358638315494022.,-5935875701420428.,.490314173296243508582,-52,56,
 5358638315494028.,-5935875701420456.,-.498983641760006348320,-52,56,
 5358638315495429.,-5935875701427226.,.499976547096545041885,-52,56,
 5358638315506922.,-5935875701482754.,-.499987818694493612706,-52,56,
 5361875182249838.,-5951490920679083.,-.491425948863521846435,-52,56,
 5361875182249860.,-5951490920679189.,-.461182726139006701828,-52,56,
 5361875182249898.,-5951490920679372.,-.499853523246017812830,-52,56,
 5361875182250493.,-5951490920682239.,.499906365014701513207,-52,56,
 5361875182254527.,-5951490920701670.,.499959162552747067523,-52,56,
 5361875182258561.,-5951490920721100.,-.499987965823482696929,-52,56,
 5361875182296057.,-5951490920901711.,-.499988765593146404337,-52,56,
 5438257955005054.,-6306218822224957.,-.499982881402074707535,-52,56,
 5438257955007272.,-6306218822234877.,-.491987467769390141858,-52,56,
 5438257955007308.,-6306218822235039.,.498223458872823826420,-52,56,
 5438257955007399.,-6306218822235445.,-.498743365422454766818,-52,56,
 5438257955007708.,-6306218822236827.,-.499432911380036271321,-52,56,
 5438257955008017.,-6306218822238210.,.499877543088550412957,-52,56,
 5438257955012307.,-6306218822257396.,-.499986977054822797677,-52,56,
 5438257955034066.,-6306218822354713.,-.499997855208745300805,-52,56,
 5627653235357357.,-7074505687808167.,-.481061996661057493494,-52,56,
 5627653235357442.,-7074505687808477.,-.485585915739820641532,-52,56,
 5627653235357697.,-7074505687809407.,-.499157672791625390357,-52,56,
 5627653235357714.,-7074505687809470.,.499937543414760143470,-52,56,
 5627653235377607.,-7074505687882021.,-.499994790653465122475,-52,56,
 5648553535546598.,-7149803522281396.,-.499991584204692827822,-52,56,
 5648553535552155.,-7149803522301170.,-.499958751147311281475,-52,56,
 5648553535553525.,-7149803522306046.,.499149597409065168860,-52,56,
 5648553535554073.,-7149803522307996.,.498792939056664923265,-52,56,
 5648553535554107.,-7149803522308116.,-.486630649193382125968,-52,56,
 5648553535574657.,-7149803522381242.,.499995583382617968114,-52,56,
 5679432883829376.,-7257670928169507.,-.499994022941792676810,-52,56,
 5679432883882853.,-7257670928352835.,.461391466942995041973,-52,56,
 5679432883882867.,-7257670928352883.,.467327841103842206224,-52,56,
 5679432883882937.,-7257670928353123.,.497009711920432108034,-52,56,
 5679432883882944.,-7257670928353147.,.499977899003223555599,-52,56,
 5794885835800254.,-7625714243020188.,.499994970564079517088,-52,56,
 5794885835816559.,-7625714243068283.,.499932264805173085496,-52,56,
 5794885835818448.,-7625714243073854.,-.499768275277932597207,-52,56,
 5794885835818588.,-7625714243074267.,-.458983772639035133656,-52,56,
 5794885835818607.,-7625714243074324.,.496551267010988603664,-52,56,
 5794885835819820.,-7625714243077902.,.499919854037372900863,-52,56,
 6190687021007412.,-8482692970139081.,.499997491259255474871,-52,56,
 6190687021023676.,-8482692970161913.,-.499989104960835003348,-52,56,
 6190687021033936.,-8482692970176317.,-.495307244009094121256,-52,56,
 6190687021033941.,-8482692970176325.,.485201860307470437443,-52,56,
 6190687021034040.,-8482692970176464.,.499282125794672147700,-52,56,
 6190687021034399.,-8482692970176968.,.499835816100705638987,-52,56,
 6190687021038093.,-8482692970182154.,.499962117008214034662,-52,56,
 6234082493742912.,-8540110864443573.,-.499998739809702347768,-52,56,
 6234082493747755.,-8540110864449592.,.499991497073990227921,-52,56,
 6234082493771970.,-8540110864479682.,.499943982866292480331,-52,56,
 6234082493773528.,-8540110864481617.,-.499233065608129028545,-52,56,
 6234082493773536.,-8540110864481627.,-.440178775718331776399,-52,56,
 6234082493774002.,-8540110864482207.,.499733610770880808542,-52,56,
 6350411099472431.,-8659843259310045.,-.499999014531322654313,-52,56,
 6350411099485073.,-8659843259320383.,.499985733432776189854,-52,56,
 6350411099497715.,-8659843259330720.,.499971057983415849549,-52,56,
 6350411099499854.,-8659843259332468.,-.498844846920033735057,-52,56,
 6350411099499947.,-8659843259332545.,.457728374980341372988,-52,56,
 6350411099499969.,-8659843259332563.,.468960750058112154693,-52,56,
 6350411099500024.,-8659843259332608.,.497041687760178457893,-52,56,
 6350411099500386.,-8659843259332903.,-.499952867455739743988,-52,56,
 6671477663203808.,-8740514407480606.,.499998876124944683073,-52,56,
 6671477663238613.,-8740514407470066.,-.499531244432374601286,-52,56,
 6671477663238646.,-8740514407470057.,.492912817443260138940,-52,56,
 6671477663238666.,-8740514407470050.,-.451060478387898780407,-52,56,
 6671477663239541.,-8740514407469785.,-.499892169678859258717,-52,56,
 6671477663242718.,-8740514407468824.,.499949814077766752066,-52,56,
 6671477663248144.,-8740514407467181.,.499994779220716972579,-52,56,
 6676648134731249.,-8738903659557127.,-.499964690033334778931,-52,56,
 6676648134731886.,-8738903659556923.,-.499344270182379618555,-52,56,
 6676648134731936.,-8738903659556907.,-.486736701847287311655,-52,56,
 6676648134742512.,-8738903659553520.,-.499983658059105196216,-52,56,
 6676648134753775.,-8738903659549914.,.499997801841894351022,-52,56,
 6863840991780194.,-8620575266355509.,-.499977802223355746501,-52,56,
 6863840991831925.,-8620575266306872.,-.499980903249119341253,-52,56,
 6863840991833898.,-8620575266305018.,.496075673913829716163,-52,56,
 6863840991833931.,-8620575266304986.,-.477634479528278043847,-52,56,
 6863840991833948.,-8620575266304970.,-.494394255542527380765,-52,56,
 6863840991834015.,-8620575266304908.,.498376038998698786816,-52,56,
 6863840991834132.,-8620575266304797.,-.499323595871920880934,-52,56,
 6863840991834968.,-8620575266304011.,-.499980814677809685066,-52,56,
 6932976942232550.,-8547837668187651.,-.499993148711425980863,-52,56,
 6932976942255962.,-8547837668160411.,-.499839873827681782224,-52,56,
 6932976942266139.,-8547837668148571.,.499714744248152584036,-52,56,
 6932976942266824.,-8547837668147773.,-.498743049318910870030,-52,56,
 6932976942266879.,-8547837668147710.,.494081507467279964439,-52,56,
 6932976942267668.,-8547837668146791.,-.499762576840620701591,-52,56,
 6932976942309061.,-8547837668098630.,-.499998282198806497316,-52,56,
 6997291737947254.,-8466397669949989.,.499996446739101976508,-52,56,
 6997291737955973.,-8466397669938055.,-.499936878676004056621,-52,56,
 6997291737957560.,-8466397669935883.,-.499580640737721001760,-52,56,
 6997291737957579.,-8466397669935857.,-.495795657374407520113,-52,56,
 6997291737957674.,-8466397669935727.,-.476870740540675377203,-52,56,
 6997291737957682.,-8466397669935717.,.472091357720313307534,-52,56,
 7143909178992168.,-8231973393177179.,-.499962364360252278319,-52,56,
 7143909179126470.,-8231973392931801.,-.499968421931593911383,-52,56,
 7143909179128835.,-8231973392927480.,-.499759544772112460108,-52,56,
 7143909179128968.,-8231973392927238.,.499406536358540990361,-52,56,
 7143909179128985.,-8231973392927206.,-.440549678831352564937,-52,56,
 7143909179130084.,-8231973392925199.,.499927941078229939535,-52,56,
 7408864542568709.,-7641335151856098.,.499996859077542408444,-52,56,
 7408864542568773.,-7641335151855930.,.499919416293091588647,-52,56,
 7408864542572837.,-7641335151845262.,.495001824149134636877,-52,56,
 7408864542578733.,-7641335151829785.,.487867529771954816505,-52,56,
 7408864542578877.,-7641335151829407.,.487693287768960293301,-52,56,
 7417783623950964.,-7617805660286469.,-.499916677561886048926,-52,56,
 7417783623952948.,-7617805660281210.,.497709948036102121705,-52,56,
 7417783623952991.,-7617805660281096.,.499674638134185484865,-52,56,
 7417783623956053.,-7617805660272977.,-.499956020457771879777,-52,56,
 7417783623961142.,-7617805660259485.,-.499995287309441429837,-52,56,
 7602884003726940.,-7077300784553045.,.499997767106356032821,-52,56,
 7602884003734158.,-7077300784530047.,-.499670568640137462357,-52,56,
 7602884003734201.,-7077300784529910.,-.498975879700369979799,-52,56,
 7602884003735593.,-7077300784525475.,-.499743155833283960547,-52,56,
 7602884003739898.,-7077300784511759.,-.499960882277558848408,-52,56,
 8248300471512757.,-8898622854491112.,-.483508535677589106607,-52,57,
 8248300471512764.,-8898622854491044.,.495759024928585951659,-52,57,
 8248300471512956.,-8898622854489152.,.498526401652948539936,-52,57,
 8248300471513052.,-8898622854488206.,.499910090085933479469,-52,57,
 8248300471517393.,-8898622854445429.,.499978800740427579793,-52,57,
 8248300471518840.,-8898622854431169.,-.499998274259968200509,-52,57,
 8270159510114320.,-8681997664862746.,-.499996346366044072526,-52,57,
 8270159510157609.,-8681997664431330.,-.499991221076317815138,-52,57,
 8270159510157902.,-8681997664428410.,-.476705792617490362549,-52,57,
 8270159510157903.,-8681997664428401.,.489243987002573409347,-52,57,
 8270159510157932.,-8681997664428111.,-.498212404013356730055,-52,57,
 8270159510158167.,-8681997664425770.,.499985806877966056441,-52,57,
 8581012629552255.,-5341274587403238.,-.499991323421872539126,-52,57,
 8581012629589795.,-5341274586970933.,-.499970384310411062779,-52,57,
 8581012629616954.,-5341274586658175.,.463687829258890594528,-52,57,
 8581012629616956.,-5341274586658152.,.495387351333350118142,-52,57,
 8581012629617051.,-5341274586657057.,-.498885350107379762050,-52,57,
 8581012629617398.,-5341274586653061.,-.499018269733141344475,-52,57,
 8581012629619827.,-5341274586625089.,-.499948690691410967556,-52,57,
 8772953774077445.,-6084036693191956.,-.499989092071067325821,-52,58,
 8772953774111563.,-6084036692343251.,-.499992264379350099154,-52,58,
 8772953774118041.,-6084036692182108.,.499949758892931709704,-52,58,
 8772953774119769.,-6084036692139122.,-.499756901909009248513,-52,58,
 8772953774119817.,-6084036692137928.,-.471970975416373087838,-52,58,
 8772953774119833.,-6084036692137530.,-.462708999913977236234,-52,58,
 9007199188962818.,-7465184997866566.,.407861727697707924381,-52,80,
 9007199188973011.,-7464028191205503.,-.414708100532245243711,-52,80,
 9007199188973551.,-7463966906441746.,-.452940244523705501711,-52,80,
 9007199188975104.,-7463790656000793.,-.498566228418502499629,-52,80,
 9007199188975116.,-7463789294117154.,-.454127682650501147148,-52,80,
 9007199188975171.,-7463783052150476.,.499619813117514152528,-52,80,
 9007199189043282.,-7456053114105473.,-.195048499719524044938,-52,80,
 9007199195432056.,-6730989214624843.,.347302488431996902817,-52,80,
 9007199195446208.,-6729383099849680.,.299288380499818473601,-52,80,
 9007199195446278.,-6729375155528435.,.471520915642207114853,-52,80,
 9007199195446290.,-6729373793644792.,-.498934593900204592256,-52,80,
 9007199195446493.,-6729350755113181.,-.498301416823879447999,-52,80,
 9007199195447713.,-6729212296942908.,-.456202009034916081355,-52,80,
 9007199195464590.,-6727296921090691.,-.002601474560925404255,-52,80,
 9007199197171615.,-6533566135697192.,-.128362141036021678161,-52,80,
 9007199197192337.,-6531214389626631.,-.499750693663222404305,-52,80,
 9007199197192488.,-6531197252590792.,-.492403272890547022084,-52,80,
 9007199197192495.,-6531196458158668.,.494713560816506774096,-52,80,
 9007199197193113.,-6531126321151061.,-.492404903838155766959,-52,80,
 9007199203226042.,-5846447376827591.,.311827495318413882411,-52,80,
 9007199203243854.,-5844425887536272.,.159523735062286193856,-52,80,
 9007199203255428.,-5843112350760062.,-.499402729757948577956,-52,80,
 9007199203255580.,-5843095100233884.,-.495571518323386232144,-52,80,
 9007199203255621.,-5843090447131429.,.413508729471067906007,-52,80,
 9007199203255651.,-5843087042422315.,.493364484665963164561,-52,80,
 9007199203255879.,-5843061166633047.,-.498601147212776094864,-52,80,
 9007199203261666.,-5842404398244941.,.203314959225349833903,-52,80,
 9007199218995373.,-8113562412222384.,-.353828416629282704861,-52,81,
 9007199218997119.,-8113166104079392.,-.498897003713801198521,-52,81,
 9007199218997325.,-8113119346073976.,-.491391353605233361397,-52,81,
 9007199218997363.,-8113110720810841.,-.499359128505307717960,-52,81,
 9007199221879290.,-7458969175469507.,-.457391630529367851538,-52,81,
 9007199221880337.,-7458731526771846.,.480744417057604246372,-52,81,
 9007199221880338.,-7458731299791236.,-.482025099907010204025,-52,81,
 9007199221880418.,-7458713141342514.,.496662641032380713137,-52,81,
 9007199221880445.,-7458707012866069.,-.497919190160514338175,-52,81,
 9007199221881009.,-7458578995802572.,-.483037445150788097596,-52,81,
 9007199221892854.,-7455890410488520.,-.483015449870330268150,-52,81,
 9007199221906418.,-7452811645507519.,-.363703429697858108940,-52,81,
 9007199222028540.,-7425092319569857.,.468868117420531170961,-52,81,
 9007199222082354.,-7412877585074403.,.476756887767780566800,-52,81,
 9007199222085674.,-7412124009452347.,.070118158997761855268,-52,81,
 9007199222088994.,-7411370433830290.,-.489094955090325139452,-52,81,
 9007199222089519.,-7411251269010538.,.489531188749749377590,-52,81,
 9007199222089538.,-7411246956378965.,-.497511681089824451140,-52,81,
 9007199222089613.,-7411229932833286.,-.498725684098222665197,-52,81,
 9007199223120906.,-7177146419539976.,-.343148782509671471967,-52,81,
 9007199223122902.,-7176693366244148.,.495637964161423107381,-52,81,
 9007199223122917.,-7176689961535011.,.487068982408155700716,-52,81,
 9007199223122925.,-7176688145690137.,-.450827401370752855240,-52,81,
 9007199223123128.,-7176642068626483.,-.498301593575133574590,-52,81,
 9007199225105258.,-6726736993695100.,.249348576668074599025,-52,81,
 9007199225151813.,-6716169911429745.,-.380400554902806627446,-52,81,
 9007199225151903.,-6716149483174909.,-.392724625131891679981,-52,81,
 9007199225153253.,-6715843059352370.,.497143753961897679226,-52,81,
 9007199225153568.,-6715771560460444.,.491607753901787381568,-52,81,
 9007199225153575.,-6715769971596178.,-.486206399936522301965,-52,81,
 9007199225584755.,-6617900472475851.,.316912439109195121431,-52,81,
 9007199225609049.,-6612386205552959.,.498745405730885380358,-52,81,
 9007199225609120.,-6612370089929697.,.495965119253094429202,-52,81,
 9007199225609367.,-6612314025719193.,-.496603245951228399645,-52,81,
 9007199225611701.,-6611784252977031.,-.243390748134690820186,-52,81,
 9007199225612090.,-6611695957520004.,-.160470081207386311608,-52,81,
 9007199229535856.,-5721077159402842.,.310152827743398597662,-52,81,
 9007199229544329.,-5719153952697480.,.499303808954615040116,-52,81,
 9007199229544404.,-5719136929151758.,.483606859088212024210,-52,81,
 9007199229544412.,-5719135113306881.,.495291375970347987159,-52,81,
 9007199229544843.,-5719037284664131.,-.492931881330224934931,-52,81,
 9007199229545100.,-5718978950647457.,-.481432744549555643209,-52,81,
 9007199229584986.,-5709925602051833.,-.197697552500396312990,-52,81,
 9007199231884133.,-5188063814160610.,-.135288806346297419925,-52,81,
 9007199231910441.,-5182092408277798.,-.242083033092535945978,-52,81,
 9007199231918099.,-5180354190767884.,.480853994667047593003,-52,81,
 9007199231918104.,-5180353055864834.,-.474370095256842569220,-52,81,
 9007199231918146.,-5180343522679222.,-.498176567953077809611,-52,81,
 9007199231918235.,-5180323321404950.,.499443614770518283396,-52,81,
 9007199231922590.,-5179334820849231.,.273034206385854876450,-52,81,
 9007199231923595.,-5179106705336372.,-.341370553096560460262,-52,81,
 9007199234847053.,-4515538425415728.,-.442538104273052522148,-52,81,
 9007199234848163.,-4515286476938591.,.499357427543997859353,-52,81,
 9007199234848280.,-4515259920207216.,-.495843131072142056627,-52,81,
 9007199234848572.,-4515193641869086.,-.496368115501830497661,-52,81,
 9007199234850646.,-4514722884083875.,-.284066142764463811756,-52,81,
 9007199234890724.,-4505625955194854.,-.235617404605329657842,-52,81,
 9007199239849393.,-6760208479311252.,-.165059780652195751229,-52,82,
 9007199239861596.,-6754668790533361.,-.197211298137911706987,-52,82,
 9007199239869884.,-6750906359935039.,-.499740850490731448806,-52,82,
 9007199239869903.,-6750897734671844.,.471883544506226912018,-52,82,
 9007199239871189.,-6750313940541842.,-.372302556766126290840,-52,82,
 9007199239873799.,-6749129101755447.,-.331832811453448413938,-52,82,
 9007199242819483.,-5411902796235911.,-.182239751239135612058,-52,82,
 9007199242887571.,-5380993484600078.,-.450748328369432738151,-52,82,
 9007199242893688.,-5378216603809355.,-.196510109701665588602,-52,82,
 9007199242895460.,-5377412184525201.,-.496851625472347420533,-52,82,
 9007199242895545.,-5377373597821391.,.499748265336860773004,-52,82,
 9007199242895630.,-5377335011117580.,.497459102954087159992,-52,82,
 9007199242895666.,-5377318668513612.,-.491410820193791546388,-52,82,
 9007199242895679.,-5377312767017736.,.484879570365363505164,-52,82,
 9007199242898919.,-5375841932660704.,.309108439073200955777,-52,82,
 9007199245003806.,-8840609718176355.,.492397449208844826733,-52,83,
 9007199245003810.,-8840606086486581.,-.467407388518521347729,-52,83,
 9007199245003856.,-8840564322054192.,.495190635424060702612,-52,83,
 9007199245003956.,-8840473529809865.,-.496916528184900670018,-52,83,
 9007199245004752.,-8839750823545030.,-.364422417170358447753,-52,83,
 9007199251495418.,-5893458967920645.,-.497792543345515404216,-52,84,
 9007199251495422.,-5893451704541083.,-.446555160153163368234,-52,84,
 9007199251495535.,-5893246514068455.,-.495033250303132774891,-52,84,
 9007199251495730.,-5892892424314805.,-.471724392934284412491,-52,84,
 9007199251514421.,-5858952467466120.,.447689356035325855707,-52,84,
 9007199254722216.,-8728141747620088.,.077590992430427307664,-52,92,
 9007199254740804.,-5593150911146969.,-.264222217120341264404,-52,98,
 9007199254740990.,-7616205496030156.,.490692624038463458337,-52,105,
 9007199254740991.,-7616205496030157.,.200824490342010405930,-52,106,
 4503599627370496.,0.,0.000000000000000000000,-51,0,
 4503599627370497.,7616205496030161.,-.331220089252651966558,-51,105,
 4503599630225345.,5183962980547302.,.097826087442354933439,-51,83,
 4503599630233746.,5199217893518816.,.342658892347554605424,-51,83,
 4503599630238097.,5207118634661460.,-.499374123137251844746,-51,83,
 4503599630238124.,5207167662473652.,.486513661484982895973,-51,83,
 4503599630238125.,5207169478318549.,-.476954754524065544249,-51,83,
 4503599632550606.,4703138151319532.,.097009877995752232595,-51,82,
 4503599632603920.,4751543128789881.,-.034895337838683472361,-51,82,
 4503599632668824.,4810470927451796.,-.279763909576468468164,-51,82,
 4503599632669657.,4811227226852240.,.499754493234704255748,-51,82,
 4503599632669661.,4811230858542039.,-.445052547581230225610,-51,82,
 4503599635993635.,7829141478140043.,-.205920399330876238013,-51,82,
 4503599635996077.,7831358624766750.,-.166721235993820828315,-51,82,
 4503599635997888.,7833002872326526.,-.477855147735852794839,-51,82,
 4503599635997929.,7833040097147040.,-.482530667102204068870,-51,82,
 4503599635998134.,7833226221249610.,-.490399600321082247379,-51,82,
 4503599635998150.,7833240748008834.,.485683416006215619811,-51,82,
 4503599635998159.,7833248919310899.,-.465200693391120983001,-51,82,
 4503599636013130.,7846841426333287.,.426640343278605697904,-51,82,
 4503599636032625.,7864541374526766.,-.185274936948738607228,-51,82,
 4503599638891344.,5230018269952315.,-.452099392639329963327,-51,81,
 4503599638973383.,5267260795028150.,-.349006590492830144048,-51,81,
 4503599638974070.,5267572666390890.,-.485744508196233143760,-51,81,
 4503599638974379.,5267712940409938.,.495709576791946103973,-51,81,
 4503599638974402.,5267723381518152.,.498739526385508935378,-51,81,
 4503599640397733.,5913860468583801.,-.075191191030418323792,-51,81,
 4503599640398276.,5914106969530134.,.461912725427573066830,-51,81,
 4503599640400448.,5915092973315470.,-.482926823494817217731,-51,81,
 4503599640400753.,5915231431489746.,-.495754732931985862233,-51,81,
 4503599640400768.,5915238240908153.,-.479254102637308757409,-51,81,
 4503599640400775.,5915241418636742.,.461803204530084849248,-51,81,
 4503599640400991.,5915339474261804.,-.492450514414072254249,-51,81,
 4503599640410341.,5919584011735525.,-.435156865746883315252,-51,81,
 4503599640448708.,5937001142137331.,-.244933821095783184839,-51,81,
 4503599641307378.,6326804029166889.,-.487032237194973891536,-51,81,
 4503599641307407.,6326817194042483.,.497176536410661242951,-51,81,
 4503599641307528.,6326872123351001.,-.496954655788096449937,-51,81,
 4503599641321118.,6333041456431576.,-.484047704831217999158,-51,81,
 4503599641339238.,6341267233872431.,-.449501826387278597615,-51,81,
 4503599642470651.,6854884868271650.,-.333517876046824168210,-51,81,
 4503599642503897.,6869977263250294.,-.252635960190884132215,-51,81,
 4503599642504886.,6870426230904570.,-.487678050229266379089,-51,81,
 4503599642505060.,6870505220158204.,-.499936448937263106899,-51,81,
 4503599642505147.,6870544714785020.,.497425876832870825710,-51,81,
 4503599642505170.,6870555155893259.,.474129078495889651399,-51,81,
 4503599642505179.,6870559241544310.,-.491464515006436258937,-51,81,
 4503599642507940.,6871812628494216.,-.315914671979203890330,-51,81,
 4503599651765847.,5537271735044461.,-.055394873696573506007,-51,80,
 4503599651768246.,5537816261540601.,.498326739303572299239,-51,80,
 4503599651768484.,5537870282927047.,-.496445440395940231247,-51,80,
 4503599651771359.,5538522852196078.,.242186173902592518545,-51,80,
 4503599651825362.,5550780486365191.,.255074720511860663856,-51,80,
 4503599652204562.,5636851535707074.,-.185237700733574084386,-51,80,
 4503599652205489.,5637061946737533.,.198330116034084961316,-51,80,
 4503599652219394.,5640218112194440.,-.192061813093222137415,-51,80,
 4503599652230373.,5642710132370756.,-.497577854686094566253,-51,80,
 4503599652230399.,5642716033866756.,-.456629157561384886762,-51,80,
 4503599652230417.,5642720119517832.,.494857754173008893979,-51,80,
 4503599652230518.,5642743044559987.,-.498652750313563396983,-51,80,
 4503599653639927.,5962651566863572.,-.499938872906588125307,-51,80,
 4503599653639942.,5962654971572806.,-.456011066888873430347,-51,80,
 4503599653642521.,5963240354580446.,.010978817237791962177,-51,80,
 4503599653643818.,5963534748438884.,-.345566897781228597778,-51,80,
 4503599654913457.,6251718190377061.,.078205087869851847026,-51,80,
 4503599654934019.,6256385365799147.,.496955080256966987256,-51,80,
 4503599654934024.,6256386500702227.,-.493480650740253452740,-51,80,
 4503599654934039.,6256389905411464.,-.464764779092516855789,-51,80,
 4503599654934125.,6256409425744423.,-.499459316786126018124,-51,80,
 4503599656141403.,6530438129740601.,-.282747597321049477022,-51,80,
 4503599656142717.,6530736382270009.,-.489619684222263240421,-51,80,
 4503599656143046.,6530811058892668.,.494053700969548130353,-51,80,
 4503599656143061.,6530814463601908.,.311335217563038090260,-51,80,
 4503599656143128.,6530829671303179.,.495615048776658322422,-51,80,
 4503599656143292.,6530866896124202.,-.498160522903933026565,-51,80,
 4503599656143374.,6530885508534713.,-.493497442391634614805,-51,80,
 6755399441055743.,6243314768165356.,-.482256173060009587762,-51,53,
 6755399441055745.,6243314768165363.,-.099981492272272472614,-51,53,
 6755399441055756.,6243314768165404.,-.497470747939668178916,-51,53,
 6755399441055824.,6243314768165654.,.499868398845588165215,-51,53,
 6755399441061082.,6243314768185063.,-.499995800200800506052,-51,53,
 6755399441075739.,6243314768239164.,-.499997517025712152136,-51,53,
 9007199254666070.,8069367277764804.,.499997888000017978952,-51,52,
 9007199254740991.,8069367277953024.,-.316329661669870523720,-51,52,
 4503599627370497.,8069367277953031.,.220376348920932690769,-50,52,
 4503599627370507.,8069367277953081.,.465083086193012100344,-50,52,
 4503599627370508.,8069367277953086.,.489553759920225587180,-50,52,
 4503599627370549.,8069367277953292.,.492851382736846729691,-50,52,
 4503599627370631.,8069367277953704.,.499446628375174081890,-50,52,
 4503599627371244.,8069367277956784.,.499969623422830300816,-50,52,
 4503599627377006.,8069367277985735.,.499991660644851082960,-50,52,
 5629499534201416.,7156341023023938.,-.499989203394216394352,-50,51,
 5629499534212940.,7156341023058651.,-.499967214178006717843,-50,51,
 5629499534213103.,7156341023059141.,.494392694582635194619,-50,51,
 5629499534213104.,7156341023059145.,-.493371968553770346879,-50,51,
 5629499534213110.,7156341023059163.,-.419959947372195339744,-50,51,
 5629499534213119.,7156341023059190.,-.309841915599806291514,-50,51,
 5629499534213121.,7156341023059196.,-.285371241872604400607,-50,51,
 5629499534213267.,7156341023059636.,-.499012059782618787482,-50,51,
 5629499534245387.,7156341023156389.,-.499991796259368205180,-50,51,
 6221883346153833.,9007199254590639.,.000004331578510082047,-50,51,
 6221883346197796.,9007199254732753.,.000013806578567803736,-50,51,
 6221883346199748.,9007199254739063.,-.000031249736531625043,-50,51,
 6221883346200337.,9007199254740967.,-.009266156322093906854,-50,51,
 6221883346200344.,9007199254740990.,-.381192547401323302373,-50,51,
 6221883346200345.,4503599627370496.,.425694698365108382251,-50,50,
 6221883346200350.,4503599627370505.,-.492850441306038808508,-50,50,
 6221883346200595.,4503599627370900.,.498437714813143029324,-50,50,
 6221883346200681.,4503599627371039.,.499461312473811770310,-50,50,
 6755399441031747.,5390236507167195.,.499991830200789360886,-50,50,
 6755399441055743.,5390236507208135.,.499563473314952414052,-50,50,
 6755399441055745.,5390236507208139.,-.088201189821446640494,-50,50,
 6755399441056495.,5390236507209419.,-.499949865925676802947,-50,50,
 6755399441087242.,5390236507261877.,-.499998513512592404075,-50,50,
 7881299347880204.,7407578326662376.,.499994854485313119702,-50,50,
 7881299347897411.,7407578326694602.,-.499951128625417330553,-50,50,
 7881299347898367.,7407578326696392.,-.118126774553281691028,-50,50,
 7881299347898369.,7407578326696396.,-.372558104356347412241,-50,50,
 7881299347898370.,7407578326696398.,-.499773769257880068284,-50,50,
 7881299347902827.,7407578326704745.,-.499992234034084648570,-50,50,
 8711254331067231.,9007199254584308.,.499985486498410550531,-50,50,
 8711254331141806.,9007199254731968.,.499981359234759788042,-50,50,
 8711254331146361.,9007199254740987.,.491600304552969341198,-50,50,
 8711254331146363.,9007199254740991.,.451640532410967104194,-50,50,
 8711254331146364.,4503599627370497.,-.284169676830016915256,-50,49,
 8711254331146711.,4503599627370840.,.249320089855020000016,-50,49,
 8711254331146761.,4503599627370890.,-.250177061918862298205,-50,49,
 8711254331148763.,4503599627372872.,-.250043018819267053909,-50,49,
 9007199254667432.,4799239191046808.,.499997858047173567372,-50,49,
 9007199254690192.,4799239191069747.,-.499983090785351081854,-50,49,
 9007199254735712.,4799239191115623.,-.499944896567476679667,-50,49,
 9007199254740954.,4799239191120905.,.496368824262215749402,-50,49,
 9007199254740966.,4799239191120918.,-.409782308004146975269,-50,49,
 9007199254740991.,4799239191120943.,-.214263833559041973155,-50,49,
 4503599627370497.,4799239191120946.,-.190801616625626889663,-49,49,
 4503599627370669.,4799239191121292.,.499532591742831483329,-49,49,
 4503599627372587.,4799239191125158.,.499887311116285459868,-49,49,
 5066549580783943.,5969860710135112.,.499998009877482841064,-49,49,
 5066549580790584.,5969860710149329.,-.499946893216407194468,-49,49,
 5066549580791551.,5969860710151399.,-.499637710291013981066,-49,49,
 5066549580791615.,5969860710151536.,-.498583121134980105843,-49,49,
 5066549580791807.,5969860710151947.,-.495419353661748405544,-49,49,
 5066549580791809.,5969860710151951.,-.214136397750528412471,-49,49,
 5629499534204394.,7206788183599886.,.499996208079432332730,-49,49,
 5629499534209244.,7206788183610808.,-.499946824032170991266,-49,49,
 5629499534212525.,7206788183618196.,-.499702097490429091591,-49,49,
 5629499534212954.,7206788183619162.,-.497841387897568227631,-49,49,
 5629499534213097.,7206788183619484.,-.497221151358974330705,-49,49,
 5629499534213101.,7206788183619493.,-.490210795092105592402,-49,49,
 5629499534213119.,7206788183619533.,.041335808108840718923,-49,49,
 5629499534213121.,7206788183619538.,-.455159013757717065782,-49,49,
 5629499534214094.,7206788183621729.,-.499889851749466942040,-49,49,
 6192449487620669.,8503028354436774.,-.499997623580568628745,-49,49,
 6192449487625519.,8503028354448180.,-.499940659279103130104,-49,49,
 6192449487634423.,8503028354469120.,-.494887615909127436688,-49,49,
 6192449487634431.,8503028354469138.,.319133096624634662517,-49,49,
 6192449487634433.,8503028354469143.,.022638274758076877812,-49,49,
 6192449487634440.,8503028354469159.,.484906398225129956400,-49,49,
 6192449487634477.,8503028354469246.,.499752193693976692264,-49,49,
 6192449487635219.,8503028354470992.,-.499826718746780625795,-49,49,
 6755399441054211.,4926461693298211.,.499979882804944053578,-49,48,
 6755399441055458.,4926461693299734.,.499537347636198108995,-49,48,
 6755399441055711.,4926461693300043.,.496239864573303566999,-49,48,
 6755399441055729.,4926461693300065.,.480194984355578373998,-49,48,
 6755399441055743.,4926461693300083.,-.421173255813746153483,-49,48,
 6755399441055745.,4926461693300085.,.021488424162065863255,-49,48,
 6755399441055747.,4926461693300087.,.464150104137878188731,-49,48,
 6755399441055833.,4926461693300192.,.498602343098100249841,-49,48,
 6755399441056330.,4926461693300800.,-.499970182899666877728,-49,48,
 6755399441115165.,4926461693372657.,-.499999358199501535692,-49,48,
 7318349394474870.,5625900734674555.,-.499870321373237095111,-49,48,
 7318349394476505.,5625900734676620.,-.498946941305812568629,-49,48,
 7318349394477055.,5625900734677314.,.149681718698378402092,-49,48,
 7318349394477057.,5625900734677317.,-.324323267992476247836,-49,48,
 7318349394477060.,5625900734677320.,.464669251971242309895,-49,48,
 7318349394477064.,5625900734677326.,-.483340721410465285567,-49,48,
 7318349394477140.,5625900734677422.,-.495530215662693709290,-49,48,
 7318349394477159.,5625900734677446.,-.498577589225686722863,-49,48,
 7318349394480121.,5625900734681187.,-.499962878048227660146,-49,48,
 7318349394610069.,5625900734845311.,-.499967501743929046604,-49,48,
 7881299347898348.,6347869795332788.,-.492221717406230811045,-49,48,
 7881299347898367.,6347869795332812.,.235500139799867664554,-49,48,
 7881299347898368.,6347869795332814.,-.463040815084021231752,-49,48,
 7881299347898369.,6347869795332815.,-.161581769967910062298,-49,48,
 7881299347898411.,6347869795332869.,.499698124908818436959,-49,48,
 7881299347899028.,6347869795333672.,.499928961563651646301,-49,48,
 7881299347903483.,6347869795339470.,.499974954684701857525,-49,48,
 7881299347907938.,6347869795345269.,-.499979050889088339133,-49,48,
 7881299347972912.,6347869795429830.,-.499981496984919738542,-49,48,
 8444249301280712.,7090698395672247.,.499995031552373575787,-49,48,
 8444249301319514.,7090698395724132.,.499577866123213379370,-49,48,
 8444249301319679.,7090698395724353.,.133177453137850182578,-49,48,
 8444249301319680.,7090698395724354.,.470350783968247002824,-49,48,
 8444249301319681.,7090698395724356.,-.192475885201356115702,-49,48,
 8444249301319686.,7090698395724362.,.493390768950629210114,-49,48,
 8444249301319689.,7090698395724367.,-.495089238558178859644,-49,48,
 8444249301319775.,7090698395724482.,-.498182787143775867598,-49,48,
 8444249301320469.,7090698395725410.,-.499891190829579360557,-49,48,
 8444249301324028.,7090698395730168.,.499993235112529066980,-49,48,
 9007199254725546.,7852946762989718.,-.499996206175901954269,-49,48,
 9007199254739678.,7852946763009086.,-.499818251124624646733,-49,48,
 9007199254740991.,7852946763010885.,-.024568204196344196700,-49,48,
 4503599627370497.,7852946763010889.,.086951788294846441803,-48,48,
 4503599627370499.,7852946763010895.,-.431021555050231904912,-48,48,
 4503599627370507.,7852946763010916.,.497085071569463873347,-48,48,
 4503599627370646.,7852946763011297.,.497937709089018906258,-48,48,
 4503599627370924.,7852946763012059.,.499642984141409915242,-48,48,
 4503599627372148.,7852946763015414.,.499956857244571531353,-48,48,
 4503599627385056.,7852946763050795.,.499998932077178788389,-48,48,
 4785074604081110.,8633361109031438.,.499488816130972664630,-48,48,
 4785074604081151.,8633361109031553.,.443535277556658025471,-48,48,
 4785074604081153.,8633361109031559.,.050561934211578762244,-48,48,
 4785074604081156.,8633361109031567.,.461101919193961481780,-48,48,
 4785074604081166.,8633361109031595.,.496235202468584538162,-48,48,
 4785074604082021.,8633361109033993.,-.499869077471547323169,-48,48,
 4785074604088169.,8633361109051229.,-.499926515027201983828,-48,48,
 4785074604095854.,8633361109072774.,-.499998300530513511835,-48,48,
 5066549580791717.,4715419884532920.,-.499766391129610153963,-48,47,
 5066549580791807.,4715419884533048.,.305392207135098067089,-48,47,
 5066549580791809.,4715419884533051.,.167729064874323141358,-48,47,
 5066549580791812.,4715419884533055.,.461234351483161513850,-48,47,
 5066549580791826.,4715419884533075.,.497592355657752661425,-48,47,
 5066549580792102.,4715419884533471.,-.499921276324817830463,-48,47,
 5066549580792487.,4715419884534021.,.499923838495016146055,-48,47,
 5066549580831103.,4715419884589287.,.499973145775694494627,-48,47,
 5066549580850411.,4715419884616920.,.499997856162646832094,-48,47,
 5348024557491908.,5122203546137130.,-.499991392039065118831,-48,47,
 5348024557501018.,5122203546150420.,.499951160438691509010,-48,47,
 5348024557502443.,5122203546152499.,.498295632869551709987,-48,47,
 5348024557502463.,5122203546152529.,-.322780234182663110872,-48,47,
 5348024557502465.,5122203546152532.,-.404887820887882481047,-48,47,
 5348024557502467.,5122203546152535.,-.486995407593101467239,-48,47,
 5348024557502650.,5122203546152802.,-.499839591119013732618,-48,47,
 5348024557506389.,5122203546158257.,-.499972935788848140103,-48,47,
 5348024557544461.,5122203546213802.,-.499993372427899579522,-48,47,
 5629499534213115.,5536596492695933.,.487688479793216742594,-48,47,
 5629499534213117.,5536596492695936.,.458212472035365064869,-48,47,
 5629499534213119.,5536596492695939.,.428736464277513751445,-48,47,
 5629499534213121.,5536596492695942.,.399260456519662802322,-48,47,
 5629499534213148.,5536596492695983.,-.498665648211289354864,-48,47,
 5629499534213216.,5536596492696083.,.499150088022162348331,-48,47,
 5629499534213657.,5536596492696738.,.499690377428740035164,-48,47,
 5629499534214098.,5536596492697394.,-.499769333146969867060,-48,47,
 5629499534225090.,5536596492713720.,-.499907963814668441365,-48,47,
 5629499534232418.,5536596492724603.,.499999621853579784067,-48,47,
 5910974510923679.,5958208328660780.,-.499327072976693135695,-48,47,
 5910974510923728.,5958208328660854.,-.496489263044349157855,-48,47,
 5910974510923775.,5958208328660924.,.485824554646053778266,-48,47,
 5910974510923777.,5958208328660928.,-.493651453111797170856,-48,47,
 5910974510924020.,5958208328661295.,-.499986395688108600218,-48,47,
 5910974510993792.,5958208328766669.,-.499992823727614063077,-48,47,
 6192449487603334.,6386686769739855.,-.499999895639424176425,-48,47,
 6192449487630879.,6386686769782111.,-.499983446730597268008,-48,47,
 6192449487632053.,6386686769783911.,.499980951504205676586,-48,47,
 6192449487634401.,6386686769787513.,.499909748315374676094,-48,47,
 6192449487634416.,6386686769787537.,-.489017452725679418213,-48,47,
 6192449487634431.,6386686769787560.,-.477944653766714926088,-48,47,
 6192449487634433.,6386686769787563.,-.409801613905518256163,-48,47,
 6473924464322992.,6821712321038503.,-.499999543981636376066,-48,47,
 6473924464344084.,6821712321071339.,-.499864823395046109521,-48,47,
 6473924464345070.,6821712321072874.,-.496255262773950437337,-48,47,
 6473924464345079.,6821712321072888.,-.485066128853120467970,-48,47,
 6473924464345087.,6821712321072900.,-.030675787590155127536,-48,47,
 6473924464345088.,6821712321072902.,-.473876994932284104769,-48,47,
 6473924464345089.,6821712321072903.,.082921797725586996934,-48,47,
 6473924464345246.,6821712321073148.,-.499667754987670989889,-48,47,
 6473924464348195.,6821712321077738.,.499971793454109579717,-48,47,
 6473924464353468.,6821712321085948.,-.499994519201158718927,-48,47,
 6755399441040388.,7262993901751188.,.499993795177196569110,-48,47,
 6755399441055680.,7262993901775328.,-.498086280873643424714,-48,47,
 6755399441055737.,7262993901775417.,.478575335407462885747,-48,47,
 6755399441055743.,7262993901775427.,-.050197126036616902546,-48,47,
 6755399441055744.,7262993901775429.,-.471659202943963269405,-48,47,
 6755399441055745.,7262993901775430.,.106878720148690439315,-48,47,
 6755399441055941.,7262993901775740.,-.499688353689723537811,-48,47,
 6755399441057227.,7262993901777770.,-.499919256455460068064,-48,47,
 6755399441057870.,7262993901778784.,.499965292208543296896,-48,47,
 7036874417726594.,7710265215652964.,-.499992849519418792985,-48,47,
 7036874417766037.,7710265215716048.,-.499525696743482412945,-48,47,
 7036874417766354.,7710265215716555.,-.498837409710301613000,-48,47,
 7036874417766359.,7710265215716562.,.498018872419617640810,-48,47,
 7036874417766389.,7710265215716610.,.479156565199171223180,-48,47,
 7036874417766399.,7710265215716626.,.472869129459036916164,-48,47,
 7036874417766401.,7710265215716630.,-.328388357688989075308,-48,47,
 7036874417767310.,7710265215718084.,-.499916266436785970197,-48,47,
 7036874417770173.,7710265215722662.,.499990881649988333490,-48,47,
 7318349394443729.,8163281714582294.,.499998623475771422552,-48,47,
 7318349394475952.,8163281714634475.,.499994399416531636102,-48,47,
 7318349394477055.,8163281714636262.,-.333509762762249190864,-48,47,
 7318349394477057.,8163281714636265.,-.094767249910275182336,-48,47,
 7318349394477058.,8163281714636267.,-.475395993484288073594,-48,47,
 7318349394477066.,8163281714636279.,.479574057923611303822,-48,47,
 7318349394477129.,8163281714636381.,.499963212760974677957,-48,47,
 7599824371187697.,8621818038216572.,-.493390143166492802447,-48,47,
 7599824371187708.,8621818038216590.,-.468767860942181221128,-48,47,
 7599824371187711.,8621818038216594.,.447038216028086981289,-48,47,
 7599824371187713.,8621818038216598.,-.275757732658400548644,-48,47,
 7599824371187733.,8621818038216630.,.496282780476738897388,-48,47,
 7599824371187816.,8621818038216767.,-.499749090012145905855,-48,47,
 7599824371189075.,8621818038218830.,-.499798788094150556153,-48,47,
 7599824371194111.,8621818038227082.,-.499997579359778396246,-48,47,
 7881299347896770.,4542832920382146.,.499980251004445138887,-48,46,
 7881299347898367.,4542832920383470.,-.289265225079896972997,-48,46,
 7881299347898368.,4542832920383471.,-.460704952992259612368,-48,46,
 7881299347898369.,4542832920383471.,.367855319095377780555,-48,46,
 7881299347898374.,4542832920383476.,-.489343320466434770423,-48,46,
 7881299347898899.,4542832920383911.,-.495200474452259742659,-48,46,
 7881299347899319.,4542832920384259.,-.499886197634511007943,-48,46,
 7881299347904452.,4542832920388511.,.499990428791219836534,-48,46,
 7881299347912134.,4542832920394877.,-.499999391516245094237,-48,46,
 8162774324586971.,4777315967089178.,.499996275515148448315,-48,46,
 8162774324603776.,4777315967103253.,-.499988441744097405821,-48,46,
 8162774324608268.,4777315967107014.,.499896632645651179092,-48,46,
 8162774324609023.,4777315967107647.,-.196026512625605573030,-48,46,
 8162774324609025.,4777315967107648.,.478951174406812037665,-48,46,
 8162774324609031.,4777315967107654.,-.496115764495934382388,-48,46,
 8162774324609191.,4777315967107788.,-.497900801902091766256,-48,46,
 8162774324609351.,4777315967107922.,-.499685839307451429570,-48,46,
 8444249301316776.,5014268345936023.,.499998226958776355032,-48,46,
 8444249301319679.,5014268345938480.,-.244026976648484863435,-48,46,
 8444249301319681.,5014268345938481.,.448192089694277574846,-48,46,
 8444249301319687.,5014268345938487.,-.475150711277434387795,-48,46,
 8444249301319778.,5014268345938564.,-.479183192681599620037,-48,46,
 8444249301320220.,5014268345938938.,-.498769530926856034732,-48,46,
 8444249301320246.,5014268345938960.,-.499921668470511489386,-48,46,
 6038495938339623.,6243314768159065.,-.499988362204694947747,-45,43,
 6038495938340852.,6243314768160644.,.499973791274170804024,-45,43,
 6038495938344517.,6243314768165356.,.216703891321116791355,-45,43,
 6038495938344518.,6243314768165358.,-.497698092280431397528,-45,43,
 6038495938344532.,6243314768165376.,-.499325862702101682090,-45,43,
 6038495938344539.,6243314768165384.,.499860252087066227487,-45,43,
 6038495938366654.,6243314768193815.,.499992914022233325020,-45,43 };
#include "trailer.h"
