Ext.namespace("Zarafa.plugins.files");Zarafa.plugins.files.ABOUT='<p>Copyright (C) 2005-2016  Zarafa B.V. &lt;info@zarafa.com&gt; and its licensors</p><p>Copyright (C) 2016 Kopano &lt;info@kopano.com&gt; and its licensors</p><p>This program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.</p><p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.</p><p>You should have received a copy of the GNU Affero General Public License along with this program.  If not, see <a href="http://www.gnu.org/licenses/" target="_blank">http://www.gnu.org/licenses/</a>.</p>';
Ext.namespace("Zarafa.plugins.files");
Zarafa.plugins.files.FilesContext=Ext.extend(Zarafa.core.Context,{oldView:void 0,oldViewMode:void 0,accountsStore:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{current_view:Zarafa.plugins.files.data.Views.LIST,current_view_mode:Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW});this.registerInsertionPoint("context.settings.categories",this.createSettingCategories,this);this.registerInsertionPoint("main.maintabbar.left",this.createMainTab,this);this.registerInsertionPoint("main.maintoolbar.new.item",this.createNewFilesButton,
this);this.registerInsertionPoint("main.toolbar.actions.last",this.createMainToolbarButtons,this);this.registerInsertionPoint("navigation.center",this.createNavigatorTreePanel,this);Zarafa.plugins.files.FilesContext.superclass.constructor.call(this,a);Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.attachdialog");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.createfolderdialog");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.fileinfopanel");
Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.sharedialog");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.uploadstatusdialog");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.treecontextmenu")},createMainTab:function(){return{text:this.getDisplayName(),tabOrderIndex:7,context:this.getName()}},createSettingCategories:function(){return{xtype:"filesplugin.settingsmaincategory",model:this.getModel(),store:this.getAccountsStore()}},
getModel:function(){Ext.isDefined(this.model)||(this.model=new Zarafa.plugins.files.FilesContextModel);return this.model},getAccountsStore:function(){Ext.isDefined(this.accountsStore)||(this.accountsStore=new Zarafa.plugins.files.data.AccountStore);return this.accountsStore},bid:function(a){return a.isContainerClass("IPF.Files",!0)?1:-1},bidSharedComponent:function(a,b){var c=-1;Ext.isArray(b)&&(b=b[0]);switch(a){case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.attachdialog"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.sharedialog"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadstatusdialog"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.treecontextmenu"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.createfolderdialog"]:c=
1;break;case Zarafa.core.data.SharedComponentType["common.create"]:case Zarafa.core.data.SharedComponentType["common.view"]:case Zarafa.core.data.SharedComponentType["common.preview"]:b instanceof Zarafa.core.data.IPMRecord&&b.isMessageClass("IPM.Files",!0)&&(c=1);break;case Zarafa.core.data.SharedComponentType["common.contextmenu"]:b instanceof Zarafa.core.data.IPMRecord&&b.isMessageClass("IPM.Files",!0)&&(c=1)}return c},getSharedComponent:function(a,b){var c;switch(a){case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"]:c=
Zarafa.plugins.files.ui.dialogs.FilesRecordContentPanel;break;case Zarafa.core.data.SharedComponentType["common.create"]:c=Zarafa.plugins.files.ui.dialogs.FilesUploadContentPanel;break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.createfolderdialog"]:c=Zarafa.plugins.files.ui.dialogs.CreateFolderContentPanel;break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.sharedialog"]:c=Zarafa.plugins.files.ui.dialogs.ShareContentPanel;break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadstatusdialog"]:c=
Zarafa.plugins.files.ui.dialogs.UploadStatusContentPanel;break;case Zarafa.core.data.SharedComponentType["common.view"]:case Zarafa.core.data.SharedComponentType["common.preview"]:c=Zarafa.plugins.files.ui.FilesRecordViewPanel;break;case Zarafa.core.data.SharedComponentType["common.contextmenu"]:c=Zarafa.plugins.files.ui.FilesMainContextMenu;break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.treecontextmenu"]:c=Zarafa.plugins.files.ui.FilesTreeContextMenu}return c},createNavigatorTreePanel:function(){return{xtype:"filesplugin.filescontextnavigationpanel",
bodyCssClass:"files_navbar_panel",context:this,store:this.getAccountsStore()}},createContentPanel:function(){return{xtype:"filesplugin.filesmainpanel",context:this}},createNewFilesButton:function(){return{xtype:"menuitem",text:dgettext("plugin_files","Upload file"),plugins:"zarafa.menuitemtooltipplugin",iconCls:"icon_files_category",newMenuIndex:6,context:this.getName(),handler:function(){Zarafa.plugins.files.data.Actions.openCreateFilesContent(this.getModel())},scope:this}},getMainToolbarViewButtons:function(){var a=
container.populateInsertionPoint("main.maintoolbar.view.files",this)||[],b=[{overflowText:dgettext("plugin_files","No preview"),iconCls:"icon_previewpanel_off",text:dgettext("plugin_files","No preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.NO_PREVIEW,valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this},{overflowText:dgettext("plugin_files","Right preview"),iconCls:"icon_previewpanel_right",text:dgettext("plugin_files","Right preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW,
valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this},{overflowText:dgettext("plugin_files","Bottom preview"),iconCls:"icon_previewpanel_bottom",text:dgettext("plugin_files","Bottom preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW,valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this}];b.push();return b.concat(a)},createMainToolbarButtons:function(){return[{xtype:"splitbutton",ref:"../../../filesSwitchViewButton",
tooltip:dgettext("plugin_files","Switch view"),scale:"large",iconCls:"icon_viewswitch",handler:function(){this.showMenu()},menu:{xtype:"menu",items:[{text:dgettext("plugin_files","List"),overflowText:dgettext("plugin_files","List"),iconCls:"icon_contact_list",valueView:Zarafa.plugins.files.data.Views.LIST,handler:this.onSwitchView,scope:this},{text:dgettext("plugin_files","Icons"),overflowText:dgettext("plugin_files","Icons"),iconCls:"icon_note_icon_view",valueView:Zarafa.plugins.files.data.Views.ICON,
handler:this.onSwitchView,scope:this}]},listeners:{afterrender:this.onAfterRenderMainToolbarButtons,menuhide:function(a,b){b.find().forEach(function(a){a.getEl().hasClass("x-menu-item-selected")&&a.getEl().removeClass("x-menu-item-selected")},this)},menushow:function(a,b){var c=b.find("valueView",this.getCurrentView())[0];Ext.isDefined(c)&&c.addClass("x-menu-item-selected")},scope:this}}]},onAfterRenderMainToolbarButtons:function(a){a.mon(container,"contextswitch",function(b,c,d){this.setVisiblityMainToolbarButton(a,
d)},this);a.mon(this,"viewchange",function(b,c,d){this.setVisiblityMainToolbarButton(a,b)},this);this.setVisiblityMainToolbarButton(a)},setVisiblityMainToolbarButton:function(a,b){b=b||container.getCurrentContext();b===this?a.show():a.hide()},onSwitchView:function(a){var b=this.getCurrentViewMode();this.switchView(a.valueView,b)},onContextSelectView:function(a){this.getModel().setDataMode(a.valueDataMode);var b=a.valueView,c=a.valueViewMode;Ext.isDefined(a.valueView)||(b=this.getCurrentView());Ext.isDefined(a.valueViewMode)||
(c=this.getCurrentViewMode());this.switchView(b,c);this.getModel().setPreviewRecord(void 0,!0)}});Zarafa.onReady(function(){!0===container.getSettingsModel().get("zarafa/v1/plugins/files/enable")&&container.registerContext(new Zarafa.core.ContextMetaData({name:"filescontext",displayName:dgettext("plugin_files","Files"),allowUserVisible:!1,pluginConstructor:Zarafa.plugins.files.FilesContext}))});Ext.namespace("Zarafa.plugins.files.context");
Zarafa.plugins.files.FilesContextModel=Ext.extend(Zarafa.core.ContextModel,{backendStore:void 0,constructor:function(a){a=a||{};Ext.isDefined(a.store)||(a.store=new Zarafa.plugins.files.data.FilesRecordStore);Ext.isDefined(a.backendStore)||(a.backendStore=new Zarafa.plugins.files.data.BackendStore);Zarafa.plugins.files.FilesContextModel.superclass.constructor.call(this,a)},createRecord:function(a){a=Zarafa.core.data.RecordFactory.createRecordObjectByMessageClass("IPM.Files",{store_entryid:"files",
parent_entryid:a||"/"});a.store=this.getStore();return a},setPreviewRecord:function(a,b){if("filescontext"===container.getCurrentContext().getName()){var c=Zarafa.plugins.files.data.ComponentBox.getPreviewPanel(),d;b&&this.previewRecord?(d=container.getSharedComponent(Zarafa.core.data.SharedComponentType["common.preview"],this.previewRecord),c.removeAll(),Ext.isDefined(d)&&(c.add(new d),c.doLayout(),c.fileinfo.update(this.previewRecord))):this.previewRecord!==a&&(this.previewRecord=a,Ext.isDefined(a)?
(d=container.getSharedComponent(Zarafa.core.data.SharedComponentType["common.preview"],a),Ext.isDefined(d)&&c.fileinfo instanceof d?c.fileinfo.update(a):(c.removeAll(),d&&(c.add(new d),c.doLayout(),c.fileinfo.update(a)))):c.removeAll())}},getFolders:function(){Zarafa.plugins.files.data.FilesMAPIFolderRecord=Ext.extend(Zarafa.hierarchy.data.MAPIFolderRecord,{getFullyQualifiedDisplayName:function(){return this.getDisplayName()},getParentFolder:function(){return!1},set:function(a,b){Ext.isDefined(this.data.name)&&
(this.data.name=b)}});return[new Zarafa.plugins.files.data.FilesMAPIFolderRecord({icon_index:Zarafa.core.mapi.IconIndex.getValue("files"),display_name:dgettext("plugin_files","Files"),entryid:this.store.getPath(),parent_entryid:this.store.getPath(),store_entryid:"files",folder_pathname:Zarafa.plugins.files.data.Utils.File.stripAccountId(this.store.getPath()),content_unread:0,content_count:0},this.store.getPath())]},onHierarchyLoad:function(a){0!==a.getCount()&&(container.on("contextswitch",this.onContextSwitch,
this),this.onContextSwitch(null,null,container.getCurrentContext()))},onContextSwitch:function(a,b,c){a=container.getNavigationBar();c instanceof Zarafa.plugins.files.FilesContext?(this.oldShowFolderList=a.showFolderList,a.setShowFolderList(!1)):Ext.isDefined(this.oldShowFolderList)&&a.setShowFolderList(this.oldShowFolderList)}});Ext.namespace("Zarafa.plugins.files");
Zarafa.plugins.files.FilesPlugin=Ext.extend(Zarafa.core.Plugin,{constructor:function(a){a=a||{};this.registerModules();Zarafa.plugins.files.FilesPlugin.superclass.constructor.call(this,a)},initPlugin:function(){Zarafa.plugins.files.FilesPlugin.superclass.initPlugin.apply(this,arguments);this.registerInsertionPoint("main.attachment.method",this.createAttachmentDownloadInsertionPoint,this);this.registerInsertionPoint("common.contextmenu.attachment.actions",this.createAttachmentUploadInsertionPoint,
this);this.registerInsertionPoint("context.mail.contextmenu.actions",this.createEmailUploadInsertionPoint,this);Zarafa.core.mapi.IconIndex.addProperty("files");Zarafa.core.data.SharedComponentType.addProperty("filesplugin.accountedit");Zarafa.core.data.SharedComponentType.addProperty("filesplugin.featurequotainfo");Zarafa.core.data.SharedComponentType.addProperty("filesplugin.featureversioninfo");Zarafa.core.data.SharedComponentType.addProperty("common.dialog.attachments.files");Zarafa.core.data.SharedComponentType.addProperty("common.dialog.attachments.savetofiles")},
createAttachmentDownloadInsertionPoint:function(a,b){return{text:dgettext("plugin_files","Add from Files"),handler:this.showFilesDownloadAttachmentDialog,scope:b,iconCls:"icon_files_category",disabled:!this.isAccountsConfigured()}},showFilesDownloadAttachmentDialog:function(a){Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"],this.record,{title:dgettext("plugin_files","Add attachment from Files"),modal:!0})},createAttachmentUploadInsertionPoint:function(a,
b){return{text:dgettext("plugin_files","Add to Files"),handler:this.showFilesUploadAttachmentDialog,scope:b,iconCls:"icon_files_category",beforeShow:this.onAttachmentUploadBeforeShow.createDelegate(this)}},onAttachmentUploadBeforeShow:function(a,b){a.setDisabled(b.isEmbeddedMessage());a.setDisabled(b.isTmpFile());a.setDisabled(!this.isAccountsConfigured())},showFilesUploadAttachmentDialog:function(){var a=this.records,b=a.store,c=b.getParentRecord().get("store_entryid"),d=b.getAttachmentParentRecordEntryId(),
e=[];a.isUploaded()?e[0]=a.get("attach_num"):e[0]=a.get("tmpname");b=b.getId();a=a.get("name");c=[{entryid:d,store:c,attachNum:e,dialog_attachments:b,filename:a}];Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"],{items:c,type:"attachment",count:c.length},{modal:!0})},createEmailUploadInsertionPoint:function(a,b){return{text:dgettext("plugin_files","Add to Files"),handler:this.showFilesUploadEmailDialog,scope:b,iconCls:"icon_files_category",
disabled:!this.isAccountsConfigured()}},showFilesUploadEmailDialog:function(){var a=this.records;Array.isArray(a)||(a=[a]);for(var b=[],c=0,d=a.length;c<d;c++)b[c]={store:a[c].get("store_entryid"),entryid:a[c].get("entryid"),filename:Ext.isEmpty(a[c].get("subject")?dgettext("plugin_files","Untitled"):a[c].get("subject"))+".eml"};Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"],{items:b,type:"mail",count:b.length},{modal:!0})},
registerModules:function(){Zarafa.core.ModuleNames["IPM.FILESACCOUNT"]={list:"filesaccountmodule",item:"filesaccountmodule"}},bidSharedComponent:function(a,b){var c=-1;switch(a){case Zarafa.core.data.SharedComponentType["filesplugin.accountedit"]:case Zarafa.core.data.SharedComponentType["filesplugin.featurequotainfo"]:case Zarafa.core.data.SharedComponentType["filesplugin.featureversioninfo"]:case Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"]:c=1;break;case Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"]:b instanceof
Zarafa.core.data.IPMRecord&&b.supportsAttachments()&&(c=1)}return c},getSharedComponent:function(a,b){var c;switch(a){case Zarafa.core.data.SharedComponentType["filesplugin.accountedit"]:c=Zarafa.plugins.files.settings.ui.AccountEditContentPanel;break;case Zarafa.core.data.SharedComponentType["filesplugin.featurequotainfo"]:c=Zarafa.plugins.files.settings.ui.FeatureQuotaInfoContentPanel;break;case Zarafa.core.data.SharedComponentType["filesplugin.featureversioninfo"]:c=Zarafa.plugins.files.settings.ui.FeatureVersionInfoContentPanel;
break;case Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"]:c=Zarafa.plugins.files.ui.dialogs.AttachFromFilesContentPanel;break;case Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"]:c=Zarafa.plugins.files.ui.dialogs.SaveToFilesContentPanel}return c},isAccountsConfigured:function(){return-1!==container.getContextByName("filescontext").getAccountsStore().findBy(function(a){if(a.get("status")===Zarafa.plugins.files.data.AccountRecordStatus.OK)return!0})}});
Zarafa.onReady(function(){container.registerPlugin(new Zarafa.core.PluginMetaData({name:"files",displayName:dgettext("plugin_files","Files Plugin"),about:Zarafa.plugins.files.ABOUT,allowUserDisable:!0,pluginConstructor:Zarafa.plugins.files.FilesPlugin}))});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.AccountRecordFields=[{name:"id"},{name:"name"},{name:"status"},{name:"status_description"},{name:"backend"},{name:"backend_config"},{name:"backend_features"},{name:"account_sequence",type:"number"},{name:"cannot_change",type:"boolean",defaultValue:!1}];Zarafa.plugins.files.data.AccountRecordStatus={OK:"ok",ERROR:"err",NEW:"new",UNKNOWN:"unk"};Zarafa.plugins.files.data.AccountRecordFeature={QUOTA:"Quota",VERSION_INFO:"VersionInfo",SHARING:"Sharing",STREAMING:"Streaming",OAUTH:"OAUTH"};
Zarafa.plugins.files.data.AccountRecord=Ext.extend(Zarafa.core.data.IPMRecord,{applyData:function(a){this.beginEdit();Ext.apply(this.data,a.data);Ext.apply(this.modified,a.modified);this.dirty=a.dirty;this.endEdit(!1);return this},supportsFeature:function(a){return(this.get("backend_features")||[]).some(function(b){return b===a})},renewOauthToken:function(){if(!this.supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.OAUTH))return!1;Zarafa.plugins.files.backend[this.get("backend")].data.OAUTH.reAuthenticate(this.get("id"));
return!0}});Zarafa.core.data.RecordFactory.addFieldToMessageClass("IPM.FilesAccount",Zarafa.plugins.files.data.AccountRecordFields);Zarafa.core.data.RecordFactory.setBaseClassToMessageClass("IPM.FilesAccount",Zarafa.plugins.files.data.AccountRecord);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.AccountStore=Ext.extend(Zarafa.core.data.ListModuleStore,{constructor:function(a){a=Ext.applyIf(a||{},{preferredMessageClass:"IPM.FilesAccount",autoLoad:!0,autoSave:!0,defaultSortInfo:{field:"account_sequence",direction:"asc"}});Zarafa.plugins.files.data.AccountStore.superclass.constructor.call(this,a);this.addEvents("reorder")}});Ext.reg("filesplugin.accountstore",Zarafa.plugins.files.data.AccountStore);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Actions={downloadFrame:void 0,convertDownloadedFileInfoToAttachmentRecord:function(a){var b=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.MAPI_ATTACH);b.set("tmpname",a.tmpname);b.set("name",a.name);b.set("size",a.size);return b},openCreateMailContent:function(a,b,c){var d=a.getAttachmentStore();Ext.each(b,function(a){a=this.convertDownloadedFileInfoToAttachmentRecord(a);d.add(a)},this);Zarafa.core.data.UIFactory.openCreateRecord(a,
c)},openCreateMailContentForContacts:function(a,b,c){a=container.getContextByName("mail").getModel().createRecord();Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.attachdialog"],void 0,{title:String.format(dgettext("plugin_files","Add attachment from {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),emailrecord:a,manager:Ext.WindowMgr});var d=a.getRecipientStore(),e=[];b=Ext.isArray(b)?b:[b];for(var f=0,g=b.length;f<
g;f++){var h=b[f];if(h.isOpened()){var k=h.convertToRecipient(Zarafa.core.mapi.RecipientType.MAPI_TO,!0);d.add(k)}else e.push({fn:function(){var a=h;return function(b,c,e,f){var g=function(b,c){if(c===a){b.un("open",g,e);var h=a.convertToRecipient(Zarafa.core.mapi.RecipientType.MAPI_TO,!0);d.add(h);f()}};a.getStore().on("open",g,e);a.open()}}()})}c=Ext.applyIf(c||{},{recordComponentPluginConfig:{loadTasks:e}});Zarafa.core.data.UIFactory.openCreateRecord(a,c)},openCreateFilesContent:function(a,b){var c=
a.createRecord();Zarafa.core.data.UIFactory.openCreateRecord(c,b)},deleteRecords:function(a){var b=!0,c=0,d=0,e,f;Ext.each(a,function(a){if(a.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||".."===a.get("filename"))b=!1;a.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER?(c+=1,f||(f=a.get("filename"))):a.get("type")===Zarafa.plugins.files.data.FileTypes.FILE&&(d+=1,e||(e=a.get("filename")))},this);var g=container.getSettingsModel().get("zarafa/v1/contexts/files/ask_before_delete");
b&&(g?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm deletion"),this.createDeletionMessage(d,e,c,f),function(b){"yes"===b&&this.doDelete(a)},this):this.doDelete(a))},createDeletionMessage:function(a,b,c,d){if(1===a&&0===c)return String.format(dgettext("plugin_files","Are you sure you want to delete {0}?"),b);if(0===a&&1===c)return String.format(dgettext("plugin_files","Are you sure you want to delete {0} and all of its contents?"),d);if(1<=a&&0===c)return String.format(dgettext("plugin_files",
"Are you sure you want to delete {0} files?"),a);if(0===a&&1<=c)return String.format(dgettext("plugin_files","Are you sure want to delete {0} folders and all of their contents?"),c);if(0!==a&&0!==c)return dgettext("plugin_files","Are you sure want to delete the selected items and all of their contents?")},doDelete:function(a){var b=[];Ext.each(a,function(a){b.push({id:a.get("id")})});container.getRequest().singleRequest("filesbrowsermodule","delete",{records:b},new Zarafa.core.data.AbstractResponseHandler({doDelete:this.deleteDone.createDelegate(this,
[a],!0)}))},deleteDone:function(a,b){Ext.each(b,function(a){var b=a.getStore(),c=Zarafa.plugins.files.data.Utils.File.getDirName(a.id)+"/";b.getPath()===c?(a=b.getById(a.id),b.on("update",this.doRefreshIconView,this,{single:!0}),b.remove(a),b.commitChanges()):a.isFolder()&&(b=a.getAccount().id,a=container.getNavigationBar().findByType("filesplugin.filescontextnavigationpanel")[0]["filesNavigatorTreePanel_"+b].getNodeById(a.get("id")),Ext.isDefined(a)&&a.remove(!0))});container.getCurrentContext().getCurrentView()===
Zarafa.plugins.files.data.Views.ICON&&Zarafa.plugins.files.data.ComponentBox.getItemsView().refresh()},createShareDialog:function(a,b){b=Ext.applyIf(b||{},{modal:!0,records:a});Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.sharedialog"],void 0,b)},createFolder:function(a,b,c){if(!Ext.isDefined(c)||Ext.isEmpty(c))c=a.getStore().getPath();b=Ext.applyIf(b||{},{modal:!0,accountFilter:Zarafa.plugins.files.data.Utils.File.getAccountId(c),selectedFolderId:c,
store:a.getStore()});Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.createfolderdialog"],void 0,b)},doRefreshIconView:function(){Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentView()===Zarafa.plugins.files.data.Views.ICON&&Zarafa.plugins.files.data.ComponentBox.getItemsView().refresh()},moveRecords:function(a,b,c){Ext.isDefined(c);Ext.isDefined(b.data)||(c=b.parentNode,b=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.ZARAFA_FILES,
{id:b.id,entryid:b.id,parent_entryid:Ext.isDefined(c)?c.id:"/"},b.id));this.doMoveRecords(void 0,null,null,a,b)},doMoveRecords:function(a,b,c,d,e){b=d[0].getStore();Ext.isDefined(a)&&"yes"!==a?b.reload():(Ext.each(d,function(b){var c=[{id:b.get("id"),isFolder:b.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER}];b.beginEdit();b.moveTo(e);b.addMessageAction("records",c);b.addMessageAction("overwrite",Ext.isDefined(a)?a:"no");b.set("deleted",!0);b.dirty=!0;b.endEdit();b.commit()}),b.filter("deleted",
!1));Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentView()===Zarafa.plugins.files.data.Views.ICON&&Zarafa.plugins.files.data.ComponentBox.getItemsView().refresh()},openRenameDialog:function(a){Ext.MessageBox.prompt(dgettext("plugin_files","Rename"),dgettext("plugin_files","Please enter a new name"),this.doCheckRenameDuplicate.createDelegate(this,[a],!0),this,!1,a.get("filename"))},doCheckRenameDuplicate:function(a,b,c,d){"ok"===a&&this.doRename(b,d)},doRename:function(a,b){var c=b.get("id"),
c=Zarafa.plugins.files.data.Utils.File.getDirName(c)+"/",d=c+a,e=b.copy().data;e.id=b.isFolder()?d+"/":d;e.filename=a;e.virtualRecord=!1;container.getRequest().singleRequest("filesbrowsermodule","rename",{entryid:b.id,props:e,records:[{id:d,isFolder:b.isFolder()}],destination:c},new Zarafa.core.data.AbstractResponseHandler({doRename:this.renameDone.createDelegate(this,[a,b],!0)}))},renameDone:function(a,b,c){if(!0===a.duplicate)this.msgWarning(dgettext("plugin_files","This name already exists"));
else if(Zarafa.plugins.files.data.Utils.File.isValidFilename(b)){var d=c.id,e=Zarafa.plugins.files.data.Utils.File.getDirName(d)+"/",f=e+b;b={id:c.isFolder()?f+"/":f,text:b,oldId:d};d=c.getStore();d.fireEvent("write",d,"rename",a,b,c);d.getPath()===e&&(d.on("update",this.doRefreshIconView,this,{single:!0}),d.reload())}else this.msgWarning(dgettext("plugin_files","Incorrect name"))},downloadItem:function(a){Array.isArray(a)||(a=[a]);var b=Ext.getBody().createChild({tag:"iframe",cls:"x-hidden"});1==
a.length?(a=this.getDownloadLink(a[0],!1),b.dom.contentWindow.location=a):1<a.length&&(a=this.getDownloadLinkForMultipleFiles(a,!1),b.dom.contentWindow.location=a);container.getNotifier().notify("info.files",dgettext("plugin_files","Downloading"),dgettext("plugin_files","Download started... please wait!"))},uploadAsyncItems:function(a,b,c){Ext.isDefined(c)||(c=b.getPath());var d=[],e=!1;Ext.each(a,function(a){a.size>Zarafa.plugins.files.data.Utils.Core.getMaxUploadFilesize()&&(e=!0);d.push({id:c+
a.name,isFolder:!1})});e?Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:String.format(dgettext("plugin_files","At least one file is too large! Maximum allowed filesize: {0}."),Zarafa.plugins.files.data.Utils.Format.fileSize(Zarafa.plugins.files.data.Utils.Core.getMaxUploadFilesize())),icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK}):container.getRequest().singleRequest("filesbrowsermodule","checkifexists",{records:d,destination:c},
new Zarafa.core.data.AbstractResponseHandler({doCheckifexists:this.checkForExistingFilesDone.createDelegate(this,[a,c,b,this.doAsyncUpload],!0)}))},doAsyncUpload:function(a,b,c,d){"overwrite"!==a&&"keepboth"!==a||Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadstatusdialog"],void 0,{files:b,destination:c,keepBoth:"keepboth"===a,manager:Ext.WindowMgr,store:d,callbackAllDone:this.uploadDone.bind(this)})},uploadDone:function(a,b,c){c.getPath()===
b?c.reload():this.updateCache(b)},checkForExistingFilesDone:function(a,b,c,d,e){!0===a.duplicate?Zarafa.common.dialogs.MessageBox.addCustomButtons({title:dgettext("plugin_files","Confirm overwrite"),icon:Ext.MessageBox.QUESTION,msg:dgettext("plugin_files","File already exists. Do you want to overwrite it?"),fn:e.createDelegate(this,[b,c,d],!0),customButton:[{text:dgettext("plugin_files","Keep both"),name:"keepboth"},{text:dgettext("plugin_files","Overwrite"),name:"overwrite"},{text:dgettext("plugin_files",
"Cancel"),name:"cancel"}],scope:this}):e.createDelegate(this,["overwrite",b,c,d])()},getDownloadLink:function(a,b){return Ext.isDefined(b)&&0==b?a.getAttachmentUrl():a.getInlineImageUrl()},getDownloadLinkForMultipleFiles:function(a){var b="",c=document.URL,b=c.substring(0,c.lastIndexOf("/")+1),b=b+"index.php?load=custom&name=download_file";Ext.each(a,function(a,c){b=Ext.urlAppend(b,"ids["+c+"]="+encodeURIComponent(a.get("id")))});return b=Ext.urlAppend(b,"inline=false")},msgWarning:function(a){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Warning"),msg:a,icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK})},onCheckCredentials:function(a,b){b?(this.usernameField.hide(),this.usernameField.setValue(""),this.usernameField.label.hide(),this.usernameField.allowBlank=!0,this.usernameField.validate(),this.passwordField.hide(),this.passwordField.setValue(""),this.passwordField.label.hide(),this.passwordField.allowBlank=!0):(this.usernameField.show(),this.usernameField.label.show(),this.usernameField.allowBlank=
!1,this.usernameField.validate(),this.passwordField.show(),this.passwordField.label.show(),this.passwordField.allowBlank=!1);this.passwordField.validate()},onCheckSSL:function(a,b){b&&"80"===this.portField.getValue()?this.portField.setValue("443"):b||"443"!==this.portField.getValue()||this.portField.setValue("80")},updateCache:function(a){container.getRequest().singleRequest("filesbrowsermodule","updatecache",{id:a})}};
Ext.override(Ext.tree.AsyncTreeNode,{quietLoad:function(a,b,c){a=0;if(this.loading){var d;a=function(){this.loading||clearInterval(d)}.createDelegate(this);d=setInterval(a,200)}else if(!this.loaded&&!1!==this.fireEvent("beforeload",this)){this.loading=!0;this.ui.beforeLoad(this);var e=this.loader||this.attributes.loader||this.getOwnerTree().getLoader();e&&(this.setCls("x-treenode-load-silent"),e.load(this,this.quietLoadComplete.createDelegate(this,[a,b,c])))}},quietLoadComplete:function(a,b,c){this.setCls("");
0===this.childNodes.length&&(this.leaf=!0);this.loading=!1;this.loaded=!0;this.ui.afterLoad(this);this.fireEvent("load",this);this.ui.expand()},setLeaf:function(a){this.leaf=a}});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.ComponentBox=Ext.extend(Object,{getContext:function(){return container.getContextByName("filescontext")},getMainPanel:function(){try{return container.getContentPanel()}catch(a){return container.getTabPanel().get(0).getActiveItem()}},getPreviewPanel:function(){return this.getMainPanel().filesPreview},getTabPanel:function(){return container.getTabPanel()},getViewPanel:function(){return this.getMainPanel().viewPanel},getItemsView:function(){return this.getViewPanel().getActiveItem()}});
Zarafa.plugins.files.data.ComponentBox=new Zarafa.plugins.files.data.ComponentBox;Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.DataModes=Zarafa.core.Enum.create({ALL:0});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.FileTypes=Zarafa.core.Enum.create({FOLDER:0,FILE:1});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.FilesBackendRecordFields=[{name:"id"},{name:"name"},{name:"backend",mapping:"name"},{name:"displayName"},{name:"message_class"}];
Zarafa.core.data.RecordFactory.addFieldToMessageClass("IPM.FilesBackend",Zarafa.plugins.files.data.FilesBackendRecordFields);Zarafa.core.data.RecordFactory.setBaseClassToMessageClass("IPM.FilesBackend",Zarafa.core.data.IPMRecord);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.BackendStore=Ext.extend(Zarafa.core.data.ListModuleStore,{constructor:function(a){a=a||{};var b=Zarafa.core.data.RecordFactory.getRecordClassByMessageClass("IPM.FilesBackend");Ext.applyIf(a,{preferredMessageClass:"IPM.FilesBackend",autoLoad:{params:{list_backend:!0}},reader:new Zarafa.core.data.JsonReader({id:"name",idProperty:"name"},b),proxy:new Zarafa.core.data.IPMProxy({listModuleName:"filesaccountmodule",itemModuleName:"filesaccountmodule"})});Zarafa.plugins.files.data.BackendStore.superclass.constructor.call(this,
a)}});Ext.reg("filesplugin.backendstore",Zarafa.plugins.files.data.BackendStore);Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.FilesProxy=Ext.extend(Zarafa.core.data.IPMProxy,{getResponseHandlerForRequest:function(a,b,c,d,e,f,g,h,k){return new Zarafa.plugins.files.data.ResponseHandler({proxy:this,action:c,reader:f,sendRecords:d,options:k,callback:g,scope:h})}});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.FilesRecordFields=[{name:"id"},{name:"path"},{name:"type",type:"int",defaultValue:Zarafa.plugins.files.data.FileTypes.FOLDER},{name:"filename"},{name:"isshared",type:"boolean",defaultValue:!1},{name:"sharedid"},{name:"lastmodified",type:"int",defaultValue:null},{name:"message_size",type:"int",defaultValue:0},{name:"deleted",type:"boolean",defaultValue:!1},{name:"virtualRecord",type:"boolean",defaultValue:!1}];
Zarafa.plugins.files.data.FilesRecord=Ext.extend(Zarafa.core.data.IPMRecord,{disabled:!1,applyData:function(a){this.beginEdit();Ext.apply(this.data,a.data);Ext.apply(this.modified,a.modified);this.dirty=a.dirty;this.endEdit(!1);return this},getInlineImageUrl:function(){return container.getBasePath()+"index.php?load=custom&name=download_file&"+Ext.urlEncode({id:this.get("id"),inline:!0})},getAttachmentUrl:function(){return container.getBasePath()+"index.php?sessionid="+container.getUser().getSessionId()+
"&load=custom&name=download_file&"+Ext.urlEncode({id:this.get("id"),inline:!1})},setDisabled:function(a){this.disabled=a},getDisabled:function(){return this.disabled},getAccount:function(){var a=Zarafa.plugins.files.data.Utils.File.getAccountId(this.get("id"));return container.getCurrentContext().getAccountsStore().getById(a)},isFolder:function(){return this.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER}});Zarafa.core.data.RecordCustomObjectType.addProperty("ZARAFA_FILES");
Zarafa.core.data.RecordFactory.addFieldToMessageClass("IPM.Files",Zarafa.plugins.files.data.FilesRecordFields);Zarafa.core.data.RecordFactory.setBaseClassToMessageClass("IPM.Files",Zarafa.plugins.files.data.FilesRecord);Zarafa.core.data.RecordFactory.addFieldToCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,Zarafa.plugins.files.data.FilesRecordFields);Zarafa.core.data.RecordFactory.setBaseClassToCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,Zarafa.plugins.files.data.FilesRecord);
Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.FilesRecordStore=Ext.extend(Zarafa.core.data.ListModuleStore,{rootID:void 0,constructor:function(){this.rootID="#R#";this.addEvents("createfolder");Zarafa.plugins.files.data.FilesRecordStore.superclass.constructor.call(this,{preferredMessageClass:"IPM.Files",autoSave:!0,defaultSortInfo:{field:"filename",direction:"asc"},baseParams:{id:this.rootID,reload:!1},listeners:{load:this.onLoad,exception:this.onLoadException},proxy:new Zarafa.plugins.files.data.FilesProxy({listModuleName:"filesbrowsermodule",itemModuleName:"filesbrowsermodule"})})},
loadPath:function(a){this.rootID=a;this.load({params:{id:this.rootID}})},load:function(a){Ext.isObject(a)||(a={});Ext.isObject(a.params)||(a.params={});Ext.isDefined(a.cancelPreviousRequest)||(a.cancelPreviousRequest=!0);this.hasSearch||(Ext.isEmpty(a.folder)?Ext.isDefined(a.params.entryid)&&Ext.isDefined(a.params.store_entryid)&&(this.setEntryId(a.params.entryid,!1),this.setStoreEntryId(a.params.store_entryid,!1)):this.setFolder(a.folder));Ext.isEmpty(a.folder)||Ext.applyIf(a.params,{id:a.folder[0].get("entryid")});
this.rootID=a.params.id;Ext.apply(a.params,{entryid:this.hasSearch?this.searchFolderEntryId:this.entryId,store_entryid:this.storeEntryId});Ext.applyIf(a,{actionType:this.actionType});Ext.applyIf(a.params,{restriction:this.restriction});this.restriction.search&&(a.params.restriction=Ext.apply(a.params.restriction||{},{search:this.restriction.search}));a.actionType==Zarafa.core.Actions.search&&Ext.applyIf(a.params,{use_searchfolder:this.useSearchFolder,subfolders:this.subfolders});a.actionType!=Zarafa.core.Actions.updatesearch&&
a.actionType!=Zarafa.core.Actions.stopsearch||delete a.params.restriction;return Zarafa.core.data.ListModuleStore.superclass.load.call(this,a)},onLoad:function(a,b,c){a=c.params.id;b=Zarafa.plugins.files.data.ComponentBox;c=b.getViewPanel();var d=!1;if(Ext.isEmpty(a)||"#R#"===a)c.switchView("files-accountview"),b.getPreviewPanel().topToolbar.disable(),d=!0;else if(b.getItemsView()instanceof Zarafa.plugins.files.ui.FilesRecordAccountView)switch(b.getContext().getCurrentView()){case Zarafa.plugins.files.data.Views.LIST:c.switchView("files-gridview");
break;case Zarafa.plugins.files.data.Views.ICON:c.switchView("files-iconview")}container.getMainPanel().filesSwitchViewButton.setDisabled(d)},onLoadException:function(a,b,c,d,e,f){e.error&&e.error.info.code&&401==parseInt(e.error.info.code)&&(a=Zarafa.plugins.files.data.Utils.File.getAccountId(d.params.id),a=container.getCurrentContext().getAccountsStore().getById(a),Ext.isDefined(a)&&a.supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.OAUTH)&&a.renewOauthToken())},reload:function(a){var b=
this.getPath();a=Ext.applyIf(a||{},{params:{reload:!0,id:b},reload:!0});Zarafa.plugins.files.data.FilesRecordStore.superclass.reload.call(this,a)},getPath:function(){return this.rootID}});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.NavigatorTreeLoader=Ext.extend(Ext.tree.TreeLoader,{loadFiles:!1,reload:!1,accountFilter:null,constructor:function(a){a=a||{};Ext.isDefined(a.reload)&&(this.reload=a.reload);Ext.isDefined(a.loadfiles)&&(this.loadFiles=a.loadfiles);Ext.isDefined(a.accountFilter)&&(this.accountFilter=a.accountFilter);Ext.applyIf(a,{preloadChildren:!0,directFn:this.loadFolder.createDelegate(this),listeners:{loadexception:this.loadException}});Zarafa.plugins.files.data.NavigatorTreeLoader.superclass.constructor.call(this,
a)},loadFolder:function(a,b){var c=new Zarafa.core.data.AbstractResponseHandler({doGetfilestree:this.doGetfilestree.createDelegate(this,[b],!0),nodeId:a});container.getRequest().singleRequest("filesbrowsermodule","getfilestree",{id:a,loadfiles:this.loadFiles,reload:this.reload,accountFilter:this.accountFilter},c)},doGetfilestree:function(a,b){a.status?this.loadSuccess(a.items,a,b):this.loadFailure(a.items,a,b)},loadSuccess:function(a,b,c){c(a,b)},loadFailure:function(a,b,c){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Error"),msg:b.error,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK});c(void 0,{status:!0,items:void 0})},loadException:function(a,b,c){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Loading failed"),msg:c.error,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})},setReload:function(a){this.reload=a}});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.ResponseHandler=Ext.extend(Zarafa.core.data.IPMResponseHandler,{nodeId:void 0,successCallback:null,failureCallback:null,doGetquota:function(a){this.successCallback(a)},doGetbackends:function(a){this.successCallback(a)},doGetversion:function(a){this.successCallback(a)},doGetfilestree:function(a){this.successCallback(a.items,a)},doCheckifexists:function(a){this.successCallback(a)},doDownloadtotmp:function(a){this.successCallback(a.items,a)},doCreatedir:function(a){this.successCallback(a)},
doUploadtobackend:function(a){this.successCallback(a)},doError:function(a){Ext.isDefined(a.info.duplicate)?!0===a.info.duplicate&&(a=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.ZARAFA_FILES,{id:a.info.destination,entryid:a.info.destination},a.info.destination),Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),Zarafa.plugins.files.data.Actions.doMoveRecords.createDelegate(this,
[null,null,this.sendRecords,a],1),this)):Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:a.info.original_message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})}});Ext.reg("filesplugin.responsehandler",Zarafa.plugins.files.data.ResponseHandler);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Utils={Base64:{_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(a){var b="",c,d,e,f,g,h,k=0;for(a=this._utf8_encode(a);k<a.length;)c=a.charCodeAt(k++),d=a.charCodeAt(k++),e=a.charCodeAt(k++),f=c>>2,c=(c&3)<<4|d>>4,g=(d&15)<<2|e>>6,h=e&63,isNaN(d)?g=h=64:isNaN(e)&&(h=64),b=b+this._keyStr.charAt(f)+this._keyStr.charAt(c)+this._keyStr.charAt(g)+this._keyStr.charAt(h);return b},decode:function(a){var b="",c,d,e,f,g,h=0;for(a=a.replace(/[^A-Za-z0-9\+\/\=]/g,
"");h<a.length;)c=this._keyStr.indexOf(a.charAt(h++)),d=this._keyStr.indexOf(a.charAt(h++)),f=this._keyStr.indexOf(a.charAt(h++)),g=this._keyStr.indexOf(a.charAt(h++)),c=c<<2|d>>4,d=(d&15)<<4|f>>2,e=(f&3)<<6|g,b+=String.fromCharCode(c),64!=f&&(b+=String.fromCharCode(d)),64!=g&&(b+=String.fromCharCode(e));return b=this._utf8_decode(b)},_utf8_decode:function(a){for(var b="",c=0,d,e,f;c<a.length;)d=a.charCodeAt(c),128>d?(b+=String.fromCharCode(d),c++):191<d&&224>d?(e=a.charCodeAt(c+1),b+=String.fromCharCode((d&
31)<<6|e&63),c+=2):(e=a.charCodeAt(c+1),f=a.charCodeAt(c+2),b+=String.fromCharCode((d&15)<<12|(e&63)<<6|f&63),c+=3);return b},_utf8_encode:function(a){a=a.replace(/\r\n/g,"\n");for(var b="",c=0;c<a.length;c++){var d=a.charCodeAt(c);128>d?b+=String.fromCharCode(d):(127<d&&2048>d?b+=String.fromCharCode(d>>6|192):(b+=String.fromCharCode(d>>12|224),b+=String.fromCharCode(d>>6&63|128)),b+=String.fromCharCode(d&63|128))}return b}},Renderer:{typeRenderer:function(a,b,c){switch(a){case Zarafa.plugins.files.data.FileTypes.FOLDER:b.css=
"zarafa-files-listview-icon "+Zarafa.plugins.files.data.Utils.File.getIconClass("folder","16");break;case Zarafa.plugins.files.data.FileTypes.FILE:b.css="zarafa-files-listview-icon "+Zarafa.plugins.files.data.Utils.File.getIconClass(c.get("filename"),"16")}b.css+=" zarafa-grid-empty-cell";return""},sharedRenderer:function(a,b,c){a&&(b.css="zarafa-files-listview-icon files_icon_16_share");b.css+=" zarafa-grid-empty-cell";return""},datetimeRenderer:function(a,b,c){b.css="mail_date";a=new Date(a);return Ext.isDate(a)?
a.format(dgettext("plugin_files","l d/m/Y G:i")):dgettext("plugin_files","Never")}},Format:{fileSize:function(a){return-1===a||"none"===a?"":1024>a?a+" bytes":1048576>a?Math.round(10*a/1024)/10+" KB":1073741824>a?Math.round(10*a/1048576)/10+" MB":Math.round(10*a/1073741824)/10+" GB"},fileSizeList:function(a){return-1===a||"none"===a?"":1024>a?100>=a&&0!=a?"0.1 &nbsp;KB":Math.round(10*a/1024)/10+" &nbsp;KB":1048576>a?Math.round(10*a/1024)/10+" &nbsp;KB":1073741824>a?Math.round(10*a/1048576)/10+" &nbsp;MB":
1099511627776>a?Math.round(10*a/1073741824)/10+" &nbsp;GB":Math.round(10*a/1099511627776)/10+" &nbsp;TB"},truncate:function(a,b){return a.length>b?a.substr(0,b-1)+"&hellip;":a}},File:{getExtension:function(a){var b=a.lastIndexOf(".");return 0>b?"":a.substr(b+1)},getIconClass:function(a,b){Ext.isDefined(b)||(b="48");if("folder"===a)return"files"+b+"icon_folder";var c=this.getExtension(a).toLowerCase(),d="aac ai aiff apk avi bmp c cpp css csv dat dmg doc docx dotx dwg dxf eps exe flv gif gz h hpp html ics iso java jpg js key less mid mp3 mp4 mpg odf ods odt otp ots ott pdf php png ppt psd py qt rar rb rtf sass sql tga tgz tiff txt wav xls xlsx xml yml zip".split(" ").indexOf(c);
return Ext.isEmpty(c)||-1===d?"files"+b+"icon_blank":"files"+b+"icon_"+c},isValidFilename:function(a){return Ext.isEmpty(a)||-1!==a.indexOf("/")||-1!==a.indexOf("\\")||-1!==a.indexOf("<")||-1!==a.indexOf(">")||-1!==a.indexOf(":")||-1!==a.indexOf("'")||-1!==a.indexOf("|")||-1!==a.indexOf("?")||-1!==a.indexOf("*")?!1:!0},getAccountId:function(a){if(!Ext.isDefined(a)||-1===a.indexOf("/"))return null;var b=0;0==a.indexOf("#R#")&&(b=3);return a.substr(b,a.indexOf("/")-b)},stripAccountId:function(a){return Ext.isDefined(a)?
-1===a.indexOf("/")?"#R#":a.substr(a.indexOf("/")):!1},getFileName:function(a){return a.replace(/^.*[\\\/]/,"")},getDirName:function(a){return a.replace(/\\/g,"/").replace(/\/[^\/]*\/?$/,"")}},Core:{getMaxUploadFilesize:function(){return container.getServerConfig().getMaxAttachmentSize()}},Validator:{actionSelectionVisibilityFilter:function(a,b,c,d,e){if(!Ext.isDefined(a)||Ext.isEmpty(a)||b&&Ext.isArray(a)&&1!=a.length)return!1;if(c||d||e)for(b=0;b<a.length;b++)if(c&&a[b].get("type")==Zarafa.plugins.files.data.FileTypes.FOLDER||
d&&a[b].get("type")!==Zarafa.plugins.files.data.FileTypes.FOLDER||e&&".."===a[b].get("filename"))return!1;return!0}}};Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.ViewModes=Zarafa.core.Enum.create({NO_PREVIEW:0,RIGHT_PREVIEW:1,BOTTOM_PREVIEW:2});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.Views=Zarafa.core.Enum.create({LIST:0,ICON:1});Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsAccountsWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Manage Accounts"),xtype:"filesplugin.settingsaccountswidget",height:400,layout:"fit",items:[{xtype:"filesplugin.accountpanel",model:a.model,store:a.store}]});Zarafa.plugins.files.settings.SettingsAccountsWidget.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.settingsaccountswidget",Zarafa.plugins.files.settings.SettingsAccountsWidget);
Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsMainCategory=Ext.extend(Zarafa.settings.ui.SettingsCategory,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Files"),categoryIndex:1,iconCls:"icon_files_category",items:[{xtype:"filesplugin.settingsaccountswidget",model:a.model,store:a.store},{xtype:"filesplugin.settingsresetwidget"},container.populateInsertionPoint("context.settings.category.files",this)]});Zarafa.plugins.files.settings.SettingsMainCategory.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.settingsmaincategory",Zarafa.plugins.files.settings.SettingsMainCategory);Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsResetWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{loadMask:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Reset Files settings"),layout:"form",items:[{xtype:"displayfield",hideLabel:!0,value:dgettext("plugin_files","Resets Files settings to their original defaults")},{xtype:"button",text:dgettext("plugin_files","Reset Files settings"),width:150,handler:this.onResetSettings,scope:this}]});Zarafa.plugins.files.settings.SettingsResetWidget.superclass.constructor.call(this,
a)},onResetSettings:function(){var a=dgettext("plugin_files","Your Files's settings will be restored to their default condition.")+" "+dgettext("plugin_files","Are you sure you want to reset all Files settings and remove all accounts?"),a=a+"<br/><br/>"+dgettext("plugin_files","WebApp will automatically restart in order for these changes to take effect"),a=a+"<br/>";Zarafa.common.dialogs.MessageBox.addCustomButtons({title:dgettext("plugin_files","Reset Files settings"),msg:a,icon:Ext.MessageBox.QUESTION,
fn:this.resetDefaultSettings,customButton:[{text:dgettext("plugin_files","Reset"),name:"reset"},{text:dgettext("plugin_files","Cancel"),name:"cancel"}],scope:this})},resetDefaultSettings:function(a){if("reset"===a){a=container.getSettingsModel();var b=a.getSettingsObject("zarafa/v1/plugins/files/accounts"),c;for(c in b)!0!==b[c].cannot_change&&a.reset("zarafa/v1/plugins/files/accounts/"+c);a.reset("zarafa/v1/contexts/files");a.save();this.loadMask=new Zarafa.common.ui.LoadMask(Ext.getBody(),{msg:"<b>"+
dgettext("plugin_files","Webapp is reloading, Please wait.")+"</b>"});this.loadMask.show();this.mon(a,"save",this.onSettingsSave,this);this.mon(a,"exception",this.onSettingsException,this)}},onSettingsSave:function(a,b){b.action===Zarafa.core.Actions.reset&&(this.mun(a,"save",this.onSettingsSave,this),this.mun(a,"exception",this.onSettingsException,this),Zarafa.core.Util.reloadWebapp())},onSettingsException:function(a,b,c,d,e){d.action===Zarafa.core.Actions.reset&&(this.loadMask.hide(),this.mun(a,
"save",this.onSettingsSave,this),this.mun(a,"exception",this.onSettingsException,this))}});Ext.reg("filesplugin.settingsresetwidget",Zarafa.plugins.files.settings.SettingsResetWidget);Ext.namespace("Zarafa.plugins.files.settings.data");
Zarafa.plugins.files.settings.data.AccountRenderUtil={statusRenderer:function(a,b,c){switch(a){case Zarafa.plugins.files.data.AccountRecordStatus.OK:b.css="zarafa-files-listview-icon zarafa-files-account-ok";break;case Zarafa.plugins.files.data.AccountRecordStatus.NEW:b.css="zarafa-files-listview-icon zarafa-files-account-new";break;case Zarafa.plugins.files.data.AccountRecordStatus.ERROR:b.css="zarafa-files-listview-icon zarafa-files-account-error";break;case Zarafa.plugins.files.data.AccountRecordStatus.UNKNOWN:b.css=
"zarafa-files-listview-icon zarafa-files-account-unknown"}b.css+=" zarafa-grid-empty-cell";b.attr='ext:qtip="'+c.get("status_description")+'"';return""},featureRenderer:function(a,b,c,d,e,f,g){a=c.get("backend_features");return Ext.isDefined(a)&&null!==a&&Zarafa.plugins.files.settings.data.AccountRenderUtil.arrayContains(a,g)?"zarafa-files-feature-spacer":"x-hide-display"},backendRenderer:function(a){return Ext.isEmpty(a)?"":'<span class="icon_16_'+a+' files_backend_selector">&nbsp;</span>'+a},arrayContains:function(a,
b){for(var c=a.length;c--;)if(a[c]===b)return!0;return!1}};Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.AccountEditContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.accounteditcontentpanel",layout:"fit",modal:!0,width:400,height:250,stateful:!1,title:dgettext("plugin_files","Edit Account"),items:[{xtype:"filesplugin.accounteditpanel",item:a.item,backendStore:a.backendStore}]});Zarafa.plugins.files.settings.ui.AccountEditContentPanel.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.accounteditcontentpanel",Zarafa.plugins.files.settings.ui.AccountEditContentPanel);Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.AccountEditPanel=Ext.extend(Ext.Panel,{currentItem:void 0,constructor:function(a){a=a||{};a.item&&(this.currentItem=a.item);Ext.applyIf(a,{xtype:"filesplugin.accounteditpanel",layout:"anchor",autoScroll:!0,border:!1,items:this.createPanelItems(a),buttons:[{text:dgettext("plugin_files","Save"),ref:"../saveBtn",cls:"zarafa-action",disabled:!0,handler:this.doSave,scope:this},{text:dgettext("plugin_files","Cancel"),handler:this.doClose,scope:this}]});Zarafa.plugins.files.settings.ui.AccountEditPanel.superclass.constructor.call(this,
a)},doClose:function(){this.dialog.close()},doSave:function(){var a=this.dialog.store,b=this.dialog.accName,c=this.dialog.accBackend,d=!0,e={};Ext.each(this.dialog.metaForm.form.items.items,function(a){e[a.getName()]=a.getValue();if(!a.isValid())return d=!1});d&&(this.currentItem?(this.currentItem.beginEdit(),this.currentItem.set("name",b.getValue()),this.currentItem.set("status",Zarafa.plugins.files.data.AccountRecordStatus.NEW),this.currentItem.set("backend",c.getValue()),this.currentItem.set("backend_config",
e),this.currentItem.endEdit()):(this.currentItem=new a.recordType({id:-1,name:b.getValue(),status:Zarafa.plugins.files.data.AccountRecordStatus.NEW,backend:c.getValue(),backend_config:e}),a.add(this.currentItem)),this.doClose())},createPanelItems:function(a){var b="",c="",d=!1,e;Ext.isDefined(a.item)&&(b=a.item.get("name"),c=a.item.get("backend"),d=!0,e=Ext.urlAppend(container.getBaseURL(),"load=custom&name=form&backend="+encodeURI(c)));return[{xtype:"fieldset",checkboxToggle:!1,title:dgettext("plugin_files",
"Account Information"),defaultType:"textfield",ref:"accInfo",collapsed:!1,items:[{xtype:"panel",layout:"form",border:!1,flex:1,defaults:{anchor:"100%",style:"margin-bottom: 10px;"},defaultType:"textfield",items:[{fieldLabel:dgettext("plugin_files","Account name"),labelAlign:"top",ref:"../../../accName",value:b,name:"accountName"},{xtype:"combo",fieldLabel:dgettext("plugin_files","Account type"),ref:"../../../accBackend",store:a.backendStore,valueField:"backend",value:c,displayField:"displayName",
tpl:'<tpl for="."><div ext:qtip="{displayText}" class="x-combo-list-item"><span class="icon_16_{backend} files_backend_selector">&nbsp;</span>{displayName}</div></tpl>',emptyText:dgettext("plugin_files","Select backend..."),triggerAction:"all",mode:"local",forceSelection:!0,editable:!1,listeners:{select:this.onBackendSelect,scope:this}}]}]},{xtype:"fieldset",checkboxToggle:!1,title:dgettext("plugin_files","Account Configuration"),autoHeight:!0,defaultType:"textfield",ref:"metaInfo",collapsed:!1,items:[{xtype:"metaform",
autoInit:d,method:"GET",flex:1,defaults:{anchor:"100%",style:"margin-bottom: 10px;"},ref:"../../metaForm",url:e,listeners:{actioncomplete:this.onMetaFormReady.createDelegate(this)}}]}]},onBackendSelect:function(a,b,c){c=b.data.backend;a=this.dialog.metaForm;b=this.saveBtn;c=Ext.urlAppend(container.getBaseURL(),"load=custom&name=form&backend="+encodeURI(c));a.url=c;a.load();b.enable()},onMetaFormReady:function(){if(Ext.isDefined(this.item)){var a=this.saveBtn;this.dialog.metaForm.bindData(this.item.data.backend_config);
a.setText(dgettext("files_plugin","Update"));a.enable()}this.dialog.metaForm.on("afterlayout",function(){this.dialog.metaForm.doLayout();Ext.WindowMgr.getActive().setHeight(this.accInfo.getHeight()+this.metaInfo.getHeight()+90)},this,{single:!0})}});Ext.reg("filesplugin.accounteditpanel",Zarafa.plugins.files.settings.ui.AccountEditPanel);Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.AccountGrid=Ext.extend(Zarafa.common.ui.grid.GridPanel,{store:null,backendStore:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.accountgrid",store:a.store,border:!1,baseCls:"accountGrid",enableHdMenu:!1,loadMask:this.initLoadMask(),viewConfig:{forceFit:!0,deferEmptyText:!1,emptyText:"<div class='emptytext'>"+dgettext("plugin_files","No account created!")+"</div>"},sm:this.initSelectionModel(),cm:this.initColumnModel(),listeners:{rowdblclick:this.onRowDblClick,
scope:this},tbar:[{iconCls:"filesplugin_icon_add",text:dgettext("plugin_files","Add Account"),ref:"../addAccountBtn",handler:this.onAccountAdd,scope:this},{iconCls:"filesplugin_icon_delete",text:dgettext("plugin_files","Remove Account"),disabled:!0,ref:"../removeAccountBtn",handler:this.onAccountRemove,scope:this},{xtype:"spacer",width:10},{xtype:"button",iconCls:"zarafa-rules-sequence-up",disabled:!0,ref:"../upButton",handler:this.onAccountSequenceUp,scope:this,width:20},{xtype:"spacer",width:10},
{xtype:"button",iconCls:"zarafa-rules-sequence-down",disabled:!0,ref:"../downButton",handler:this.onAccountSequenceDown,scope:this,width:20}]});Zarafa.plugins.files.settings.ui.AccountGrid.superclass.constructor.call(this,a)},initLoadMask:function(){return{msg:dgettext("plugin_files","Loading accounts")+"..."}},initEvents:function(){this.on("afterrender",this.onAfterRender,this)},onAfterRender:function(){this.store.reload()},initSelectionModel:function(){return new Ext.grid.RowSelectionModel({singleSelect:!0,
listeners:{selectionchange:this.onRowSelected}})},initColumnModel:function(){return new Zarafa.plugins.files.settings.ui.AccountGridColumnModel},onRowSelected:function(a){if(!(1>a.getCount())){var b=this.grid.removeAccountBtn,c=a.getSelections()[0].get("cannot_change");b.setDisabled(c);this.grid.upButton.setDisabled(!a.hasPrevious());this.grid.downButton.setDisabled(!a.hasNext())}},onRowDblClick:function(a,b){this.getStore().getAt(b).get("cannot_change")||Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["filesplugin.accountedit"],
void 0,{store:a.getStore(),item:a.getStore().getAt(b),backendStore:this.backendStore,manager:Ext.WindowMgr})},onAccountAdd:function(){Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["filesplugin.accountedit"],void 0,{store:this.getStore(),backendStore:this.backendStore,modal:!0})},onAccountRemove:function(){var a=this.getSelectionModel().getSelections();Ext.isDefined(a[0])&&Ext.MessageBox.confirm(dgettext("plugin_files","Confirm deletion"),String.format(dgettext("plugin_files",
'Do you really want to delete the account "{0}"?'),a[0].get("name")),this.doRemove.createDelegate(this,[a[0]],!0),this)},doRemove:function(a,b,c,d){"yes"===a&&this.getStore().remove(d)},onAccountSequenceUp:function(){var a=this.getStore(),b=this.getSelectionModel().getSelected(),c;a.each(function(a){b.get("account_sequence")>a.get("account_sequence")&&(!c||a.get("account_sequence")>c.get("account_sequence"))&&(c=a)},this);this.swapAccounts(b,c)},onAccountSequenceDown:function(){var a=this.getStore(),
b=this.getSelectionModel().getSelected(),c;a.each(function(a){b.get("account_sequence")<a.get("account_sequence")&&(!c||a.get("account_sequence")<c.get("account_sequence"))&&(c=a)},this);this.swapAccounts(b,c)},swapAccounts:function(a,b){var c=parseInt(a.get("account_sequence")),d=parseInt(b.get("account_sequence"));this.upButton.setDisabled(!0);this.downButton.setDisabled(!0);this.store.suspendEvents();a.set("account_sequence",d);b.set("account_sequence",c);this.store.resumeEvents();this.store.save(this.store.getModifiedRecords());
this.store.on("update",this.onAfterSequenceChanged.createDelegate(this,[a,b],!0),null,{single:!0})},onAfterSequenceChanged:function(a,b,c,d,e){a.reload();a.on("load",this.onAfterSequenceReload.createDelegate(this,[d,e],!0),this,{single:!0})},onAfterSequenceReload:function(a,b,c,d,e){b=this.getSelectionModel();this.upButton.setDisabled(!b.hasPrevious());this.downButton.setDisabled(!b.hasNext());a.fireEvent("reorder",d,e)}});Ext.reg("filesplugin.accountgrid",Zarafa.plugins.files.settings.ui.AccountGrid);
Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.AccountGridColumnModel=Ext.extend(Zarafa.common.ui.grid.ColumnModel,{constructor:function(a){a=a||{};Ext.applyIf(a,{columns:this.createDefaultColumns(),defaults:{sortable:!0}});Zarafa.plugins.files.settings.ui.AccountGridColumnModel.superclass.constructor.call(this,a)},createDefaultColumns:function(){return[new Ext.grid.RowNumberer,{header:dgettext("plugin_files","ID"),dataIndex:"id",width:50,hidden:!0,sortable:!1,tooltip:dgettext("plugin_files","Sort by: ID")},{header:dgettext("plugin_files",
"Status"),dataIndex:"status",width:40,sortable:!1,renderer:Zarafa.plugins.files.settings.data.AccountRenderUtil.statusRenderer,tooltip:dgettext("plugin_files","Sort by: Status")},{header:dgettext("plugin_files","Name"),dataIndex:"name",flex:1,sortable:!1,tooltip:dgettext("plugin_files","Sort by: Name")},{header:dgettext("plugin_files","Backend"),dataIndex:"backend",width:40,sortable:!1,renderer:Zarafa.plugins.files.settings.data.AccountRenderUtil.backendRenderer,tooltip:dgettext("plugin_files","Sort by: Backend")},
{xtype:"actioncolumn",header:dgettext("plugin_files","Features"),dataIndex:"backend_features",width:40,sortable:!1,tooltip:dgettext("plugin_files","Shows all available features of the backend."),items:[{getClass:Zarafa.plugins.files.settings.data.AccountRenderUtil.featureRenderer.createDelegate(this,[Zarafa.plugins.files.data.AccountRecordFeature.QUOTA],!0),icon:"plugins/files/resources/icons/features/quota.png",tooltip:dgettext("plugin_files","Show quota information"),handler:this.showDialog.createDelegate(this,
["filesplugin.featurequotainfo"],2)},{getClass:Zarafa.plugins.files.settings.data.AccountRenderUtil.featureRenderer.createDelegate(this,[Zarafa.plugins.files.data.AccountRecordFeature.VERSION_INFO],!0),icon:"plugins/files/resources/icons/features/info.png",tooltip:dgettext("plugin_files","Show version information"),handler:this.showDialog.createDelegate(this,["filesplugin.featureversioninfo"],2)},{getClass:Zarafa.plugins.files.settings.data.AccountRenderUtil.featureRenderer.createDelegate(this,[Zarafa.plugins.files.data.AccountRecordFeature.SHARING],
!0),icon:"plugins/files/resources/icons/features/sharing.png",tooltip:dgettext("plugin_files","Share files")},{getClass:Zarafa.plugins.files.settings.data.AccountRenderUtil.featureRenderer.createDelegate(this,[Zarafa.plugins.files.data.AccountRecordFeature.STREAMING],!0),icon:"plugins/files/resources/icons/features/streaming.png",tooltip:dgettext("plugin_files","Fast Down/Upload")}]}]},showDialog:function(a,b,c){b=a.getStore().getAt(b);"ok"===b.get("status")&&Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType[c],
void 0,{store:a.getStore(),item:b,manager:Ext.WindowMgr})}});Ext.namespace("Zarafa.plugins.files.settings.ui");Zarafa.plugins.files.settings.ui.AccountPanel=Ext.extend(Ext.Panel,{constructor:function(a){a=Ext.applyIf(a||{},{border:!1,layout:"fit",items:[{xtype:"filesplugin.accountgrid",backendStore:a.model.backendStore,store:a.store,flex:1}]});Zarafa.plugins.files.settings.ui.AccountPanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.accountpanel",Zarafa.plugins.files.settings.ui.AccountPanel);
Ext.namespace("Zarafa.plugins.files.settings.ui");Zarafa.plugins.files.settings.ui.FeatureQuotaInfoContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.featurequotainfocontentpanel",title:dgettext("plugin_files","Quota Information"),statefull:!1,width:200,autoHeight:!0,items:[{xtype:"filesplugin.featurequotainfopanel",item:a.item}]});Zarafa.plugins.files.settings.ui.FeatureQuotaInfoContentPanel.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.featurequotainfocontentpanel",Zarafa.plugins.files.settings.ui.FeatureQuotaInfoContentPanel);Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.FeatureQuotaInfoPanel=Ext.extend(Ext.Panel,{account:void 0,constructor:function(a){a=a||{};a.item&&(this.account=a.item);Ext.applyIf(a,{xtype:"filesplugin.featurequotainfopanel",items:this.createPanelItems(),buttons:[{text:dgettext("plugin_files","Reload"),handler:this.doReload.createDelegate(this),scope:this},{text:dgettext("plugin_files","Close"),handler:this.doClose,scope:this}]});Zarafa.plugins.files.settings.ui.FeatureQuotaInfoPanel.superclass.constructor.call(this,
a);this.doReload()},doClose:function(){this.dialog.close()},doReload:function(){var a=new Zarafa.core.data.AbstractResponseHandler({doGetquota:this.gotQuotaValues.createDelegate(this)});container.getRequest().singleRequest("filesaccountmodule","getquota",{accountId:this.account.get("id"),folder:"/"},a)},gotQuotaValues:function(a){if(this.formPanel){var b=parseInt(a.quota[0].amount);a=parseInt(a.quota[1].amount);0>b&&(b=0);0>a&&(a=0);this.formPanel.getForm().setValues([{id:"usedField",value:Ext.util.Format.fileSize(b)},
{id:"availableField",value:Ext.util.Format.fileSize(a)},{id:"totalField",value:Ext.util.Format.fileSize(a+b)}])}},createPanelItems:function(){return[{xtype:"form",border:!1,ref:"formPanel",labelAlign:"left",items:[{xtype:"displayfield",name:"usedField",fieldLabel:dgettext("plugin_files","Used"),value:dgettext("plugin_files","Loading")+"&hellip;"},{xtype:"displayfield",name:"availableField",fieldLabel:dgettext("plugin_files","Free"),value:dgettext("plugin_files","Loading")+"&hellip;"},{xtype:"displayfield",
name:"totalField",fieldLabel:dgettext("plugin_files","Total"),value:dgettext("plugin_files","Loading")+"&hellip;"}]}]}});Ext.reg("filesplugin.featurequotainfopanel",Zarafa.plugins.files.settings.ui.FeatureQuotaInfoPanel);Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.FeatureVersionInfoContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.featureversioninfocontentpanel",stateful:!1,title:dgettext("plugin_files","Version Information"),width:300,height:100,items:[{xtype:"filesplugin.featureversioninfopanel",item:a.item}]});Zarafa.plugins.files.settings.ui.FeatureVersionInfoContentPanel.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.featureversioninfocontentpanel",Zarafa.plugins.files.settings.ui.FeatureVersionInfoContentPanel);Ext.namespace("Zarafa.plugins.files.settings.ui");
Zarafa.plugins.files.settings.ui.FeatureVersionInfoPanel=Ext.extend(Ext.Panel,{account:void 0,constructor:function(a){a=a||{};a.item&&(this.account=a.item);Ext.applyIf(a,{xtype:"filesplugin.featureversioninfopanel",items:this.createPanelItems(a),buttons:[{text:dgettext("plugin_files","Close"),handler:this.doClose,scope:this}]});Zarafa.plugins.files.settings.ui.FeatureVersionInfoPanel.superclass.constructor.call(this,a);this.doReload()},doClose:function(){this.dialog.close()},doReload:function(){var a=
new Zarafa.core.data.AbstractResponseHandler({doGetversion:this.gotVersionValues.createDelegate(this)});container.getRequest().singleRequest("filesaccountmodule","getversion",{accountId:this.account.get("id")},a)},gotVersionValues:function(a){this.backendVersionField.setValue(a.version.backend);this.serverVersionField.setValue(a.version.server)},createPanelItems:function(){return[{xtype:"form",border:!1,labelAlign:"left",items:[{xtype:"displayfield",ref:"../backendVersionField",fieldLabel:dgettext("plugin_files",
"Backend"),value:dgettext("plugin_files","Loading")+"&hellip;"},{xtype:"displayfield",ref:"../serverVersionField",fieldLabel:this.account.get("backend"),value:dgettext("plugin_files","Loading")+"&hellip;"}]}]}});Ext.reg("filesplugin.featureversioninfopanel",Zarafa.plugins.files.settings.ui.FeatureVersionInfoPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesContextNavigationPanel=Ext.extend(Zarafa.core.ui.ContextNavigationPanel,{context:void 0,model:void 0,store:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.filescontextnavigationpanel"});Zarafa.plugins.files.ui.FilesContextNavigationPanel.superclass.constructor.call(this,a);this.mon(this.store,"load",this.createAccountNavigationPanels,this,{single:!0});this.mon(this.store,{write:this.manageAccountNavigationPanel,reorder:this.swapPanels,scope:this})},
createAccountNavigationPanels:function(a,b){var c=[],d=this.context.getModel().getStore();b.forEach(function(a){a.get("status")===Zarafa.plugins.files.data.AccountRecordStatus.OK&&c.push({xtype:"panel",autoHeight:!0,cls:"zarafa-files-hierarchypanel-subpanel",iconCls:"icon_16_logo_"+a.get("backend"),title:dgettext("plugin_files",a.get("backend")),accId:a.get("id"),items:[{xtype:"filesplugin.navigatortreepanel",accountFilter:a.get("id"),ref:"../filesNavigatorTreePanel_"+a.get("id"),filesStore:d,listeners:{beforeclick:this.onBeforeClickNode,
scope:this}}]})},this);Ext.isEmpty(c)||(this.add(c),this.doLayout(!1,!0))},initEvents:function(){Zarafa.plugins.files.ui.FilesContextNavigationPanel.superclass.initEvents.apply(this,arguments);this.model=this.context.getModel();this.mon(this.model.getStore(),{load:this.onLoadFilesStore,write:this.onWriteFilesStore,remove:this.onRemoveFilesStore,update:this.onUpdateFilesStore,createfolder:this.onCreateFolder,scope:this})},manageAccountNavigationPanel:function(a,b,c,d,e){if("create"===b)return e.get("status")===
Zarafa.plugins.files.data.AccountRecordStatus.OK&&this.createAccountNavigationPanels(e.getStore(),[e]),!0;c=this.getTreePanelByAccountId(e.id);if(Ext.isDefined(c)){a=this.find("accId",e.id)[0];if("destroy"===b||e.get("status")===Zarafa.plugins.files.data.AccountRecordStatus.ERROR)return a.destroy(),!0;b=c.getRootNode().item(0);Ext.isDefined(b)&&(b.setText(e.get("name")),b.setIconCls("icon_16_"+e.get("backend")));a.setTitle(e.get("backend"));a.setIconClass("icon_16_logo_"+e.get("backend"))}else"update"===
b&&e.get("status")===Zarafa.plugins.files.data.AccountRecordStatus.OK&&this.createAccountNavigationPanels(e.getStore(),[e])},swapPanels:function(a,b){this.removeAll();this.createAccountNavigationPanels(this.store,this.store.getRange());this.doLayout()},onBeforeClickNode:function(a){var b=a.getOwnerTree().accountFilter;a=this.store.getRange().filter(function(a){return a.get("entryid")!==b});this.clearSelections(a)},clearSelections:function(a){Ext.isEmpty(a)||a.forEach(function(a){(a=this.getTreePanelByAccountId(a.get("id")))&&
a.getSelectionModel().clearSelections()},this)},onLoadFilesStore:function(a,b,c){a=c.params.id;Ext.isEmpty(a)||"#R#"===a?this.clearSelections(this.store.getRange()):(b=Zarafa.plugins.files.data.Utils.File.getAccountId(a),b=this.getTreePanelByAccountId(b),a=b.getNodeById(a),Ext.isDefined(a)&&b.selectNode(a))},onCreateFolder:function(a,b,c){a=Zarafa.plugins.files.data.Utils.File.getAccountId(a.getPath());b=this.getTreePanelByAccountId(a).getNodeById(b);Ext.isDefined(b)&&b.rendered&&b.appendChild({id:c.id,
text:c.filename,filename:c.filename,has_children:!1,expanded:!0,iconCls:"icon_folder_note",loaded:!0,isFolder:!0})},onWriteFilesStore:function(a,b,c,d,e){switch(b){case "rename":a=this.getTreePanelByAccountId(e.getAccount().id),b=a.getNodeById(d.oldId),Ext.isDefined(b)&&(b.setId(d.id),b.setText(d.text),b.attributes.filename=d.text,a.refreshNode(d.id))}},onRemoveFilesStore:function(a,b){var c=this.getTreePanelByAccountId(b.getAccount().id).getNodeById(b.get("id"));Ext.isDefined(c)&&c.remove(!0)},getTreePanelByAccountId:function(a){return this["filesNavigatorTreePanel_"+
a]},onUpdateFilesStore:function(a,b,c){c===Ext.data.Record.COMMIT&&b.isFolder()&&b.hasMessageAction("action_type")&&(a=b.getMessageActions(),"move"===a.action_type&&(c=this.getTreePanelByAccountId(b.getAccount().id),b=c.getNodeById(b.id),Ext.isDefined(b)&&(b.remove(),a=c.getNodeById(a.destination_parent_entryid),Ext.isDefined(a)&&(c=0<b.childNodes.length,a.appendChild({id:a.attributes.id+b.text+"/",text:b.text,isFolder:!0,has_children:c,expanded:!c,loaded:!1,iconCls:"icon_folder_note",filename:b.text,
leaf:!1})))))}});Ext.reg("filesplugin.filescontextnavigationpanel",Zarafa.plugins.files.ui.FilesContextNavigationPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesListToolbar=Ext.extend(Ext.Toolbar,{context:void 0,model:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(this.model=a.context.getModel());Ext.applyIf(a,{enableOverflow:!0,items:this.createToolbarItems()});Zarafa.plugins.files.ui.FilesListToolbar.superclass.constructor.call(this,a);this.initEvent()},initEvent:function(){this.mon(this.model.getStore(),"load",this.onLoad,this);this.mon(this.model,"recordselectionchange",this.onRecordSelectionChange,
this)},createToolbarItems:function(){return[{cls:"files_icon_actionbutton",text:dgettext("plugin_files","Upload"),ref:"uploadButton",overflowText:dgettext("plugin_files","Upload files"),iconCls:"files_icon_action files_icon_action_upload",handler:this.onFileUpload,model:this.model,scope:this},{cls:"files_icon_actionbutton",text:dgettext("plugin_files","New Folder"),ref:"createFolderButton",overflowText:dgettext("plugin_files","New Folder"),iconCls:"files_icon_action files_icon_action_new_folder",
handler:this.onCreateFolder,model:this.model},{ref:"downloadBtn",cls:"files_icon_actionbutton",text:dgettext("plugin_files","Download"),overflowText:dgettext("plugin_files","Download files"),iconCls:"files_icon_action files_icon_action_download",handler:this.onFileDownload,model:this.model},{cls:"files_icon_actionbutton",ref:"shareBtn",text:dgettext("plugin_files","Share"),overflowText:dgettext("plugin_files","Share files"),iconCls:"files_icon_action files_icon_action_share",handler:this.onFileShare,
model:this.model},{cls:"files_icon_actionbutton",ref:"attachToMailBtn",text:dgettext("plugin_files","Attach to mail"),overflowText:dgettext("plugin_files","Attach to mail"),iconCls:"files_icon_action files_icon_action_attach_to_mail",handler:this.onFileAddToMail,model:this.model,scope:this},{xtype:"tbfill"},{tooltip:dgettext("plugin_files","Rename"),overflowText:dgettext("plugin_files","Rename"),ref:"renameBtn",iconCls:"files_icon_action files_icon_action_edit",handler:this.onRename,model:this.model},
{xtype:"zarafa.toolbarbutton",tooltip:dgettext("plugin_files","Delete"),overflowText:dgettext("plugin_files","Delete"),iconCls:"files_icon_action files_icon_action_delete",nonEmptySelectOnly:!0,handler:this.onDelete,model:this.model}]},onRecordSelectionChange:function(a,b){var c=Zarafa.plugins.files.data.Utils.Validator,d=c.actionSelectionVisibilityFilter(b,!1,!0,!1,!0);this.downloadBtn.setDisabled(!d);this.attachToMailBtn.setDisabled(!d);(d=c.actionSelectionVisibilityFilter(b,!0,!1,!1,!0))?(this.shareBtn.setDisabled(!d),
c=b[0].getAccount(),this.shareBtn.setVisible(c.supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.SHARING))):this.shareBtn.setVisible(!1);this.renameBtn.setDisabled(!d)},onLoad:function(a,b,c){a=c.params.id;Ext.isEmpty(a)||"#R#"===a?(this.setDisabled(!0),this.shareBtn.setVisible(!1)):(this.createFolderButton.setDisabled(!1),this.uploadButton.setDisabled(!1))},onCreateFolder:function(a,b){Zarafa.plugins.files.data.Actions.createFolder(this.model)},onFileUpload:function(a,b){(new Zarafa.plugins.files.ui.UploadComponent({callback:this.uploadCallback,
multiple:!0,scope:this})).openUploadDialog()},onFileDownload:function(){var a=this.model.getSelectedRecords();Zarafa.plugins.files.data.Actions.downloadItem(a)},onFileShare:function(a,b){var c=this.model.getSelectedRecords();Zarafa.plugins.files.data.Actions.createShareDialog(c)},onFileAddToMail:function(a,b){var c=a.model.getSelectedRecords(),d=container.getContextByName("mail").getModel().createRecord(),e=[],f=d.getAttachmentStore();Ext.each(c,function(a){e.push(a.get("id"))},this);container.getNotifier().notify("info.files",
dgettext("plugin_files","Attaching"),dgettext("plugin_files","Creating email... Please wait!"));try{container.getRequest().singleRequest("filesbrowsermodule","downloadtotmp",{ids:e,maxAttachmentSize:container.getServerConfig().getMaxAttachmentSize(),dialog_attachments:f.getId()},new Zarafa.core.data.AbstractResponseHandler({doDownloadtotmp:this.attachToMail.createDelegate(this,[d],!0)}))}catch(g){Zarafa.plugins.files.data.Actions.msgWarning(g.message)}},uploadCallback:function(a,b){Zarafa.plugins.files.data.Actions.uploadAsyncItems(a,
this.model.getStore())},attachToMail:function(a,b){Zarafa.plugins.files.data.Actions.openCreateMailContent(b,a.items)},onRename:function(a,b){var c=this.model.getSelectedRecords();Zarafa.plugins.files.data.Actions.openRenameDialog(c[0])},onDelete:function(a,b){var c=this.model.getSelectedRecords();Zarafa.plugins.files.data.Actions.deleteRecords(c)}});Ext.reg("filesplugin.fileslisttoolbar",Zarafa.plugins.files.ui.FilesListToolbar);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesMainContextMenu=Ext.extend(Zarafa.core.ui.menu.ConditionalMenu,{context:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{items:[this.createContextActionItems(a.context.model),{xtype:"menuseparator"},container.populateInsertionPoint("plugin.files.contextmenu.actions",this),{xtype:"menuseparator"},container.populateInsertionPoint("plugin.files.contextmenu.options",this)]});Zarafa.plugins.files.ui.FilesMainContextMenu.superclass.constructor.call(this,a)},createContextActionItems:function(a){return[{xtype:"zarafa.conditionalitem",
text:dgettext("plugin_files","Download"),iconCls:"files_icon_action files_icon_action_download",handler:this.onContextItemDownload,beforeShow:function(a,c){var b=Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,!1,!0,!1,!1);a.setVisible(b)},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Share"),iconCls:"files_icon_action files_icon_action_share",handler:this.onContextItemShare,beforeShow:function(a,c){var b=!1,e=!1;0<c.length&&(b=c[0].getAccount(),
e=c[0].get("isshared"),b=b.supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.SHARING));b=b&&Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,!0,!1,!1,!0);a.setVisible(b);1==e&&a.setText(dgettext("plugin_files","Edit share"))},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","New Folder"),iconCls:"files_icon_action files_icon_action_new_folder",handler:this.onContextItemNewFolder,beforeShow:function(a,c){a.setVisible(Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,
!1,!1,!0,!0))},model:a,scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Attach to mail"),iconCls:"files_icon_action files_icon_action_attach_to_mail",handler:this.onContextItemAttach,beforeShow:function(a,c){for(var b=Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,!1,!0,!1,!0),e=container.getServerConfig().getMaxAttachmentSize(),f=0;f<c.length;f++)if(c[f].get("message_size")>e){b=!1;break}a.setVisible(b)},scope:this},{xtype:"zarafa.conditionalitem",
text:dgettext("plugin_files","Rename"),iconCls:"files_icon_action files_icon_action_edit",handler:this.onContextItemRename,beforeShow:function(a,c){a.setVisible(Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,!0,!1,!1,!0))},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Delete"),iconCls:"files_icon_action files_icon_action_delete",handler:this.onContextItemDelete,beforeShow:function(a,c){a.setVisible(Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,
!1,!1,!0))},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Info"),iconCls:"icon_info",handler:this.onContextItemInfo,beforeShow:function(a,c){var b=Zarafa.plugins.files.data.Utils.Validator.actionSelectionVisibilityFilter(c,!0,!1,!1,!0),e=this.context.getCurrentViewMode()===Zarafa.plugins.files.data.ViewModes.NO_PREVIEW;a.setDisabled(!b||!e)},scope:this}]},onContextItemDownload:function(){Zarafa.plugins.files.data.Actions.downloadItem(this.records)},onContextItemDelete:function(){Zarafa.plugins.files.data.Actions.deleteRecords(this.records)},
onContextItemShare:function(){Zarafa.plugins.files.data.Actions.createShareDialog(this.records)},onContextItemNewFolder:function(a,b){Zarafa.plugins.files.data.Actions.createFolder(a.model)},onContextItemInfo:function(){var a=void 0;1==this.records.length&&(a=this.records[0]);a=Ext.applyIf({},{modal:!0,record:a});Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"],void 0,a)},onContextItemRename:function(){Zarafa.plugins.files.data.Actions.openRenameDialog(this.records[0])},
onContextItemAttach:function(){var a=container.getContextByName("mail").getModel().createRecord(),b=[],c=a.getAttachmentStore();Ext.each(this.records,function(a){b.push(a.get("id"))},this);container.getNotifier().notify("info.files",dgettext("plugin_files","Attaching"),dgettext("plugin_files","Creating email... Please wait!"));try{container.getRequest().singleRequest("filesbrowsermodule","downloadtotmp",{ids:b,maxAttachmentSize:container.getServerConfig().getMaxAttachmentSize(),dialog_attachments:c.getId()},
new Zarafa.core.data.AbstractResponseHandler({doDownloadtotmp:this.attachToMail.createDelegate(this,[a],!0)}))}catch(d){Zarafa.plugins.files.data.Actions.msgWarning(d.message)}},attachToMail:function(a,b){Zarafa.plugins.files.data.Actions.openCreateMailContent(b,a.items)}});Ext.reg("filesplugin.filesmaincontextmenu",Zarafa.plugins.files.ui.FilesMainContextMenu);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesMainPanel=Ext.extend(Zarafa.common.ui.ContextMainPanel,{viewPanel:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.filesmainpanel",layout:"zarafa.switchborder",items:[this.initMainItems(a),this.initPreviewPanel(a.context)],tbar:{xtype:"filesplugin.filestoptoolbar",height:28,context:a.context}});Zarafa.plugins.files.ui.FilesMainPanel.superclass.constructor.call(this,a)},initMainItems:function(a){return{xtype:"panel",ref:"filesViewPanel",layout:"zarafa.collapsible",
cls:"zarafa-context-mainpanel",minWidth:200,minHeight:200,region:"center",collapsible:!1,split:!0,items:[{xtype:"zarafa.switchviewcontentcontainer",ref:"../viewPanel",layout:"card",lazyItems:this.initViews(a.context)}],tbar:{xtype:"filesplugin.fileslisttoolbar",defaultTitle:dgettext("plugin_files","Files"),height:33,context:a.context}}},initViews:function(a){var b=[{xtype:"filesplugin.filesrecordaccountview",flex:1,id:"files-accountview",anchor:"100%",context:a},{xtype:"filesplugin.filesrecordgridview",
flex:1,id:"files-gridview",anchor:"100%",context:a},{xtype:"filesplugin.filesrecordiconview",flex:1,id:"files-iconview",anchor:"100%",context:a}];a=container.populateInsertionPoint("plugin.files.views",this,a);return b=b.concat(a)},initPreviewPanel:function(a){return{xtype:"filesplugin.filespreviewpanel",ref:"filesPreview",region:"south",split:!0,context:a}},initEvents:function(){Ext.isDefined(this.context)&&(this.mon(this.context,"viewchange",this.onViewChange,this),this.mon(this.context,"viewmodechange",
this.onViewModeChange,this),this.onViewChange(this.context,this.context.getCurrentView()),this.onViewModeChange(this.context,this.context.getCurrentViewMode()));Zarafa.plugins.files.ui.FilesMainPanel.superclass.initEvents.apply(this,arguments)},onViewChange:function(a,b,c){switch(b){case Zarafa.plugins.files.data.Views.LIST:this.viewPanel.switchView("files-gridview");break;case Zarafa.plugins.files.data.Views.ICON:this.viewPanel.switchView("files-iconview")}},onViewModeChange:function(a,b,c){var d;
switch(b){case Zarafa.plugins.files.data.ViewModes.NO_PREVIEW:d=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.OFF;break;case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:d=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.HORIZONTAL;break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:d=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.VERTICAL;break;case Zarafa.plugins.files.data.ViewModes.SEARCH:return}a=this.getLayout();Ext.isFunction(a.setOrientation)?a.setOrientation(d):
Ext.isString(a)?this.layoutConfig=Ext.apply(this.layoutConfig||{},{orientation:d}):this.layout.orientation=d}});Ext.reg("filesplugin.filesmainpanel",Zarafa.plugins.files.ui.FilesMainPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesPreviewPanel=Ext.extend(Ext.Panel,{constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());var b=Ext.applyIf(a.tbar||{},{cls:"zarafa-previewpanel-toolbar",xtype:"zarafa.toolbar",height:33,hidden:!1,items:[]});Ext.applyIf(a,{xtype:"filesplugin.filespreviewpanel",layout:"fit",stateful:!0,cls:"zarafa-previewpanel zarafa-context-mainpanel",width:300,height:300,tbar:b});Zarafa.plugins.files.ui.FilesPreviewPanel.superclass.constructor.call(this,
a)}});Ext.reg("filesplugin.filespreviewpanel",Zarafa.plugins.files.ui.FilesPreviewPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordAccountView=Ext.extend(Ext.DataView,{context:void 0,model:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());!Ext.isDefined(a.store)&&Ext.isDefined(a.model)&&(a.store=a.model.getStore());a.store=Ext.StoreMgr.lookup(a.store);Ext.applyIf(a,{xtype:"filesplugin.filesrecordaccountview",cls:"zarafa-files-accountview",loadingText:dgettext("plugin_files","Loading accounts")+"...",deferEmptyText:!1,autoScroll:!0,
emptyText:'<div class="emptytext">'+dgettext("plugin_files","There are no accounts added. Go to settings and add an account!")+"</div>",overClass:"zarafa-files-accountview-over",tpl:this.initTemplate(a.context),multiSelect:!0,selectedClass:"zarafa-files-accountview-selected",itemSelector:"div.zarafa-files-accountview-container"});Zarafa.plugins.files.ui.FilesRecordAccountView.superclass.constructor.call(this,a);this.initEvents()},initTemplate:function(a){return new Ext.XTemplate('<div style="height: 100%; width: 100%; overflow: auto;">',
'<tpl for=".">','<div class="zarafa-files-accountview-container">','<div class="zarafa-files-account-background {.:this.getAccountType}"> </div>','<div class="zarafa-files-account-info">','<span class="zarafa-files-accountview-subject">{filename:htmlEncode}</span>','<span class="zarafa-files-accountview-account">{.:this.getAccountIdentifier}</span>',"</div>","</div>","</tpl>","</div>",{getAccountType:function(a){var b=this.context.getAccountsStore();a=Zarafa.plugins.files.data.Utils.File.getAccountId(a.id);
b=b.getById(a);a="Webdav";Ext.isDefined(b)&&(a=b.get("backend"));return"icon_256_"+a},getAccountIdentifier:function(a){var b=this.context.getAccountsStore();a=Zarafa.plugins.files.data.Utils.File.getAccountId(a.id);a=b.getById(a);b="";Ext.isDefined(a)&&(a=a.get("backend_config"))&&Ext.isDefined(a.user)&&Ext.isDefined(a.server_address)&&(b=a.user+"@"+a.server_address);return Zarafa.plugins.files.data.Utils.Format.truncate(b,27)},context:a})},initEvents:function(){this.on({dblclick:this.onIconDblClick,
afterrender:this.onAfterRender,scope:this})},onAfterRender:function(){new Ext.KeyMap(this.getEl(),{key:Ext.EventObject.DELETE,fn:this.onKeyDelete,scop:this})},onKeyDelete:function(){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:dgettext("plugin_files","To delete an account you have to go to settings."),icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})},onIconDblClick:function(a,b){var c=this.getStore(),d=c.getAt(b);c.loadPath(d.get("id"))}});
Ext.reg("filesplugin.filesrecordaccountview",Zarafa.plugins.files.ui.FilesRecordAccountView);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordDetailsPanel=Ext.extend(Ext.form.FormPanel,{defaultPreviewImage:"plugins/files/resources/icons/no-preview.jpg",record:void 0,constructor:function(a){a=a||{};var b={type:"vbox",align:"stretch",pack:"start"};Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode()===Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW&&Ext.apply(b,{type:"hbox"});a=Ext.applyIf(a,{xtype:"filesplugin.filesrecorddetailspanel",ref:"../fileinfo",autoDestroy:!0,layout:b,border:!1,
items:[this.fieldSetFileInfo(),this.fieldSetFilePreview()]});Ext.isDefined(a.record)&&(a=Ext.applyIf(a,{listeners:{afterlayout:function(a){this.update(this.record)}}}));Zarafa.plugins.files.ui.FilesRecordDetailsPanel.superclass.constructor.call(this,a)},refresh:function(){this.removeAll();this.add(this.fieldSetFileInfo());this.add(this.fieldSetFilePreview())},fieldSetFileInfo:function(){return{xtype:"fieldset",title:dgettext("plugin_files","File information"),height:150,width:300,defaults:{anchor:"-3"},
items:[{xtype:"textfield",fieldLabel:dgettext("plugin_files","Filename"),ref:"../filename",value:"unknown",readOnly:!0},{xtype:"textfield",fieldLabel:dgettext("plugin_files","Filesize"),ref:"../filesize",value:"unknown",readOnly:!0},{xtype:"textfield",fieldLabel:dgettext("plugin_files","Last modified"),ref:"../lastmodified",value:"unknown",readOnly:!0},{xtype:"textfield",fieldLabel:dgettext("plugin_files","Type"),ref:"../type",value:"unknown",readOnly:!0},{xtype:"textfield",fieldLabel:dgettext("plugin_files",
"Is shared"),ref:"../shared",hidden:!0,value:"unknown",readOnly:!0}]}},fieldSetFilePreview:function(){var a="width: 100%;";switch(Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode()){case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:a="width: 100%;";break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:a="height: 100%;"}return{xtype:"fieldset",title:dgettext("plugin_files","File preview"),ref:"filepreview",flex:1,autoScroll:!0,defaultType:"textfield",items:[{xtype:"component",
id:"previewimage",autoEl:{tag:"img",src:this.defaultPreviewImage,style:a}}]}},setPreviewPanel:function(a,b){var c=Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode(),d=Ext.isDefined(container.getPluginByName("filepreviewer"))?!0:!1,e=Ext.isDefined(container.getPluginByName("pdfbox"))?!0:!1,f=Ext.isDefined(container.getPluginByName("webodf"))?!0:!1,g="width: 100%;";switch(c){case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:g="width: 100%;";break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:g=
"height: 100%;"}c={};if(d||Ext.isEmpty(b)||!/\.(gif|jpg|jpeg|tiff|png|bmp)$/i.test(b))if(d&&!Ext.isEmpty(b)&&(new RegExp(container.getSettingsModel().get("zarafa/v1/plugins/filepreviewer/supported_filetypes"),"i")).test(b))c={xtype:"filepreviewer.viewerpanel",record:a,defaultScale:1,autoResize:this.filepreview,height:this.filepreview.getInnerHeight()};else if(!d&&e&&!Ext.isEmpty(b)&&/\.(pdf)$/i.test(b))c={xtype:"filesplugin.pdfjspanel",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),title:a.get("filename")};
else if(d||e||Ext.isEmpty(b)||!/\.(pdf)$/i.test(b))if(!Ext.isEmpty(b)&&/\.(txt|html|php|js|c|cpp|h|java|sh|bat|log|cfg|conf|tex|py|pl)$/i.test(b))c={xtype:"textarea",hideLabel:!0,readOnly:!0,anchor:"0, 0",listeners:{afterrender:function(){Ext.Ajax.request({method:"GET",url:Zarafa.plugins.files.data.Actions.getDownloadLink(a),success:function(a,b){this.setRawValue(a.responseText)},scope:this})}}};else if(!Ext.isEmpty(b)&&/\.(mp3|wav)$/i.test(b)){d="";switch(b.toLowerCase()){case ".wav":d="audio/wav";
break;default:d="audio/mpeg"}c={xtype:"component",autoEl:{tag:"audio",style:g,controls:"controls",cn:[{tag:"source",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),type:d},dgettext("plugin_files","Your browser does not support previewing of audio files!")]}}}else if(!Ext.isEmpty(b)&&/\.(mp4|ogg|webm)$/i.test(b)){d="";switch(b.toLowerCase()){case ".ogg":d="video/ogg";break;case ".webm":d="video/webm";break;default:d="audio/mp4"}c={xtype:"component",autoEl:{tag:"video",style:g+"height: auto;",
poster:"plugins/files/resources/images/preview/video_loader.gif",preload:"metadata",controls:"controls",cn:[{tag:"source",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),type:d},dgettext("plugin_files","Your browser does not support previewing of video files!")]}}}else c=f&&!Ext.isEmpty(b)&&/\.(odp|odt|ods)$/i.test(b)?{xtype:"filesplugin.webodfpanel",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),title:a.get("filename")}:{xtype:"component",autoEl:{tag:"img",src:this.defaultPreviewImage,
style:g}};else c={xtype:"component",autoEl:{tag:"iframe",width:"98%",height:"98%",border:"none",seamless:"",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a)}};else c={xtype:"component",autoEl:{tag:"img",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),style:g}};this.filepreview.removeAll(!0);this.filepreview.add(c);this.filepreview.doLayout()},update:function(a){this.filename.setValue(a.get("filename"));var b=a.get("type")==Zarafa.plugins.files.data.FileTypes.FILE;this.filesize.setVisible(b);
b&&this.filesize.setValue(Zarafa.plugins.files.data.Utils.Format.fileSize(a.get("message_size")));var c=Ext.util.Format.date(new Date(a.get("lastmodified")),dgettext("plugin_files","d.m.Y G:i"));this.lastmodified.setValue(c);c=dgettext("plugin_files","Folder");if(b)var d=this.getExtension(a.get("filename")),c=String.format(dgettext("plugin_files","File ({0})"),d);this.type.setValue(c);b=a.getAccount().supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.SHARING);this.shared.setVisible(b);
b&&this.shared.setValue(a.get("isshared")?dgettext("plugin_files","Yes"):dgettext("plugin_files","No"));this.setPreviewPanel(a,d)},onRender:function(a,b){Zarafa.plugins.files.ui.FilesRecordDetailsPanel.superclass.onRender.call(this,a,b);this.resizeEl=this.positionEl=this.wrap=this.el.wrap({cls:"preview-body"})},getExtension:function(a){var b=a.lastIndexOf(".");return 0>b?"":a.substr(b)}});Ext.reg("filesplugin.filesrecorddetailspanel",Zarafa.plugins.files.ui.FilesRecordDetailsPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordGridColumnModel=Ext.extend(Zarafa.common.ui.grid.ColumnModel,{useCompactView:!1,constructor:function(a){a=a||{};this.defaultColumns=this.createDefaultColumns();this.compactColumns=this.createCompactColumns();Ext.applyIf(a,{columns:this.defaultColumns,defaults:{sortable:!0}});!0===a.useCompactView&&(a.columns=this.compactColumns);Ext.apply(this,a);Zarafa.plugins.files.ui.FilesRecordGridColumnModel.superclass.constructor.call(this,a)},createDefaultColumns:function(){return[{id:"type",
dataIndex:"type",header:'<p class="icon_index">&nbsp;</p>',headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Utils.Renderer.typeRenderer,width:24,fixed:!0,tooltip:dgettext("plugin_files","Sort by: Type")},{header:"ID",dataIndex:"id",width:50,hidden:!0,tooltip:dgettext("plugin_files","Sort by: ID")},{header:"Path",dataIndex:"path",width:100,hidden:!0,tooltip:dgettext("plugin_files","Sort by: Path")},{header:dgettext("plugin_files","Filename"),dataIndex:"filename",width:160,tooltip:dgettext("plugin_files",
"Sort by: Filename")},{header:dgettext("plugin_files","Last modified"),dataIndex:"lastmodified",width:160,renderer:Zarafa.plugins.files.data.Utils.Renderer.datetimeRenderer,tooltip:dgettext("plugin_files","Sort by: Last modified")},{header:dgettext("plugin_files","Size"),dataIndex:"message_size",width:80,renderer:Zarafa.plugins.files.data.Utils.Format.fileSizeList,tooltip:dgettext("plugin_files","Sort by: Size")},{id:"isshared",dataIndex:"isshared",header:'<p class="files_icon_12_share">&nbsp;</p>',
headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Utils.Renderer.sharedRenderer,listeners:{click:this.doOnShareButtonClick},width:32,fixed:!0,tooltip:dgettext("plugin_files","Sort by: Shared")}]},createCompactColumns:function(){return[{id:"column_type",dataIndex:"type",header:'<p class="icon_index">&nbsp;</p>',headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Utils.Renderer.typeRenderer,width:24,fixed:!0,tooltip:dgettext("plugin_files","Sort by: Type")},{header:dgettext("plugin_files",
"Filename"),dataIndex:"filename",width:160,tooltip:dgettext("plugin_files","Sort by: Filename")},{header:dgettext("plugin_files","Last modified"),dataIndex:"lastmodified",width:100,renderer:Zarafa.plugins.files.data.Utils.Renderer.datetimeRenderer,tooltip:dgettext("plugin_files","Sort by: Last modified")},{header:dgettext("plugin_files","Size"),dataIndex:"message_size",width:80,hidden:!0,renderer:Zarafa.plugins.files.data.Utils.Format.fileSizeList,tooltip:dgettext("plugin_files","Sort by: Size")},
{id:"isshared",dataIndex:"isshared",header:'<p class="files_icon_12_share">&nbsp;</p>',headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Utils.Renderer.sharedRenderer,listeners:{click:this.doOnShareButtonClick},width:32,fixed:!0,tooltip:dgettext("plugin_files","Sort by: Shared")}]},setCompactView:function(a){this.useCompactView!==a&&((this.useCompactView=a)?(this.name="compact",this.defaultColumns=this.config,this.columns=this.compactColumns):(this.name="default",this.compactColumns=
this.config,this.columns=this.defaultColumns),this.setConfig(this.columns,!1))},doOnShareButtonClick:function(a,b,c,d){a=b.store.getAt(c);!0===a.get("isshared")&&Zarafa.plugins.files.data.Actions.createShareDialog([a])}});Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordGridView=Ext.extend(Zarafa.common.ui.grid.GridPanel,{context:void 0,model:void 0,dropTarget:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());!Ext.isDefined(a.store)&&Ext.isDefined(a.model)&&(a.store=a.model.getStore());a.store=Ext.StoreMgr.lookup(a.store);Ext.applyIf(a,{xtype:"filesplugin.filesrecordgridview",ddGroup:"dd.filesrecord",id:"files-gridview",enableDragDrop:!0,border:!1,stateful:!0,
statefulRelativeDimensions:!1,loadMask:this.initLoadMask(),viewConfig:this.initViewConfig(),sm:this.initSelectionModel(),cm:this.initColumnModel(),keys:{key:Ext.EventObject.DELETE,handler:this.onKeyDelete,scope:this}});Zarafa.plugins.files.ui.FilesRecordGridView.superclass.constructor.call(this,a)},initEvents:function(){Zarafa.plugins.files.ui.FilesRecordGridView.superclass.initEvents.call(this);this.mon(this,"cellcontextmenu",this.onCellContextMenu,this);this.mon(this,"rowbodycontextmenu",this.onRowBodyContextMenu,
this);this.mon(this,"rowdblclick",this.onRowDblClick,this);this.mon(this,"afterrender",this.initDropTarget,this);this.mon(this.getStore(),"createFolder",this.onCreateFolder,this);this.mon(this.getSelectionModel(),"rowselect",this.onRowSelect,this,{buffer:1});this.mon(this.getSelectionModel(),"selectionchange",this.onSelectionChange,this,{buffer:1});this.mon(this.context,"viewmodechange",this.onContextViewModeChange,this);this.onContextViewModeChange(this.context,this.context.getCurrentViewMode());
this.mon(this.bwrap,"drop",this.onDropItemToUpload,this)},initLoadMask:function(){return{msg:dgettext("plugin_files","Loading files")+"..."}},initViewConfig:function(){return{enableRowBody:!1,rowSelectorDepth:15}},initSelectionModel:function(){return new Ext.grid.RowSelectionModel},initColumnModel:function(){return new Zarafa.plugins.files.ui.FilesRecordGridColumnModel},initDropTarget:function(){this.dropTarget=new Ext.dd.DropTarget(this.getEl(),{ddGroup:"dd.filesrecord",copy:!1,gridStore:this.getStore(),
gridSM:this.getSelectionModel(),notifyDrop:function(a,b,c){if(this.notifyOver(a,b,c)!==this.dropAllowed)return!1;a=a.getDragData(b).rowIndex;b=this.gridStore.getAt(a);return Ext.isDefined(a)&&b.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER?(Ext.each(c.selections,function(a){a.setDisabled(!0)}),Zarafa.plugins.files.data.Actions.moveRecords(c.selections,b)):!1},notifyOver:function(a,b,c){a=a.getDragData(b).rowIndex;var d=this.dropNotAllowed;if(Ext.isDefined(a)){var e=this.gridStore.getAt(a);
e.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER&&(d=this.dropAllowed);Ext.each(c.selections,function(a){var b=a.get("id"),c=e.get("id");if(b===c||".."===a.get("filename")||c.slice(0,b.length)===b)return d=this.dropNotAllowed,!1},this)}return d},notifyEnter:function(a,b,c){return this.notifyOver(a,b,c)}});this.getView().dragZone.onBeforeDrag=function(a,b){var c=!0,d=!1,e=a.grid.getStore().getAt(a.rowIndex);Ext.each(a.selections,function(a){e.get("id")===a.get("id")&&(d=!0);if(".."===a.get("filename")||
a.getDisabled())return c=!1});return d?c:".."===e.get("filename")||e.getDisabled()?!1:!0}},onDropItemToUpload:function(a){a.stopPropagation();a.preventDefault();Zarafa.plugins.files.data.Actions.uploadAsyncItems(a.browserEvent.target.files||a.browserEvent.dataTransfer.files,this.getStore())},onContextViewModeChange:function(a,b,c){a=b===Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW;this.getColumnModel().setCompactView(a)},onCellContextMenu:function(a,b,c,d){a=this.getSelectionModel();a.hasSelection()?
a.isSelected(b)||(a.clearSelections(),a.selectRow(b)):a.selectRow(b);b=a.getSelections();b.some(function(a){return!0===a.getDisabled()},this)||Zarafa.core.data.UIFactory.openDefaultContextMenu(b,{position:d.getXY(),context:this.context})},onRowBodyContextMenu:function(a,b,c){this.onCellContextMenu(a,b,-1,c)},onRowDblClick:function(a,b){var c=this.getStore(),d=c.getAt(b);d.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER?c.loadPath(d.get("id")):Zarafa.plugins.files.data.Actions.downloadItem(d)},
onKeyDelete:function(a,b){var c=this.getSelectionModel().getSelections();Zarafa.plugins.files.data.Actions.deleteRecords(c)},onRowSelect:function(a,b,c){b=this.context.getCurrentViewMode();a=a.getCount();b===Zarafa.plugins.files.data.ViewModes.NO_PREVIEW||1<a||c.getDisabled()||(1===a?(a=container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/",c.get("id")!==a&&this.model.setPreviewRecord(c)):this.model.setPreviewRecord(void 0))},onSelectionChange:function(a){a=a.getSelections();
this.model.setSelectedRecords(Ext.isEmpty(a)?void 0:a)},onCreateFolder:function(a,b,c){a.getPath()===b&&(b=Zarafa.core.data.RecordFactory.createRecordObjectByCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,c),a.add(b),a.on("update",Zarafa.plugins.files.data.Actions.doRefreshIconView,Zarafa.plugins.files.data.Actions,{single:!0}),b.commit(!0))}});Ext.reg("filesplugin.filesrecordgridview",Zarafa.plugins.files.ui.FilesRecordGridView);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordIconView=Ext.extend(Zarafa.common.ui.DraggableDataView,{context:void 0,model:void 0,dropTarget:void 0,keyMap:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());!Ext.isDefined(a.store)&&Ext.isDefined(a.model)&&(a.store=a.model.getStore());a.store=Ext.StoreMgr.lookup(a.store);a.plugins=Ext.value(a.plugins,[]);a.plugins.push("zarafa.icondragselectorplugin");Ext.applyIf(a,{xtype:"filesplugin.filesrecordiconview",
cls:"zarafa-files-iconview",loadingText:dgettext("plugin_files","Loading files")+"...",deferEmptyText:!1,autoScroll:!0,emptyText:'<div class="emptytext">'+dgettext("plugin_files","There are no items to show in this view")+"</div>",overClass:"zarafa-files-iconview-over",tpl:this.initTemplate(),multiSelect:!0,selectedClass:"zarafa-files-iconview-selected",itemSelector:"div.zarafa-files-iconview-thumb",enableDragDrop:!0,ddGroup:"dd.filesrecord"});Zarafa.plugins.files.ui.FilesRecordIconView.superclass.constructor.call(this,
a);this.initEvents()},initTemplate:function(){return new Ext.XTemplate('<div style="height: 100%; width: 100%; overflow: auto;">','<tpl for=".">','<div class="zarafa-files-iconview-container {.:this.getHidden}">','<div class="zarafa-files-iconview-thumb {.:this.getTheme} {.:this.getHidden}"></div>','<span class="zarafa-files-iconview-subject">{filename:htmlEncode}</span>',"</div>","</tpl>","</div>",{getHidden:function(a){return".."===a.filename?"files_type_hidden":""},getTheme:function(a){switch(a.type){case Zarafa.plugins.files.data.FileTypes.FOLDER:return Zarafa.plugins.files.data.Utils.File.getIconClass("folder");
case Zarafa.plugins.files.data.FileTypes.FILE:return Zarafa.plugins.files.data.Utils.File.getIconClass(a.filename);default:return"files48icon_blank"}}})},initEvents:function(){this.on({contextmenu:this.onFilesIconContextMenu,dblclick:this.onIconDblClick,selectionchange:this.onSelectionChange,afterrender:this.onAfterRender,scope:this});this.mon(this.store,"createfolder",this.onCreateFolder,this)},onCreateFolder:function(a,b,c){a.getPath()===b&&(b=Zarafa.core.data.RecordFactory.createRecordObjectByCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,
c),a.add(b),a.on("update",Zarafa.plugins.files.data.Actions.doRefreshIconView,Zarafa.plugins.files.data.Actions,{single:!0}),b.commit(!0))},onAfterRender:function(){Zarafa.core.KeyMapMgr.isGloballyEnabled()&&(this.keyMap=new Ext.KeyMap(this.getEl(),{key:Ext.EventObject.DELETE,fn:this.onKeyDelete.createDelegate(this)}),Zarafa.core.KeyMapMgr.disableAllKeymaps(this.getEl()));this.initDropTarget()},onKeyDelete:function(a,b){var c=this.getSelectedRecords();Zarafa.plugins.files.data.Actions.deleteRecords(c)},
initDropTarget:function(){var a=this.getEl(),b=a.wrap({cls:"x-form-field-wrap"});this.mon(b,"drop",this.onDropItemToUpload,this);this.dropTarget=new Ext.dd.DropTarget(a,{ddGroup:"dd.filesrecord",copy:!1,fileStore:this.getStore(),notifyDrop:function(a,b,e){if(this.notifyOver(a,b,e)!==this.dropAllowed)return!1;a=a.getDragData(b);return Ext.isDefined(a)&&(a=a.index,b=this.fileStore.getAt(a),Ext.isDefined(a)&&b.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER)?(Ext.each(e.selections,function(a){a.setDisabled(!0)}),
Zarafa.plugins.files.data.Actions.moveRecords(e.selections,b)):!1},notifyOver:function(a,b,e){a=a.getDragData(b);var c=this.dropNotAllowed;if(Ext.isDefined(a)&&(a=a.index,Ext.isDefined(a))){var d=this.fileStore.getAt(a);d.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER&&(c=this.dropAllowed);Ext.each(e.selections,function(a){var b=a.get("id"),e=d.get("id");if(b===e||".."===a.get("filename")||e.slice(0,b.length)===b)return c=this.dropNotAllowed,!1},this)}return c},notifyEnter:function(a,b,
e){return this.notifyOver(a,b,e)}});this.dragZone.onBeforeDrag=function(a,b){var c=!0,d=!1,g=this.view.getStore().getAt(a.index);Ext.each(a.selections,function(a){g.get("id")===a.get("id")&&(d=!0);if(a.getDisabled())return c=!1});return d?c:g.getDisabled()?!1:!0}},onDropItemToUpload:function(a){a.stopPropagation();a.preventDefault();Zarafa.plugins.files.data.Actions.uploadAsyncItems(a.browserEvent.target.files||a.browserEvent.dataTransfer.files,this.getStore())},onFilesIconContextMenu:function(a,
b,c,d){a.isSelected(c)||a.select(c);a=a.getSelectedRecords();var e=!0;Ext.each(a,function(a){!0===a.getDisabled()&&(e=!1)});e&&Zarafa.core.data.UIFactory.openDefaultContextMenu(a,{position:d.getXY(),context:this.context})},onIconDblClick:function(a,b,c,d){a=this.getStore();b=a.getAt(b);b.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER?a.loadPath(b.get("id")):Zarafa.plugins.files.data.Actions.downloadItem(b)},onSelectionChange:function(a,b){this.model.setSelectedRecords(a.getSelectedRecords());
var c=this.context.getCurrentViewMode(),d=a.getSelectedRecords(),e=d.length;c!=Zarafa.plugins.files.data.ViewModes.NO_PREVIEW&&(1!=e?this.model.setPreviewRecord(void 0):1==e&&(d[0].get("id")!==container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"&&".."!==d[0].get("filename")?this.model.setPreviewRecord(d[0]):this.model.setPreviewRecord(void 0)))}});Ext.reg("filesplugin.filesrecordiconview",Zarafa.plugins.files.ui.FilesRecordIconView);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesRecordViewPanel=Ext.extend(Ext.Panel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.filesrecordviewpanel",border:!1,cls:"zarafa-filesviewpanel",layout:"zarafa.collapsible",items:[{xtype:"filesplugin.filesrecorddetailspanel"}]});Zarafa.plugins.files.ui.FilesRecordViewPanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.filesrecordviewpanel",Zarafa.plugins.files.ui.FilesRecordViewPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesTopToolbar=Ext.extend(Ext.Toolbar,{context:void 0,model:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());Ext.applyIf(a,{cls:"files_top_toolbar",items:[{xtype:"filesplugin.navigationbar",model:a.model,accountsStore:a.context.getAccountsStore()},{xtype:"tbfill"},{xtype:"filesplugin.quotabar",model:a.model,accountsStore:a.context.getAccountsStore()}]});Zarafa.plugins.files.ui.FilesTopToolbar.superclass.constructor.call(this,
a)}});Ext.reg("filesplugin.filestoptoolbar",Zarafa.plugins.files.ui.FilesTopToolbar);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesTreeContextMenu=Ext.extend(Zarafa.core.ui.menu.ConditionalMenu,{context:void 0,model:void 0,records:void 0,constructor:function(a){a=a||{};!Ext.isDefined(a.model)&&Ext.isDefined(a.context)&&(a.model=a.context.getModel());Ext.isDefined(a.records)&&(this.records=a.records);Ext.applyIf(a,{items:[this.createContextActionItems(),{xtype:"menuseparator"},container.populateInsertionPoint("plugin.files.treecontextmenu.actions",this),{xtype:"menuseparator"},container.populateInsertionPoint("plugin.files.treecontextmenu.options",
this)]});Zarafa.plugins.files.ui.FilesTreeContextMenu.superclass.constructor.call(this,a)},createContextActionItems:function(){return[{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","New Folder"),iconCls:"files_icon_action files_icon_action_new_folder",handler:this.onContextItemNewFolder,scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Rename"),iconCls:"files_icon_action files_icon_action_edit",handler:this.onContextItemRename,beforeShow:function(a,b){var c=Zarafa.plugins.files.data.Utils.File.stripAccountId(b[0].get("id"));
a.setVisible("/"!=c)},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Delete"),iconCls:"files_icon_action files_icon_action_delete",handler:this.onContextItemDelete,beforeShow:function(a,b){var c=Zarafa.plugins.files.data.Utils.File.stripAccountId(b[0].get("id"));a.setVisible("/"!=c)},scope:this}]},onContextItemDelete:function(a,b){Zarafa.plugins.files.data.Actions.deleteRecords(this.records)},onContextItemNewFolder:function(a,b){Zarafa.plugins.files.data.Actions.createFolder(this.model,
null,this.records[0].get("id"))},onContextItemRename:function(a,b){Zarafa.plugins.files.data.Actions.openRenameDialog(this.records[0])}});Ext.reg("filesplugin.filestreecontextmenu",Zarafa.plugins.files.ui.FilesTreeContextMenu);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.MultipleFileUploadField=Ext.extend(Ext.ux.form.FileUploadField,{createFileInput:function(){var a={id:this.getFileInputId(),name:this.name||this.getId(),cls:"x-form-file",tag:"input",type:"file",size:1,multiple:"multiple"};this.fileInput=this.wrap.createChild(a)},bindListeners:function(){this.fileInput.on({scope:this,mouseenter:function(){this.button.addClass(["x-btn-over","x-btn-focus"])},mouseleave:function(){this.button.removeClass(["x-btn-over","x-btn-focus","x-btn-click"])},
mousedown:function(){this.button.addClass("x-btn-click")},mouseup:function(){this.button.removeClass(["x-btn-over","x-btn-focus","x-btn-click"])},change:function(){var a=this.fileInput.dom.value;1<this.fileInput.dom.files.length&&(a=this.fileInput.dom.files.length+" "+dgettext("plugin_files","files selected"));this.setValue(a);this.fireEvent("fileselected",this,a)}})}});Ext.reg("filesplugin.multiplefileuploadfield",Zarafa.plugins.files.ui.MultipleFileUploadField);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.Tree=Ext.extend(Ext.tree.TreePanel,{accountFilter:null,treeSorter:!0,constructor:function(a){a=a||{};Ext.isDefined(a.accountFilter)&&(this.accountFilter=a.accountFilter);Ext.applyIf(a,{xtype:"filesplugin.tree",enableDD:!0,ddGroup:"dd.filesrecord",ddAppendOnly:!0,pathSeparator:"&",root:{nodeType:"async",text:"Files",id:"#R#",expanded:!0,cc:!1},rootVisible:!1,autoScroll:!0,maskDisabled:!0,loader:new Zarafa.plugins.files.data.NavigatorTreeLoader({loadfiles:!1,accountFilter:this.accountFilter})});
Zarafa.plugins.files.ui.Tree.superclass.constructor.call(this,a);!this.treeSorter||this.treeSorter instanceof Ext.tree.TreeSorter||(this.treeSorter=new Ext.tree.TreeSorter(this))},convertNodeToRecord:function(a){a=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,{id:a.attributes.id,filename:a.attributes.filename,path:a.attributes.path,type:a.attributes.isFolder?Zarafa.plugins.files.data.FileTypes.FOLDER:Zarafa.plugins.files.data.FileTypes.FILE,
entryid:a.attributes.id,message_class:"IPM.Files"},a.attributes.id);a.store=this.filesStore;return a},selectNode:function(a,b){Ext.isDefined(b)||(this.nodeToSelect=a.id);if(Ext.isDefined(b)&&b.rendered)b.select(),b.expand();else if(Ext.isDefined(a)&&a.rendered)a.select(),a.expand();else{var c=a.id.replace(/\\/g,"/").replace(/\/[^\/]*\/?$/,"")+"/",c=this.getNodeById(c);if(Ext.isDefined(c))c.on("expand",this.selectNode.createDelegate(this,[a],!0),this,{single:!0})}}});Ext.reg("filesplugin.tree",Zarafa.plugins.files.ui.Tree);
Ext.namespace("Zarafa.plugins.files.ui");Zarafa.plugins.files.ui.TreeSorter=Ext.extend(Ext.tree.TreeSorter,{constructor:function(a,b){Zarafa.plugins.files.ui.TreeSorter.superclass.constructor.apply(this,arguments);this.sortFn=this.hierarchySort.createDelegate(this)},hierarchySort:function(a,b){var c=a.attributes,d=b.attributes,e=c.isFolder,f=d.isFolder;return e&&f||!e&&!f?(d=d.text,c.text.toUpperCase()<d.toUpperCase()?-1:1):!e&&f?1:-1}});Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.UploadComponent=Ext.extend(Ext.Component,{callback:Ext.emptyFn,scope:void 0,multiple:!1,accept:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.uploadcomponent"});Zarafa.plugins.files.ui.UploadComponent.superclass.constructor.call(this,a)},openUploadDialog:function(){var a=this.getUploadEl();a.on("change",this.onFileInputChange,this);a.dom.click()},getUploadEl:function(){var a=Ext.DomHelper.append(Ext.getBody(),{cls:"x-hidden",tag:"input",type:"file"});
Ext.isDefined(this.multiple)&&this.multiple&&(a.multiple=this.multiple);Ext.isDefined(this.accept)&&(a.accept=this.accept);return a=Ext.get(a)},onFileInputChange:function(a){var b=a.browserEvent;a=Ext.get(b.target);b=(b=b.dataTransfer)?b.files:void 0;this.callback.call(this.scope,a.dom.files||b);a.remove()}});Ext.reg("filesplugin.uploadcomponent",Zarafa.plugins.files.ui.UploadComponent);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.AttachFromFilesContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{record:null,constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:dgettext("plugin_files","Add attachment from Files"),closeOnSave:!0,width:400,height:300,items:[{xtype:"filesplugin.attachfromfilestreepanel",emailrecord:a.emailrecord,ref:"treePanel"}]});Zarafa.plugins.files.ui.dialogs.AttachFromFilesContentPanel.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.attachfromfilescontentpanel",Zarafa.plugins.files.ui.dialogs.AttachFromFilesContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.AttachFromFilesTreePanel=Ext.extend(Ext.tree.TreePanel,{emailRecord:void 0,treeSorter:!0,constructor:function(a){a=a||{};Ext.isDefined(a.emailrecord)&&(this.emailRecord=a.emailrecord);Ext.applyIf(a,{root:{nodeType:"async",text:"Files",id:"#R#",expanded:!0,cc:!1},rootVisible:!1,autoScroll:!0,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},listeners:{expandnode:this.onExpandNode},maskDisabled:!0,loader:new Zarafa.plugins.files.data.NavigatorTreeLoader({loadfiles:!0}),
buttons:[this.createActionButtons()]});Zarafa.plugins.files.ui.dialogs.AttachFromFilesTreePanel.superclass.constructor.call(this,a);!this.treeSorter||this.treeSorter instanceof Ext.tree.TreeSorter||(this.treeSorter=new Zarafa.plugins.files.ui.TreeSorter(this,Ext.apply({},this.treeSorter)))},onExpandNode:function(a){a.attributes.cc=!0;a.eachChild(function(a){!0!==a.attributes.cc&&(a.attributes.cc=!0,a.quietLoad())})},createActionButtons:function(){return[{xtype:"button",text:"&nbsp;&nbsp;&nbsp;&nbsp;"+
dgettext("plugin_files","Add attachment"),iconCls:"icon_files_category_white",handler:this.downloadSelectedFilesFromFilesToTmp,scope:this}]},downloadSelectedFilesFromFilesToTmp:function(){var a=this.getChecked(),b=[],c=this.dialog.record;Ext.isDefined(this.emailRecord)&&(c=this.emailRecord);var c=c.getAttachmentStore(),d=container.getServerConfig().getMaxAttachmentSize(),e=!1;Ext.each(a,function(a,c){if(a.attributes.filesize>d)return Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Warning"),msg:String.format(dgettext("plugin_files","The file {0} is too large!"),a.attributes.filename)+" ("+dgettext("plugin_files","max")+": "+Ext.util.Format.fileSize(d)+")",icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK}),e=!0,!1;b.push(a.id)});if(!e)if(1>b.length)Ext.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:dgettext("plugin_files","You have to choose at least one file!"),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK});
else try{this.disable(),container.getRequest().singleRequest("filesbrowsermodule","downloadtotmp",{ids:b,dialog_attachments:c.getId()},new Zarafa.core.data.AbstractResponseHandler({doDownloadtotmp:this.addDownloadedFilesAsAttachmentToEmail.createDelegate(this)}))}catch(f){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:f.getMessage(),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK})}},convertDownloadedFileInfoToAttachmentRecord:function(a){var b=
Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.MAPI_ATTACH);b.set("tmpname",a.tmpname);b.set("name",a.name);b.set("size",a.size);b.set("attach_id",a.attach_id);return b},addDownloadedFilesAsAttachmentToEmail:function(a){a=a.items;var b=this.dialog.record;Ext.isDefined(this.emailRecord)&&(b=this.emailRecord);var c=b.getAttachmentStore();Ext.each(a,function(a){a=this.convertDownloadedFileInfoToAttachmentRecord(a);c.add(a)},this);this.dialog.close()}});
Ext.reg("filesplugin.attachfromfilestreepanel",Zarafa.plugins.files.ui.dialogs.AttachFromFilesTreePanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.CreateFolderContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.createfoldercontentpanel",layout:"fit",title:dgettext("plugin_files","Create New Folder"),width:300,height:350,items:[{xtype:"filesplugin.createfolderpanel",accountFilter:a.accountFilter,selectedFolderId:a.selectedFolderId,store:a.store}]});Zarafa.plugins.files.ui.dialogs.CreateFolderContentPanel.superclass.constructor.call(this,a)}});
Ext.reg("filesplugin.createfoldercontentpanel",Zarafa.plugins.files.ui.dialogs.CreateFolderContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.CreateFolderPanel=Ext.extend(Ext.Panel,{selectedFolderId:void 0,store:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.createfolderpanel",layout:{type:"fit",align:"stretch"},border:!1,header:!1,items:this.createPanel(a.accountFilter),buttonAlign:"right",buttons:[{text:dgettext("plugin_files","Ok"),disabled:!0,ref:"../okButton",cls:"zarafa-action",handler:this.onOk,scope:this},{text:dgettext("plugin_files","Cancel"),disabled:!0,ref:"../cancelButton",
handler:this.onCancel,scope:this}]});Zarafa.plugins.files.ui.dialogs.CreateFolderPanel.superclass.constructor.call(this,a)},createPanel:function(a){return[{xtype:"panel",layout:"form",border:!1,defaults:{anchor:"100%"},labelAlign:"top",items:[{xtype:"textfield",fieldLabel:dgettext("plugin_files","Name"),cls:"form-field-name",ref:"../newNameField"},{xtype:"filesplugin.tree",bodyCssClass:"files-create-folder-tree-panel",fieldLabel:dgettext("plugin_files","Select where to place the folder"),anchor:"100% 80%",
forceLayout:!0,ref:"../hierarchyTree",accountFilter:a}]}]},initEvents:function(){Zarafa.plugins.files.ui.dialogs.CreateFolderPanel.superclass.initEvents.apply(this,arguments);this.mon(this.hierarchyTree,"load",this.onTreeNodeLoad,this);this.mon(this.hierarchyTree.getSelectionModel(),"selectionchange",this.onSelectionChange,this)},onCancel:function(){this.dialog.close()},onOk:function(a,b){this.okButton.disable();var c=this.newNameField.getValue();Ext.isEmpty(c.trim())?Ext.MessageBox.show({title:dgettext("plugin_files",
"Kopano WebApp"),msg:dgettext("plugin_files","You must specify a name."),buttons:Ext.MessageBox.OK,icon:Ext.MessageBox.INFO,fn:function(a){this.okButton.enable()},scope:this}):this.doCheckFolderDuplicate(c)},doCheckFolderDuplicate:function(a){container.getRequest().singleRequest("filesbrowsermodule","checkifexists",{records:[{id:this.selectedFolderId+a+"/",isFolder:!0}],destination:this.selectedFolderId},new Zarafa.core.data.AbstractResponseHandler({doCheckifexists:this.checkForDuplicateDone.createDelegate(this,
[a,this.selectedFolderId],!0)}))},checkForDuplicateDone:function(a,b,c){!0===a.duplicate?(this.okButton.enable(),Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Folder already exists"))):Zarafa.plugins.files.data.Utils.File.isValidFilename(b)?this.doCreateFolder(b,c):(this.okButton.enable(),Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Incorrect foldername")))},doCreateFolder:function(a,b){var c=new Date,c={filename:a,path:Zarafa.plugins.files.data.Utils.File.stripAccountId(b).replace(/\/+$/,
""),id:b+a+"/",message_size:-1,lastmodified:c.toUTC().getTime(),type:Zarafa.plugins.files.data.FileTypes.FOLDER};container.getRequest().singleRequest("filesbrowsermodule","createdir",{props:c},new Zarafa.core.data.AbstractResponseHandler({doCreatedir:this.createFolderDone.createDelegate(this,[a,b],!0)}))},createFolderDone:function(a,b,c){if(!Ext.isDefined(a.item[0]))return Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Folder could not be created!")),!1;a=new Date;b={filename:b,
path:Zarafa.plugins.files.data.Utils.File.stripAccountId(c).replace(/\/+$/,""),id:c+b+"/",virtualRecord:!0,message_size:-1,lastmodified:a.toUTC().getTime(),type:Zarafa.plugins.files.data.FileTypes.FOLDER};this.store.fireEvent("createfolder",this.store,c,b);this.dialog.close()},onSelectionChange:function(a,b){Ext.isDefined(b)?(this.okButton.enable(),this.cancelButton.enable(),this.selectedFolderId=b.id):(this.okButton.disable(),this.cancelButton.disable())},onTreeNodeLoad:function(a){a=this.getNodeFromPath(this.selectedFolderId);
a.id===this.selectedFolderId?(this.hierarchyTree.selectNode(a),a.expand(!1,!0,function(){this.newNameField.focus(!1,50)},this),this.mun(this.hierarchyTree,"load",this.onTreeNodeLoad,this)):a.expand()},getNodeFromPath:function(a){var b=this.hierarchyTree.getNodeById(a);Ext.isDefined(b)||(a=a.split("/").slice(0,-2).join("/"),b=this.getNodeFromPath(a+"/"));return b}});Ext.reg("filesplugin.createfolderpanel",Zarafa.plugins.files.ui.dialogs.CreateFolderPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.FilesRecordContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.filesrecordcontentpanel",layout:"fit",title:dgettext("plugin_files","File information"),items:[this.createPanel(a)]});Zarafa.plugins.files.ui.dialogs.FilesRecordContentPanel.superclass.constructor.call(this,a)},createPanel:function(a){return{xtype:"filesplugin.filesrecorddetailspanel",record:a.record}}});
Ext.reg("filesplugin.filesrecordcontentpanel",Zarafa.plugins.files.ui.dialogs.FilesRecordContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.FilesUploadContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{targetFolder:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.filesuploadcontentpanel",layout:"fit",title:dgettext("plugin_files","Upload file"),items:[{xtype:"form",ref:"mainuploadform",layout:{type:"vbox",align:"stretch",pack:"start"},fileUpload:!0,padding:5,items:[this.createFolderSelector(),this.createUploadField()],buttons:this.createActionButtons()}]});Zarafa.plugins.files.ui.dialogs.FilesUploadContentPanel.superclass.constructor.call(this,
a)},createUploadField:function(){return{xtype:"panel",title:dgettext("plugin_files","Select a file")+" ("+dgettext("plugin_files","Maximum upload size")+": "+Zarafa.plugins.files.data.Utils.Format.fileSize(Zarafa.plugins.files.data.Utils.Core.getMaxUploadFilesize())+"):",layout:"fit",padding:10,items:[{xtype:"filesplugin.multiplefileuploadfield",buttonText:dgettext("plugin_files","Browse")+"...",name:"attachments[]",disabled:!0,listeners:{fileselected:this.onUploadFieldChanged,scope:this},ref:"../../mainuploadfield"}]}},
createFolderSelector:function(){return{xtype:"treepanel",anchor:"0, 0",flex:1,title:dgettext("plugin_files","Select upload folder")+":",root:{nodeType:"async",text:"Files",id:"#R#",expanded:!0,cc:!1},rootVisible:!1,autoScroll:!0,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:!0,listeners:{click:this.onFolderSelected,expandnode:this.onExpandNode,scope:this},loader:new Zarafa.plugins.files.data.NavigatorTreeLoader({loadfiles:!1})}},onExpandNode:function(a){a.attributes.cc=!0;a.eachChild(function(a){!0!==
a.attributes.cc&&(a.attributes.cc=!0,a.quietLoad())})},createActionButtons:function(){return[{xtype:"button",ref:"../../mainuploadbutton",disabled:!0,text:"&nbsp;&nbsp;"+dgettext("plugin_files","Upload"),iconCls:"icon_files",handler:this.doUpload,scope:this},{xtype:"button",text:dgettext("plugin_files","Cancel"),handler:this.onClose,scope:this}]},onFolderSelected:function(a){this.targetFolder=a.attributes.id;a.ownerTree.dialog.mainuploadfield.enable()},onUploadFieldChanged:function(a,b,c){if(Ext.isEmpty(b))this.mainuploadbutton.setDisabled(!0);
else{a.ownerCt.ownerCt.getForm();var d=!1;Ext.each(this.mainuploadfield.fileInput.dom.files,function(a){if(a.size>Zarafa.plugins.files.data.Utils.Core.getMaxUploadFilesize())return this.mainuploadfield.reset(),Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:String.format(dgettext("plugin_files",'File "{0}" is too large! Maximum allowed filesize: {1}.'),a.name,Zarafa.plugins.files.data.Utils.Format.fileSize(Zarafa.plugins.files.data.Utils.Core.getMaxUploadFilesize())),
icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK}),this.mainuploadbutton.setDisabled(!0),d=!0,!1;d||this.mainuploadbutton.setDisabled(!1)},this)}},doUpload:function(){Zarafa.plugins.files.data.Actions.uploadAsyncItems(this.mainuploadfield.fileInput.dom.files,this.record.getStore(),this.targetFolder);this.onClose()},onClose:function(){this.close()}});Ext.reg("filesplugin.filesuploadcontentpanel",Zarafa.plugins.files.ui.dialogs.FilesUploadContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.SaveToFilesContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:dgettext("plugin_files","Add item to Files"),closeOnSave:!0,width:400,height:300,items:[{xtype:"filesplugin.savetofilestreepanel",ref:"treePanel",response:a.record}]});Zarafa.plugins.files.ui.dialogs.SaveToFilesContentPanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.savetofilescontentpanel",Zarafa.plugins.files.ui.dialogs.SaveToFilesContentPanel);
Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.SaveToFilesTreePanel=Ext.extend(Ext.tree.TreePanel,{selectedFolder:null,response:null,treeSorter:!0,constructor:function(a){a=a||{};this.response=a.response;Ext.applyIf(a,{pathSeparator:"&",root:{nodeType:"async",text:"Files",id:"#R#",expanded:!0,cc:!1,listeners:{load:this.onAfterRootLoad,scope:this}},rootVisible:!1,autoScroll:!0,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:!0,listeners:{click:this.onTreeNodeClick,expandnode:this.onExpandNode,
scope:this},loader:new Zarafa.plugins.files.data.NavigatorTreeLoader({loadfiles:!1}),buttons:[this.createActionButtons()]});Zarafa.plugins.files.ui.dialogs.SaveToFilesTreePanel.superclass.constructor.call(this,a);!this.treeSorter||this.treeSorter instanceof Ext.tree.TreeSorter||(this.treeSorter=new Ext.tree.TreeSorter(this))},onAfterRootLoad:function(){Ext.isDefined(Zarafa.plugins.files.current_tree_path)&&(this.selectedFolder=Zarafa.plugins.files.current_tree_path,this.expandPathById(Zarafa.plugins.files.current_tree_path))},
expandPathById:function(a){var b=this.getNodeById(a),c="",d=this;if(b)return c=b.getPath(),this.expandPath(c,"id",function(b,c){b&&d.getNodeById(a)&&(d.getNodeById(a).ensureVisible(),d.getNodeById(a).select())}),!0;var c="",e=a.replace(/\/+$/,"").split("/");Ext.each(e,function(a,b){for(var d=this.pathSeparator,f=0;f<=b;f++)d+=e[f]+"/";c+=d},this);c=this.pathSeparator+"#R#"+c;return""!=c?(this.expandPath(c,"id",function(b,c){b&&d.getNodeById(a)&&(d.getNodeById(a).ensureVisible(),d.getNodeById(a).select())}),
!0):!1},onExpandNode:function(a){!0!==a.attributes.cc&&(a.attributes.cc=!0,a.eachChild(function(a){!0!==a.attributes.cc&&(a.attributes.cc=!0,a.quietLoad())}))},onTreeNodeClick:function(a){this.selectedFolder=a.attributes.id;Zarafa.plugins.files.current_tree_path=this.selectedFolder},createActionButtons:function(){return[{xtype:"button",text:dgettext("plugin_files","New folder"),cls:"zarafa-normal",handler:this.newFolder,scope:this},{xtype:"button",text:dgettext("plugin_files","Save"),cls:"zarafa-action",
iconCls:"icon_files_category_white",handler:this.uploadFile,scope:this}]},uploadFile:function(){if(!Ext.isDefined(this.selectedFolder)||Ext.isEmpty(this.selectedFolder))Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","You have to choose a folder!"));else{for(var a=[],b=0,c=this.response.count;b<c;b++)a[b]={id:this.selectedFolder+this.response.items[b].filename,isFolder:!1};try{container.getRequest().singleRequest("filesbrowsermodule","checkifexists",{records:a,destination:this.selectedFolder},
new Zarafa.core.data.AbstractResponseHandler({doCheckifexists:this.checkForDuplicateFileDone.createDelegate(this)}))}catch(d){return Zarafa.plugins.files.data.Actions.msgWarning(d.message),!1}}},newFolder:function(){!Ext.isDefined(this.selectedFolder)||Ext.isEmpty(this.selectedFolder)?Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","You have to choose a folder!")):Zarafa.common.dialogs.MessageBox.prompt(dgettext("plugin_files","Folder Name"),dgettext("plugin_files","Please enter a foldername"),
this.checkForDuplicateFolder,this)},checkForDuplicateFolder:function(a,b){if("ok"===a)if(Zarafa.plugins.files.data.Utils.File.isValidFilename(b))try{container.getRequest().singleRequest("filesbrowsermodule","checkifexists",{records:[{id:this.selectedFolder+b,isFolder:!0}]},new Zarafa.core.data.AbstractResponseHandler({doCheckifexists:this.checkForDuplicateFolderDone.createDelegate(this,[b],!0)}))}catch(c){return Zarafa.plugins.files.data.Actions.msgWarning(c.message),!1}else Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files",
"Incorrect foldername"))},checkForDuplicateFolderDone:function(a,b){!1===a.duplicate?this.createRemoteFolder(b):Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Folder already exists"))},checkForDuplicateFileDone:function(a){!1===a.duplicate?this.doUpload():Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),this.doUpload,this)},doUpload:function(a){if(!Ext.isDefined(a)||"yes"===a)try{this.disable(),
container.getRequest().singleRequest("filesbrowsermodule","uploadtobackend",{items:this.response.items,count:this.response.count,type:this.response.type,destdir:this.selectedFolder},new Zarafa.core.data.AbstractResponseHandler({doUploadtobackend:this.uploadDone.createDelegate(this)}))}catch(b){Zarafa.plugins.files.data.Actions.msgWarning(b.message)}},uploadDone:function(a){!0===a.status?container.getNotifier().notify("info.files",dgettext("plugin_files","Uploaded"),dgettext("plugin_files","Attachment successfully stored in Files")):
container.getNotifier().notify("error",dgettext("plugin_files","Upload Failed"),dgettext("plugin_files","Attachment could not be stored in Files! Error: "+a.status));this.dialog.close()},createRemoteFolder:function(a){try{container.getRequest().singleRequest("filesbrowsermodule","createdir",{props:{id:this.selectedFolder+a},entryid:this.selectedFolder+a,parentID:this.selectedFolder},new Zarafa.core.data.AbstractResponseHandler({doCreatedir:this.createDirDone.createDelegate(this)}))}catch(b){Zarafa.plugins.files.data.Actions.msgWarning(b.message)}},
createDirDone:function(a){container.getNotifier().notify("info.files",dgettext("plugin_files","Created"),dgettext("plugin_files","Directory created!"));a=a.item[0].parent_entryid;var b=this.getNodeById(a);Ext.isDefined(b)&&(b.isLeaf()?(b="/"==a.substr(-1)?a.substr(0,a.length-1):a,b=this.getNodeById(b.match(/.*\//)),Ext.isDefined(b)&&(b.on("expand",this.reloadParentDone.createDelegate(this,[a]),this,{single:!0}),b.reload())):b.reload())},reloadParentDone:function(a){a=this.getNodeById(a);Ext.isDefined(a)&&
a.expand()}});Ext.reg("filesplugin.savetofilestreepanel",Zarafa.plugins.files.ui.dialogs.SaveToFilesTreePanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.ShareContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{records:null,constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:dgettext("plugin_files","Share Files"),width:800,height:500,items:[container.populateInsertionPoint("plugin.files.sharedialog",this,a.context)]});Zarafa.plugins.files.ui.dialogs.ShareContentPanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.sharecontentpanel",Zarafa.plugins.files.ui.dialogs.ShareContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.SharePanel=Ext.extend(Ext.Panel,{constructor:function(a){a=a||{};var b=a.ownerCt.records,c=!0;0<b.length&&b[0].getAccount().get("backend")===a.plugin.info.name.substring(12)&&(c=!1);c&&Ext.applyIf(a,{disabled:!0,hidden:!0});Zarafa.plugins.files.ui.dialogs.SharePanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.sharepanel",Zarafa.plugins.files.ui.dialogs.SharePanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.UploadStatusContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:dgettext("plugin_files","Uploading files to ")+Zarafa.plugins.files.data.Utils.File.stripAccountId(a.destination)+" &hellip;",closeOnSave:!0,width:480,height:445,items:[{xtype:"filesplugin.uploadstatuspanel",files:a.files,destination:a.destination,keepBoth:a.keepBoth,callbackAllDone:a.callbackAllDone||Ext.emptyFn,callbackUploadFailed:a.callbackUploadFailed||
Ext.emptyFn,callbackUploadAborted:a.callbackUploadAborted||Ext.emptyFn,store:a.store}]});Zarafa.plugins.files.ui.dialogs.UploadStatusContentPanel.superclass.constructor.call(this,a)}});Ext.reg("filesplugin.uploadstatuscontentpanel",Zarafa.plugins.files.ui.dialogs.UploadStatusContentPanel);Ext.namespace("Zarafa.plugins.files.ui.dialogs");
Zarafa.plugins.files.ui.dialogs.UploadStatusPanel=Ext.extend(Ext.form.FormPanel,{files:null,destination:null,xhr:[],statsTimer:null,timerCounter:null,timerIntervall:200,callbackAllDone:Ext.emptyFn,callbackUploadFailed:Ext.emptyFn,callbackUploadAborted:Ext.emptyFn,store:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{autoScroll:!0,defaults:{anchor:"100%"},items:this.initUploadUI(a),listeners:{afterrender:this.startUpload,scope:this}});Zarafa.plugins.files.ui.dialogs.UploadStatusPanel.superclass.constructor.call(this,
a)},getBasicElement:function(a,b){return{xtype:"panel",padding:10,custom_fileid:b,ref:"fileuploadfield_"+b,items:[{layout:"column",border:!1,defaults:{border:!1},anchor:"0",items:[{columnWidth:.8,items:{xtype:"displayfield",fieldClass:"fp_upload_header",value:a.name}},{columnWidth:.2,style:"text-align: right;",items:{xtype:"displayfield",fieldClass:"fp_upload_header",value:Zarafa.plugins.files.data.Utils.Format.fileSizeList(a.size)}}]},{layout:"column",border:!1,defaults:{border:!1},anchor:"0",items:[{columnWidth:.95,
items:{xtype:"progress",text:dgettext("plugin_files","Starting upload")+"&hellip;",ref:"../../progress"}},{columnWidth:.05,items:{xtype:"button",ref:"../../cancel",custom_fileid:b,tooltip:dgettext("plugin_files","Cancel upload"),overflowText:dgettext("plugin_files","Cancel upload"),iconCls:"icon_action_cancel",handler:this.doCancelUpload.createDelegate(this)}}]},{layout:"column",border:!1,defaults:{border:!1},anchor:"0",items:[{columnWidth:.33,items:{xtype:"displayfield",value:"- kB/s",ref:"../../speed"}},
{columnWidth:.33,items:[{xtype:"displayfield",value:"0 MB",ref:"../../uploaded"}]},{columnWidth:.33,style:"text-align: right;",items:{xtype:"displayfield",value:dgettext("plugin_files","- seconds left"),ref:"../../eta"}}]}]}},initUploadUI:function(a){var b=[];Ext.each(a.files,function(a,d){b.push(this.getBasicElement(a,d))},this);return b},startUpload:function(){Ext.each(this.files,function(a,b){this.xhr[b]=new XMLHttpRequest;this.xhr[b].open("post","index.php?load=custom&name=upload_file&keep_both="+
this.keepBoth,!0);this.xhr[b].upload.addEventListener("progress",this.onUpdateProgress.createDelegate(this,[b],!0),!1);this.xhr[b].addEventListener("load",this.onFinishProgress.createDelegate(this,[b],!0),!1);this.xhr[b].addEventListener("error",this.onUploadFailed.createDelegate(this,[b],!0),!1);this.xhr[b].addEventListener("abort",this.onUploadAborted.createDelegate(this,[b],!0),!1);this.xhr[b].setRequestHeader("Content-Type","multipart/form-data");this.xhr[b].setRequestHeader("X-FILE-NAME",encodeURIComponent(a.name));
this.xhr[b].setRequestHeader("X-FILE-SIZE",a.size);this.xhr[b].setRequestHeader("X-FILE-TYPE",a.type);this.xhr[b].setRequestHeader("X-FILE-DESTINATION",this.destination);this.xhr[b].send(a);this.xhr[b].cust_loaded=0;this.xhr[b].cust_total=0},this);this.statsTimer=window.setInterval(this.getStats.createDelegate(this),this.timerIntervall);this.timerCounter=this.xhr.length},getStats:function(){Ext.each(this.xhr,function(a,b){var c=a.cust_loaded_old,d=a.cust_loaded,e=a.cust_total;a.cust_loaded_old=d;
var f=(d-c)/(this.timerIntervall/1E3),g=" B/s",h=(e-d)/f,k=dgettext("plugin_files"," seconds left");60<h&&(h/=60,k=dgettext("plugin_files"," minutes left"));1E3<f&&(f/=1E3,g=" kB/s");1E3<f&&(f/=1E3,g=" mB/s");var l=this["fileuploadfield_"+b];Ext.isDefined(l)&&(Ext.isDefined(c)&&0!=d&&0!=e?d!=c&&(l.speed.setValue(f.toFixed(2)+g),l.eta.setValue(parseInt(h)+k)):(l.speed.setValue("- kB/s"),l.eta.setValue(dgettext("plugin_files","- seconds left"))))},this)},onUpdateProgress:function(a,b){var c=this["fileuploadfield_"+
b];if(Ext.isDefined(c))if(a.lengthComputable){this.xhr[b].cust_loaded=a.loaded;this.xhr[b].cust_total=a.total;var d=(a.loaded/a.total*100).toFixed(2);c.progress.updateProgress(a.loaded/a.total,dgettext("plugin_files","Uploading: ")+d+"%",!0);c.uploaded.setValue(Zarafa.plugins.files.data.Utils.Format.fileSizeList(a.loaded))}else c.progress.updateProgress(.5,dgettext("plugin_files","Upload status unavailable... please wait."),!0)},onFinishProgress:function(a,b){var c=this["fileuploadfield_"+b];c&&(c.progress.updateProgress(1,
dgettext("plugin_files","Upload finished!"),!0),this.xhr[b].cust_loaded=0,this.xhr[b].cust_total=0,c.cancel.disable(),this.checkTimerAlive())},onUploadAborted:function(a,b){var c=this["fileuploadfield_"+b];if(Ext.isDefined(c)){var d=c.progress;d.updateProgress(1,dgettext("plugin_files","Upload aborted!"),!0);d.addClass("fp_upload_canceled");c.cancel.disable();this.callbackUploadAborted(this.files[b],this.destination,a);this.checkTimerAlive()}},onUploadFailed:function(a,b){var c=this["fileuploadfield_"+
b];if(Ext.isDefined(c)){var d=c.progress;d.updateProgress(1,dgettext("plugin_files","Upload failed!"),!0);d.addClass("fp_upload_canceled");c.cancel.disable();this.callbackUploadFailed(this.files[b],this.destination,a);this.checkTimerAlive()}},checkTimerAlive:function(){this.timerCounter--;0>=this.timerCounter&&(window.clearTimeout(this.statsTimer),this.onUploadsFinished())},doCancelUpload:function(a,b){this.xhr[a.custom_fileid].abort()},onUploadsFinished:function(){this.dialog.close();this.callbackAllDone(this.files,
this.destination,this.store)}});Ext.reg("filesplugin.uploadstatuspanel",Zarafa.plugins.files.ui.dialogs.UploadStatusPanel);Ext.namespace("Zarafa.plugins.files.ui.snippets");
Zarafa.plugins.files.ui.snippets.FilesNavigationBar=Ext.extend(Ext.Panel,{context:void 0,model:void 0,maxPathBeforeTruncate:5,maxStringBeforeTruncate:20,pathTruncateText:"&hellip;",hasOverflow:!1,currentPath:"#R#",filesStore:void 0,constructor:function(a){a=a||{};Ext.isDefined(a.model)&&!Ext.isDefined(a.filesStore)&&(a.filesStore=a.model.getStore(),this.currentPath=a.filesStore.getPath());Ext.applyIf(a,{xtype:"filesplugin.navigationbar",maskDisabled:!1,hideBorders:!0,border:!1,cls:"navbar_container",
height:25,defaults:{height:25},layout:"column"});Zarafa.plugins.files.ui.snippets.FilesNavigationBar.superclass.constructor.call(this,a)},initEvents:function(){this.mon(this.filesStore,{beforeload:this.onStoreLoad,scope:this});this.on("afterrender",this.generateNavigationButtons.createDelegate(this,[Zarafa.plugins.files.data.Utils.File.stripAccountId(this.currentPath),Zarafa.plugins.files.data.Utils.File.getAccountId(this.currentPath)]),this)},onStoreLoad:function(a){var b=a.getPath();this.currentPath!==
b&&(this.currentPath=b,a=Zarafa.plugins.files.data.Utils.File.getAccountId(b),b=Zarafa.plugins.files.data.Utils.File.stripAccountId(b),this.generateNavigationButtons(b,a))},recalculateMaxPath:function(){var a=8*this.maxStringBeforeTruncate,b=this.getWidth(),c=this.items?this.items.items:[],d=this.hasOverflow?3:2;Ext.each(c,function(a){b-=a.getWidth()});if(b<a){var e=a-b,f=0;Ext.each(c,function(a){e-=a.getWidth();f++;if(0>=e)return!1});this.maxPathBeforeTruncate=c.length-f}else this.maxPathBeforeTruncate=
Math.floor(c.length+b/a);this.maxPathBeforeTruncate-=d},createHomeButton:function(){this.add({xtype:"button",cls:"files_navbar_button files_navbar_button_first",tooltip:dgettext("plugin_files","Home"),path:"#R#",listeners:{click:this.doNavButtonClick,scope:this},iconCls:"files_navbar files_navbar_home"})},createBackEndRootButton:function(a,b,c){if(!Ext.isEmpty(b)&&(a=this.accountsStore.getById(b),!Ext.isEmpty(a))){var d=c?" files_navbar_button_last":"";c=Zarafa.plugins.files.data.Utils.Format.truncate(a.get("name"),
this.maxStringBeforeTruncate);b={xtype:"button",cls:"files_navbar_button"+d,path:"#R#"+b+"/",listeners:{click:this.doNavButtonClick,scope:this},text:c};Ext.isEmpty(c)&&(b.iconCls="files_navbar icon_16_"+a.get("backend"));this.add(b)}},generateNavigationButtons:function(a,b){this.recalculateMaxPath();this.removeAll(!0);this.createHomeButton();var c=-1===a.indexOf("/")||"/"===a;this.createBackEndRootButton(a,b,c);if(!c){var d="/",e=a.replace(/^\/|\/$/g,"").split("/");if(e.length>this.maxPathBeforeTruncate){this.hasOverflow=
!0;var c=e.splice(0,e.length-this.maxPathBeforeTruncate),f=[];Ext.each(c,function(a){d+=a+"/";f.push({text:Zarafa.plugins.files.data.Utils.Format.truncate(a,this.maxStringBeforeTruncate),handler:this.doNavButtonClick,iconCls:"icon_folder_note",path:"#R#"+b+d,scope:this})},this);c=new Ext.Button({cls:"files_navbar_button",menu:f,text:this.pathTruncateText});this.add(c)}else this.hasOverflow=!1;Ext.each(e,function(a,c){d+=a+"/";var f=c==e.length-1?" files_navbar_button_last":"",f=new Ext.Button({text:Zarafa.plugins.files.data.Utils.Format.truncate(a,
this.maxStringBeforeTruncate),cls:"files_navbar_button"+f,path:"#R#"+b+d,listeners:{click:this.doNavButtonClick,scope:this}});this.add(f)},this)}this.doLayout()},doNavButtonClick:function(a,b){"#R#"===a.path&&this.model.setPreviewRecord(void 0);this.filesStore.loadPath(a.path)}});Ext.reg("filesplugin.navigationbar",Zarafa.plugins.files.ui.snippets.FilesNavigationBar);Ext.namespace("Zarafa.plugins.files.ui.snippets");
Zarafa.plugins.files.ui.snippets.FilesQuotaBar=Ext.extend(Ext.Panel,{model:void 0,quotaText:dgettext("plugin_files","{0} of {1} in use"),loadOnlyOnce:!0,defaultDirectory:"/",constructor:function(a){a=a||{};!Ext.isDefined(a.store)&&Ext.isDefined(a.model)&&(a.store=a.model.getStore());Ext.applyIf(a,{xtype:"filesplugin.quotabar",cls:"files_quota_bar_snippet",border:!1,items:[{xtype:"panel",ref:"quotaPanel",layout:"table",layoutConfig:{columns:2},cls:"files_quota_bar_container",border:!1,items:[{xtype:"label",
ref:"../usageInfo",autoWidth:!0},{xtype:"progress",width:"150",ref:"../progressBar",height:"8",cls:"files_quota_bar",style:"margin: 0 0 0 20px"}]},{xtype:"label",border:!1,hidden:!0,ref:"loadingIcon",html:'<div class="img"></div>'}]});Zarafa.plugins.files.ui.snippets.FilesQuotaBar.superclass.constructor.call(this,a)},initEvents:function(){this.mon(this.store,{load:this.onStoreLoad,scope:this})},onStoreLoad:function(a,b,c){a=a.getPath();a=Zarafa.plugins.files.data.Utils.File.getAccountId(a);b=this.accountsStore.getById(a);
Ext.isDefined(b)&&b.supportsFeature(Zarafa.plugins.files.data.AccountRecordFeature.QUOTA)?(this.loaded==a&&this.loadOnlyOnce||(this.quotaPanel.hide(),this.loadingIcon.show(),this.loadQuotaInformation(a,this.defaultDirectory)),this.isVisible()||this.show(),this.loaded=a):this.hide()},loadQuotaInformation:function(a,b){var c=new Zarafa.core.data.AbstractResponseHandler({doGetquota:this.gotQuotaValues.createDelegate(this)});container.getRequest().singleRequest("filesaccountmodule","getquota",{accountId:a,
folder:b},c)},gotQuotaValues:function(a){if(this.quotaPanel){var b=parseInt(a.quota[0].amount);a=parseInt(a.quota[1].amount);a=b+a;this.loadingIcon.hide();this.quotaPanel.show();this.usageInfo.setText(String.format(this.quotaText,Ext.util.Format.fileSize(b),Ext.util.Format.fileSize(a)));this.progressBar.updateProgress(b/a)}}});Ext.reg("filesplugin.quotabar",Zarafa.plugins.files.ui.snippets.FilesQuotaBar);Ext.namespace("Zarafa.plugins.files.ui.snippets");
Zarafa.plugins.files.ui.snippets.PDFjsPanel=Ext.extend(Ext.Panel,{src:"",title:"",pageScale:1,disableWorker:!0,disableTextLayer:!0,loadingMessage:"Loading PDF, please wait...",beforePageText:"Page",afterPageText:"of {0}",firstText:"First Page",prevText:"Previous Page",nextText:"Next Page",lastText:"Last Page",fullscreenText:"Fullscreen",inputItemWidth:30,scaleWidth:60,constructor:function(a){a=a||{};a=Ext.applyIf(a,{xtype:"filesplugin.pdfjspanel",border:!1,baseCls:"x-panel pdf",bodyCssCls:"pdf-body",
pageScale:1,header:!1,items:[{xtype:"component",autoEl:{cn:[{tag:"canvas","class":"pdf-page-container"},{tag:"div","class":"pdf-text-layer"}]},listeners:{afterrender:this.init.createDelegate(this)}}],bbar:this.getPagingToolbar()});PDFJS.disableTextLayer=this.disableTextLayer;Zarafa.plugins.files.ui.snippets.PDFjsPanel.superclass.constructor.call(this,a)},getPagingToolbar:function(){return{xtype:"toolbar",height:25,items:[{ref:"first",tooltip:this.firstText,overflowText:this.firstText,iconCls:"x-tbar-page-first",
disabled:!0,handler:this.moveFirst,scope:this},{ref:"prev",tooltip:this.prevText,overflowText:this.prevText,iconCls:"x-tbar-page-prev",disabled:!0,handler:this.movePrevious,scope:this},"-",this.beforePageText,{xtype:"numberfield",ref:"inputItem",name:"inputItem",cls:"x-tbar-page-number",minValue:1,allowDecimals:!1,allowNegative:!1,enableKeyEvents:!0,selectOnFocus:!0,submitValue:!1,width:this.inputItemWidth,disabled:!0,margins:"-1 2 3 2",listeners:{scope:this,keydown:this.onPagingKeyDown,blur:this.onPagingBlur}},
{xtype:"tbtext",ref:"afterTextItem",text:String.format(this.afterPageText,1),margins:"0 5 0 0"},"-",{ref:"next",tooltip:this.nextText,overflowText:this.nextText,iconCls:"x-tbar-page-next",disabled:!0,handler:this.moveNext,scope:this},{ref:"last",tooltip:this.lastText,overflowText:this.lastText,iconCls:"x-tbar-page-last",disabled:!0,handler:this.moveLast,scope:this},"->",{xtype:"combo",ref:"scaleCombo",triggerAction:"all",lazyInit:!1,forceSelection:!0,editable:!1,autoSelect:!0,disabled:!0,hidden:!0,
width:this.scaleWidth,store:{xtype:"jsonstore",autoDestroy:!0,fields:["scale","text"],data:[{scale:.5,text:"50%"},{scale:.75,text:"75%"},{scale:1,text:"100%"},{scale:1.25,text:"125%"},{scale:1.5,text:"150%"},{scale:2,text:"200%"},{scale:4,text:"400%"}]},valueField:"scale",displayField:"text",mode:"local",listeners:{scope:this,select:this.onScaleChange}},{ref:"fullscreen",tooltip:this.fullscreenText,overflowText:this.fullscreenText,iconCls:"files_icon_action_fullscreen",disabled:!1,handler:this.displayFullscreen,
scope:this}]}},init:function(){this.pageContainer=this.el.query(".pdf-page-container")[0];PDFJS.disableTextLayer||(this.textLayerDiv=this.el.query(".pdf-text-layer")[0]);this.disableWorker&&(PDFJS.disableWorker=!0);this.getDocument()},onLoad:function(){try{var a;a=0===this.pdfDoc.numPages;this.currentPage=this.currentPage||(a?0:1);this.renderPage(this.currentPage)}catch(b){console.log("PDF: Can't render: "+b.message)}},renderPage:function(a){var b=this,c,d,e,f,g=b.getBottomToolbar();this.isRendering||
(b.isRendering=!0,b.currentPage=a,e=b.currentPage,d=b.pdfDoc.numPages,f=String.format(b.afterPageText,isNaN(d)?1:d),c=0===d,g.afterTextItem.setText(f),g.inputItem.setDisabled(c),g.inputItem.setValue(e),g.first.setDisabled(1===e||c),g.prev.setDisabled(1===e||c),g.next.setDisabled(e===d||c),g.last.setDisabled(e===d||c),g.scaleCombo.setDisabled(c),g.scaleCombo.setValue(b.pageScale),b.pdfDoc.getPage(a).then(function(a){if(b.pageContainer){var c=a.getViewport(b.pageScale);b.pageContainer.height=c.height;
b.pageContainer.width=c.width;var d=b.pageContainer.getContext("2d");d.save();d.fillStyle="rgb(255, 255, 255)";d.fillRect(0,0,b.pageContainer.width,b.pageContainer.height);d.restore();a.render({canvasContext:d,viewport:c,textLayer:null});b.isRendering=!1;b.loader&&b.loader.destroy();b.rendered&&b.fireEvent("change",b,{current:b.currentPage,total:b.pdfDoc.numPages})}else b.isRendering=!1}))},moveFirst:function(){!1!==this.fireEvent("beforechange",this,1)&&this.renderPage(1)},movePrevious:function(){var a=
this.currentPage-1;0<a&&!1!==this.fireEvent("beforechange",this,a)&&this.renderPage(a)},moveNext:function(){var a=this.currentPage+1;a<=this.pdfDoc.numPages&&!1!==this.fireEvent("beforechange",this,a)&&this.renderPage(a)},moveLast:function(){var a=this.pdfDoc.numPages;!1!==this.fireEvent("beforechange",this,a)&&this.renderPage(a)},readPageFromInput:function(){var a=this.getBottomToolbar().inputItem.getValue(),b=parseInt(a,10);return!a||isNaN(b)?(this.getBottomToolbar().inputItem.setValue(this.currentPage),
!1):b},onPagingFocus:function(){this.getBottomToolbar().inputItem.select()},onPagingBlur:function(a){a=this.getPageData().currentPage;this.getBottomToolbar().inputItem.setValue(a)},onPagingKeyDown:function(a,b){var c=b.getKey(),d=b.shiftKey?10:1,e,f=this.pdfDoc.numPages;if(c==b.RETURN)b.stopEvent(),e=this.readPageFromInput(),!1!==e&&(e=Math.min(Math.max(1,e),f),!1!==this.fireEvent("beforechange",this,e)&&this.renderPage(e));else if(c==b.HOME||c==b.END)b.stopEvent(),e=c==b.HOME?1:f,a.setValue(e);else if(c==
b.UP||c==b.PAGE_UP||c==b.DOWN||c==b.PAGE_DOWN)if(b.stopEvent(),e=this.readPageFromInput()){if(c==b.DOWN||c==b.PAGE_DOWN)d*=-1;e+=d;1<=e&&e<=f&&a.setValue(e)}},onScaleChange:function(a,b){this.pageScale=b.get(a.valueField);this.renderPage(this.currentPage)},displayFullscreen:function(){Ext.ux.PdfBox.open({easing:"elasticOut",resizeDuration:.6,close:"&#215;",hideInfo:"auto",href:this.src,title:this.tile})},setSrc:function(a){this.src=a;return this.getDocument()},getDocument:function(){var a=this;a.src&&
PDFJS.getDocument(a.src).then(function(b){a.pdfDoc=b;a.onLoad()});return a}});Ext.reg("filesplugin.pdfjspanel",Zarafa.plugins.files.ui.snippets.PDFjsPanel);Ext.namespace("Zarafa.plugins.files.ui.snippets");
Zarafa.plugins.files.ui.snippets.WebODFPanel=Ext.extend(Ext.Panel,{odfCanvas:null,pages:[],currentPage:0,src:null,title:"",loadingMessage:"Loading PDF, please wait...",beforePageText:"Page",afterPageText:"of {0}",firstText:"First Page",prevText:"Previous Page",nextText:"Next Page",lastText:"Last Page",fullscreenText:"Fullscreen",inputItemWidth:30,scaleWidth:60,panelID:null,constructor:function(a){a=a||{};a=Ext.applyIf(a,{xtype:"filesplugin.webodfpanel",border:!1,header:!1,items:[{xtype:"component",
cls:"webodfpanel-outerDocumentContainer",autoEl:{cn:[{tag:"div","class":"webodfpanel-canvas"}]},listeners:{afterrender:this.initODF.createDelegate(this)}}],bbar:this.getPagingToolbar()});Zarafa.plugins.files.ui.snippets.WebODFPanel.superclass.constructor.call(this,a)},getPagingToolbar:function(){return{xtype:"toolbar",height:25,items:[{ref:"first",tooltip:this.firstText,overflowText:this.firstText,iconCls:"x-tbar-page-first",disabled:!0,handler:this.moveFirst,scope:this},{ref:"prev",tooltip:this.prevText,
overflowText:this.prevText,iconCls:"x-tbar-page-prev",disabled:!0,handler:this.movePrevious,scope:this},"-",this.beforePageText,{xtype:"numberfield",ref:"inputItem",name:"inputItem",cls:"x-tbar-page-number",minValue:1,allowDecimals:!1,allowNegative:!1,enableKeyEvents:!0,selectOnFocus:!0,submitValue:!1,width:this.inputItemWidth,disabled:!0,margins:"-1 2 3 2",listeners:{scope:this,keydown:this.onPagingKeyDown,blur:this.onPagingBlur}},{xtype:"tbtext",ref:"afterTextItem",text:String.format(this.afterPageText,
1),margins:"0 5 0 0"},"-",{ref:"next",tooltip:this.nextText,overflowText:this.nextText,iconCls:"x-tbar-page-next",disabled:!0,handler:this.moveNext,scope:this},{ref:"last",tooltip:this.lastText,overflowText:this.lastText,iconCls:"x-tbar-page-last",disabled:!0,handler:this.moveLast,scope:this},"->",{xtype:"combo",ref:"scaleCombo",triggerAction:"all",lazyInit:!1,forceSelection:!0,editable:!1,autoSelect:!0,disabled:!0,hidden:!0,width:this.scaleWidth,store:{xtype:"jsonstore",autoDestroy:!0,fields:["scale",
"text"],data:[{scale:.5,text:"50%"},{scale:.75,text:"75%"},{scale:1,text:"100%"},{scale:1.25,text:"125%"},{scale:1.5,text:"150%"},{scale:2,text:"200%"},{scale:4,text:"400%"}]},valueField:"scale",displayField:"text",mode:"local",listeners:{scope:this,select:this.onScaleChange}},{ref:"fullscreen",tooltip:this.fullscreenText,overflowText:this.fullscreenText,iconCls:"files_icon_action_fullscreen",disabled:!1,handler:this.displayFullscreen,scope:this}]}},initODF:function(){this.canvasContainer=Ext.DomQuery.selectNode("div[class*=webodfpanel-canvas]",
this.el.dom);this.odfCanvas=new odf.OdfCanvas(this.canvasContainer);this.odfCanvas.load(this.src)},moveFirst:function(){!1!==this.fireEvent("beforechange",this,1)&&this.renderPage(1)},movePrevious:function(){var a=this.currentPage-1;0<a&&!1!==this.fireEvent("beforechange",this,a)&&this.renderPage(a)},moveNext:function(){var a=this.currentPage+1;a<=this.pdfDoc.numPages&&!1!==this.fireEvent("beforechange",this,a)&&this.renderPage(a)},moveLast:function(){var a=this.pdfDoc.numPages;!1!==this.fireEvent("beforechange",
this,a)&&this.renderPage(a)},readPageFromInput:function(){var a=this.getBottomToolbar().inputItem.getValue(),b=parseInt(a,10);return!a||isNaN(b)?(this.getBottomToolbar().inputItem.setValue(this.currentPage),!1):b},onPagingFocus:function(){this.getBottomToolbar().inputItem.select()},onPagingBlur:function(a){a=this.getPageData().currentPage;this.getBottomToolbar().inputItem.setValue(a)},onPagingKeyDown:function(a,b){var c=b.getKey(),d=b.shiftKey?10:1,e,f=this.pdfDoc.numPages;if(c==b.RETURN)b.stopEvent(),
e=this.readPageFromInput(),!1!==e&&(e=Math.min(Math.max(1,e),f),!1!==this.fireEvent("beforechange",this,e)&&this.renderPage(e));else if(c==b.HOME||c==b.END)b.stopEvent(),e=c==b.HOME?1:f,a.setValue(e);else if(c==b.UP||c==b.PAGE_UP||c==b.DOWN||c==b.PAGE_DOWN)if(b.stopEvent(),e=this.readPageFromInput()){if(c==b.DOWN||c==b.PAGE_DOWN)d*=-1;e+=d;1<=e&&e<=f&&a.setValue(e)}},onScaleChange:function(a,b){this.pageScale=b.get(a.valueField);this.renderPage(this.currentPage)},displayFullscreen:function(){Zarafa.plugins.webodf.WebOdfBox.open({resizeDuration:.4,
overlayDuration:.6,href:this.src,title:this.title})}});Ext.reg("filesplugin.webodfpanel",Zarafa.plugins.files.ui.snippets.WebODFPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.NavigatorTreePanel=Ext.extend(Zarafa.plugins.files.ui.Tree,{nodeToSelect:null,filesStore:void 0,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"filesplugin.navigatortreepanel",bodyCssClass:"files-context-navigation-node",accountFilter:a.accountFilter});Zarafa.plugins.files.ui.NavigatorTreePanel.superclass.constructor.call(this,a)},initEvents:function(){Zarafa.plugins.files.ui.NavigatorTreePanel.superclass.initEvents.apply(this,arguments);this.on({click:this.onNodeClick,
load:this.treeNodeLoaded,beforenodedrop:this.onBeforeNodeDrop,expandnode:this.onExpandNode,nodedragover:this.onNodeDragOver,afterrender:this.onAfterRender,contextmenu:this.onContextMenu,scope:this})},onExpandNode:function(a){a.attributes.cc=!0;container.getSettingsModel().get("zarafa/v1/contexts/files/preload_folder")&&a.eachChild(function(a){!0!==a.attributes.cc&&(a.attributes.cc=!0,a.quietLoad())})},onBeforeNodeDrop:function(a){if(Ext.isArray(a.data.selections))return a.cancel=!1,Ext.each(a.data.selections,
function(a){a.setDisabled(!0)}),Zarafa.plugins.files.data.Actions.moveRecords(a.data.selections,a.target)},onNodeDragOver:function(a){var b=!0;Ext.each(a.data.selections,function(c){c=c.get("id");var d=c.replace(/\\/g,"/").replace(/\/[^\/]*\/?$/,"")+"/",e=a.target.id,f=Zarafa.plugins.files.data.Utils.File.getAccountId(c),g=Zarafa.plugins.files.data.Utils.File.getAccountId(e);if(f!=g||c===e||e.slice(0,c.length)===c||d===e)return b=!1},this);return b},onNodeClick:function(a){this.nodeToSelect=a.attributes.id;
this.filesStore.loadPath(this.nodeToSelect);a=this.getNodeById(this.nodeToSelect);Ext.isDefined(a)&&a.expand()},onAfterRender:function(a){this.dragZone.lock();this.dropZone=new Ext.tree.TreeDropZone(this,{ddGroup:this.ddGroup,appendOnly:!0===this.ddAppendOnly})},treeNodeLoaded:function(a){this.getLoader().setReload(!1);a.setLeaf(!1);a=Ext.isEmpty(this.nodeToSelect)?this.getNodeById("#R#"):this.getNodeById(this.nodeToSelect);this.selectNode(a)},refreshNode:function(a,b){var c=this.getNodeById(a);Ext.isDefined(b)||
(this.nodeToSelect=a);Ext.isEmpty(c)||(this.getLoader().setReload(!0),c.reload(),c.hasChildNodes()&&c.expand())},onContextMenu:function(a,b){Zarafa.core.data.UIFactory.openContextMenu(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.treecontextmenu"],[this.convertNodeToRecord(a)],{position:b.getXY(),context:Zarafa.plugins.files.data.ComponentBox.getContext()})}});Ext.reg("filesplugin.navigatortreepanel",Zarafa.plugins.files.ui.NavigatorTreePanel);
