/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoFuture;

public class Driver
implements java.sql.Driver {
    protected static final int major = 3;
    protected static final int minor = 61;
    private String host = "localhost";
    private String port = "1111";
    private String user;
    private String password;
    private String database;
    private String charset;
    private String pwdclear;
    private Integer timeout;
    private Integer log_enable;
    private String keystore_cert;
    private String keystore_pass;
    private String keystore_path;
    private String ssl_provider;
    private Integer fbs;
    private Integer sendbs;
    private Integer recvbs;
    private final String VirtPrefix = "jdbc:virtuoso://";

    public Driver() throws SQLException {
        try {
            String string = System.getProperty("JDBC3_LOG");
            if (string != null) {
                System.err.println("RPC logfile=" + string);
                try {
                    VirtuosoFuture.rpc_log = new PrintStream(new BufferedOutputStream(new FileOutputStream(string), 4096));
                }
                catch (Exception exception) {
                    VirtuosoFuture.rpc_log = System.out;
                }
            }
        }
        catch (Exception exception) {
            VirtuosoFuture.rpc_log = null;
        }
    }

    public Connection connect(String string, Properties properties) throws VirtuosoException {
        try {
            if (this.acceptsURL(string)) {
                Properties properties2 = this.urlToInfo(string, properties);
                return new VirtuosoConnection(string, this.host, Integer.parseInt(this.port), properties2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VirtuosoException("Wrong port number : " + numberFormatException.getMessage(), -11);
        }
        return null;
    }

    public boolean acceptsURL(String string) throws VirtuosoException {
        return string.startsWith("jdbc:virtuoso://");
    }

    protected Properties urlToInfo(String string, Properties properties) {
        char c;
        CharSequence charSequence;
        String string2;
        this.host = "localhost";
        this.port = "1111";
        this.fbs = new Integer(100);
        this.sendbs = new Integer(32768);
        this.recvbs = new Integer(32768);
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            charSequence = properties.getProperty(string2);
            properties2.setProperty(string2.toLowerCase(), (String)charSequence);
        }
        char c2 = '\u0000';
        string2 = null;
        charSequence = new StringBuffer();
        String string3 = string.substring("jdbc:virtuoso://".length());
        boolean bl = true;
        block6: for (int i = 0; i < string3.length(); ++i) {
            c = string3.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (c2 == c) {
                        c2 = '\u0000';
                        continue block6;
                    }
                    if (c2 != '\u0000') continue block6;
                    c2 = c;
                    continue block6;
                }
                case '/': {
                    if (c2 == '\u0000') {
                        String string4 = ((StringBuffer)charSequence).toString().trim();
                        if (string2 == null) {
                            string2 = string4;
                            string4 = "";
                        }
                        if (string2 != null && string2.length() > 0) {
                            if (bl) {
                                bl = false;
                                properties2.setProperty("_vhost", string2);
                            } else {
                                properties2.setProperty(string2.toLowerCase(), string4);
                            }
                        }
                        string2 = null;
                        ((StringBuffer)charSequence).setLength(0);
                        continue block6;
                    }
                    ((StringBuffer)charSequence).append(c);
                    continue block6;
                }
                case '=': {
                    if (c2 == '\u0000') {
                        string2 = ((StringBuffer)charSequence).toString().trim();
                        ((StringBuffer)charSequence).setLength(0);
                        continue block6;
                    }
                    ((StringBuffer)charSequence).append(c);
                    continue block6;
                }
                default: {
                    ((StringBuffer)charSequence).append(c);
                }
            }
        }
        String string5 = ((StringBuffer)charSequence).toString().trim();
        if (string2 == null) {
            string2 = string5;
            string5 = "";
        }
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                properties2.put("_vhost", string2);
            } else {
                properties2.put(string2.toLowerCase(), string5);
            }
        }
        if ((string5 = properties2.getProperty("kpath")) != null && (c = System.getProperty("file.separator").charAt(0)) != '\\') {
            string5 = string5.replace('\\', c);
            properties2.put("kpath", string5);
        }
        if ((string5 = properties2.getProperty("ssl")) != null && properties2.getProperty("cert") == null) {
            properties2.setProperty("cert", "");
        }
        if ((string5 = properties2.getProperty("pwdtype")) != null) {
            properties2.setProperty("pwdclear", string5);
        }
        if ((string5 = properties2.getProperty("uid")) != null) {
            properties2.setProperty("user", string5);
        }
        if ((string5 = properties2.getProperty("pwd")) != null) {
            properties2.setProperty("password", string5);
        }
        if ((string5 = properties2.getProperty("cert")) != null) {
            properties2.setProperty("certificate", string5);
        }
        if ((string5 = properties2.getProperty("pass")) != null) {
            properties2.setProperty("keystorepass", string5);
        }
        if ((string5 = properties2.getProperty("kpath")) != null) {
            properties2.setProperty("keystorepath", string5);
        }
        return properties2;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws VirtuosoException {
        Vector<DriverPropertyInfo> vector = new Vector<DriverPropertyInfo>();
        if (this.acceptsURL(string)) {
            DriverPropertyInfo driverPropertyInfo;
            if (properties.get("user") == null) {
                driverPropertyInfo = new DriverPropertyInfo("user", null);
                driverPropertyInfo.required = true;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("password") == null) {
                driverPropertyInfo = new DriverPropertyInfo("password", null);
                driverPropertyInfo.required = true;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("database") == null) {
                driverPropertyInfo = new DriverPropertyInfo("database", null);
                driverPropertyInfo.required = false;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("certificate") == null) {
                driverPropertyInfo = new DriverPropertyInfo("certificate", null);
                driverPropertyInfo.required = false;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("keystorepass") == null) {
                driverPropertyInfo = new DriverPropertyInfo("keystorepass", null);
                driverPropertyInfo.required = false;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("keystorepath") == null) {
                driverPropertyInfo = new DriverPropertyInfo("keystorepath", null);
                driverPropertyInfo.required = false;
                vector.add(driverPropertyInfo);
            }
            if (properties.get("provider") == null) {
                driverPropertyInfo = new DriverPropertyInfo("provider", null);
                driverPropertyInfo.required = false;
                vector.add(driverPropertyInfo);
            }
            Object[] objectArray = new DriverPropertyInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("url", string);
        driverPropertyInfo.required = true;
        vector.add(driverPropertyInfo);
        if (properties.get("user") == null) {
            driverPropertyInfo = new DriverPropertyInfo("user", null);
            driverPropertyInfo.required = true;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("password") == null) {
            driverPropertyInfo = new DriverPropertyInfo("password", null);
            driverPropertyInfo.required = true;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("database") == null) {
            driverPropertyInfo = new DriverPropertyInfo("database", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("fbs") == null) {
            driverPropertyInfo = new DriverPropertyInfo("fbs", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("sendbs") == null) {
            driverPropertyInfo = new DriverPropertyInfo("sendbs", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("recvbs") == null) {
            driverPropertyInfo = new DriverPropertyInfo("recvbs", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("roundrobin") == null) {
            driverPropertyInfo = new DriverPropertyInfo("roundrobin", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("certificate") == null) {
            driverPropertyInfo = new DriverPropertyInfo("certificate", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("keystorepass") == null) {
            driverPropertyInfo = new DriverPropertyInfo("keystorepass", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("keystorepath") == null) {
            driverPropertyInfo = new DriverPropertyInfo("keystorepath", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        if (properties.get("provider") == null) {
            driverPropertyInfo = new DriverPropertyInfo("provider", null);
            driverPropertyInfo.required = false;
            vector.add(driverPropertyInfo);
        }
        Object[] objectArray = new DriverPropertyInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 61;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println("OpenLink Virtuoso(TM) Driver with SSL support for JDBC(TM) Version 3.x [Build 3.61]");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

