/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.StaticInfo;
import org.linkedin.util.io.resource.UnsupportedURIException;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.URLResourceProvider;
import org.linkedin.util.url.URLBuilder;

public class URLResource
extends AbstractResource {
    private final URL _url;
    private final Timespan _connectTimeout;
    private final Timespan _readTimeout;
    public static final Timespan DEFAULT_CONNECT_TIMEOUT = Timespan.ZERO_MILLISECONDS;
    public static final Timespan DEFAULT_READ_TIMEOUT = Timespan.ZERO_MILLISECONDS;

    protected URLResource(InternalResourceProvider resourceProvider, String path, URL url) {
        this(resourceProvider, path, url, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public URLResource(InternalResourceProvider resourceProvider, String path, URL url, Timespan connectTimeout, Timespan readTimeout) {
        super(resourceProvider, path);
        this._url = url;
        this._connectTimeout = connectTimeout;
        this._readTimeout = readTimeout;
    }

    @Override
    public boolean isDirectory() {
        return this.getPath().endsWith("/");
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        return URLResource.extractInfo(this._url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection urlConnection = this._url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(false);
        urlConnection.setUseCaches(false);
        urlConnection.setConnectTimeout(new Long(this._connectTimeout.getDurationInMilliseconds()).intValue());
        urlConnection.setReadTimeout(new Long(this._readTimeout.getDurationInMilliseconds()).intValue());
        urlConnection.connect();
        return urlConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        InputStream is = this.getInputStream();
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    @Override
    public URI toURI() {
        try {
            return this._url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInfo extractInfo(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(false);
        urlConnection.setUseCaches(false);
        urlConnection.connect();
        InputStream is = urlConnection.getInputStream();
        try {
            StaticInfo staticInfo = new StaticInfo(urlConnection.getContentLength(), urlConnection.getLastModified());
            return staticInfo;
        }
        finally {
            is.close();
        }
    }

    public static Resource create(URL url) {
        URLBuilder rootURL = URLBuilder.createFromPath("/");
        rootURL.setScheme(url.getProtocol());
        rootURL.setHost(url.getHost());
        rootURL.setPort(url.getPort());
        rootURL.setUserInfo(url.getUserInfo());
        return URLResource.create(rootURL.toJavaURL(), "/").createRelative(url.getPath());
    }

    public static Resource createFromRoot(URL url) {
        String urlPath = url.getPath();
        String path = "/";
        if (!urlPath.endsWith("/")) {
            urlPath = PathUtils.addLeadingSlash(urlPath);
            int idx = urlPath.lastIndexOf("/");
            path = urlPath.substring(idx + 1);
            urlPath = urlPath.substring(0, idx);
        }
        URLBuilder rootURL = URLBuilder.createFromPath(urlPath);
        rootURL.setScheme(url.getProtocol());
        rootURL.setHost(url.getHost());
        rootURL.setPort(url.getPort());
        rootURL.setUserInfo(url.getUserInfo());
        return URLResource.create(rootURL.toJavaURL(), "/").createRelative(path);
    }

    public static Resource create(URL url, String rootPath) {
        try {
            return new URLResourceProvider(url, rootPath).getRootResource();
        }
        catch (UnsupportedURIException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

