/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor.policy;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jolokia.restrictor.policy.AbstractChecker;
import org.jolokia.util.IpChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkChecker
extends AbstractChecker<String[]> {
    private Set<String> allowedHostsSet;
    private Set<String> allowedSubnetsSet;
    private static final Pattern IP_PATTERN = Pattern.compile("^[\\d.]+$");
    private static final Pattern SUBNET_PATTERN = Pattern.compile("^[\\d.]+/[\\d.]+$");

    public NetworkChecker(Document pDoc) {
        NodeList nodes = pDoc.getElementsByTagName("remote");
        if (nodes.getLength() == 0) {
            this.allowedHostsSet = null;
            return;
        }
        this.allowedHostsSet = new HashSet<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node hostNode = childs.item(j);
                if (hostNode.getNodeType() != 1) continue;
                this.assertNodeName(hostNode, "host");
                String host = hostNode.getTextContent().trim().toLowerCase();
                if (SUBNET_PATTERN.matcher(host).matches()) {
                    if (this.allowedSubnetsSet == null) {
                        this.allowedSubnetsSet = new HashSet<String>();
                    }
                    this.allowedSubnetsSet.add(host);
                    continue;
                }
                this.allowedHostsSet.add(host);
            }
        }
    }

    @Override
    public boolean check(String[] pHostOrAddresses) {
        if (this.allowedHostsSet == null) {
            return true;
        }
        for (String addr : pHostOrAddresses) {
            if (this.allowedHostsSet.contains(addr)) {
                return true;
            }
            if (this.allowedSubnetsSet == null || !IP_PATTERN.matcher(addr).matches()) continue;
            for (String subnet : this.allowedSubnetsSet) {
                if (!IpChecker.matches(subnet, addr)) continue;
                return true;
            }
        }
        return false;
    }
}

