/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtScreenDevice;
import gnu.java.awt.peer.qt.QtToolkit;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;

public class QtScreenDeviceConfiguration
extends GraphicsConfiguration {
    private QtScreenDevice owner;
    private Rectangle bounds;
    private double dpiX;
    private double dpiY;
    private int depth;

    public QtScreenDeviceConfiguration(QtScreenDevice owner) {
        this.owner = owner;
        this.bounds = owner.getBounds();
        this.dpiX = owner.getDpiX();
        this.dpiY = owner.getDpiY();
        this.depth = owner.depth();
    }

    public BufferedImage createCompatibleImage(int width, int height) {
        switch (this.depth) {
            case 24: {
                return new BufferedImage(width, height, 5);
            }
            case 16: {
                return new BufferedImage(width, height, 8);
            }
            case 8: {
                return new BufferedImage(width, height, 13);
            }
        }
        return new BufferedImage(width, height, 1);
    }

    public BufferedImage createCompatibleImage(int width, int height, int transparency) {
        if (this.depth == 32) {
            return new BufferedImage(width, height, 2);
        }
        return this.createCompatibleImage(width, height);
    }

    public VolatileImage createCompatibleVolatileImage(int width, int height) {
        return new QtVolatileImage(width, height);
    }

    public VolatileImage createCompatibleVolatileImage(int width, int height, ImageCapabilities caps) {
        return this.createCompatibleVolatileImage(width, height);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public ColorModel getColorModel() {
        return QtToolkit.getDefaultToolkit().getColorModel();
    }

    public ColorModel getColorModel(int transparency) {
        return QtToolkit.getDefaultToolkit().getColorModel();
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public GraphicsDevice getDevice() {
        return this.owner;
    }

    public AffineTransform getNormalizingTransform() {
        AffineTransform nTrans = new AffineTransform();
        nTrans.scale(72.0 / this.dpiX, 72.0 / this.dpiY);
        return nTrans;
    }

    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency) {
        return this.createCompatibleVolatileImage(width, height);
    }
}

