/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import java.lang.reflect.Array;

class GrowableArrayContext
extends AbstractContext {
    private static final int INITIAL_SIZE = 16;
    private Class klass;
    private Object array;
    private int length;

    GrowableArrayContext(String id, Class newClass) {
        this.setId(id);
        this.klass = newClass;
        this.array = Array.newInstance(this.klass, 16);
    }

    public void addParameterObject(Object o) throws AssemblyException {
        if (this.length == Array.getLength(this.array)) {
            Object tmp = Array.newInstance(this.klass, this.length * 2);
            System.arraycopy(this.array, 0, tmp, 0, this.length);
            this.array = tmp;
        }
        try {
            Array.set(this.array, this.length++, o);
        }
        catch (IllegalArgumentException iae) {
            throw new AssemblyException(iae);
        }
    }

    public void notifyStatement(Context outerContext) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Statements inside a growable array are not allowed."));
    }

    public Object endContext(Context outerContext) throws AssemblyException {
        if (this.length != Array.getLength(this.array)) {
            Object tmp = Array.newInstance(this.klass, this.length);
            System.arraycopy(this.array, 0, tmp, 0, this.length);
            this.array = tmp;
        }
        return this.array;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int index, Object o) throws AssemblyException {
        try {
            Array.set(this.array, index, o);
        }
        catch (IllegalArgumentException iae) {
            throw new AssemblyException(iae);
        }
    }

    public Object get(int index) throws AssemblyException {
        return Array.get(this.array, index);
    }

    public Object getResult() {
        return this.array;
    }
}

