/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.DomIterator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;

public abstract class DomNode
implements Node,
NodeList,
EventTarget,
DocumentEvent,
Cloneable,
Comparable {
    private static final int NKIDS_DELTA = 8;
    private static final int ANCESTORS_INIT = 20;
    private static final int NOTIFICATIONS_INIT = 10;
    static final boolean reportMutations = true;
    private static final Object lockNode = new Object();
    private static boolean dispatchDataLock;
    private static DomNode[] ancestors;
    private static ListenerRecord[] notificationSet;
    private static boolean eventDataLock;
    private static DomEvent.DomMutationEvent mutationEvent;
    DomDocument owner;
    DomNode parent;
    DomNode previous;
    DomNode next;
    DomNode first;
    DomNode last;
    int index;
    int depth;
    int length;
    final short nodeType;
    boolean readonly;
    private HashSet listeners;
    private int nListeners;
    private HashMap userData;
    private HashMap userDataHandlers;

    static {
        ancestors = new DomNode[20];
        notificationSet = new ListenerRecord[10];
        mutationEvent = new DomEvent.DomMutationEvent(null);
    }

    public void compact() {
    }

    protected DomNode(short nodeType, DomDocument owner) {
        this.nodeType = nodeType;
        if (owner == null && nodeType != 9 && nodeType != 10) {
            throw new IllegalArgumentException("no owner!");
        }
        this.owner = owner;
        this.listeners = new HashSet();
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public boolean hasChildNodes() {
        return this.length != 0;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        DomNode child = this.first;
        while (child != null) {
            child.makeReadonly();
            child = child.next;
        }
    }

    void setOwner(DomDocument doc) {
        this.owner = doc;
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.setOwner(doc);
            ctx = ctx.next;
        }
    }

    private void checkMisc(DomNode child) {
        if (this.readonly && !this.owner.building) {
            throw new DomDOMException(7, null, this, 0);
        }
        DomNode ctx = this;
        while (ctx != null) {
            if (child == ctx) {
                throw new DomDOMException(3, "can't make ancestor into a child", this, 0);
            }
            ctx = ctx.parent;
        }
        DomDocument owner = this.nodeType == 9 ? (DomDocument)this : this.owner;
        DomDocument childOwner = child.owner;
        short childNodeType = child.nodeType;
        if (childOwner != owner && (childNodeType != 10 || childOwner != null)) {
            throw new DomDOMException(4, null, child, 0);
        }
        switch (this.nodeType) {
            case 9: {
                switch (childNodeType) {
                    case 1: 
                    case 7: 
                    case 8: 
                    case 10: {
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (childNodeType) {
                    case 3: 
                    case 5: {
                        return;
                    }
                }
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                switch (childNodeType) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
            case 10: {
                if (!owner.building) break;
                switch (childNodeType) {
                    case 7: 
                    case 8: {
                        return;
                    }
                }
            }
        }
        if (owner.checkingWellformedness) {
            throw new DomDOMException(3, "can't append " + this.nodeTypeToString(childNodeType) + " to node of type " + this.nodeTypeToString(this.nodeType), this, 0);
        }
    }

    private void insertionEvent(DomEvent.DomMutationEvent event, DomNode target) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean doFree = false;
        if (event == null) {
            event = DomNode.getMutationEvent();
        }
        if (event != null) {
            doFree = true;
        } else {
            event = new DomEvent.DomMutationEvent(null);
        }
        event.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
        target.dispatchEvent(event);
        if (doFree) {
            event.target = null;
            event.relatedNode = null;
            event.currentNode = null;
            eventDataLock = false;
        }
    }

    private void removalEvent(DomEvent.DomMutationEvent event, DomNode target) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean doFree = false;
        if (event == null) {
            event = DomNode.getMutationEvent();
        }
        if (event != null) {
            doFree = true;
        } else {
            event = new DomEvent.DomMutationEvent(null);
        }
        event.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
        target.dispatchEvent(event);
        event.target = null;
        event.relatedNode = null;
        event.currentNode = null;
        if (doFree) {
            eventDataLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DomEvent.DomMutationEvent getMutationEvent() {
        Object object = lockNode;
        synchronized (object) {
            block4: {
                if (!eventDataLock) break block4;
                return null;
            }
            eventDataLock = true;
            return mutationEvent;
        }
    }

    private static void freeMutationEvent() {
        mutationEvent.clear();
        eventDataLock = false;
    }

    void setDepth(int depth) {
        this.depth = depth;
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.setDepth(depth + 1);
            ctx = ctx.next;
        }
    }

    public Node appendChild(Node newChild) {
        try {
            DomNode child = (DomNode)newChild;
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                ctx = child.first;
                while (ctx != null) {
                    DomNode ctxNext = ctx.next;
                    this.appendChild(ctx);
                    ctx = ctxNext;
                }
            } else {
                this.checkMisc(child);
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                child.index = this.length++;
                child.setDepth(this.depth + 1);
                child.next = null;
                if (this.last == null) {
                    this.first = child;
                    child.previous = null;
                } else {
                    this.last.next = child;
                    child.previous = this.last;
                }
                this.last = child;
                this.insertionEvent(null, child);
            }
            return child;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        try {
            DomNode child = (DomNode)newChild;
            DomNode ref = (DomNode)refChild;
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                ctx = child.first;
                while (ctx != null) {
                    DomNode ctxNext = ctx.next;
                    this.insertBefore(ctx, ref);
                    ctx = ctxNext;
                }
            } else {
                this.checkMisc(child);
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                if (ref == child) {
                    throw new DomDOMException(3, "can't insert node before itself", ref, 0);
                }
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                int i = ref.index;
                child.setDepth(this.depth + 1);
                child.next = ref;
                if (ref.previous != null) {
                    ref.previous.next = child;
                }
                child.previous = ref.previous;
                ref.previous = child;
                if (this.first == ref) {
                    this.first = child;
                }
                DomNode ctx = child;
                while (ctx != null) {
                    ctx.index = i++;
                    ctx = ctx.next;
                }
                this.insertionEvent(null, child);
                ++this.length;
            }
            return child;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    public Node replaceChild(Node newChild, Node refChild) {
        try {
            boolean doFree;
            DomNode child = (DomNode)newChild;
            DomNode ref = (DomNode)refChild;
            DomEvent.DomMutationEvent event = DomNode.getMutationEvent();
            boolean bl = doFree = event != null;
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                this.removalEvent(event, ref);
                --this.length;
                this.length += child.length;
                if (child.length == 0) {
                    if (ref.previous != null) {
                        ref.previous.next = ref.next;
                    }
                    if (ref.next != null) {
                        ref.next.previous = ref.previous;
                    }
                    if (this.first == ref) {
                        this.first = ref.next;
                    }
                    if (this.last == ref) {
                        this.last = ref.previous;
                    }
                } else {
                    int i = ref.index;
                    DomNode ctx2 = child.first;
                    while (ctx2 != null) {
                        ctx2.parent = this;
                        ctx2.index = i++;
                        ctx2.setDepth(ref.depth);
                        if (ctx2 == child.first) {
                            ctx2.previous = ref.previous;
                        }
                        if (ctx2 == child.last) {
                            ctx2.next = ref.next;
                        }
                        ctx2 = ctx2.next;
                    }
                    if (this.first == ref) {
                        this.first = child.first;
                    }
                    if (this.last == ref) {
                        this.last = child.last;
                    }
                }
            } else {
                this.checkMisc(child);
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                this.removalEvent(event, ref);
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                child.index = ref.index;
                child.setDepth(ref.depth);
                if (ref.previous != null) {
                    ref.previous.next = child;
                }
                child.previous = ref.previous;
                if (ref.next != null) {
                    ref.next.previous = child;
                }
                child.next = ref.next;
                if (this.first == ref) {
                    this.first = child;
                }
                if (this.last == ref) {
                    this.last = child;
                }
                this.insertionEvent(event, child);
                if (doFree) {
                    DomNode.freeMutationEvent();
                }
            }
            ref.parent = null;
            ref.index = 0;
            ref.setDepth(0);
            ref.previous = null;
            ref.next = null;
            return ref;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    public Node removeChild(Node refChild) {
        try {
            DomNode ref = (DomNode)refChild;
            if (ref == null || ref.parent != this) {
                throw new DomDOMException(8, null, ref, 0);
            }
            if (this.readonly && !this.owner.building) {
                throw new DomDOMException(7, null, this, 0);
            }
            DomNode child = this.first;
            while (child != null) {
                if (child == ref) {
                    this.removalEvent(null, child);
                    --this.length;
                    if (ref.previous != null) {
                        ref.previous.next = ref.next;
                    }
                    if (ref.next != null) {
                        ref.next.previous = ref.previous;
                    }
                    if (this.first == ref) {
                        this.first = ref.next;
                    }
                    if (this.last == ref) {
                        this.last = ref.previous;
                    }
                    int i = 0;
                    DomNode ctx = this.first;
                    while (ctx != null) {
                        ctx.index = i++;
                        ctx = ctx.next;
                    }
                    ref.parent = null;
                    ref.setDepth(0);
                    ref.index = 0;
                    ref.previous = null;
                    ref.next = null;
                    return ref;
                }
                child = child.next;
            }
            throw new DomDOMException(8, "that's no child of mine", refChild, 0);
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, refChild, 0);
        }
    }

    public Node item(int index) {
        DomNode child = this.first;
        int count = 0;
        while (child != null && count < index) {
            child = child.next;
            ++count;
        }
        return child;
    }

    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
    }

    public Node getNextSibling() {
        return this.next;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public boolean isSupported(String feature, String version) {
        Document doc = this.owner;
        DOMImplementation impl = null;
        if (doc == null && this.nodeType == 9) {
            doc = (Document)((Object)this);
        }
        if (doc == null) {
            throw new IllegalStateException("unbound ownerDocument");
        }
        impl = doc.getImplementation();
        return impl.hasFeature(feature, version);
    }

    public final Document getOwnerDocument() {
        return this.owner;
    }

    public void setNodeValue(String value) {
    }

    public String getNodeValue() {
        return null;
    }

    public final short getNodeType() {
        return this.nodeType;
    }

    public abstract String getNodeName();

    public void setPrefix(String prefix) {
    }

    public String getPrefix() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public Node cloneNode(boolean deep) {
        if (deep) {
            return this.cloneNodeDeepInternal(true, null);
        }
        DomNode node2 = (DomNode)this.clone();
        if (this.nodeType == 5) {
            node2.makeReadonly();
        }
        this.notifyUserDataHandlers((short)1, this, node2);
        return node2;
    }

    private DomNode cloneNodeDeepInternal(boolean root, DomDocument doc) {
        DomNode node2 = (DomNode)this.clone();
        boolean building = false;
        if (root) {
            doc = this.nodeType == 9 ? (DomDocument)node2 : node2.owner;
            building = doc.building;
            doc.building = true;
        }
        node2.owner = doc;
        DomNode ctx = this.first;
        while (ctx != null) {
            DomNode newChild = ctx.cloneNodeDeepInternal(false, doc);
            node2.appendChild(newChild);
            ctx = ctx.next;
        }
        if (this.nodeType == 5) {
            node2.makeReadonly();
        }
        if (root) {
            doc.building = building;
        }
        this.notifyUserDataHandlers((short)1, this, node2);
        return node2;
    }

    void notifyUserDataHandlers(short op, Node src, Node dst) {
        if (this.userDataHandlers != null) {
            for (Map.Entry entry : this.userDataHandlers.entrySet()) {
                String key = (String)entry.getKey();
                UserDataHandler handler = (UserDataHandler)entry.getValue();
                Object data = this.userData.get(key);
                handler.handle(op, key, data, src, dst);
            }
        }
    }

    public Object clone() {
        try {
            DomNode node2 = (DomNode)super.clone();
            node2.parent = null;
            node2.depth = 0;
            node2.index = 0;
            node2.length = 0;
            node2.first = null;
            node2.last = null;
            node2.previous = null;
            node2.next = null;
            node2.readonly = false;
            node2.listeners = new HashSet();
            node2.nListeners = 0;
            return node2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("clone didn't work");
        }
    }

    public NodeList getElementsByTagName(String tag) {
        return new ShadowList(null, tag);
    }

    public NodeList getElementsByTagNameNS(String namespace, String local) {
        return new ShadowList(namespace, local);
    }

    public Event createEvent(String eventType) {
        if ("mutationevents".equals(eventType = eventType.toLowerCase())) {
            return new DomEvent.DomMutationEvent(null);
        }
        if ("htmlevents".equals(eventType) || "events".equals(eventType) || "user-events".equals(eventType)) {
            return new DomEvent(null);
        }
        if ("uievents".equals(eventType)) {
            return new DomEvent.DomUIEvent(null);
        }
        throw new DomDOMException(9, eventType, null, 0);
    }

    public final void addEventListener(String type, EventListener listener, boolean useCapture) {
        ListenerRecord record = new ListenerRecord(type, listener, useCapture);
        this.listeners.add(record);
        this.nListeners = this.listeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean dispatchEvent(Event event) throws EventException {
        Throwable throwable2;
        block29: {
            boolean bl;
            block28: {
                Object object;
                DomEvent e = (DomEvent)event;
                DomNode[] ancestors = null;
                int ancestorMax = 0;
                boolean haveDispatchDataLock = false;
                if (e.type == null) {
                    throw new DomEventException();
                }
                e.doDefault = true;
                e.target = this;
                try {
                    DomNode current;
                    int ancestorLen;
                    ListenerRecord[] notificationSet;
                    boolean haveAncestorRegistrations = false;
                    Object object2 = lockNode;
                    synchronized (object2) {
                        if (!dispatchDataLock) {
                            dispatchDataLock = true;
                            haveDispatchDataLock = true;
                            notificationSet = DomNode.notificationSet;
                            ancestors = DomNode.ancestors;
                        } else {
                            notificationSet = new ListenerRecord[10];
                            ancestors = new DomNode[20];
                        }
                        ancestorLen = ancestors.length;
                    }
                    DomNode domNode = current = this.parent == null ? this : this.parent;
                    if (current.depth >= 20) {
                        DomNode[] newants = new DomNode[current.depth + 1];
                        System.arraycopy(ancestors, 0, newants, 0, ancestors.length);
                        ancestors = newants;
                        ancestorLen = ancestors.length;
                    }
                    int index = 0;
                    while (index < ancestorLen) {
                        if (current == null || current.depth == 0) break;
                        if (current.nListeners != 0) {
                            haveAncestorRegistrations = true;
                        }
                        ancestors[index] = current;
                        current = current.parent;
                        ++index;
                    }
                    if (current.depth > 0) {
                        throw new RuntimeException("dispatchEvent capture stack size");
                    }
                    ancestorMax = index;
                    e.stop = false;
                    if (haveAncestorRegistrations) {
                        e.eventPhase = 1;
                        while (!e.stop && index-- > 0) {
                            current = ancestors[index];
                            if (current.nListeners == 0) continue;
                            this.notifyNode(e, current, true, notificationSet);
                        }
                    }
                    if (!e.stop && this.nListeners != 0) {
                        e.eventPhase = (short)2;
                        this.notifyNode(e, this, false, notificationSet);
                    } else if (!haveAncestorRegistrations) {
                        e.stop = true;
                    }
                    if (!e.stop && e.bubbles) {
                        e.eventPhase = (short)3;
                        index = 0;
                        while (!e.stop && index < ancestorMax && (current = ancestors[index]) != null) {
                            if (current.nListeners != 0) {
                                this.notifyNode(e, current, false, notificationSet);
                            }
                            ++index;
                        }
                    }
                    e.eventPhase = 0;
                    bl = e.doDefault;
                    if (!haveDispatchDataLock) break block28;
                    object = lockNode;
                }
                catch (Throwable throwable2) {
                    if (!haveDispatchDataLock) break block29;
                    Object object3 = lockNode;
                    synchronized (object3) {
                        int i = 0;
                        while (i < ancestorMax) {
                            ancestors[i] = null;
                            ++i;
                        }
                        dispatchDataLock = false;
                    }
                }
                synchronized (object) {
                    int i = 0;
                    while (i < ancestorMax) {
                        ancestors[i] = null;
                        ++i;
                    }
                    dispatchDataLock = false;
                }
            }
            return bl;
        }
        throw throwable2;
    }

    private void notifyNode(DomEvent e, DomNode current, boolean capture, ListenerRecord[] notificationSet) {
        int count = 0;
        for (ListenerRecord rec : current.listeners) {
            if (rec.useCapture != capture || !e.type.equals(rec.type)) continue;
            if (count >= notificationSet.length) {
                int len = Math.max(notificationSet.length, 1);
                ListenerRecord[] tmp = new ListenerRecord[len * 2];
                System.arraycopy(notificationSet, 0, tmp, 0, notificationSet.length);
                notificationSet = tmp;
            }
            notificationSet[count++] = rec;
        }
        Iterator iter = null;
        e.currentNode = current;
        int i = 0;
        while (i < count) {
            try {
                for (ListenerRecord rec : current.listeners) {
                    if (!rec.equals(notificationSet[i])) continue;
                    notificationSet[i].listener.handleEvent(e);
                    break;
                }
                iter = null;
            }
            catch (Exception exception) {}
            notificationSet[i] = null;
            ++i;
        }
    }

    public final void removeEventListener(String type, EventListener listener, boolean useCapture) {
        this.listeners.remove(new ListenerRecord(type, listener, useCapture));
        this.nListeners = this.listeners.size();
    }

    public final void normalize() {
        boolean saved = this.readonly;
        this.readonly = false;
        DomNode ctx = this.first;
        while (ctx != null) {
            boolean saved2 = ctx.readonly;
            ctx.readonly = false;
            switch (ctx.nodeType) {
                case 3: 
                case 4: {
                    while (ctx.next != null && (ctx.next.nodeType == 3 || ctx.next.nodeType == 4)) {
                        Text text = (Text)((Object)ctx);
                        text.appendData(ctx.next.getNodeValue());
                        this.removeChild(ctx.next);
                    }
                    break;
                }
                case 1: {
                    NamedNodeMap attrs = ctx.getAttributes();
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        DomNode attr = (DomNode)attrs.item(i);
                        boolean saved3 = attr.readonly;
                        attr.readonly = false;
                        attr.normalize();
                        attr.readonly = saved3;
                        ++i;
                    }
                }
                case 2: 
                case 5: 
                case 9: 
                case 11: {
                    ctx.normalize();
                }
            }
            ctx.readonly = saved2;
            ctx = ctx.next;
        }
        this.readonly = saved;
    }

    public boolean nameAndTypeEquals(Node other) {
        if (other == this) {
            return true;
        }
        if (this.nodeType != other.getNodeType()) {
            return false;
        }
        String ns1 = this.getNamespaceURI();
        String ns2 = other.getNamespaceURI();
        if (ns1 != null && ns2 != null) {
            return ns1.equals(ns2) && this.equal(this.getLocalName(), other.getLocalName());
        }
        if (ns1 == null && ns2 == null) {
            return this.getNodeName().equals(other.getNodeName());
        }
        return false;
    }

    public String getBaseURI() {
        return this.parent != null ? this.parent.getBaseURI() : null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return (short)this.compareTo(other);
    }

    public final int compareTo(Object other) {
        if (other instanceof DomNode) {
            DomNode n1 = this;
            DomNode n2 = (DomNode)other;
            if (n1.owner != n2.owner) {
                return 0;
            }
            int d1 = n1.depth;
            int d2 = n2.depth;
            int delta = d1 - d2;
            while (d1 > d2) {
                n1 = n1.parent;
                --d1;
            }
            while (d2 > d1) {
                n2 = n2.parent;
                --d2;
            }
            int c = this.compareTo2(n1, n2);
            return c != 0 ? c : delta;
        }
        return 0;
    }

    final int compareTo2(DomNode n1, DomNode n2) {
        if (n1 == n2 || n1.depth == 0 || n2.depth == 0) {
            return 0;
        }
        int c = this.compareTo2(n1.parent, n2.parent);
        return c != 0 ? c : n1.index - n2.index;
    }

    public final String getTextContent() throws DOMException {
        return this.getTextContent(true);
    }

    final String getTextContent(boolean topLevel) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                CPStringBuilder buffer = new CPStringBuilder();
                DomNode ctx = this.first;
                while (ctx != null) {
                    String textContent = ctx.getTextContent(false);
                    if (textContent != null) {
                        buffer.append(textContent);
                    }
                    ctx = ctx.next;
                }
                return buffer.toString();
            }
            case 3: 
            case 4: {
                if (((Text)((Object)this)).isElementContentWhitespace()) {
                    return "";
                }
                return this.getNodeValue();
            }
            case 2: {
                return this.getNodeValue();
            }
            case 7: 
            case 8: {
                return topLevel ? this.getNodeValue() : "";
            }
        }
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                DomNode ctx = this.first;
                while (ctx != null) {
                    DomNode n = ctx.next;
                    this.removeChild(ctx);
                    ctx = n;
                }
                if (textContent == null) break;
                Text text = this.owner.createTextNode(textContent);
                this.appendChild(text);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.setNodeValue(textContent);
            }
        }
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public String lookupPrefix(String namespaceURI) {
        return this.parent == null || this.parent == this.owner ? null : this.parent.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.parent == null || this.parent == this.owner ? false : this.parent.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.parent == null || this.parent == this.owner ? null : this.parent.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node arg) {
        if (this == arg) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (this.nodeType != arg.getNodeType()) {
            return false;
        }
        switch (this.nodeType) {
            case 1: 
            case 2: {
                if (this.equal(this.getLocalName(), arg.getLocalName()) && this.equal(this.getNamespaceURI(), arg.getNamespaceURI())) break;
                return false;
            }
            case 7: {
                if (this.equal(this.getNodeName(), arg.getNodeName()) && this.equal(this.getNodeValue(), arg.getNodeValue())) break;
                return false;
            }
            case 3: 
            case 4: 
            case 8: {
                if (this.equal(this.getNodeValue(), arg.getNodeValue())) break;
                return false;
            }
        }
        Node argCtx = arg.getFirstChild();
        this.getFirstChild();
        DomNode ctx = this.first;
        while (ctx != null && argCtx != null) {
            if (this.nodeType == 9) {
                while (ctx != null && ctx.nodeType == 3) {
                    ctx = ctx.next;
                }
                while (argCtx != null && ctx.getNodeType() == 3) {
                    argCtx = argCtx.getNextSibling();
                }
                if (ctx == null && argCtx != null) {
                    return false;
                }
                if (argCtx == null && ctx != null) {
                    return false;
                }
            }
            if (!ctx.isEqualNode(argCtx)) {
                return false;
            }
            argCtx = argCtx.getNextSibling();
            ctx = ctx.next;
        }
        return ctx == null && argCtx == null;
    }

    boolean equal(String arg1, String arg2) {
        return arg1 == null && arg2 == null || arg1 != null && arg1.equals(arg2);
    }

    public Object getFeature(String feature, String version) {
        DOMImplementation impl;
        DOMImplementation dOMImplementation = impl = this.nodeType == 9 ? ((Document)((Object)this)).getImplementation() : this.owner.getImplementation();
        if (impl.hasFeature(feature, version)) {
            return this;
        }
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (handler != null) {
            if (this.userDataHandlers == null) {
                this.userDataHandlers = new HashMap();
            }
            this.userDataHandlers.put(key, handler);
        }
        return this.userData.put(key, data);
    }

    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    public String toString() {
        String nodeName = this.getNodeName();
        String nodeValue = this.getNodeValue();
        CPStringBuilder buf = new CPStringBuilder(this.getClass().getName());
        buf.append('[');
        if (nodeName != null) {
            buf.append(nodeName);
        }
        if (nodeValue != null) {
            if (nodeName != null) {
                buf.append('=');
            }
            buf.append('\'');
            buf.append(this.encode(nodeValue));
            buf.append('\'');
        }
        buf.append(']');
        return buf.toString();
    }

    String encode(String value) {
        CPStringBuilder buf = null;
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\n') {
                if (buf == null) {
                    buf = new CPStringBuilder(value.substring(0, i));
                }
                buf.append("\\n");
            } else if (c == '\r') {
                if (buf == null) {
                    buf = new CPStringBuilder(value.substring(0, i));
                }
                buf.append("\\r");
            } else if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf != null ? buf.toString() : value;
    }

    String nodeTypeToString(short nodeType) {
        switch (nodeType) {
            case 1: {
                return "ELEMENT_NODE";
            }
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
        }
        return "UNKNOWN";
    }

    public void list(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.println(this.toString());
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.list(out, indent + 1);
            ctx = ctx.next;
        }
    }

    static final class DomEventException
    extends EventException {
        DomEventException() {
            super((short)0, "unspecified event type");
        }
    }

    static final class ListenerRecord {
        String type;
        EventListener listener;
        boolean useCapture;

        ListenerRecord(String type, EventListener listener, boolean useCapture) {
            this.type = type.intern();
            this.listener = listener;
            this.useCapture = useCapture;
        }

        public boolean equals(Object o) {
            ListenerRecord rec = (ListenerRecord)o;
            return this.listener == rec.listener && this.useCapture == rec.useCapture && this.type == rec.type;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.type.hashCode();
        }
    }

    final class LiveNodeList
    implements NodeList,
    EventListener,
    NodeFilter {
        private final boolean matchAnyURI;
        private final boolean matchAnyName;
        private final String elementURI;
        private final String elementName;
        private DomIterator current;
        private int lastIndex;

        LiveNodeList(String uri, String name) {
            this.elementURI = uri;
            this.elementName = name;
            this.matchAnyURI = "*".equals(uri);
            this.matchAnyName = "*".equals(name);
            DomNode.this.addEventListener("DOMNodeInserted", this, true);
            DomNode.this.addEventListener("DOMNodeRemoved", this, true);
        }

        void detach() {
            if (this.current != null) {
                this.current.detach();
            }
            this.current = null;
            DomNode.this.removeEventListener("DOMNodeInserted", this, true);
            DomNode.this.removeEventListener("DOMNodeRemoved", this, true);
        }

        public short acceptNode(Node element) {
            if (element == DomNode.this) {
                return 3;
            }
            if (this.elementURI != null) {
                if (!this.matchAnyURI && !this.elementURI.equals(element.getNamespaceURI())) {
                    return 3;
                }
                if (!this.matchAnyName && !this.elementName.equals(element.getLocalName())) {
                    return 3;
                }
            } else if (!this.matchAnyName && !this.elementName.equals(element.getNodeName())) {
                return 3;
            }
            return 1;
        }

        private DomIterator createIterator() {
            return new DomIterator(DomNode.this, 1, this, true);
        }

        public void handleEvent(Event e) {
            MutationEvent mutation = (MutationEvent)e;
            Node related = mutation.getRelatedNode();
            if (related.getNodeType() != 1 || related.getNodeName() != this.elementName || related.getNamespaceURI() != this.elementURI) {
                return;
            }
            if (this.current != null) {
                this.current.detach();
            }
            this.current = null;
        }

        /*
         * Unable to fully structure code
         */
        public Node item(int index) {
            if (this.current == null) {
                this.current = this.createIterator();
                this.lastIndex = -1;
            }
            if (index > this.lastIndex) ** GOTO lbl16
            while (index != this.lastIndex) {
                this.current.previousNode();
                --this.lastIndex;
            }
            ret = this.current.previousNode();
            this.current.detach();
            this.current = null;
            return ret;
lbl-1000:
            // 1 sources

            {
                this.current.nextNode();
lbl16:
                // 2 sources

                ** while (++this.lastIndex != index)
            }
lbl17:
            // 1 sources

            ret = this.current.nextNode();
            this.current.detach();
            this.current = null;
            return ret;
        }

        public int getLength() {
            int retval = 0;
            DomIterator iter = this.createIterator();
            while (iter.nextNode() != null) {
                ++retval;
            }
            iter.detach();
            return retval;
        }
    }

    final class ShadowList
    implements NodeList {
        private LiveNodeList liveList;

        ShadowList(String ns, String local) {
            this.liveList = new LiveNodeList(ns, local);
        }

        public void finalize() {
            this.liveList.detach();
            this.liveList = null;
        }

        public Node item(int index) {
            return this.liveList.item(index);
        }

        public int getLength() {
            return this.liveList.getLength();
        }
    }
}

