/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.editors.ColorEditor;
import gnu.java.beans.editors.FontEditor;
import gnu.java.beans.editors.NativeBooleanEditor;
import gnu.java.beans.editors.NativeByteEditor;
import gnu.java.beans.editors.NativeDoubleEditor;
import gnu.java.beans.editors.NativeFloatEditor;
import gnu.java.beans.editors.NativeIntEditor;
import gnu.java.beans.editors.NativeLongEditor;
import gnu.java.beans.editors.NativeShortEditor;
import gnu.java.beans.editors.StringEditor;
import gnu.java.lang.ClassHelper;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorManager {
    static Hashtable<Class<?>, Class<?>> editors = new Hashtable();
    static String[] editorSearchPath = new String[]{"gnu.java.beans.editors", "sun.beans.editors"};

    static {
        PropertyEditorManager.registerEditor(Boolean.TYPE, NativeBooleanEditor.class);
        PropertyEditorManager.registerEditor(Byte.TYPE, NativeByteEditor.class);
        PropertyEditorManager.registerEditor(Short.TYPE, NativeShortEditor.class);
        PropertyEditorManager.registerEditor(Integer.TYPE, NativeIntEditor.class);
        PropertyEditorManager.registerEditor(Long.TYPE, NativeLongEditor.class);
        PropertyEditorManager.registerEditor(Float.TYPE, NativeFloatEditor.class);
        PropertyEditorManager.registerEditor(Double.TYPE, NativeDoubleEditor.class);
        PropertyEditorManager.registerEditor(String.class, StringEditor.class);
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        PropertyEditorManager.registerEditor(Font.class, FontEditor.class);
    }

    public static void registerEditor(Class<?> editedClass, Class<?> editorClass) {
        editors.put(editedClass, editorClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyEditor findEditor(Class<?> editedClass) {
        try {
            Class<?> found = editors.get(editedClass);
            if (found != null) {
                return (PropertyEditor)found.newInstance();
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                found = Class.forName(String.valueOf(editedClass.getName()) + "Editor", true, contextClassLoader);
                PropertyEditorManager.registerEditor(editedClass, found);
                return (PropertyEditor)found.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                String appendName = "." + ClassHelper.getTruncatedClassName(editedClass) + "Editor";
                String[] stringArray = editorSearchPath;
                synchronized (editorSearchPath) {
                    int i = 0;
                    while (i < editorSearchPath.length) {
                        try {
                            found = Class.forName(String.valueOf(editorSearchPath[i]) + appendName, true, contextClassLoader);
                            PropertyEditorManager.registerEditor(editedClass, found);
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return (PropertyEditor)found.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            ++i;
                        }
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        {
            return null;
        }
    }

    public static String[] getEditorSearchPath() {
        return editorSearchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEditorSearchPath(String[] editorSearchPath) {
        String[] stringArray = editorSearchPath;
        synchronized (editorSearchPath) {
            PropertyEditorManager.editorSearchPath = editorSearchPath;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

