/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class BasicHTML {
    public static final String propertyKey = "html";
    public static final String documentBaseKey = "html.base";

    public static View createHTMLView(JComponent c, String html) {
        HTMLDocument doc = new HTMLDocument();
        HTMLEditorKit kit = new HTMLEditorKit();
        StringReader reader = new StringReader(html);
        try {
            kit.read(reader, (Document)doc, 0);
        }
        catch (IOException ex) {
            AssertionError err = new AssertionError((Object)"unexpected IOException");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError((Object)"unexpected BadLocationException");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        ViewFactory vf = kit.getViewFactory();
        Element root = doc.getDefaultRootElement();
        View view = vf.create(root);
        HTMLRootView rootView = new HTMLRootView(c, view, kit, doc);
        return rootView;
    }

    public static boolean isHTMLString(String s) {
        return s != null && s.contains("<") && s.contains(">");
    }

    public static void updateRenderer(JComponent c, String text) {
        if (BasicHTML.isHTMLString(text)) {
            c.putClientProperty(propertyKey, BasicHTML.createHTMLView(c, text));
        } else {
            c.putClientProperty(propertyKey, null);
        }
    }

    private static class HTMLRootView
    extends View {
        private View view;
        private JComponent component;
        private EditorKit editorKit;
        private Document document;

        public HTMLRootView(JComponent c, View view, EditorKit kit, Document doc) {
            super(null);
            this.component = c;
            this.editorKit = kit;
            this.document = doc;
            this.setView(view);
            this.setSize(view.getPreferredSpan(0), view.getPreferredSpan(1));
        }

        public ViewFactory getViewFactory() {
            return this.editorKit.getViewFactory();
        }

        public void preferenceChanged(View v, boolean width, boolean height) {
            this.component.revalidate();
        }

        public void setView(View v) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (v != null) {
                v.setParent(this);
            }
            this.view = v;
        }

        public void setSize(float w, float h) {
            this.view.setSize(w, h);
        }

        public View getView(int index) {
            return this.view;
        }

        public int getViewCount() {
            int count = 0;
            if (this.view != null) {
                count = 1;
            }
            return count;
        }

        public Container getContainer() {
            return this.component;
        }

        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics g, Shape s) {
            if (this.view != null) {
                Rectangle b = s.getBounds();
                this.view.setSize(b.width, b.height);
                this.view.paint(g, s);
            }
        }

        public Shape modelToView(int position, Shape a, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(position, a, bias);
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            return this.view.viewToModel(x, y, a, b);
        }

        public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.insertUpdate(ev, shape, vf);
        }

        public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.removeUpdate(ev, shape, vf);
        }

        public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.changedUpdate(ev, shape, vf);
        }

        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int d, Position.Bias[] biasRet) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(pos, b, a, d, biasRet);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return this.document;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public Element getElement() {
            return this.view.getElement();
        }
    }
}

