/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class RevTag
extends RevObject {
    private RevObject object;
    private byte[] buffer;
    private String tagName;

    public static RevTag parse(byte[] raw) throws CorruptObjectException {
        return RevTag.parse(new RevWalk((ObjectReader)null), raw);
    }

    public static RevTag parse(RevWalk rw, byte[] raw) throws CorruptObjectException {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        boolean retain = rw.isRetainBody();
        rw.setRetainBody(true);
        RevTag r = rw.lookupTag(fmt.idFor(4, raw));
        r.parseCanonical(rw, raw);
        rw.setRetainBody(retain);
        return r;
    }

    protected RevTag(AnyObjectId id) {
        super(id);
    }

    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk, walk.getCachedBytes(this));
    }

    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk, byte[] rawTag) throws CorruptObjectException {
        MutableInteger pos = new MutableInteger();
        pos.value = 53;
        int oType = Constants.decodeTypeString(this, rawTag, (byte)10, pos);
        walk.idBuffer.fromString(rawTag, 7);
        this.object = walk.lookupAny(walk.idBuffer, oType);
        int p = pos.value += 4;
        int nameEnd = RawParseUtils.nextLF(rawTag, p) - 1;
        this.tagName = RawParseUtils.decode(Constants.CHARSET, rawTag, p, nameEnd);
        if (walk.isRetainBody()) {
            this.buffer = rawTag;
        }
        this.flags |= 1;
    }

    public final int getType() {
        return 4;
    }

    public final PersonIdent getTaggerIdent() {
        byte[] raw = this.buffer;
        int nameB = RawParseUtils.tagger(raw, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw, nameB);
    }

    public final String getFullMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        return RawParseUtils.decode(enc, raw, msgB, raw.length);
    }

    public final String getShortMessage() {
        byte[] raw = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw);
        int msgE = RawParseUtils.endOfParagraph(raw, msgB);
        String str = RawParseUtils.decode(enc, raw, msgB, msgE);
        if (RevCommit.hasLF(raw, msgB, msgE)) {
            str = StringUtils.replaceLineBreaksWithSpace(str);
        }
        return str;
    }

    public final RevObject getObject() {
        return this.object;
    }

    public final String getTagName() {
        return this.tagName;
    }

    final void disposeBody() {
        this.buffer = null;
    }
}

