/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;

public class UniqueVariableNameFinder {
    private Map<String, Integer> varDeclMap = new HashMap<String, Integer>();

    public void addPattern(String pattern, int count) {
        if (this.varDeclMap.containsKey(pattern)) {
            this.varDeclMap.remove(pattern);
        }
        this.varDeclMap.put(pattern, new Integer(count));
    }

    public int getPatternCount(String pattern) {
        Integer count = this.varDeclMap.get(pattern);
        return count != null ? count : 0;
    }

    public String getVariableDecl(ParameterInfo p) {
        if (p == null) {
            return "";
        }
        return p.getType().getSimpleName() + " " + Util.getParameterName(p, true, true, true);
    }

    public String getVariableDecl(WSParameter p) {
        if (p == null) {
            return "";
        }
        return p.getTypeName() + " " + p.getName();
    }

    public String getVariableCount(String varName) {
        return this.getPatternCount(varName) > 0 ? this.getPatternCount(varName) + "" : "";
    }

    public void updateVariableDecl(String text, List<ParameterInfo> params) throws BadLocationException {
        for (ParameterInfo p : params) {
            this.updateVariableDecl(text, this.getVariableDecl(p));
        }
    }

    public void updateVariableDeclForWS(String text, List<? extends WSParameter> params) throws BadLocationException {
        for (WSParameter wSParameter : params) {
            this.updateVariableDecl(text, this.getVariableDecl(wSParameter));
        }
    }

    public void updateVariableDecl(String text, String pattern) throws BadLocationException {
        int count = 0;
        int ndx = -1;
        while ((ndx = text.indexOf(pattern, ndx + 1)) > -1) {
            ++count;
        }
        if (count > 0) {
            this.addPattern(pattern, count);
        }
    }

    public String findNewName(String pattern, String oldName) {
        Integer pCount = this.varDeclMap.get(pattern);
        if (pCount != null) {
            return oldName + pCount;
        }
        return oldName;
    }

    public List<ParameterInfo> renameParameterNames(List<ParameterInfo> params) {
        ArrayList<ParameterInfo> returnParams = new ArrayList<ParameterInfo>();
        for (ParameterInfo p : params) {
            String oldName;
            String newName = oldName = Util.getParameterName(p, true, true, true);
            if (!"request".equals(oldName) && !"response".equals(oldName)) {
                newName = this.findNewName(this.getVariableDecl(p), oldName);
            }
            if (!newName.equals(oldName)) {
                ParameterInfo clone = this.clone(p, newName, p.getType());
                returnParams.add(clone);
                continue;
            }
            returnParams.add(p);
        }
        return returnParams;
    }

    private ParameterInfo clone(ParameterInfo p, String name, Class type) {
        ParameterInfo clone = new ParameterInfo(name, type);
        clone.setFixed(p.getFixed());
        clone.setStyle(p.getStyle());
        clone.setDefaultValue(p.getDefaultValue());
        clone.setIsApiKey(p.isApiKey());
        clone.setId(p.getId());
        clone.setIsRequired(p.isRequired());
        clone.setIsRepeating(p.isRepeating());
        clone.setIsSessionKey(p.isSessionKey());
        clone.setOption(p.getOption());
        return clone;
    }

    public void clearPatterns() {
        this.varDeclMap.clear();
    }
}

