/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.nette.tester.Bundle;
import org.netbeans.modules.php.nette.tester.commands.Tester;
import org.netbeans.modules.php.nette.tester.coverage.CoverageProvider;
import org.netbeans.modules.php.nette.tester.create.TestCreator;
import org.netbeans.modules.php.nette.tester.locate.TesterTestLocator;
import org.netbeans.modules.php.nette.tester.run.TapParser;
import org.netbeans.modules.php.nette.tester.run.TestRunner;
import org.netbeans.modules.php.nette.tester.ui.customizer.TesterCustomizer;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class TesterTestingProvider
implements PhpTestingProvider {
    public static final String IDENTIFIER = "Nette Tester";
    private static final TesterTestingProvider INSTANCE = new TesterTestingProvider();

    private TesterTestingProvider() {
    }

    public static TesterTestingProvider getInstance() {
        return INSTANCE;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.TesterTestingProvider_name();
    }

    public boolean isTestFile(PhpModule phpModule, FileObject fileObj) {
        if (!FileUtils.isPhpFile((FileObject)fileObj)) {
            return false;
        }
        for (FileObject testDirectory : phpModule.getTestDirectories()) {
            if (!FileUtil.isParentOf((FileObject)testDirectory, (FileObject)fileObj)) continue;
            return true;
        }
        return false;
    }

    public boolean isTestCase(PhpModule phpModule, PhpType.Method method) {
        return Tester.isTestMethod(method);
    }

    public void runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        new TestRunner(phpModule).runTests(runInfo, testSession);
        if (runInfo.isCoverageEnabled()) {
            testSession.setCoverage(new CoverageProvider(phpModule).getCoverage(runInfo));
        }
    }

    public TestLocator getTestLocator(PhpModule phpModule) {
        return new TesterTestLocator(phpModule);
    }

    public CreateTestsResult createTests(PhpModule phpModule, List<FileObject> files, Map<String, Object> configurationPanelProperties) {
        return new TestCreator(phpModule).createTests(files);
    }

    public boolean isCoverageSupported(PhpModule phpModule) {
        return true;
    }

    public Locations.Line parseFileFromOutput(String line) {
        File file;
        Pair<String, Integer> fileLine = TapParser.getFileLine(line);
        if (fileLine != null && (file = new File((String)fileLine.first())).isFile()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            assert (fo != null);
            return new Locations.Line(fo, ((Integer)fileLine.second()).intValue());
        }
        return null;
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer(PhpModule phpModule) {
        return new TesterCustomizer(phpModule);
    }
}

