/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver;

import java.awt.EventQueue;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.jstestdriver.Bundle;
import org.netbeans.modules.javascript.jstestdriver.api.JsTestDriver;
import org.netbeans.modules.javascript.jstestdriver.api.RunTests;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferences;
import org.netbeans.modules.javascript.jstestdriver.preferences.JsTestDriverPreferencesValidator;
import org.netbeans.modules.javascript.jstestdriver.ui.customizer.CustomizerPanel;
import org.netbeans.modules.web.clientproject.api.ProjectDirectoriesProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.TestRunInfo;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.clientproject.spi.jstesting.JsTestingProviderImplementation;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class JsTestingProviderImpl
implements JsTestingProviderImplementation {
    private static final Logger LOGGER = Logger.getLogger(JsTestingProviderImpl.class.getName());

    public String getIdentifier() {
        return "JsTestDriver";
    }

    public String getDisplayName() {
        return Bundle.JsTestingProviderImpl_displayName();
    }

    public boolean isEnabled(Project project) {
        return JsTestDriverPreferences.isEnabled(project);
    }

    public boolean isCoverageSupported(Project project) {
        return false;
    }

    public void runTests(Project project, TestRunInfo runInfo) {
        assert (!EventQueue.isDispatchThread());
        FileObject configFile = this.getValidConfigFile(project);
        if (configFile == null) {
            LOGGER.log(Level.INFO, "Cannot run tests for \"{0}\" project, no jsTestDriver.conf provided", ProjectUtils.getInformation((Project)project).getName());
            return;
        }
        try {
            RunTests.runAllTests(project, project.getProjectDirectory(), configFile);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "cannot execute tests", t);
        }
    }

    public FileObject fromServer(Project project, URL serverUrl) {
        File file;
        String serverU = WebUtils.urlToString((URL)serverUrl);
        String prefix = JsTestDriver.getServerURL();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (!serverU.startsWith(prefix = prefix + "test/")) {
            return null;
        }
        String projectRelativePath = serverU.substring(prefix.length());
        if (projectRelativePath.isEmpty()) {
            return null;
        }
        try {
            projectRelativePath = URLDecoder.decode(projectRelativePath, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        FileObject projectDirectory = project.getProjectDirectory();
        FileObject fileObject = projectDirectory.getFileObject(projectRelativePath);
        if (fileObject != null) {
            return fileObject;
        }
        FileObject testsFolder = this.getTestsFolder(project);
        if (testsFolder != null && !this.isUnderneath(projectDirectory, testsFolder) && (file = new File(projectRelativePath)).isFile()) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public URL toServer(Project project, FileObject projectFile) {
        FileObject testsFolder;
        String prefix = JsTestDriver.getServerURL();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        prefix = prefix + "test/";
        String relativePath = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)projectFile);
        if (relativePath != null) {
            try {
                return new URL(prefix + relativePath);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        if ((testsFolder = this.getTestsFolder(project)) == null) {
            return null;
        }
        if (this.isUnderneath(testsFolder, projectFile)) {
            String absolutePath = FileUtil.toFile((FileObject)projectFile).getAbsolutePath();
            try {
                return new URL(prefix + absolutePath);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    public CustomizerPanelImplementation createCustomizerPanel(Project project) {
        return new CustomizerPanel(project);
    }

    public void notifyEnabled(Project project, boolean enabled) {
        JsTestDriverPreferences.setEnabled(project, enabled);
    }

    public void projectOpened(Project project) {
    }

    public void projectClosed(Project project) {
    }

    public NodeList<Node> createNodeList(Project project) {
        return null;
    }

    private FileObject getValidConfigFile(Project project) {
        String message;
        String config = JsTestDriverPreferences.getConfig(project);
        ValidationResult result = new JsTestDriverPreferencesValidator().validateConfig(config).getResult();
        if (result.isFaultless()) {
            File configFile = new File(config);
            FileObject fo = FileUtil.toFileObject((File)configFile);
            assert (fo != null) : "FileObject must be found for " + config;
            assert (fo.isValid()) : "Valid FileObject must be found for " + config;
            return fo;
        }
        if (result.hasErrors()) {
            message = ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        } else {
            assert (result.hasWarnings()) : result;
            message = ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
        File file = new FileChooserBuilder(JsTestingProviderImpl.class).setTitle(Bundle.JsTestingProviderImpl_chooser_title()).setFilesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)project.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            JsTestDriverPreferences.setConfig(project, file.getAbsolutePath());
            FileObject fo = FileUtil.toFileObject((File)file);
            assert (fo != null) : "FileObject must be found for " + file;
            assert (fo.isValid()) : "Valid FileObject must be found for " + file;
            return fo;
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.JsTestingProviderImpl_error_config()));
        return null;
    }

    @CheckForNull
    private FileObject getTestsFolder(Project project) {
        ProjectDirectoriesProvider directoriesProvider = (ProjectDirectoriesProvider)project.getLookup().lookup(ProjectDirectoriesProvider.class);
        if (directoriesProvider == null) {
            return null;
        }
        return directoriesProvider.getTestDirectory(false);
    }

    private boolean isUnderneath(FileObject root, FileObject folder) {
        return root.equals(folder) || FileUtil.isParentOf((FileObject)root, (FileObject)folder);
    }
}

