/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;

public class ScheduledTaskContainer
extends AbstractTaskContainer {
    private final TaskActivityManager activityManager;
    private final String summary;
    private final DateRange range;
    private String shortSummary;

    public ScheduledTaskContainer(TaskActivityManager activityManager, DateRange range, String summary) {
        super(summary == null ? range.toString(false) : summary);
        this.activityManager = activityManager;
        this.range = range;
        if (summary == null) {
            if (range instanceof DayDateRange && TaskActivityUtil.getNextWeek().includes(range)) {
                String day;
                DayDateRange dayRange = (DayDateRange)range;
                this.summary = day = NLS.bind((String)Messages.ScheduledTaskContainer_Next_Day, (Object)dayRange.getDayOfWeek());
                this.shortSummary = day;
            } else {
                this.shortSummary = this.summary = range.toString(false);
            }
        } else {
            this.summary = summary;
        }
    }

    public ScheduledTaskContainer(TaskActivityManager taskActivityManager, DateRange day) {
        this(taskActivityManager, day, null);
    }

    public boolean isFuture() {
        return !this.isPresent() && this.range.getStartDate().after(Calendar.getInstance());
    }

    public boolean isPresent() {
        return this.range.getStartDate().before(Calendar.getInstance()) && this.range.getEndDate().after(Calendar.getInstance());
    }

    @Override
    public Collection<ITask> getChildren() {
        Calendar now = Calendar.getInstance();
        int offsetInMinutes = this.range.getStartDate().getTimeZone().getOffset(now.getTimeInMillis()) / 1000 / 60;
        if (offsetInMinutes > 660) {
            offsetInMinutes = -(1440 - offsetInMinutes);
        }
        int minutesForwardToDateline = 660 - offsetInMinutes;
        int minutesBackwardToDateline = 1380 - minutesForwardToDateline;
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(this.range.getStartDate().getTimeInMillis());
        start.add(12, -minutesForwardToDateline);
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(this.range.getEndDate().getTimeInMillis());
        end.add(12, minutesBackwardToDateline);
        Set<ITask> tasks = this.activityManager.getScheduledTasks(start, end);
        if (this.range instanceof WeekDateRange) {
            Iterator<ITask> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                DateRange scheduledDate;
                ITask task = iterator.next();
                if (!(task instanceof AbstractTask) || (scheduledDate = ((AbstractTask)task).getScheduledForDate()) instanceof WeekDateRange || TaskActivityUtil.getNextWeek().next().compareTo(this.range) == 0 && !scheduledDate.getEndDate().after(end)) continue;
                iterator.remove();
            }
        }
        HashSet<ITask> children = new HashSet<ITask>();
        Calendar cal = TaskActivityUtil.getCalendar();
        for (ITask task : tasks) {
            if (task.isCompleted() && !this.isCompletedToday(task) || this.isDueBeforeScheduled(task) && this.activityManager.isOwnedByUser(task)) continue;
            if (this.isThisWeekBin() && this.isScheduledForAWeek(task)) {
                if (task.getDueDate() != null) {
                    cal.setTime(task.getDueDate());
                    if (this.range.includes(cal) && this.activityManager.isOwnedByUser(task)) continue;
                }
                this.addChild(children, task);
            }
            this.addChild(children, task);
        }
        if (!TaskActivityUtil.getCurrentWeek().equals(this.range) && !TaskActivityUtil.getNextWeek().equals(this.range)) {
            Calendar endDueSearch = Calendar.getInstance();
            endDueSearch.setTimeInMillis(this.range.getStartDate().getTimeInMillis());
            endDueSearch.add(12, minutesBackwardToDateline);
            for (ITask iTask : this.activityManager.getDueTasks(start, endDueSearch)) {
                if (this.isScheduledBeforeDue(iTask) || !this.activityManager.isOwnedByUser(iTask)) continue;
                this.addChild(children, iTask);
            }
        }
        if (this.isTodayBin()) {
            for (ITask task : this.activityManager.getOverScheduledTasks()) {
                if (!this.isScheduledForADay(task)) continue;
                this.addChild(children, task);
            }
            Calendar searchFrom = Calendar.getInstance();
            searchFrom.setTimeInMillis(start.getTimeInMillis());
            searchFrom.add(5, -1);
            for (ITask iTask : this.activityManager.getScheduledTasks(searchFrom, end)) {
                if (!this.isScheduledForADay(iTask)) continue;
                this.addChild(children, iTask);
            }
            for (ITask iTask : this.activityManager.getOverDueTasks()) {
                this.addChild(children, iTask);
            }
            ITask iTask = this.activityManager.getActiveTask();
            if (iTask != null && !children.contains(iTask)) {
                this.addChild(children, iTask);
            }
        }
        if (this.range instanceof WeekDateRange && ((WeekDateRange)this.range).isThisWeek()) {
            for (ITask task : this.activityManager.getOverScheduledTasks()) {
                if (!this.isScheduledForAWeek(task)) continue;
                this.addChild(children, task);
            }
        }
        return children;
    }

    private boolean isTodayBin() {
        return this.range instanceof DayDateRange && ((DayDateRange)this.range).isPresent();
    }

    private boolean isThisWeekBin() {
        return this.range instanceof WeekDateRange && ((WeekDateRange)this.range).isThisWeek();
    }

    private boolean isScheduledForAWeek(ITask task) {
        return task instanceof AbstractTask && ((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange;
    }

    public boolean isDueBeforeScheduled(ITask task) {
        return task.getDueDate() != null && task.getDueDate().before(((AbstractTask)task).getScheduledForDate().getEndDate().getTime());
    }

    private boolean isScheduledForADay(ITask task) {
        return task instanceof AbstractTask && !(((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange);
    }

    private boolean isScheduledBeforeDue(ITask task) {
        return ((AbstractTask)task).getScheduledForDate() != null && ((AbstractTask)task).getScheduledForDate().before(this.range.getStartDate());
    }

    private boolean isCompletedToday(ITask task) {
        return task.isCompleted() && TaskActivityUtil.getDayOf(task.getCompletionDate()).isPresent();
    }

    private void addChild(Set<ITask> collection, ITask task) {
        collection.add(task);
    }

    @Override
    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return this.range.toString();
    }

    public String getShortSummary() {
        if (this.shortSummary != null) {
            return this.shortSummary;
        }
        return this.range.toString();
    }

    @Override
    public String getHandleIdentifier() {
        return this.summary;
    }

    @Override
    public String getPriority() {
        return "";
    }

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public int compareTo(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            return this.range.compareTo(container.getDateRange());
        }
        return 0;
    }

    public DateRange getDateRange() {
        return this.range;
    }

    public Calendar getEnd() {
        return this.range.getEndDate();
    }

    public Calendar getStart() {
        return this.range.getStartDate();
    }

    public boolean includes(Calendar pastWeeksTaskStart) {
        return this.range.includes(pastWeeksTaskStart);
    }
}

