/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.ProjectDefaultHtmlSourceVersionController;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class CreateHtmlFromTemplateAttributeProvider
implements CreateFromTemplateAttributesProvider {
    private static final String DOCTYPE_TEMPLATE_PROPERTY_NAME = "doctype";

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        HtmlVersion version;
        Project project = FileOwnerQuery.getOwner((FileObject)target.getPrimaryFile());
        if (project == null) {
            version = HtmlVersion.getDefaultVersion();
        } else {
            String mimeType = template.getPrimaryFile().getMIMEType();
            boolean xhtml = "text/xhtml".equals(mimeType);
            version = ProjectDefaultHtmlSourceVersionController.getDefaultHtmlVersion(project, xhtml);
            if (version == null) {
                version = xhtml ? HtmlVersion.getDefaultXhtmlVersion() : HtmlVersion.getDefaultVersion();
            }
        }
        return Collections.singletonMap(DOCTYPE_TEMPLATE_PROPERTY_NAME, version.getDoctypeDeclaration());
    }
}

