/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.Pattern;

public class NBSLanguage
extends Language {
    static final String NBS_MIME_TYPE = "text/x-nbs";
    public static int WHITESPACE_ID;
    public static int COMMENT_ID;
    public static int IDENTIFIER_ID;
    private static Language nbsLanguage;
    private Parser parser;
    private LLSyntaxAnalyser analyser;
    private FeatureList featureList = new FeatureList();
    private Map<String, Integer> tokenTypeToID = new HashMap<String, Integer>();
    private Map<Integer, String> idToTokenType = new HashMap<Integer, String>();
    private int tokenTypeCount = 0;
    private Map<String, Integer> ntToNTID;
    private Map<Integer, String> ntidToNt;

    static Language getNBSLanguage() {
        if (nbsLanguage == null) {
            nbsLanguage = new NBSLanguage();
        }
        return nbsLanguage;
    }

    private static Rule rule(String nt, Object[] right) {
        return Rule.create(nt, Arrays.asList(right));
    }

    private NBSLanguage() {
        ArrayList<TokenType> tokenTypes = new ArrayList<TokenType>();
        try {
            tokenTypes.add(new TokenType(null, Pattern.create("'ACTION' |'AST' |'BRACE' |'BUNDLE' |'COLOR' |'COMMENT_LINE' |'COMPLETE' |'COMPLETION' |'FOLD' |'FORMAT' |'HYPERLINK' |'IMPORT' |'INDENT' |'MARK' | 'NAVIGATOR' |'PARSE' |'PROPERTIES' |'REFORMAT' |'SELECTION' | 'SEMANTIC_CONTEXT' | 'SEMANTIC_DECLARATION' | 'SEMANTIC_USAGE' | 'SKIP' |'SYNTAX_ERROR' |'TOKEN' |'TOOLTIP'"), "keyword", 1, null, 1, null));
            tokenTypes.add(new TokenType(null, Pattern.create("['a'-'z' 'A'-'Z'] ['a'-'z' 'A'-'Z' '0'-'9' '_']*"), "identifier", 2, null, 2, null));
            tokenTypes.add(new TokenType(null, Pattern.create("':' | '*' | '?' | '+' | '-' | '[' | ']' | '<' | '>' | '^' | '|' | '{' | '}' | '(' | ')' | ',' | '=' | ';' | '.' | '$'"), "operator", 3, null, 3, null));
            tokenTypes.add(new TokenType(null, Pattern.create("'\\\"'([^'\\\"' '\\\\' '\\r' '\\n'] |('\\\\' ['r' 'n' 't' '\\\\' '\\'' '\\\"']) |('\\\\' 'u' ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F']))*'\\\"'"), "string", 4, null, 4, null));
            tokenTypes.add(new TokenType(null, Pattern.create("'\\''([^'\\'' '\\\\' '\\r' '\\n'] |('\\\\' ['r' 'n' 't' '\\\\' '\\'' '\\\"']) |('\\\\' 'u' ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F']))*'\\''"), "string", 4, null, 4, null));
            tokenTypes.add(new TokenType(null, Pattern.create("'#' [^'\\n' '\\r']* ['\\n' '\\r']+"), "comment", 5, null, 5, null));
            tokenTypes.add(new TokenType(null, Pattern.create("'/#' - '#/'"), "comment", 5, null, 5, null));
            tokenTypes.add(new TokenType(null, Pattern.create("['\\n' '\\r' ' ' '\\t']+"), "whitespace", 6, null, 6, null));
        }
        catch (ParseException ex) {
            Utils.notify(ex);
        }
        this.tokenTypeToID.put("error", 0);
        this.idToTokenType.put(0, "error");
        this.tokenTypeCount = 1;
        for (TokenType tokenType : tokenTypes) {
            this.tokenTypeToID.put(tokenType.getType(), tokenType.getTypeID());
            this.idToTokenType.put(tokenType.getTypeID(), tokenType.getType());
            this.tokenTypeCount = Math.max(this.tokenTypeCount, tokenType.getTypeID() + 1);
        }
        this.parser = Parser.create(tokenTypes);
        int OPERATOR_ID = this.getTokenID("operator");
        ASTToken COLON = ASTToken.create(this, OPERATOR_ID, ":", 0);
        ASTToken PARENTHESIS = ASTToken.create(this, OPERATOR_ID, "(", 0);
        ASTToken PARENTHESIS2 = ASTToken.create(this, OPERATOR_ID, ")", 0);
        ASTToken BRACE = ASTToken.create(this, OPERATOR_ID, "{", 0);
        ASTToken BRACE2 = ASTToken.create(this, OPERATOR_ID, "}", 0);
        ASTToken LT = ASTToken.create(this, OPERATOR_ID, "<", 0);
        ASTToken GT = ASTToken.create(this, OPERATOR_ID, ">", 0);
        ASTToken DOT = ASTToken.create(this, OPERATOR_ID, ".", 0);
        ASTToken PLUS = ASTToken.create(this, OPERATOR_ID, "+", 0);
        ASTToken QUESTION = ASTToken.create(this, OPERATOR_ID, "?", 0);
        ASTToken MULTIPLY = ASTToken.create(this, OPERATOR_ID, "*", 0);
        ASTToken OR = ASTToken.create(this, OPERATOR_ID, "|", 0);
        ASTToken MINUS = ASTToken.create(this, OPERATOR_ID, "-", 0);
        ASTToken BRACKET = ASTToken.create(this, OPERATOR_ID, "[", 0);
        ASTToken BRACKET2 = ASTToken.create(this, OPERATOR_ID, "]", 0);
        ASTToken UPP = ASTToken.create(this, OPERATOR_ID, "^", 0);
        ASTToken EQUAL = ASTToken.create(this, OPERATOR_ID, "=", 0);
        ASTToken SEMICOLON = ASTToken.create(this, OPERATOR_ID, ";", 0);
        ASTToken COMMA = ASTToken.create(this, OPERATOR_ID, ",", 0);
        int KEYWORD_ID = this.getTokenID("keyword");
        ASTToken KEYWORD = ASTToken.create(this, KEYWORD_ID, null, 0);
        ASTToken KEYWORD_TOKEN = ASTToken.create(this, KEYWORD_ID, "TOKEN", 0);
        IDENTIFIER_ID = this.getTokenID("identifier");
        ASTToken IDENTIFIER = ASTToken.create(this, IDENTIFIER_ID, null, 0);
        ASTToken IDENTIFIER_I = ASTToken.create(this, IDENTIFIER_ID, "i", 0);
        int STRING_ID = this.getTokenID("string");
        ASTToken STRING = ASTToken.create(this, STRING_ID, null, 0);
        WHITESPACE_ID = this.getTokenID("whitespace");
        COMMENT_ID = this.getTokenID("comment");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(NBSLanguage.rule("S", new Object[]{"token", "S"}));
        rules.add(NBSLanguage.rule("S", new Object[]{"tokenState", "S"}));
        rules.add(NBSLanguage.rule("S", new Object[]{"grammarRule", "S"}));
        rules.add(NBSLanguage.rule("S", new Object[]{"command", "S"}));
        rules.add(NBSLanguage.rule("S", new Object[0]));
        rules.add(NBSLanguage.rule("tokenState", new Object[]{"state", "tokenState1"}));
        rules.add(NBSLanguage.rule("tokenState1", new Object[]{COLON, "token"}));
        rules.add(NBSLanguage.rule("tokenState1", new Object[]{BRACE, "tokenGroup"}));
        rules.add(NBSLanguage.rule("token", new Object[]{KEYWORD_TOKEN, COLON, IDENTIFIER, COLON, "token2"}));
        rules.add(NBSLanguage.rule("token2", new Object[]{PARENTHESIS, "regularExpression", PARENTHESIS2, "token3"}));
        rules.add(NBSLanguage.rule("token2", new Object[]{BRACE, "properties", BRACE2}));
        rules.add(NBSLanguage.rule("token3", new Object[]{COLON, "state"}));
        rules.add(NBSLanguage.rule("token3", new Object[0]));
        rules.add(NBSLanguage.rule("state", new Object[]{LT, IDENTIFIER, GT}));
        rules.add(NBSLanguage.rule("tokenGroup", new Object[]{"tokensInGroup", BRACE2}));
        rules.add(NBSLanguage.rule("tokensInGroup", new Object[]{"token", "tokensInGroup"}));
        rules.add(NBSLanguage.rule("tokensInGroup", new Object[0]));
        rules.add(NBSLanguage.rule("regularExpression", new Object[]{"reChoice", "regularExpression1"}));
        rules.add(NBSLanguage.rule("regularExpression1", new Object[]{OR, "reChoice", "regularExpression1"}));
        rules.add(NBSLanguage.rule("regularExpression1", new Object[0]));
        rules.add(NBSLanguage.rule("reChoice", new Object[]{"rePart", "reChoice1"}));
        rules.add(NBSLanguage.rule("reChoice1", new Object[]{"rePart", "reChoice1"}));
        rules.add(NBSLanguage.rule("reChoice1", new Object[0]));
        rules.add(NBSLanguage.rule("rePart", new Object[]{STRING, "rePartOperatorOrMinus"}));
        rules.add(NBSLanguage.rule("rePart", new Object[]{STRING, IDENTIFIER_I, "rePartOperatorOrMinus"}));
        rules.add(NBSLanguage.rule("rePart", new Object[]{DOT, "rePartOperator"}));
        rules.add(NBSLanguage.rule("rePart", new Object[]{"reClass", "rePartOperator"}));
        rules.add(NBSLanguage.rule("rePart", new Object[]{PARENTHESIS, "regularExpression", PARENTHESIS2, "rePartOperator"}));
        rules.add(NBSLanguage.rule("rePartOperator", new Object[0]));
        rules.add(NBSLanguage.rule("rePartOperator", new Object[]{PLUS}));
        rules.add(NBSLanguage.rule("rePartOperator", new Object[]{QUESTION}));
        rules.add(NBSLanguage.rule("rePartOperator", new Object[]{MULTIPLY}));
        rules.add(NBSLanguage.rule("rePartOperatorOrMinus", new Object[]{MINUS, STRING}));
        rules.add(NBSLanguage.rule("rePartOperatorOrMinus", new Object[]{"rePartOperator"}));
        rules.add(NBSLanguage.rule("reClass", new Object[]{BRACKET, "reInClassNegation", "reInClass", BRACKET2}));
        rules.add(NBSLanguage.rule("reInClassNegation", new Object[]{UPP}));
        rules.add(NBSLanguage.rule("reInClassNegation", new Object[0]));
        rules.add(NBSLanguage.rule("reInClass", new Object[]{STRING, "reInClassMinus", "reInClass1"}));
        rules.add(NBSLanguage.rule("reInClass1", new Object[]{STRING, "reInClassMinus", "reInClass1"}));
        rules.add(NBSLanguage.rule("reInClass1", new Object[0]));
        rules.add(NBSLanguage.rule("reInClassMinus", new Object[]{MINUS, STRING}));
        rules.add(NBSLanguage.rule("reInClassMinus", new Object[0]));
        rules.add(NBSLanguage.rule("grammarRule", new Object[]{IDENTIFIER, EQUAL, "grRightSide", SEMICOLON}));
        rules.add(NBSLanguage.rule("grRightSide", new Object[]{"grChoice", "grRightSide1"}));
        rules.add(NBSLanguage.rule("grRightSide1", new Object[]{OR, "grChoice", "grRightSide1"}));
        rules.add(NBSLanguage.rule("grRightSide1", new Object[0]));
        rules.add(NBSLanguage.rule("grChoice", new Object[]{"grPart", "grChoice"}));
        rules.add(NBSLanguage.rule("grChoice", new Object[0]));
        rules.add(NBSLanguage.rule("grPart", new Object[]{IDENTIFIER, "grOperator"}));
        rules.add(NBSLanguage.rule("grPart", new Object[]{"tokenDef", "grOperator"}));
        rules.add(NBSLanguage.rule("grPart", new Object[]{STRING, "grOperator"}));
        rules.add(NBSLanguage.rule("grPart", new Object[]{BRACKET, "grRightSide", BRACKET2}));
        rules.add(NBSLanguage.rule("grPart", new Object[]{PARENTHESIS, "grRightSide", PARENTHESIS2, "grOperator"}));
        rules.add(NBSLanguage.rule("grOperator", new Object[]{PLUS}));
        rules.add(NBSLanguage.rule("grOperator", new Object[]{MULTIPLY}));
        rules.add(NBSLanguage.rule("grOperator", new Object[]{QUESTION}));
        rules.add(NBSLanguage.rule("grOperator", new Object[0]));
        rules.add(NBSLanguage.rule("tokenDef", new Object[]{LT, IDENTIFIER, "tokenDef1", GT}));
        rules.add(NBSLanguage.rule("tokenDef1", new Object[]{COMMA, STRING}));
        rules.add(NBSLanguage.rule("tokenDef1", new Object[0]));
        rules.add(NBSLanguage.rule("command", new Object[]{KEYWORD, "command0"}));
        rules.add(NBSLanguage.rule("command0", new Object[]{COLON, "selector", "command1"}));
        rules.add(NBSLanguage.rule("command0", new Object[]{"value"}));
        rules.add(NBSLanguage.rule("command1", new Object[]{COLON, "value"}));
        rules.add(NBSLanguage.rule("command1", new Object[0]));
        rules.add(NBSLanguage.rule("value", new Object[]{"class"}));
        rules.add(NBSLanguage.rule("value", new Object[]{STRING}));
        rules.add(NBSLanguage.rule("value", new Object[]{BRACE, "properties", BRACE2}));
        rules.add(NBSLanguage.rule("value", new Object[]{PARENTHESIS, "regularExpression", PARENTHESIS2}));
        rules.add(NBSLanguage.rule("properties", new Object[]{"property", "properties"}));
        rules.add(NBSLanguage.rule("properties", new Object[0]));
        rules.add(NBSLanguage.rule("property", new Object[]{IDENTIFIER, COLON, "propertyValue", SEMICOLON}));
        rules.add(NBSLanguage.rule("propertyValue", new Object[]{STRING}));
        rules.add(NBSLanguage.rule("propertyValue", new Object[]{"class"}));
        rules.add(NBSLanguage.rule("propertyValue", new Object[]{PARENTHESIS, "regularExpression", PARENTHESIS2}));
        rules.add(NBSLanguage.rule("selector", new Object[]{"class", "selector1"}));
        rules.add(NBSLanguage.rule("selector1", new Object[]{COMMA, "class", "selector1"}));
        rules.add(NBSLanguage.rule("selector1", new Object[0]));
        rules.add(NBSLanguage.rule("class", new Object[]{IDENTIFIER, "class1"}));
        rules.add(NBSLanguage.rule("class1", new Object[]{DOT, IDENTIFIER, "class1"}));
        rules.add(NBSLanguage.rule("class1", new Object[0]));
        HashSet<Integer> skipTokenIDs = new HashSet<Integer>();
        skipTokenIDs.add(this.getTokenID("whitespace"));
        skipTokenIDs.add(this.getTokenID("comment"));
        try {
            this.analyser = LLSyntaxAnalyser.create(this, rules, skipTokenIDs);
        }
        catch (ParseException ex) {
            Utils.notify(ex);
        }
    }

    @Override
    public String getMimeType() {
        return NBS_MIME_TYPE;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public LLSyntaxAnalyser getAnalyser() {
        return this.analyser;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public int getTokenID(String tokenType) {
        if (!this.tokenTypeToID.containsKey(tokenType)) {
            System.err.println("unknown token type: " + tokenType);
        }
        return this.tokenTypeToID.get(tokenType);
    }

    @Override
    public int getTokenTypeCount() {
        return this.tokenTypeCount;
    }

    @Override
    public String getTokenType(int tokenTypeID) {
        return this.idToTokenType.get(tokenTypeID);
    }

    @Override
    public int getNTID(String nt) {
        if (this.ntidToNt == null) {
            this.ntidToNt = new HashMap<Integer, String>();
        }
        if (this.ntToNTID == null) {
            this.ntToNTID = new HashMap<String, Integer>();
        }
        if (!this.ntToNTID.containsKey(nt)) {
            int id = this.ntToNTID.size();
            this.ntToNTID.put(nt, id);
            this.ntidToNt.put(id, nt);
        }
        return this.ntToNTID.get(nt);
    }

    @Override
    public int getNTCount() {
        if (this.ntToNTID == null) {
            return 0;
        }
        return this.ntToNTID.size();
    }

    @Override
    public String getNT(int ntid) {
        return this.ntidToNt.get(ntid);
    }

    @Override
    public Feature getPreprocessorImport() {
        return null;
    }

    @Override
    public Map<String, Feature> getTokenImports() {
        return Collections.emptyMap();
    }

    @Override
    public List<Language> getImportedLanguages() {
        return Collections.emptyList();
    }
}

