/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8ExceptionBreakType;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Scope;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.V8ScriptLocation;
import org.netbeans.lib.v8debug.V8StepAction;
import org.netbeans.lib.v8debug.V8Type;
import org.netbeans.lib.v8debug.commands.Backtrace;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.lib.v8debug.commands.ChangeLive;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.ClearBreakpointGroup;
import org.netbeans.lib.v8debug.commands.Continue;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.commands.Flags;
import org.netbeans.lib.v8debug.commands.Frame;
import org.netbeans.lib.v8debug.commands.GC;
import org.netbeans.lib.v8debug.commands.ListBreakpoints;
import org.netbeans.lib.v8debug.commands.Lookup;
import org.netbeans.lib.v8debug.commands.References;
import org.netbeans.lib.v8debug.commands.RestartFrame;
import org.netbeans.lib.v8debug.commands.Scope;
import org.netbeans.lib.v8debug.commands.Scopes;
import org.netbeans.lib.v8debug.commands.Scripts;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.commands.SetExceptionBreak;
import org.netbeans.lib.v8debug.commands.SetVariableValue;
import org.netbeans.lib.v8debug.commands.Source;
import org.netbeans.lib.v8debug.commands.Threads;
import org.netbeans.lib.v8debug.commands.V8Flags;
import org.netbeans.lib.v8debug.commands.Version;
import org.netbeans.lib.v8debug.events.AfterCompileEventBody;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.lib.v8debug.events.CompileErrorEventBody;
import org.netbeans.lib.v8debug.events.ExceptionEventBody;
import org.netbeans.lib.v8debug.events.ScriptCollectedEventBody;
import org.netbeans.lib.v8debug.vars.NewValue;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Boolean;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Generator;
import org.netbeans.lib.v8debug.vars.V8Number;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8String;
import org.netbeans.lib.v8debug.vars.V8Value;

public class JSONReader {
    private JSONReader() {
    }

    public static V8Type getType(JSONObject obj) throws IllegalArgumentException {
        String type = (String)obj.get((Object)"type");
        if (type == null) {
            throw new IllegalArgumentException("No type in " + obj.toJSONString());
        }
        return V8Type.valueOf(type);
    }

    public static V8Response getResponse(JSONObject obj) throws IllegalArgumentException {
        long sequence = (Long)obj.get((Object)"seq");
        V8Type type = JSONReader.getType(obj);
        long requestSequence = (Long)obj.get((Object)"request_seq");
        String commandName = (String)obj.get((Object)"command");
        V8Command command = commandName != null ? V8Command.fromString(commandName) : null;
        Boolean runningObj = (Boolean)obj.get((Object)"running");
        boolean running = runningObj != null ? runningObj : false;
        boolean success = (Boolean)obj.get((Object)"success");
        V8Body body = null;
        String errorMessage = null;
        if (success) {
            Object bodyObj = obj.get((Object)"body");
            if (bodyObj instanceof JSONObject) {
                body = JSONReader.getBody(command, (JSONObject)bodyObj);
            } else if (bodyObj instanceof JSONArray) {
                body = JSONReader.getBody(command, (JSONArray)bodyObj);
            } else if (body != null) {
                throw new IllegalArgumentException("Unknown body " + bodyObj + " in " + obj.toJSONString());
            }
        } else {
            errorMessage = (String)obj.get((Object)"message");
        }
        ReferencedValue[] refs = JSONReader.getRefs((JSONArray)obj.get((Object)"refs"));
        return new V8Response(sequence, requestSequence, command, body, refs, running, success, errorMessage);
    }

    public static V8Event getEvent(JSONObject obj) throws IllegalArgumentException {
        V8Event.Kind eventKind;
        long sequence = (Long)obj.get((Object)"seq");
        String eventName = (String)obj.get((Object)"event");
        V8Body body = null;
        if (eventName != null) {
            eventKind = V8Event.Kind.fromString(eventName);
            JSONObject bodyObj = (JSONObject)obj.get((Object)"body");
            switch (eventKind) {
                case AfterCompile: {
                    V8Script script = JSONReader.getScript((JSONObject)bodyObj.get((Object)"script"));
                    body = new AfterCompileEventBody(script);
                    break;
                }
                case CompileError: {
                    V8Script script = JSONReader.getScript((JSONObject)bodyObj.get((Object)"script"));
                    body = new CompileErrorEventBody(script);
                    break;
                }
                case ScriptCollected: {
                    long scriptId = JSONReader.getLong((JSONObject)bodyObj.get((Object)"script"), "id");
                    body = new ScriptCollectedEventBody(scriptId);
                    break;
                }
                case Break: {
                    String invocationText = (String)bodyObj.get((Object)"invocationText");
                    long sourceLine = JSONReader.getLong(bodyObj, "sourceLine");
                    long sourceColumn = JSONReader.getLong(bodyObj, "sourceColumn");
                    String sourceLineText = (String)bodyObj.get((Object)"sourceLineText");
                    V8ScriptLocation scriptLocation = JSONReader.getScriptLocation((JSONObject)bodyObj.get((Object)"script"));
                    long[] breakpoints = JSONReader.getLongArray((JSONArray)bodyObj.get((Object)"breakpoints"));
                    body = new BreakEventBody(invocationText, sourceLine, sourceColumn, sourceLineText, scriptLocation, breakpoints);
                    break;
                }
                case Exception: {
                    boolean uncaught = (Boolean)bodyObj.get((Object)"uncaught");
                    V8Value exception = JSONReader.getValue((JSONObject)bodyObj.get((Object)"exception"));
                    long sourceLine = JSONReader.getLong(bodyObj, "sourceLine");
                    long sourceColumn = JSONReader.getLong(bodyObj, "sourceColumn");
                    String sourceLineText = (String)bodyObj.get((Object)"sourceLineText");
                    V8Script script = JSONReader.getScript((JSONObject)bodyObj.get((Object)"script"));
                    body = new ExceptionEventBody(uncaught, exception, sourceLine, sourceColumn, sourceLineText, script);
                    break;
                }
                default: {
                    new IllegalArgumentException("Unknown event " + eventName + " in " + obj.toJSONString()).printStackTrace();
                    break;
                }
            }
        } else {
            eventKind = null;
        }
        ReferencedValue[] refs = JSONReader.getRefs((JSONArray)obj.get((Object)"refs"));
        Boolean running = (Boolean)obj.get((Object)"running");
        Boolean success = (Boolean)obj.get((Object)"success");
        String errorMessage = (String)obj.get((Object)"message");
        return new V8Event(sequence, eventKind, body, refs, running, success, errorMessage);
    }

    public static V8Request getRequest(JSONObject obj) {
        long sequence = (Long)obj.get((Object)"seq");
        V8Type type = JSONReader.getType(obj);
        if (V8Type.request != type) {
            throw new IllegalArgumentException("Expecting request type. Actual type = " + (Object)((Object)type));
        }
        String commandName = (String)obj.get((Object)"command");
        V8Command command = V8Command.fromString(commandName);
        JSONObject argsObj = (JSONObject)obj.get((Object)"arguments");
        V8Arguments args = argsObj != null ? JSONReader.getArguments(command, argsObj) : JSONReader.getSpecialArguments(command, obj);
        return new V8Request(sequence, command, args);
    }

    private static V8Body getBody(V8Command command, JSONObject obj) {
        switch (command) {
            case Listbreakpoints: {
                V8Breakpoint[] breakpoints = JSONReader.getBreakpoints((JSONArray)obj.get((Object)"breakpoints"));
                boolean breakOnExceptions = JSONReader.getBoolean(obj, "breakOnExceptions");
                boolean breakOnUncaughtExceptions = JSONReader.getBoolean(obj, "breakOnUncaughtExceptions");
                return new ListBreakpoints.ResponseBody(breakpoints, breakOnExceptions, breakOnUncaughtExceptions);
            }
            case Setbreakpoint: {
                String type = JSONReader.getString(obj, "type");
                long bpId = JSONReader.getLong(obj, "breakpoint");
                String scriptName = null;
                if ("scriptName".equals(type)) {
                    scriptName = JSONReader.getString(obj, "script_name");
                }
                Long line = JSONReader.getLongOrNull(obj, "line");
                Long column = JSONReader.getLongOrNull(obj, "column");
                V8Breakpoint.ActualLocation[] actualLocations = JSONReader.getActualLocations((JSONArray)obj.get((Object)"actual_locations"));
                return new SetBreakpoint.ResponseBody(V8Breakpoint.Type.valueOf(type), bpId, scriptName, line, column, actualLocations);
            }
            case Setexceptionbreak: {
                String typeName = JSONReader.getString(obj, "type");
                V8ExceptionBreakType extype = V8ExceptionBreakType.valueOf(typeName);
                if (extype == null) {
                    throw new IllegalArgumentException("Unknown exception breakpoint type: '" + typeName + "'.");
                }
                boolean enabled = JSONReader.getBoolean(obj, "enabled");
                return new SetExceptionBreak.ResponseBody(extype, enabled);
            }
            case Clearbreakpoint: {
                long bpId = JSONReader.getLong(obj, "breakpoint");
                return new ClearBreakpoint.ResponseBody(bpId);
            }
            case Clearbreakpointgroup: {
                long[] bpIds = JSONReader.getLongArray((JSONArray)obj.get((Object)"breakpoints"));
                return new ClearBreakpointGroup.ResponseBody(bpIds);
            }
            case Backtrace: {
                long fromFrame = JSONReader.getLong(obj, "fromFrame");
                long toFrame = JSONReader.getLong(obj, "toFrame");
                long totalFrames = JSONReader.getLong(obj, "totalFrames");
                V8Frame[] frames = JSONReader.getFrames((JSONArray)obj.get((Object)"frames"));
                return new Backtrace.ResponseBody(fromFrame, toFrame, totalFrames, frames);
            }
            case Frame: {
                V8Frame frame = JSONReader.getFrame(obj);
                return new Frame.ResponseBody(frame);
            }
            case Restartframe: {
                JSONObject resultObj = (JSONObject)obj.get((Object)"result");
                if (resultObj == null) {
                    return null;
                }
                return new RestartFrame.ResponseBody((Map<String, Object>)resultObj);
            }
            case Changelive: {
                JSONObject resultObj = (JSONObject)obj.get((Object)"result");
                if (resultObj == null) {
                    return null;
                }
                ChangeLive.ChangeLog changeLog = JSONReader.getChangeLog((JSONArray)obj.get((Object)"change_log"));
                ChangeLive.Result result = JSONReader.getChangeLiveResult(resultObj);
                Boolean stepInRecommended = JSONReader.getBooleanOrNull(obj, "stepin_recommended");
                return new ChangeLive.ResponseBody(changeLog, result, stepInRecommended);
            }
            case Lookup: {
                LinkedHashMap<Long, V8Value> valuesByHandle = new LinkedHashMap<Long, V8Value>();
                for (Object element : obj.values()) {
                    V8Value value = JSONReader.getValue((JSONObject)element);
                    valuesByHandle.put(value.getHandle(), value);
                }
                return new Lookup.ResponseBody(valuesByHandle);
            }
            case Evaluate: {
                V8Value value = JSONReader.getValue(obj);
                return new Evaluate.ResponseBody(value);
            }
            case SetVariableValue: {
                V8Value value = JSONReader.getValue((JSONObject)obj.get((Object)"newValue"));
                return new SetVariableValue.ResponseBody(value);
            }
            case Scope: {
                V8Scope scope = JSONReader.getScope(obj, null);
                return new Scope.ResponseBody(scope);
            }
            case Scopes: {
                long fromScope = JSONReader.getLong(obj, "fromScope");
                long toScope = JSONReader.getLong(obj, "toScope");
                long totalScopes = JSONReader.getLong(obj, "totalScopes");
                V8Scope[] scopes = JSONReader.getScopes((JSONArray)obj.get((Object)"scopes"), null);
                return new Scopes.ResponseBody(fromScope, toScope, totalScopes, scopes);
            }
            case Source: {
                String source = JSONReader.getString(obj, "source");
                long fromLine = JSONReader.getLong(obj, "fromLine");
                long toLine = JSONReader.getLong(obj, "toLine");
                long fromPosition = JSONReader.getLong(obj, "fromPosition");
                long toPosition = JSONReader.getLong(obj, "toPosition");
                long totalLines = JSONReader.getLong(obj, "totalLines");
                return new Source.ResponseBody(source, fromLine, toLine, fromPosition, toPosition, totalLines);
            }
            case Threads: {
                long numThreads = JSONReader.getLong(obj, "totalThreads");
                Map<Long, Boolean> threads = JSONReader.getThreads((JSONArray)obj.get((Object)"threads"));
                return new Threads.ResponseBody(numThreads, threads);
            }
            case Gc: {
                long before = JSONReader.getLong(obj, "before");
                long after = JSONReader.getLong(obj, "after");
                return new GC.ResponseBody(before, after);
            }
            case Version: {
                String version = JSONReader.getString(obj, "V8Version");
                return new Version.ResponseBody(version);
            }
            case Flags: {
                JSONArray flagsArray = (JSONArray)obj.get((Object)"flags");
                LinkedHashMap<String, Boolean> flags = new LinkedHashMap<String, Boolean>();
                for (Object fObj : flagsArray) {
                    JSONObject flag = (JSONObject)fObj;
                    flags.put(JSONReader.getString(flag, "name"), JSONReader.getBoolean(flag, "value"));
                }
                return new Flags.ResponseBody(flags);
            }
        }
        return null;
    }

    private static V8Body getBody(V8Command command, JSONArray array) {
        switch (command) {
            case Scripts: {
                int n = array.size();
                V8Script[] scripts = new V8Script[n];
                for (int i = 0; i < n; ++i) {
                    scripts[i] = JSONReader.getScript((JSONObject)array.get(i));
                }
                return new Scripts.ResponseBody(scripts);
            }
            case References: {
                int n = array.size();
                V8Value[] refs = new V8Value[n];
                for (int i = 0; i < n; ++i) {
                    refs[i] = JSONReader.getValue((JSONObject)array.get(i));
                }
                return new References.ResponseBody(refs);
            }
        }
        return null;
    }

    private static V8Arguments getArguments(V8Command command, JSONObject obj) {
        switch (command) {
            case Backtrace: {
                return new Backtrace.Arguments(JSONReader.getLongOrNull(obj, "fromFrame"), JSONReader.getLongOrNull(obj, "toFrame"), JSONReader.getBooleanOrNull(obj, "bottom"), JSONReader.getBooleanOrNull(obj, "inlineRefs"));
            }
            case Changebreakpoint: {
                return new ChangeBreakpoint.Arguments(JSONReader.getLong(obj, "breakpoint"), JSONReader.getBooleanOrNull(obj, "enabled"), JSONReader.getString(obj, "condition"), JSONReader.getLongOrNull(obj, "ignoreCount"));
            }
            case Changelive: {
                return new ChangeLive.Arguments(JSONReader.getLong(obj, "script_id"), JSONReader.getString(obj, "new_source"), JSONReader.getBooleanOrNull(obj, "preview_only"));
            }
            case Clearbreakpoint: {
                return new ClearBreakpoint.Arguments(JSONReader.getLong(obj, "breakpoint"));
            }
            case Clearbreakpointgroup: {
                return new ClearBreakpointGroup.Arguments(JSONReader.getLong(obj, "groupId"));
            }
            case Continue: {
                String step = JSONReader.getString(obj, "stepaction");
                if (step == null) {
                    return null;
                }
                return new Continue.Arguments(V8StepAction.valueOf(step), JSONReader.getLongOrNull(obj, "stepcount"));
            }
            case Evaluate: {
                return new Evaluate.Arguments(JSONReader.getString(obj, "expression"), JSONReader.getLongOrNull(obj, "frame"), JSONReader.getBooleanOrNull(obj, "global"), JSONReader.getBooleanOrNull(obj, "disable_break"), JSONReader.getAdditionalContext(obj.get((Object)"additional_context")));
            }
            case Flags: {
                Object fobj = obj.get((Object)"flags");
                if (!(fobj instanceof JSONArray)) {
                    return null;
                }
                JSONArray farray = (JSONArray)fobj;
                LinkedHashMap<String, Boolean> flags = new LinkedHashMap<String, Boolean>();
                for (int i = 0; i < farray.size(); ++i) {
                    Object felm = farray.get(i);
                    if (!(felm instanceof JSONObject)) continue;
                    JSONObject fo = (JSONObject)felm;
                    flags.put(JSONReader.getString(fo, "name"), JSONReader.getBooleanOrNull(fo, "value"));
                }
                return new Flags.Arguments(flags);
            }
            case Frame: {
                return new Frame.Arguments(JSONReader.getLongOrNull(obj, "number"));
            }
            case Gc: {
                return new GC.Arguments(JSONReader.getString(obj, "type"));
            }
            case Lookup: {
                long[] handles = null;
                Object hObj = obj.get((Object)"handles");
                if (hObj instanceof JSONArray) {
                    handles = JSONReader.getLongArray((JSONArray)hObj);
                }
                return new Lookup.Arguments(handles, JSONReader.getBooleanOrNull(obj, "includeSource"));
            }
            case References: {
                String rTypeStr = JSONReader.getString(obj, "type");
                References.Type rType = rTypeStr != null ? References.Type.valueOf(rTypeStr) : null;
                return new References.Arguments(rType, JSONReader.getLong(obj, "handle"));
            }
            case Restartframe: {
                return new RestartFrame.Arguments(JSONReader.getLongOrNull(obj, "frame"));
            }
            case Scope: {
                return new Scope.Arguments(JSONReader.getLong(obj, "number"), JSONReader.getLongOrNull(obj, "frameNumber"));
            }
            case Scopes: {
                return new Scopes.Arguments(JSONReader.getLongOrNull(obj, "frameNumber"));
            }
            case Scripts: {
                V8Script.Types scrTypes = null;
                long types = JSONReader.getLong(obj, "types");
                if (types >= 0L) {
                    scrTypes = new V8Script.Types((int)types);
                }
                long[] ids = null;
                Object idsObj = obj.get((Object)"ids");
                if (idsObj instanceof JSONArray) {
                    ids = JSONReader.getLongArray((JSONArray)idsObj);
                }
                Boolean includeSource = JSONReader.getBooleanOrNull(obj, "includeSource");
                Object filter = obj.get((Object)"filter");
                if (filter instanceof String) {
                    return new Scripts.Arguments(scrTypes, ids, includeSource, (String)filter);
                }
                if (!(filter instanceof Long)) {
                    return null;
                }
                return new Scripts.Arguments(scrTypes, ids, includeSource, (Long)filter);
            }
            case SetVariableValue: {
                NewValue nv;
                Object nvObj = obj.get((Object)"newValue");
                if (!(nvObj instanceof JSONObject)) {
                    return null;
                }
                Long handle = JSONReader.getLongOrNull((JSONObject)nvObj, "handle");
                if (handle != null) {
                    nv = new NewValue(handle);
                } else {
                    Object typeObj = ((JSONObject)nvObj).get((Object)"type");
                    if (!(typeObj instanceof String)) {
                        return null;
                    }
                    V8Value.Type type = V8Value.Type.fromString((String)typeObj);
                    nv = new NewValue(type, "stringDescription");
                }
                Object scopeObj = obj.get((Object)"scope");
                if (!(scopeObj instanceof JSONObject)) {
                    return null;
                }
                return new SetVariableValue.Arguments(JSONReader.getString(obj, "name"), nv, JSONReader.getLong((JSONObject)scopeObj, "number"), JSONReader.getLongOrNull((JSONObject)scopeObj, "frameNumber"));
            }
            case Setbreakpoint: {
                Object bpTypeObj = obj.get((Object)"type");
                if (!(bpTypeObj instanceof String)) {
                    return null;
                }
                String bpType = (String)bpTypeObj;
                if ("script".equals(bpType)) {
                    bpType = V8Breakpoint.Type.scriptName.toString();
                }
                return new SetBreakpoint.Arguments(V8Breakpoint.Type.valueOf(bpType), JSONReader.getString(obj, "target"), JSONReader.getLongOrNull(obj, "line"), JSONReader.getLongOrNull(obj, "column"), JSONReader.getBooleanOrNull(obj, "enabled"), JSONReader.getString(obj, "condition"), JSONReader.getLongOrNull(obj, "ignoreCount"), JSONReader.getLongOrNull(obj, "groupId"));
            }
            case Setexceptionbreak: {
                Object bpTypeObj = obj.get((Object)"type");
                if (!(bpTypeObj instanceof String)) {
                    return null;
                }
                String bpType = (String)bpTypeObj;
                return new SetExceptionBreak.Arguments(V8ExceptionBreakType.valueOf(bpType), JSONReader.getBoolean(obj, "enabled"));
            }
            case Source: {
                return new Source.Arguments(JSONReader.getLongOrNull(obj, "frame"), JSONReader.getLongOrNull(obj, "fromLine"), JSONReader.getLongOrNull(obj, "toLine"));
            }
            case V8flags: {
                return new V8Flags.Arguments(JSONReader.getString(obj, "flags"));
            }
        }
        return null;
    }

    private static V8Arguments getSpecialArguments(V8Command command, JSONObject obj) {
        switch (command) {
            case Source: {
                return new Source.Arguments(JSONReader.getLongOrNull(obj, "frame"), JSONReader.getLongOrNull(obj, "fromLine"), JSONReader.getLongOrNull(obj, "toLine"));
            }
        }
        return null;
    }

    private static Evaluate.Arguments.Context[] getAdditionalContext(Object obj) {
        if (!(obj instanceof JSONArray)) {
            return null;
        }
        JSONArray array = (JSONArray)obj;
        int n = array.size();
        Evaluate.Arguments.Context[] context = new Evaluate.Arguments.Context[n];
        for (int i = 0; i < n; ++i) {
            context[i] = JSONReader.getContext(array.get(i));
        }
        return context;
    }

    private static Evaluate.Arguments.Context getContext(Object obj) {
        if (!(obj instanceof JSONObject)) {
            return null;
        }
        JSONObject jobj = (JSONObject)obj;
        return new Evaluate.Arguments.Context(JSONReader.getString(jobj, "name"), JSONReader.getLong(jobj, "handle"));
    }

    private static String getString(JSONObject obj, String propertyName) {
        return (String)obj.get((Object)propertyName);
    }

    private static String[] getStringValuesFromArray(JSONArray array, String propertyName) {
        int l = array.size();
        String[] strings = new String[l];
        for (int i = 0; i < l; ++i) {
            strings[i] = JSONReader.getString((JSONObject)array.get(i), propertyName);
        }
        return strings;
    }

    private static long getLong(JSONObject obj, String propertyName) {
        return JSONReader.getLong(obj, propertyName, -1L);
    }

    private static long getLong(JSONObject obj, String propertyName, long defaultValue) {
        Object prop = obj.get((Object)propertyName);
        if (prop == null) {
            return defaultValue;
        }
        if (prop instanceof Long) {
            return (Long)prop;
        }
        String str = (String)prop;
        return Long.parseLong(str);
    }

    private static Long getLongOrNull(JSONObject obj, String propertyName) {
        Object prop = obj.get((Object)propertyName);
        if (prop == null) {
            return null;
        }
        return (Long)prop;
    }

    private static PropertyLong getLongProperty(JSONObject obj, String propertyName) {
        Object prop = obj.get((Object)propertyName);
        if (prop == null) {
            return new PropertyLong(null);
        }
        if (prop instanceof Long) {
            return new PropertyLong((Long)prop);
        }
        String str = (String)prop;
        return new PropertyLong(Long.parseLong(str));
    }

    private static boolean getBoolean(JSONObject obj, String propertyName) {
        Object prop = obj.get((Object)propertyName);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop;
    }

    private static Boolean getBooleanOrNull(JSONObject obj, String propertyName) {
        Object prop = obj.get((Object)propertyName);
        if (prop == null) {
            return null;
        }
        return (Boolean)prop;
    }

    private static V8ScriptLocation getScriptLocation(JSONObject obj) {
        long id = JSONReader.getLong(obj, "id");
        String name = JSONReader.getString(obj, "name");
        long line = JSONReader.getLong(obj, "lineOffset");
        long column = JSONReader.getLong(obj, "columnOffset");
        long lineCount = JSONReader.getLong(obj, "lineCount");
        return new V8ScriptLocation(id, name, line, column, lineCount);
    }

    private static V8Script getScript(JSONObject obj) {
        long handle = JSONReader.getLong(obj, "handle");
        String name = JSONReader.getString(obj, "name");
        long id = JSONReader.getLong(obj, "id");
        long lineOffset = JSONReader.getLong(obj, "lineOffset");
        long columnOffset = JSONReader.getLong(obj, "columnOffset");
        long lineCount = JSONReader.getLong(obj, "lineCount");
        Object data = obj.get((Object)"data");
        String source = JSONReader.getString(obj, "source");
        String sourceStart = JSONReader.getString(obj, "sourceStart");
        Long sourceLength = JSONReader.getLongOrNull(obj, "sourceLength");
        ReferencedValue context = JSONReader.getReferencedValue(obj, "context");
        String text = JSONReader.getString(obj, "text");
        long scriptTypeNum = JSONReader.getLong(obj, "scriptType");
        V8Script.Type scriptType = scriptTypeNum >= 0L ? V8Script.Type.valueOf((int)scriptTypeNum) : null;
        long compilationTypeNum = JSONReader.getLong(obj, "compilationType");
        V8Script.CompilationType compilationType = compilationTypeNum >= 0L ? V8Script.CompilationType.valueOf((int)compilationTypeNum) : null;
        ReferencedValue evalFromScript = JSONReader.getReferencedValue(obj, "evalFromScript");
        V8Script.EvalFromLocation evalFromLocation = V8Script.CompilationType.EVAL.equals((Object)compilationType) ? new V8Script.EvalFromLocation(JSONReader.getLong(obj, "line"), JSONReader.getLong(obj, "column")) : null;
        return new V8Script(handle, name, id, lineOffset, columnOffset, lineCount, data, source, sourceStart, sourceLength, context, text, scriptType, compilationType, evalFromScript, evalFromLocation);
    }

    private static V8Value getValue(JSONObject obj) {
        return JSONReader.getValue(obj, -1L);
    }

    private static V8Value getValue(JSONObject obj, long handle) {
        if (handle < 0L) {
            handle = JSONReader.getLong(obj, "handle");
        }
        V8Value.Type type = V8Value.Type.fromString(JSONReader.getString(obj, "type"));
        String text = JSONReader.getString(obj, "text");
        switch (type) {
            case Boolean: {
                return new V8Boolean(handle, JSONReader.getBoolean(obj, "value"), text);
            }
            case Number: {
                Object nVal = obj.get((Object)"value");
                if (nVal instanceof Long) {
                    return new V8Number(handle, (Long)nVal, text);
                }
                if (nVal instanceof Double) {
                    return new V8Number(handle, (Double)nVal, text);
                }
                if (nVal == null) {
                    return new V8Number(handle, -1L, text);
                }
                if ("Infinity".equals(nVal)) {
                    return new V8Number(handle, Double.POSITIVE_INFINITY, text);
                }
                if ("-Infinity".equals(nVal)) {
                    return new V8Number(handle, Double.NEGATIVE_INFINITY, text);
                }
                if ("NaN".equals(nVal)) {
                    return new V8Number(handle, Double.NaN, text);
                }
                throw new IllegalArgumentException("Unknown variable value type: " + nVal);
            }
            case String: {
                return new V8String(handle, JSONReader.getString(obj, "value"), text);
            }
            case Function: {
                String name = JSONReader.getString(obj, "name");
                String inferredName = JSONReader.getString(obj, "inferredName");
                Boolean resolved = JSONReader.getBooleanOrNull(obj, "resolved");
                String source = JSONReader.getString(obj, "source");
                PropertyLong scriptRef = JSONReader.getReferenceProperty(obj, "script");
                Long scriptId = JSONReader.getLongOrNull(obj, "scriptId");
                PropertyLong position = JSONReader.getLongProperty(obj, "position");
                PropertyLong line = JSONReader.getLongProperty(obj, "line");
                PropertyLong column = JSONReader.getLongProperty(obj, "column");
                PropertyLong constructorFunctionHandle = JSONReader.getReferenceProperty(obj, "constructorFunction");
                PropertyLong protoObject = JSONReader.getReferenceProperty(obj, "protoObject");
                PropertyLong prototypeObject = JSONReader.getReferenceProperty(obj, "prototypeObject");
                V8Scope[] scopes = null;
                if (obj.get((Object)"scopes") instanceof JSONArray) {
                    scopes = JSONReader.getScopes((JSONArray)obj.get((Object)"scopes"), null);
                }
                Map<String, V8Object.Property> properties = JSONReader.getProperties((JSONArray)obj.get((Object)"properties"), null);
                return new V8Function(handle, constructorFunctionHandle, protoObject, prototypeObject, name, inferredName, resolved, source, scriptRef, scriptId, position, line, column, scopes, properties, text);
            }
            case Generator: {
                String className = JSONReader.getString(obj, "className");
                PropertyLong constructorFunctionHandle = JSONReader.getReferenceProperty(obj, "constructorFunction");
                PropertyLong protoObject = JSONReader.getReferenceProperty(obj, "protoObject");
                PropertyLong prototypeObject = JSONReader.getReferenceProperty(obj, "prototypeObject");
                PropertyLong function = JSONReader.getReferenceProperty(obj, "func");
                PropertyLong receiver = JSONReader.getReferenceProperty(obj, "receiver");
                Map<String, V8Object.Property> properties = JSONReader.getProperties((JSONArray)obj.get((Object)"properties"), null);
                return new V8Generator(handle, className, constructorFunctionHandle, protoObject, prototypeObject, function, receiver, properties, text);
            }
            case Object: 
            case Error: 
            case Regexp: {
                String className = JSONReader.getString(obj, "className");
                PropertyLong constructorFunctionHandle = JSONReader.getReferenceProperty(obj, "constructorFunction");
                PropertyLong protoObject = JSONReader.getReferenceProperty(obj, "protoObject");
                PropertyLong prototypeObject = JSONReader.getReferenceProperty(obj, "prototypeObject");
                boolean isArray = "Array".equals(className);
                V8Object.Array[] arrayRef = isArray ? new V8Object.Array[]{null} : null;
                Map<String, V8Object.Property> properties = JSONReader.getProperties((JSONArray)obj.get((Object)"properties"), arrayRef);
                if (isArray && arrayRef[0] == null) {
                    arrayRef[0] = new V8Object.DefaultArray();
                }
                V8Object.Array array = arrayRef != null ? arrayRef[0] : null;
                return new V8Object(handle, type, className, constructorFunctionHandle, protoObject, prototypeObject, properties, array, text);
            }
            case Frame: {
                return new V8Value(handle, type, text);
            }
            case Script: {
                V8Script script = JSONReader.getScript(obj);
                return new V8ScriptValue(handle, script, text);
            }
        }
        return new V8Value(handle, type, text);
    }

    private static long[] getLongArray(JSONArray array) {
        if (array == null) {
            return null;
        }
        int n = array.size();
        long[] iarr = new long[n];
        for (int i = 0; i < n; ++i) {
            iarr[i] = (Long)array.get(i);
        }
        return iarr;
    }

    private static V8Breakpoint[] getBreakpoints(JSONArray array) {
        int n = array.size();
        V8Breakpoint[] breakpoints = new V8Breakpoint[n];
        for (int i = 0; i < n; ++i) {
            breakpoints[i] = JSONReader.getBreakpoint((JSONObject)array.get(i));
        }
        return breakpoints;
    }

    private static V8Breakpoint getBreakpoint(JSONObject obj) {
        String scriptName;
        PropertyLong scriptId;
        String typeStr = (String)obj.get((Object)"type");
        V8Breakpoint.Type type = V8Breakpoint.Type.valueOf(typeStr);
        if (V8Breakpoint.Type.scriptId.equals((Object)type)) {
            scriptId = new PropertyLong(JSONReader.getLong(obj, "script_id"));
            scriptName = null;
        } else {
            scriptId = new PropertyLong(null);
            scriptName = JSONReader.getString(obj, "script_name");
        }
        long number = JSONReader.getLong(obj, "number");
        PropertyLong line = JSONReader.getLongProperty(obj, "line");
        PropertyLong column = JSONReader.getLongProperty(obj, "column");
        PropertyLong groupId = JSONReader.getLongProperty(obj, "groupId");
        long hitCount = JSONReader.getLong(obj, "hit_count", 0L);
        boolean active = JSONReader.getBoolean(obj, "active");
        Object conditionObject = obj.get((Object)"condition");
        String condition = conditionObject instanceof String ? (String)conditionObject : null;
        long ignoreCount = JSONReader.getLong(obj, "ignoreCount", 0L);
        V8Breakpoint.ActualLocation[] actualLocations = JSONReader.getActualLocations((JSONArray)obj.get((Object)"actual_locations"));
        return new V8Breakpoint(type, scriptId, scriptName, number, line, column, groupId, hitCount, active, condition, ignoreCount, actualLocations);
    }

    private static V8Breakpoint.ActualLocation[] getActualLocations(JSONArray array) {
        int n = array.size();
        V8Breakpoint.ActualLocation[] locations = new V8Breakpoint.ActualLocation[n];
        for (int i = 0; i < n; ++i) {
            JSONObject location = (JSONObject)array.get(i);
            long line = JSONReader.getLong(location, "line");
            long column = JSONReader.getLong(location, "column");
            String scriptName = JSONReader.getString(location, "script_name");
            if (scriptName != null) {
                locations[i] = new V8Breakpoint.ActualLocation(line, column, scriptName);
                continue;
            }
            long scriptId = JSONReader.getLong(location, "script_id");
            locations[i] = new V8Breakpoint.ActualLocation(line, column, scriptId);
        }
        return locations;
    }

    private static V8Frame[] getFrames(JSONArray array) {
        if (array == null) {
            return new V8Frame[0];
        }
        int n = array.size();
        V8Frame[] frames = new V8Frame[n];
        for (int i = 0; i < n; ++i) {
            frames[i] = JSONReader.getFrame((JSONObject)array.get(i));
        }
        return frames;
    }

    private static V8Frame getFrame(JSONObject obj) {
        Long index = JSONReader.getLongOrNull(obj, "index");
        ReferencedValue receiver = JSONReader.getReferencedValue(obj, "receiver");
        ReferencedValue func = JSONReader.getReferencedValue(obj, "func");
        long scriptRef = JSONReader.getReference(obj, "script");
        boolean constructCall = JSONReader.getBoolean(obj, "constructCall");
        boolean atReturn = JSONReader.getBoolean(obj, "atReturn");
        boolean debuggerFrame = JSONReader.getBoolean(obj, "debuggerFrame");
        Map<String, ReferencedValue> arguments = JSONReader.getReferences((JSONArray)obj.get((Object)"arguments"));
        Map<String, ReferencedValue> locals = JSONReader.getReferences((JSONArray)obj.get((Object)"locals"));
        long position = JSONReader.getLong(obj, "position");
        long line = JSONReader.getLong(obj, "line");
        long column = JSONReader.getLong(obj, "column");
        String sourceLineText = JSONReader.getString(obj, "sourceLineText");
        V8Scope[] scopes = JSONReader.getScopes((JSONArray)obj.get((Object)"scopes"), null);
        String text = JSONReader.getString(obj, "text");
        return new V8Frame(index, receiver, func, scriptRef, constructCall, atReturn, debuggerFrame, arguments, locals, position, line, column, sourceLineText, scopes, text);
    }

    private static Map<String, ReferencedValue> getReferences(JSONArray array) {
        if (array == null) {
            return null;
        }
        LinkedHashMap<String, ReferencedValue> references = new LinkedHashMap<String, ReferencedValue>();
        for (Object obj : array) {
            String name = JSONReader.getString((JSONObject)obj, "name");
            ReferencedValue ref = JSONReader.getReferencedValue((JSONObject)obj, "value");
            references.put(name, ref);
        }
        return references;
    }

    private static Map<String, V8Object.Property> getProperties(JSONArray array, V8Object.Array[] oArrayRef) {
        if (array == null) {
            return null;
        }
        if (array.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, V8Object.Property> properties = new LinkedHashMap<String, V8Object.Property>();
        V8Object.Property.Type[] types = V8Object.Property.Type.values();
        V8Object.DefaultArray oArray = null;
        for (Object obj : array) {
            V8Object.Property.Type type;
            JSONObject prop = (JSONObject)obj;
            Object nameObj = prop.get((Object)"name");
            if (nameObj == null) continue;
            long ref = JSONReader.getReference(prop);
            if (oArrayRef != null && nameObj instanceof Long) {
                if (oArray == null) {
                    oArray = new V8Object.DefaultArray();
                }
                long index = (Long)nameObj;
                oArray.putReferenceAt(index, ref);
                continue;
            }
            String name = nameObj.toString();
            long attributes = JSONReader.getLong(prop, "attributes", 0L);
            long propertyTypeNum = JSONReader.getLong(prop, "propertyType");
            if (propertyTypeNum < 0L) {
                type = null;
            } else if (propertyTypeNum < (long)types.length) {
                type = types[(int)propertyTypeNum];
            } else {
                throw new IllegalArgumentException("Unknown property type: " + propertyTypeNum);
            }
            V8Object.Property property = new V8Object.Property(name, type, (int)attributes, ref);
            properties.put(name, property);
        }
        if (oArrayRef != null) {
            oArrayRef[0] = oArray;
        }
        return properties;
    }

    private static ReferencedValue[] getRefs(JSONArray array) {
        if (array == null) {
            return null;
        }
        int n = array.size();
        ReferencedValue[] refs = new ReferencedValue[n];
        for (int i = 0; i < n; ++i) {
            long ref;
            JSONObject obj = (JSONObject)array.get(i);
            V8Value value = JSONReader.getValue(obj, ref = JSONReader.getReference(obj));
            refs[i] = value != null ? new ReferencedValue<V8Value>(value.getHandle(), value) : new ReferencedValue<V8Value>(ref, value);
        }
        return refs;
    }

    private static long getReference(JSONObject obj) {
        return JSONReader.getLong(obj, "ref");
    }

    private static Long getReference(JSONObject obj, String propertyName) {
        JSONObject ref = (JSONObject)obj.get((Object)propertyName);
        if (ref == null) {
            return null;
        }
        return JSONReader.getReference(ref);
    }

    private static PropertyLong getReferenceProperty(JSONObject obj, String propertyName) {
        JSONObject ref = (JSONObject)obj.get((Object)propertyName);
        if (ref == null) {
            return new PropertyLong(null);
        }
        return JSONReader.getLongProperty(ref, "ref");
    }

    private static ReferencedValue getReferencedValue(JSONObject obj, String propertyName) {
        JSONObject ref = (JSONObject)obj.get((Object)propertyName);
        if (ref == null) {
            return null;
        }
        long reference = JSONReader.getReference(ref);
        V8Value value = null;
        if (JSONReader.getString(ref, "type") != null) {
            value = JSONReader.getValue(ref, reference);
        }
        return new ReferencedValue<V8Value>(reference, value);
    }

    private static V8Scope[] getScopes(JSONArray array, Long frameIndex) {
        int n = array.size();
        V8Scope[] scopes = new V8Scope[n];
        for (int i = 0; i < n; ++i) {
            scopes[i] = JSONReader.getScope((JSONObject)array.get(i), frameIndex);
        }
        return scopes;
    }

    private static V8Scope getScope(JSONObject scope, Long frameIndex) {
        ReferencedValue<V8Object> referencedObject;
        ReferencedValue referencedValue;
        V8Scope.Type type = V8Scope.Type.valueOf((int)JSONReader.getLong(scope, "type"));
        long index = JSONReader.getLong(scope, "index");
        PropertyLong scopeFrameIndex = JSONReader.getLongProperty(scope, "frameIndex");
        if (!scopeFrameIndex.hasValue() && frameIndex != null) {
            scopeFrameIndex = new PropertyLong(frameIndex);
        }
        if ((referencedValue = JSONReader.getReferencedValue(scope, "object")) != null) {
            V8Object object = referencedValue.hasValue() ? (V8Object)referencedValue.getValue() : null;
            referencedObject = new ReferencedValue<V8Object>(referencedValue.getReference(), object);
        } else {
            referencedObject = null;
        }
        String text = JSONReader.getString(scope, "text");
        return new V8Scope(index, scopeFrameIndex, type, referencedObject, text);
    }

    private static Map<Long, Boolean> getThreads(JSONArray array) {
        LinkedHashMap<Long, Boolean> threads = new LinkedHashMap<Long, Boolean>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            threads.put(JSONReader.getLong(obj, "id"), JSONReader.getBoolean(obj, "current"));
        }
        return threads;
    }

    private static ChangeLive.Result getChangeLiveResult(JSONObject resultObj) {
        ChangeLive.Result.ChangeTree changeTree = JSONReader.getChangeTree((JSONObject)resultObj.get((Object)"change_tree"));
        ChangeLive.Result.TextualDiff diff = JSONReader.getTextualDiff((JSONObject)resultObj.get((Object)"textual_diff"));
        boolean updated = JSONReader.getBoolean(resultObj, "updated");
        Boolean stackModified = JSONReader.getBooleanOrNull(resultObj, "stack_modified");
        Boolean stackUpdateNeedsStepIn = JSONReader.getBooleanOrNull(resultObj, "stack_update_needs_step_in");
        String createdScriptName = JSONReader.getString(resultObj, "created_script_name");
        return new ChangeLive.Result(changeTree, diff, updated, stackModified, stackUpdateNeedsStepIn, createdScriptName);
    }

    private static ChangeLive.Result.ChangeTree getChangeTree(JSONObject obj) {
        String name = JSONReader.getString(obj, "name");
        ChangeLive.Result.ChangeTree.Positions positions = JSONReader.getChangeTreePositions((JSONObject)obj.get((Object)"positions"));
        ChangeLive.Result.ChangeTree.Positions newPositions = JSONReader.getChangeTreePositions((JSONObject)obj.get((Object)"new_positions"));
        String statusStr = JSONReader.getString(obj, "status");
        ChangeLive.Result.ChangeTree.FunctionStatus status = statusStr != null ? ChangeLive.Result.ChangeTree.FunctionStatus.fromString(statusStr) : null;
        String statusExplanation = JSONReader.getString(obj, "status_explanation");
        ChangeLive.Result.ChangeTree[] children = JSONReader.getChangeTreeChildren((JSONArray)obj.get((Object)"children"));
        ChangeLive.Result.ChangeTree[] newChildren = JSONReader.getChangeTreeChildren((JSONArray)obj.get((Object)"new_children"));
        return new ChangeLive.Result.ChangeTree(name, positions, newPositions, status, statusExplanation, children, newChildren);
    }

    private static ChangeLive.Result.ChangeTree[] getChangeTreeChildren(JSONArray array) {
        if (array == null) {
            return null;
        }
        int n = array.size();
        ChangeLive.Result.ChangeTree[] ch = new ChangeLive.Result.ChangeTree[n];
        for (int i = 0; i < n; ++i) {
            ch[i] = JSONReader.getChangeTree((JSONObject)array.get(i));
        }
        return ch;
    }

    private static ChangeLive.Result.TextualDiff getTextualDiff(JSONObject obj) {
        long oldLen = JSONReader.getLong(obj, "old_len");
        long newLen = JSONReader.getLong(obj, "new_len");
        long[] chunks = JSONReader.getLongArray((JSONArray)obj.get((Object)"chunks"));
        return new ChangeLive.Result.TextualDiff(oldLen, newLen, chunks);
    }

    private static ChangeLive.Result.ChangeTree.Positions getChangeTreePositions(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        long startPosition = JSONReader.getLong(obj, "start_position");
        long endPosition = JSONReader.getLong(obj, "end_position");
        return new ChangeLive.Result.ChangeTree.Positions(startPosition, endPosition);
    }

    private static ChangeLive.ChangeLog getChangeLog(JSONArray array) {
        int n = array.size();
        if (n == 0) {
            return null;
        }
        ChangeLive.ChangeLog.BreakpointUpdate[] breakpointsUpdate = null;
        String[] namesLinkedToOldScript = null;
        String[] droppedFrames = null;
        ChangeLive.ChangeLog.FunctionPatched functionPatched = null;
        ChangeLive.ChangeLog.PositionPatched[] patchedPositions = null;
        for (Object aelem : array) {
            JSONArray positionPatchedArr;
            String fp;
            JSONArray droppedFromStack;
            JSONArray linkedToOldScriptArr;
            if (!(aelem instanceof JSONObject)) continue;
            JSONObject obj = (JSONObject)aelem;
            JSONArray breakpointsUpdateArr = (JSONArray)obj.get((Object)"break_points_update");
            if (breakpointsUpdateArr != null) {
                breakpointsUpdate = JSONReader.getChangeLogBreakpointsUpdate(breakpointsUpdateArr);
            }
            if ((linkedToOldScriptArr = (JSONArray)obj.get((Object)"linked_to_old_script")) != null) {
                namesLinkedToOldScript = JSONReader.getStringValuesFromArray(linkedToOldScriptArr, "name");
            }
            if ((droppedFromStack = (JSONArray)obj.get((Object)"dropped_from_stack")) != null) {
                droppedFrames = JSONReader.getStringValuesFromArray(droppedFromStack, "name");
            }
            if ((fp = (String)obj.get((Object)"function_patched")) != null) {
                Boolean finf = JSONReader.getBooleanOrNull(obj, "function_info_not_found");
                functionPatched = new ChangeLive.ChangeLog.FunctionPatched(fp, new PropertyBoolean(finf));
            }
            if ((positionPatchedArr = (JSONArray)obj.get((Object)"position_patched")) == null) continue;
            patchedPositions = JSONReader.getPatchedPositions(positionPatchedArr);
        }
        return new ChangeLive.ChangeLog(breakpointsUpdate, namesLinkedToOldScript, droppedFrames, functionPatched, patchedPositions);
    }

    private static ChangeLive.ChangeLog.BreakpointUpdate[] getChangeLogBreakpointsUpdate(JSONArray array) {
        int l = array.size();
        ChangeLive.ChangeLog.BreakpointUpdate[] bpus = new ChangeLive.ChangeLog.BreakpointUpdate[l];
        for (int i = 0; i < l; ++i) {
            JSONObject bpu = (JSONObject)array.get(i);
            String typeRaw = JSONReader.getString(bpu, "type");
            ChangeLive.ChangeLog.BreakpointUpdate.Type type = ChangeLive.ChangeLog.BreakpointUpdate.Type.fromString(typeRaw);
            long id = JSONReader.getLong(bpu, "id");
            PropertyLong newId = JSONReader.getLongProperty(bpu, "new_id");
            ChangeLive.ChangeLog.BreakpointUpdate.Position oldPositions = null;
            ChangeLive.ChangeLog.BreakpointUpdate.Position newPositions = null;
            JSONObject positionsObj = (JSONObject)bpu.get((Object)"old_positions");
            if (positionsObj != null) {
                oldPositions = JSONReader.getPositions(positionsObj);
            }
            if ((positionsObj = (JSONObject)bpu.get((Object)"positions")) == null) {
                positionsObj = (JSONObject)bpu.get((Object)"new_positions");
            }
            if (positionsObj != null) {
                newPositions = JSONReader.getPositions(positionsObj);
            }
            bpus[i] = new ChangeLive.ChangeLog.BreakpointUpdate(type, id, newId, oldPositions, newPositions);
        }
        return bpus;
    }

    private static ChangeLive.ChangeLog.BreakpointUpdate.Position getPositions(JSONObject positionObj) {
        long position = JSONReader.getLong(positionObj, "position");
        long line = JSONReader.getLong(positionObj, "line");
        long column = JSONReader.getLong(positionObj, "column");
        return new ChangeLive.ChangeLog.BreakpointUpdate.Position(position, line, column);
    }

    private static ChangeLive.ChangeLog.PositionPatched[] getPatchedPositions(JSONArray array) {
        int l = array.size();
        ChangeLive.ChangeLog.PositionPatched[] pps = new ChangeLive.ChangeLog.PositionPatched[l];
        for (int i = 0; i < l; ++i) {
            JSONObject pp = (JSONObject)array.get(i);
            String name = JSONReader.getString(pp, "name");
            Boolean infoNF = JSONReader.getBooleanOrNull(pp, "info_not_found");
            pps[i] = new ChangeLive.ChangeLog.PositionPatched(name, new PropertyBoolean(infoNF));
        }
        return pps;
    }
}

