/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.WeakListeners;

public class RefCacheSupport {
    public static final long UNRESOLVED_EXPIRATION_DELAY = 5000L;
    private SchemaModel mSModel;
    private WeakHashMap<SchemaModelReference, Object> refModelCache = new WeakHashMap();
    private PropertyChangeListener mPropertySelfListener = null;
    private PropertyChangeListener mPropertyExtListener = null;

    public RefCacheSupport(SchemaModel sModel) {
        this.mSModel = sModel;
    }

    public int getCachedModelsSize() {
        return this.refModelCache.size();
    }

    public int checkKeys() {
        int wrongModelCounter = 0;
        for (SchemaModelReference smr : this.refModelCache.keySet()) {
            if (smr.getModel() == this.mSModel) continue;
            ++wrongModelCounter;
        }
        return wrongModelCounter;
    }

    public SchemaModelImpl getCachedModel(SchemaModelReference ref) {
        Object cachedValue = this.refModelCache.get(ref);
        if (cachedValue != null && cachedValue instanceof SmAttachment) {
            return ((SmAttachment)SmAttachment.class.cast((Object)cachedValue)).mSchemaModel;
        }
        return null;
    }

    public boolean contains(SchemaModelImpl model) {
        return this.refModelCache.containsValue(model);
    }

    public SchemaModelImpl optimizedResolve(SchemaModelReference ref) {
        try {
            SchemaModelImpl resolved;
            Object cachedValue = this.refModelCache.get(ref);
            if (cachedValue != null) {
                if (cachedValue instanceof SmAttachment) {
                    SmAttachment sma = (SmAttachment)SmAttachment.class.cast(cachedValue);
                    SchemaModelImpl cachedModel = sma.mSchemaModel;
                    Model.State cachedModelState = cachedModel.getState();
                    if (cachedModelState == Model.State.VALID) {
                        return cachedModel;
                    }
                    this.excludeModel(cachedModel);
                } else if (cachedValue instanceof UnresolvedSchemaRef && System.currentTimeMillis() < ((UnresolvedSchemaRef)UnresolvedSchemaRef.class.cast((Object)cachedValue)).expiratoinTime) {
                    return null;
                }
            }
            if ((resolved = (SchemaModelImpl)ref.resolveReferencedModel()) != null) {
                this.attach(ref, resolved);
            } else {
                this.refModelCache.put(ref, new UnresolvedSchemaRef());
            }
            return resolved;
        }
        catch (CatalogModelException ex) {
            this.refModelCache.put(ref, new UnresolvedSchemaRef());
            return null;
        }
    }

    public void discardCache() {
        for (Object cachedValue : this.refModelCache.values()) {
            if (!(cachedValue instanceof SmAttachment)) continue;
            SmAttachment sma = (SmAttachment)SmAttachment.class.cast(cachedValue);
            sma.mSchemaModel.removePropertyChangeListener(sma.mPCL);
        }
        this.refModelCache.clear();
        this.mSModel.removePropertyChangeListener(this.mPropertySelfListener);
    }

    private void lazySelfListenerInit() {
        if (this.mPropertySelfListener == null) {
            this.mPropertySelfListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object source;
                    String propName = evt.getPropertyName();
                    if ("schemaReferences".equals(propName)) {
                        Object newValue = evt.getNewValue();
                        Object oldValue = evt.getOldValue();
                        if (newValue == null && oldValue != null && oldValue instanceof SchemaModelReference) {
                            SchemaModelReference sModelRef = (SchemaModelReference)SchemaModelReference.class.cast(oldValue);
                            RefCacheSupport.this.excludeModelRef(sModelRef);
                        }
                    }
                    if ("schemaLocation".equals(propName) && (source = evt.getSource()) != null && source instanceof SchemaModelReference) {
                        RefCacheSupport.this.excludeModelRef((SchemaModelReference)source);
                    }
                    if ("namespace".equals(propName) && (source = evt.getSource()) != null && source instanceof Import) {
                        RefCacheSupport.this.excludeModelRef((Import)source);
                    }
                    if ("state".equals(propName)) {
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        Object source2 = evt.getSource();
                        if (newValue != Model.State.VALID && source2 == RefCacheSupport.this.mSModel) {
                            RefCacheSupport.this.discardCache();
                        }
                        if (oldValue != Model.State.VALID && newValue == Model.State.VALID && source2 == RefCacheSupport.this.mSModel) {
                            RefCacheSupport.this.discardCache();
                        }
                    }
                }
            };
            this.mSModel.addPropertyChangeListener(this.mPropertySelfListener);
        }
    }

    private synchronized void attach(SchemaModelReference ref, SchemaModelImpl referencedModel) {
        this.lazySelfListenerInit();
        if (this.mPropertyExtListener == null) {
            this.initExtListener();
        }
        PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this.mPropertySelfListener, (Object)referencedModel);
        referencedModel.addPropertyChangeListener(weakListener);
        this.refModelCache.put(ref, new SmAttachment(referencedModel, weakListener));
    }

    private synchronized void excludeModel(SchemaModel referencedModel) {
        ArrayList<SchemaModelReference> toRemove = new ArrayList<SchemaModelReference>();
        for (Map.Entry<SchemaModelReference, Object> entry : this.refModelCache.entrySet()) {
            Object cachedValue = entry.getValue();
            if (!(cachedValue instanceof SmAttachment)) continue;
            SmAttachment sma = (SmAttachment)SmAttachment.class.cast(cachedValue);
            if (!referencedModel.equals(sma.mSchemaModel)) continue;
            toRemove.add(entry.getKey());
        }
        for (SchemaModelReference smr : toRemove) {
            this.excludeModelRef(smr);
        }
    }

    private synchronized void excludeModelRef(SchemaModelReference sModelRef) {
        Object oldValue = this.refModelCache.remove(sModelRef);
        if (oldValue != null && oldValue instanceof SmAttachment) {
            SmAttachment sma = (SmAttachment)SmAttachment.class.cast(oldValue);
            sma.mSchemaModel.removePropertyChangeListener(sma.mPCL);
        }
    }

    private void initExtListener() {
        this.mPropertyExtListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object source;
                String propName = evt.getPropertyName();
                if ("state".equals(propName)) {
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    Object source2 = evt.getSource();
                    if (newValue != Model.State.VALID && source2 instanceof SchemaModel) {
                        RefCacheSupport.this.excludeModel((SchemaModel)SchemaModel.class.cast(source2));
                    }
                    if (oldValue != Model.State.VALID && newValue == Model.State.VALID && source2 == RefCacheSupport.this.mSModel) {
                        RefCacheSupport.this.excludeModel((SchemaModel)SchemaModel.class.cast(source2));
                    }
                }
                if ("targetNamespace".equals(propName) && (source = evt.getSource()) instanceof Schema) {
                    Schema schema = (Schema)Schema.class.cast(source);
                    RefCacheSupport.this.excludeModel(schema.getModel());
                }
            }
        };
    }

    private static class UnresolvedSchemaRef {
        public long expiratoinTime = System.currentTimeMillis() + 5000L;
    }

    private static class SmAttachment {
        public SchemaModelImpl mSchemaModel;
        public PropertyChangeListener mPCL;

        public SmAttachment(SchemaModelImpl sModel, PropertyChangeListener pcl) {
            assert (sModel != null && pcl != null);
            this.mSchemaModel = sModel;
            this.mPCL = pcl;
        }
    }
}

