/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.metrics.hints.Bundle;
import org.netbeans.modules.java.metrics.hints.CyclomaticComplexityVisitor;
import org.netbeans.modules.java.metrics.hints.DependencyCollector;
import org.netbeans.modules.java.metrics.hints.DepthVisitor;
import org.netbeans.modules.java.metrics.hints.NCLOCVisitor;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class MethodMetrics {
    static final int DEFAULT_COMPLEXITY_LIMIT = 10;
    static final int DEFAULT_NESTING_LIMIT = 6;
    static final int DEFAULT_LINES_LIMIT = 60;
    static final int DEFAULT_EXCEPTIONS_LIMIT = 3;
    static final int DEFAULT_STATEMENTS_LIMIT = 30;
    static final int DEFAULT_METHOD_PARAMETERS_LIMIT = 8;
    static final int DEFAULT_CTOR_PARAMETERS_LIMIT = 12;
    static final boolean DEFAULT_IGNORE_RETURN_GUARDS = true;
    static final boolean DEFAULT_IGNORE_EQUALS = true;
    static final int DEFAULT_RETURN_LIMIT = 2;
    static final int DEFAULT_NEGATIONS_LIMIT = 3;
    static final boolean DEFAULT_NEGATIONS_IGNORE_ASSERT = true;
    static final boolean DEFAULT_NEGATIONS_IGNORE_EQUALS = true;
    static final boolean DEFAULT_COUPLING_IGNORE_JAVA = true;
    static final int DEFAULT_LOOPS_LIMIT = 3;
    static final int DEFAULT_COUPLING_LIMIT = 15;
    public static final String OPTION_COMPLEXITY_TRESHOLD = "metrics.method.complexity.limit";
    public static final String OPTION_NESTING_LIMIT = "metrics.method.depth.limit";
    public static final String OPTION_LINES_LIMIT = "metrics.method.lines.limit";
    public static final String OPTION_STATEMENTS_LIMIT = "metrics.method.statements.limit";
    public static final String OPTION_EXCEPTIONS_LIMIT = "metrics.method.exceptions.limit";
    public static final String OPTION_METHOD_PARAMETERS_LIMIT = "metrics.method.parameters.limit";
    public static final String OPTION_CTOR_PARAMETERS_LIMIT = "metrics.constructor.parameters.limit";
    public static final String OPTION_RETURN_LIMIT = "metrics.method.return.limit";
    public static final String OPTION_RETURN_IGNORE_GUARDS = "metrics.method.returns.ignoreguards";
    public static final String OPTION_RETURN_IGNORE_EQUALS = "metrics.method.returns.ignoreequals";
    public static final String OPTION_NEGATIONS_LIMIT = "metrics.method.negations.limit";
    public static final String OPTION_NEGATIONS_IGNORE_EQUALS = "metrics.method.negations.ignoreequals";
    public static final String OPTION_NEGATIONS_IGNORE_ASSERT = "metrics.method.negations.ignoreassert";
    public static final String OPTION_LOOPS_LIMIT = "metrics.method.loops.limit";
    public static final String OPTION_COUPLING_LIMIT = "metrics.method.coupling.limit";
    public static final String OPTION_COUPLING_IGNORE_JAVA = "metrics.method.coupling.nojava";
    public static final String OPTION_COUPLING_IGNORE_LIBS = "metrics.method.coupling.nolibraries";

    private static boolean methodOrConstructor(HintContext ctx) {
        Element el = ctx.getInfo().getTrees().getElement(ctx.getPath());
        return el.getKind() == ElementKind.CONSTRUCTOR;
    }

    public static ErrorDescription methodTooComplex(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        CyclomaticComplexityVisitor v = new CyclomaticComplexityVisitor();
        v.scan(ctx.getPath(), (Object)v);
        int complexity = v.getComplexity();
        int treshold = ctx.getPreferences().getInt(OPTION_COMPLEXITY_TRESHOLD, 10);
        if (complexity <= treshold) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooComplex(complexity) : Bundle.TEXT_MethodTooComplex(method.getName().toString(), complexity)), (Fix[])new Fix[0]);
    }

    public static ErrorDescription tooDeepNesting(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        DepthVisitor v = new DepthVisitor();
        v.scan(ctx.getPath(), null);
        int depth = v.getDepth();
        int treshold = ctx.getPreferences().getInt(OPTION_NESTING_LIMIT, 6);
        if (depth <= treshold) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooDeepNesting(depth) : Bundle.TEXT_MethodTooDeepNesting(method.getName().toString(), depth)), (Fix[])new Fix[0]);
    }

    public static ErrorDescription tooLong(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        NCLOCVisitor v = new NCLOCVisitor(ctx.getInfo().getSnapshot().getText(), ctx.getInfo().getTrees().getSourcePositions());
        v.scan(ctx.getPath(), null);
        int count = v.getLineCount();
        int treshold = ctx.getPreferences().getInt(OPTION_LINES_LIMIT, 60);
        if (count > treshold) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooLongLines(count) : Bundle.TEXT_MethodTooLongLines(method.getName().toString(), count)), (Fix[])new Fix[0]);
        }
        count = v.getStatementCount();
        if (count > (treshold = ctx.getPreferences().getInt(OPTION_STATEMENTS_LIMIT, 30))) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooLongStatements(count) : Bundle.TEXT_MethodTooLongStatements(method.getName().toString(), count)), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription tooManyExceptions(HintContext ctx) {
        int count;
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        Collection exc2 = (Collection)ctx.getMultiVariables().get("$thrown2$");
        int limit = ctx.getPreferences().getInt(OPTION_EXCEPTIONS_LIMIT, 3);
        int n = count = exc2 == null ? 1 : exc2.size() + 1;
        if (count <= limit) {
            return null;
        }
        Element el = ctx.getInfo().getTrees().getElement(ctx.getPath());
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooManyExceptions(count) : Bundle.TEXT_MethodTooManyExceptions(method.getName().toString(), count)), (Fix[])new Fix[0]);
    }

    public static ErrorDescription tooManyParameters(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        Collection args = (Collection)ctx.getMultiVariables().get("$args$");
        int limit = ctx.getPreferences().getInt(OPTION_METHOD_PARAMETERS_LIMIT, 8);
        int count = args.size() + 2;
        if (count <= limit) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)(MethodMetrics.methodOrConstructor(ctx) ? Bundle.TEXT_ConstructorTooManyParameters(count) : Bundle.TEXT_MethodTooManyParameters(method.getName().toString(), count)), (Fix[])new Fix[0]);
    }

    public static ErrorDescription tooManyParametersCtor(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        Collection args = (Collection)ctx.getMultiVariables().get("$args$");
        int limit = ctx.getPreferences().getInt(OPTION_METHOD_PARAMETERS_LIMIT, 8);
        int count = args.size() + 2;
        if (count <= limit) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)Bundle.TEXT_MethodTooManyParameters(method.getName().toString(), count), (Fix[])new Fix[0]);
    }

    public static ErrorDescription multipleReturnPoints(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        boolean ignoreEquals = ctx.getPreferences().getBoolean(OPTION_RETURN_IGNORE_EQUALS, true);
        if (ignoreEquals && method.getName().contentEquals("equals")) {
            return null;
        }
        ReturnCountVisitor v = new ReturnCountVisitor(ctx.getPreferences().getBoolean(OPTION_RETURN_IGNORE_GUARDS, true));
        v.scan(ctx.getPath(), null);
        int count = v.getReturnCount();
        int limit = ctx.getPreferences().getInt(OPTION_RETURN_LIMIT, 2);
        if (count > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)Bundle.TEXT_MethodMultipleReturns(method.getName().toString(), count), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription multipleNegations(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        boolean ignoreEquals = ctx.getPreferences().getBoolean(OPTION_NEGATIONS_IGNORE_EQUALS, true);
        if (ignoreEquals && method.getName().contentEquals("equals")) {
            return null;
        }
        boolean ignoreAsserts = ctx.getPreferences().getBoolean(OPTION_NEGATIONS_IGNORE_ASSERT, true);
        NegationsVisitor v = new NegationsVisitor(ignoreAsserts);
        v.scan(ctx.getPath(), null);
        int limit = ctx.getPreferences().getInt(OPTION_NEGATIONS_LIMIT, 3);
        int count = v.getNegationsCount();
        if (count > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)Bundle.TEXT_MethodMultipleNegations(method.getName().toString(), count), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription multipleLoops(HintContext ctx) {
        Tree t = ctx.getPath().getLeaf();
        MethodTree method = (MethodTree)t;
        LoopFinder v = new LoopFinder();
        v.scan(ctx.getPath(), null);
        int count = v.getLoopCount();
        int limit = ctx.getPreferences().getInt(OPTION_LOOPS_LIMIT, 3);
        if (count > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)t, (String)Bundle.TEXT_MethodMultipleLoops(method.getName().toString(), count), (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription tooManyDependencies(HintContext ctx) {
        MethodTree m = (MethodTree)ctx.getPath().getLeaf();
        boolean ignoreJava = ctx.getPreferences().getBoolean(OPTION_COUPLING_IGNORE_JAVA, true);
        TypeElement outermost = ctx.getInfo().getElementUtilities().outermostTypeElement(ctx.getInfo().getTrees().getElement(ctx.getPath()));
        DependencyCollector col = new DependencyCollector(ctx.getInfo());
        col.setIgnoreJavaLibraries(ignoreJava);
        col.setOutermostClass(outermost);
        col.scan(ctx.getPath(), null);
        int deps = col.getSeenQNames().size();
        int limit = ctx.getPreferences().getInt(OPTION_COUPLING_LIMIT, 15);
        if (deps > limit) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)m, (String)Bundle.TEXT_MethodTooCoupled(m.getName().toString(), deps), (Fix[])new Fix[0]);
        }
        return null;
    }

    private static class LoopFinder
    extends ErrorAwareTreePathScanner {
        private int loopCount;

        private LoopFinder() {
        }

        public int getLoopCount() {
            return this.loopCount;
        }

        public Object visitClass(ClassTree node, Object p) {
            int save = this.loopCount;
            Object o = super.visitClass(node, p);
            this.loopCount = save;
            return o;
        }

        public Object visitDoWhileLoop(DoWhileLoopTree node, Object p) {
            ++this.loopCount;
            return super.visitDoWhileLoop(node, p);
        }

        public Object visitWhileLoop(WhileLoopTree node, Object p) {
            ++this.loopCount;
            return super.visitWhileLoop(node, p);
        }

        public Object visitForLoop(ForLoopTree node, Object p) {
            ++this.loopCount;
            return super.visitForLoop(node, p);
        }

        public Object visitEnhancedForLoop(EnhancedForLoopTree node, Object p) {
            ++this.loopCount;
            return super.visitEnhancedForLoop(node, p);
        }
    }

    private static class NegationsVisitor
    extends ErrorAwareTreePathScanner {
        private int negationsCount;
        private final boolean ignoreAsserts;

        public NegationsVisitor(boolean ignoreAsserts) {
            this.ignoreAsserts = ignoreAsserts;
        }

        public int getNegationsCount() {
            return this.negationsCount;
        }

        public Object visitUnary(UnaryTree node, Object p) {
            if (node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                ++this.negationsCount;
            }
            return super.visitUnary(node, p);
        }

        public Object visitBinary(BinaryTree node, Object p) {
            if (node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                ++this.negationsCount;
            }
            return super.visitBinary(node, p);
        }

        public Object visitAssert(AssertTree node, Object p) {
            int saveCount = this.negationsCount;
            Object o = super.visitAssert(node, p);
            if (this.ignoreAsserts) {
                this.negationsCount = saveCount;
            }
            return o;
        }
    }

    private static class ReturnCountVisitor
    extends ErrorAwareTreePathScanner {
        private boolean suppress;
        private int returnCount;
        private final boolean ignoreGuards;

        public ReturnCountVisitor(boolean ignoreGuards) {
            this.ignoreGuards = ignoreGuards;
        }

        public int getReturnCount() {
            return this.returnCount;
        }

        public Object visitClass(ClassTree node, Object p) {
            boolean s = this.suppress;
            this.suppress = true;
            Object o = super.visitClass(node, p);
            this.suppress = s;
            return o;
        }

        public Object visitReturn(ReturnTree node, Object p) {
            TreePath path = this.getCurrentPath();
            TreePath parentPath = path.getParentPath();
            if (this.suppress) {
                return super.visitReturn(node, p);
            }
            if (this.ignoreGuards && parentPath != null) {
                Tree parentTree = parentPath.getLeaf();
                TreePath branchPath = path;
                while (parentTree.getKind() == Tree.Kind.BLOCK) {
                    branchPath = parentPath;
                    parentPath = parentPath.getParentPath();
                    parentTree = parentPath.getLeaf();
                }
                if (parentTree.getKind() == Tree.Kind.IF) {
                    BlockTree bt;
                    StatementTree trueTree;
                    IfTree ifTree = (IfTree)parentTree;
                    StatementTree statementTree = trueTree = ifTree.getThenStatement() == branchPath.getLeaf() ? ifTree.getThenStatement() : ifTree.getElseStatement();
                    if (trueTree == node) {
                        return super.visitReturn(node, p);
                    }
                    if (trueTree.getKind() == Tree.Kind.BLOCK && (bt = (BlockTree)trueTree).getStatements().size() == 1) {
                        return super.visitReturn(node, p);
                    }
                }
            }
            ++this.returnCount;
            return super.visitReturn(node, p);
        }
    }
}

