/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbDriverManager;
import org.openide.util.Exceptions;

public class DerbyConectionEventListener {
    private static final DerbyConectionEventListener DEFAULT = new DerbyConectionEventListener();
    private static final String DERBY_DATABASE_FORCE_LOCK = "derby.database.forceDatabaseLock";
    private static final String DERBY_SYSTEM_HOME = "derby.system.home";
    private static final String DERBY_SYSTEM_SHUTDOWN_STATE = "XJ015";

    public static DerbyConectionEventListener getDefault() {
        return DEFAULT;
    }

    public void beforeConnect(DatabaseConnection dbconn) {
        if (!dbconn.getDriver().equals("org.apache.derby.jdbc.EmbeddedDriver")) {
            return;
        }
        if (System.getProperty(DERBY_DATABASE_FORCE_LOCK) == null) {
            System.setProperty(DERBY_DATABASE_FORCE_LOCK, "true");
        }
        if (System.getProperty(DERBY_SYSTEM_HOME) == null) {
            File derbySystemHome = new File(System.getProperty("netbeans.user"), "derby");
            derbySystemHome.mkdirs();
            System.setProperty(DERBY_SYSTEM_HOME, derbySystemHome.getAbsolutePath());
        }
    }

    public void afterDisconnect(DatabaseConnection dbconn, Connection conn) {
        block3: {
            if (!dbconn.getDriver().equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                return;
            }
            try {
                DbDriverManager.getDefault().getSameDriverConnection(conn, "jdbc:derby:;shutdown=true", new Properties());
            }
            catch (SQLException e) {
                if (DERBY_SYSTEM_SHUTDOWN_STATE.equals(e.getSQLState())) break block3;
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

