/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class Face {
    private List<MGraph.Edge> edges = new ArrayList<MGraph.Edge>();
    private Set<MGraph.Edge> edgeMap = new HashSet<MGraph.Edge>();
    private List<Dart> darts = new ArrayList<Dart>();
    private Set<Dart> dartMap = new HashSet<Dart>();
    private Map<Dart, Integer> dartIndices = new HashMap<Dart, Integer>();
    private boolean isOuterFace;

    public int getDegree() {
        return this.edges.size();
    }

    public void setOuterFace(boolean flag) {
        this.isOuterFace = flag;
    }

    public boolean isOuterFace() {
        return this.isOuterFace;
    }

    public List<MGraph.Vertex> getVertices() {
        ArrayList<MGraph.Vertex> vertices = new ArrayList<MGraph.Vertex>();
        List<Dart> _darts = this.getDarts();
        for (Dart dart : _darts) {
            vertices.add(dart.getV());
        }
        return vertices;
    }

    public void addEdge(MGraph.Edge edge) {
        this.edgeMap.add(edge);
        this.edges.add(edge);
    }

    public void addEdges(Collection<MGraph.Edge> newEdges) {
        this.edges.addAll(newEdges);
        this.edgeMap.addAll(newEdges);
    }

    private void addEdge(int index, MGraph.Edge newEdge) {
        this.edges.add(index, newEdge);
        this.edgeMap.add(newEdge);
    }

    private void removeEdge(MGraph.Edge edgeToRemove) {
        this.edges.remove(edgeToRemove);
        if (!this.edges.contains(edgeToRemove)) {
            this.edgeMap.remove(edgeToRemove);
        }
    }

    private void removeEdge(int index) {
        MGraph.Edge removedEdge = this.edges.remove(index);
        if (!this.edges.contains(removedEdge)) {
            this.edgeMap.remove(removedEdge);
        }
    }

    public List<MGraph.Edge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public MGraph.Edge getBorderingEdge(Face face) {
        for (MGraph.Edge e : face.getEdges()) {
            if (!this.edgeMap.contains(e)) continue;
            return e;
        }
        return null;
    }

    public List<Dart> replaceEdge(MGraph.Edge edgeToReplace, Collection<MGraph.Edge> newEdges) {
        HashSet<MGraph.Edge> newEdgeSet = new HashSet<MGraph.Edge>(newEdges);
        ArrayList<Dart> newDarts = new ArrayList<Dart>();
        Dart dartToReplace = this.getDart(edgeToReplace);
        MGraph.Vertex v = dartToReplace.getV();
        MGraph.Vertex w = dartToReplace.getW();
        int index = this.getDartIndex(dartToReplace);
        this.removeEdge(index);
        this.removeDart(index);
        while (v != w) {
            MGraph.Edge newEdge = this.searchAndRemoveEdge(v, newEdgeSet);
            MGraph.Vertex ov = newEdge.getOppositeVertex(v);
            Dart newDart = new Dart(v, ov, newEdge);
            this.addEdge(index, newEdge);
            this.addDart(index, newDart);
            newDarts.add(newDart);
            ++index;
            v = ov;
        }
        return newDarts;
    }

    public List<Dart> replaceDart(Dart dartToReplace, Collection<MGraph.Edge> newEdges) {
        HashSet<MGraph.Edge> newEdgeSet = new HashSet<MGraph.Edge>(newEdges);
        ArrayList<Dart> newDarts = new ArrayList<Dart>();
        MGraph.Vertex v = dartToReplace.getV();
        MGraph.Vertex w = dartToReplace.getW();
        int index = this.getDartIndex(dartToReplace);
        this.removeEdge(index);
        this.removeDart(index);
        while (v != w) {
            MGraph.Edge newEdge = this.searchAndRemoveEdge(v, newEdgeSet);
            MGraph.Vertex ov = newEdge.getOppositeVertex(v);
            Dart newDart = new Dart(v, ov, newEdge);
            this.addEdge(index, newEdge);
            this.addDart(index, newDart);
            newDarts.add(newDart);
            ++index;
            v = ov;
        }
        return newDarts;
    }

    public List<Dart> replaceDarts(MGraph.Edge edgeToAdd) {
        return this.replaceDarts(edgeToAdd, null);
    }

    public List<Dart> replaceDarts(MGraph.Edge edgeToAdd, MGraph.Vertex startingVertex) {
        ArrayList<Dart> removedDarts = new ArrayList<Dart>();
        MGraph.Vertex v = null;
        MGraph.Vertex w = null;
        if (startingVertex == null) {
            v = edgeToAdd.getV();
            w = edgeToAdd.getW();
        } else {
            v = startingVertex;
            w = edgeToAdd.getOppositeVertex(v);
        }
        List<Dart> dartsTo = this.getDartsTo(v);
        if (dartsTo.isEmpty()) {
            return removedDarts;
        }
        Dart firstDart = dartsTo.get(dartsTo.size() - 1);
        if (firstDart == null) {
            return removedDarts;
        }
        Dart lastDart = this.getDartFrom(w);
        Dart currentDart = this.getNextDart(firstDart);
        while (currentDart != lastDart) {
            int index = this.darts.indexOf(currentDart);
            currentDart = this.getNextDart(currentDart);
            this.removeEdge(index);
            removedDarts.add(this.darts.get(index));
            this.removeDart(index);
        }
        Dart newDart = new Dart(v, w, edgeToAdd);
        int index = this.getDartIndex(firstDart) + 1;
        this.addDart(index, newDart);
        this.addEdge(index, edgeToAdd);
        return removedDarts;
    }

    private MGraph.Edge searchAndRemoveEdge(MGraph.Vertex v, Collection<MGraph.Edge> edges) {
        MGraph.Edge edge = null;
        for (MGraph.Edge e : edges) {
            if (!e.contains(v)) continue;
            edge = e;
            break;
        }
        edges.remove(edge);
        return edge;
    }

    public List<Dart> getDarts() {
        if (this.darts.size() != this.edges.size()) {
            this.createDarts();
        }
        return Collections.unmodifiableList(this.darts);
    }

    public void createDarts(MGraph.Vertex startingVertex) {
        MGraph.Vertex prevVertex = null;
        this.darts.clear();
        this.dartMap.clear();
        for (MGraph.Edge e : this.edges) {
            if (prevVertex == null) {
                MGraph.Vertex v = e.getV();
                MGraph.Vertex w = e.getW();
                prevVertex = startingVertex == null ? (this.isOuterFace ? (v.getNumber() < w.getNumber() ? w : v) : (v.getNumber() < w.getNumber() ? v : w)) : startingVertex;
            }
            MGraph.Vertex nextVertex = e.getOppositeVertex(prevVertex);
            Dart dart = new Dart(prevVertex, nextVertex, e);
            this.addDart(dart);
            prevVertex = nextVertex;
        }
    }

    public void createDarts() {
        this.createDarts(null);
    }

    private void addDart(Dart newDart) {
        this.darts.add(newDart);
        this.dartMap.add(newDart);
        this.updateDartIndices(this.darts.size() - 1, null);
    }

    private void addDart(int index, Dart newDart) {
        this.darts.add(index, newDart);
        this.dartMap.add(newDart);
        this.updateDartIndices(index, null);
    }

    private void removeDart(Dart dartToRemove) {
        int index = this.getDartIndex(dartToRemove);
        this.darts.remove(index);
        this.dartMap.remove(dartToRemove);
        this.updateDartIndices(index, dartToRemove);
    }

    private void removeDart(int index) {
        Dart removedDart = this.darts.remove(index);
        this.dartMap.remove(removedDart);
        this.updateDartIndices(index, removedDart);
    }

    private void updateDartIndices(int index, Dart removedDart) {
        if (removedDart != null) {
            this.dartIndices.remove(removedDart);
        }
        int size = this.darts.size();
        for (int i = index; i < size; ++i) {
            this.dartIndices.put(this.darts.get(i), i);
        }
    }

    public List<Dart> getDartsFrom(MGraph.Vertex v) {
        ArrayList<Dart> darts = new ArrayList<Dart>();
        for (Dart d : this.getDarts()) {
            if (v != d.getV()) continue;
            darts.add(d);
        }
        return darts;
    }

    public Dart getDartFrom(MGraph.Vertex v) {
        for (Dart d : this.getDarts()) {
            if (v != d.getV()) continue;
            return d;
        }
        return null;
    }

    public List<Dart> getDartsTo(MGraph.Vertex v) {
        ArrayList<Dart> darts = new ArrayList<Dart>();
        for (Dart d : this.getDarts()) {
            if (v != d.getW()) continue;
            darts.add(d);
        }
        return darts;
    }

    public Dart getDartTo(MGraph.Vertex v) {
        for (Dart d : this.getDarts()) {
            if (v != d.getW()) continue;
            return d;
        }
        return null;
    }

    public Dart getDart(MGraph.Edge edge) {
        for (Dart d : this.getDarts()) {
            if (d.getEdge() != edge) continue;
            return d;
        }
        return null;
    }

    public List<Dart> getDarts(MGraph.Edge edge) {
        ArrayList<Dart> _darts = new ArrayList<Dart>();
        for (Dart d : this.getDarts()) {
            if (d.getEdge() != edge) continue;
            _darts.add(d);
        }
        return _darts;
    }

    public Dart getDart(MGraph.Edge edge, MGraph.Vertex sourceVertex) {
        for (Dart d : this.getDarts()) {
            if (d.getEdge() != edge || d.getV() != sourceVertex) continue;
            return d;
        }
        return null;
    }

    public Dart getBorderingDart(Face face) {
        MGraph.Edge edge = this.getBorderingEdge(face);
        for (Dart d : this.getDarts()) {
            if (d.getEdge() != edge) continue;
            return d;
        }
        return null;
    }

    public boolean containsEdge(MGraph.Edge e) {
        return this.edgeMap.contains(e);
    }

    public boolean containsDart(Dart d) {
        return this.dartMap.contains(d);
    }

    public boolean containsVertex(MGraph.Vertex v) {
        for (MGraph.Edge e : this.edges) {
            if (!e.contains(v)) continue;
            return true;
        }
        return false;
    }

    public boolean connects(Face face) {
        for (MGraph.Edge e : this.getEdges()) {
            for (MGraph.Edge ne : face.getEdges()) {
                if (!e.shareVertex(ne)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean borders(Face face) {
        for (MGraph.Edge e : face.edges) {
            if (!this.edgeMap.contains(e)) continue;
            return true;
        }
        return false;
    }

    public MGraph.Vertex getCornerVertex(MGraph.Edge edge) {
        MGraph.Edge nextEdge = this.getNextEdge(edge);
        MGraph.Vertex v = edge.getV();
        MGraph.Vertex w = edge.getW();
        MGraph.Vertex nv = nextEdge.getV();
        MGraph.Vertex nw = nextEdge.getW();
        if (v == nv || v == nw) {
            return v;
        }
        if (w == nv || w == nw) {
            return w;
        }
        return null;
    }

    public MGraph.Edge getNextEdge(MGraph.Edge e) {
        int index = this.getEdgeIndex(e);
        return this.edges.get((index + 1) % this.edges.size());
    }

    private int getEdgeIndex(MGraph.Edge e) {
        return this.edges.indexOf(e);
    }

    public MGraph.Vertex getCornerVertex(Dart dart) {
        Dart nextDart = this.getNextDart(dart);
        MGraph.Vertex v = dart.getV();
        MGraph.Vertex w = dart.getW();
        MGraph.Vertex nv = nextDart.getV();
        MGraph.Vertex nw = nextDart.getW();
        if (v == nv || v == nw) {
            return v;
        }
        if (w == nv || w == nw) {
            return w;
        }
        return null;
    }

    public Dart getNextDart(Dart dart) {
        int index = this.getDartIndex(dart);
        if (index == -1) {
            return null;
        }
        return this.darts.get((index + 1) % this.darts.size());
    }

    private int getDartIndex(Dart dart) {
        return this.dartIndices.get(dart);
    }

    public void reverseDirection() {
        ArrayList<MGraph.Edge> l = new ArrayList<MGraph.Edge>(this.edges);
        this.edges.clear();
        this.edgeMap.clear();
        for (int i = l.size() - 1; i >= 0; --i) {
            this.addEdge(l.get(i));
        }
        this.darts.clear();
        this.dartMap.clear();
    }

    public String toString() {
        String s = "Face:\n";
        if (this.isOuterFace) {
            s = "Outer Face:\n";
        }
        s = s + "Edges:\n";
        for (MGraph.Edge e : this.edges) {
            s = s + "\t" + e + "\n";
        }
        s = s + "Darts:\n";
        for (Dart d : this.getDarts()) {
            s = s + "\t" + d + "\n";
        }
        return s;
    }

    public static class Dart
    extends MGraph.Edge {
        private MGraph.Edge e;

        public Dart(MGraph.Vertex v, MGraph.Vertex w, MGraph.Edge e) {
            super(v, w, null);
            this.e = e;
        }

        public MGraph.Edge getEdge() {
            return this.e;
        }

        @Override
        public MGraph.Edge.Direction getDirection() {
            return this.e.getDirection();
        }

        @Override
        public String toString() {
            return "dart : v = " + this.getV() + " w = " + this.getW() + " direction = " + (Object)((Object)this.getDirection());
        }
    }
}

