/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.kenai;

import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.mercurial.kenai.KenaiNotificationListener;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.util.Lookup;

public class HgKenaiAccessor {
    private static HgKenaiAccessor instance;
    private VCSKenaiAccessor kenaiAccessor = null;
    private Set<String> queriedUrls = new HashSet<String>(5);

    private HgKenaiAccessor() {
        this.kenaiAccessor = (VCSKenaiAccessor)Lookup.getDefault().lookup(VCSKenaiAccessor.class);
    }

    public static HgKenaiAccessor getInstance() {
        if (instance == null) {
            instance = new HgKenaiAccessor();
        }
        return instance;
    }

    public boolean isKenai(String url) {
        return this.kenaiAccessor != null && this.kenaiAccessor.isKenai(url);
    }

    public boolean isLoggedIntoKenai(String url) {
        return this.kenaiAccessor != null && this.kenaiAccessor.isLogged(url);
    }

    public PasswordAuthentication getPasswordAuthentication(String url, boolean forceRelogin) {
        if (this.kenaiAccessor != null) {
            if (forceRelogin && this.queriedUrls.contains(url) && !this.kenaiAccessor.showLogin()) {
                return null;
            }
            this.queriedUrls.add(url);
            return this.kenaiAccessor.getPasswordAuthentication(url);
        }
        return null;
    }

    public boolean isUserOnline(String user) {
        return this.kenaiAccessor != null ? this.kenaiAccessor.isUserOnline(user) : false;
    }

    public VCSKenaiAccessor.KenaiUser forName(String user, String url) {
        return this.kenaiAccessor != null ? this.kenaiAccessor.forName(user, url) : null;
    }

    public String getRevisionUrl(String repositoryUrl, String revision) {
        return this.kenaiAccessor == null ? null : this.kenaiAccessor.getRevisionUrl(repositoryUrl, revision);
    }

    private void removeVCSNoficationListener(PropertyChangeListener l) {
        if (this.kenaiAccessor != null) {
            this.kenaiAccessor.removeVCSNoficationListener(l);
        }
    }

    private void addVCSNoficationListener(PropertyChangeListener l) {
        if (this.kenaiAccessor != null) {
            this.kenaiAccessor.addVCSNoficationListener(l);
        }
    }

    public void registerVCSNoficationListener() {
        if ("true".equals(System.getProperty("kenai.vcs.notifications.ignore"))) {
            return;
        }
        this.addVCSNoficationListener((PropertyChangeListener)((Object)new KenaiNotificationListener()));
    }

    public boolean canRead(String repositoryUrl) {
        return this.isAuthorized(repositoryUrl, VCSKenaiAccessor.RepositoryActivity.READ);
    }

    public boolean canWrite(String repositoryUrl) {
        return this.isAuthorized(repositoryUrl, VCSKenaiAccessor.RepositoryActivity.WRITE);
    }

    private boolean isAuthorized(String repositoryUrl, VCSKenaiAccessor.RepositoryActivity permission) {
        return this.kenaiAccessor == null || !this.kenaiAccessor.isLogged(repositoryUrl) || this.kenaiAccessor.isAuthorized(repositoryUrl, permission);
    }
}

