/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) - u64vec2(10ul, 12ul)) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) - u64vec2(42ul, 48ul)) => u64vec2(18446744073709551584ul, 18446744073709551580ul)
 * (u64vec2(42ul, 48ul) - u64vec2(10ul, 12ul)) => u64vec2(32ul, 36ul)
 * (u64vec2(42ul, 48ul) - u64vec2(42ul, 48ul)) => u64vec2(0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) - u64vec2(10ul, 12ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) - u64vec2(42ul, 48ul)), u64vec2(18446744073709551584ul, 18446744073709551580ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(42ul, 48ul) - u64vec2(10ul, 12ul)), u64vec2(32ul, 36ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(42ul, 48ul) - u64vec2(42ul, 48ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
