/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000b2\n\u0010\u000f\u001a\u00060\u0007R\u00020\bH\u0014J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u000f\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0007R\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/LookaheadText$Position;)V", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "3ce148cfd89a773"})
public final class CodeBlockMarkerBlock
extends MarkerBlockImpl {
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        MarkdownConstraints nextConstraints;
        block10: {
            block9: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
                if (pos.getOffset() < this.realInterestingOffset) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                if (pos.getOffsetInCurrentLine() != -1) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                boolean bl2 = bl = pos.getOffsetInCurrentLine() == -1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                LookaheadText.Position position2 = MarkdownParserUtil.INSTANCE.findNonEmptyLineWithSameConstraints(this.getConstraints(), pos);
                if (position2 == null) {
                    return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
                }
                LookaheadText.Position nonemptyPos = position2;
                nextConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
                LookaheadText.Position shifted = nonemptyPos.nextPosition(1 + nextConstraints.getCharsEaten(nonemptyPos.getCurrentLine()));
                position = shifted;
                if (position == null) break block9;
                Integer n = shifted.charsToNonWhitespace();
                if ((position = position.nextPosition(n != null ? n : 0)) != null) break block10;
            }
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonWhitespace = position;
        if (!MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(nonWhitespace, nextConstraints)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        int n = pos.getOffset() + 1 + nextLineConstraints.getCharsEaten(pos.getCurrentLine());
        IntRange nodeRange = new IntRange(n, pos.getNextLineOrEofOffset());
        if (nodeRange.getEndInclusive() - nodeRange.getStart() > 0) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(nodeRange, MarkdownTokenTypes.CODE_LINE)));
        }
        this.realInterestingOffset = pos.getNextLineOrEofOffset();
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.CODE_BLOCK;
    }

    public CodeBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        int n = startPosition.getOffset();
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(n, startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.CODE_LINE)));
        this.realInterestingOffset = -1;
    }
}

