/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections.incomplete;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.editor.inspections.incomplete.IncompletePropertyInspectionOptionsPanel;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompletePropertyInspection
extends LocalInspectionTool
implements ResourceBundleEditorInspection,
UnfairLocalInspectionTool {
    private static final String SUFFIXES_TAG_NAME = "suffixes";
    private static final String TOOL_KEY = "IncompleteProperty";
    SortedSet<String> mySuffixes = new TreeSet<String>();

    @Nullable
    public JComponent createOptionsPanel() {
        return new IncompletePropertyInspectionOptionsPanel(this.mySuffixes).buildPanel();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            IncompletePropertyInspection.$$$reportNull$$$0(0);
        }
        this.mySuffixes.clear();
        Element element = node.getChild(SUFFIXES_TAG_NAME);
        if (element != null) {
            this.mySuffixes.addAll(StringUtil.split((String)element.getText(), (String)",", (boolean)true, (boolean)false));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            IncompletePropertyInspection.$$$reportNull$$$0(1);
        }
        if (!this.mySuffixes.isEmpty()) {
            node.addContent(new Element(SUFFIXES_TAG_NAME).setText(StringUtil.join(this.mySuffixes, (String)",")));
        }
    }

    @Override
    @NotNull
    public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            IncompletePropertyInspection.$$$reportNull$$$0(2);
        }
        Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (resourceBundle == null) {
                IncompletePropertyInspection.$$$reportNull$$$0(5);
            }
            if (!this.isPropertyComplete((IProperty[])properties, resourceBundle)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, PropertiesBundle.message("incomplete.property.inspection.description", properties[0].getName()), new IgnoreLocalesQuickFix(properties[0], resourceBundle));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
        if (function == null) {
            IncompletePropertyInspection.$$$reportNull$$$0(3);
        }
        return function;
    }

    @NotNull
    public static IncompletePropertyInspection getInstance(PsiElement element) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        IncompletePropertyInspection incompletePropertyInspection = (IncompletePropertyInspection)inspectionProfile.getUnwrappedTool(TOOL_KEY, element);
        if (incompletePropertyInspection == null) {
            IncompletePropertyInspection.$$$reportNull$$$0(4);
        }
        return incompletePropertyInspection;
    }

    public boolean isPropertyComplete(String key, ResourceBundle resourceBundle) {
        return this.isPropertyComplete((IProperty[])resourceBundle.getPropertiesFiles().stream().map(f -> f.findPropertyByKey(key)).filter(Objects::nonNull).toArray(IProperty[]::new), resourceBundle);
    }

    private boolean isPropertyComplete(IProperty[] properties, ResourceBundle resourceBundle) {
        Set existed = ContainerUtil.map2Set((Object[])properties, IProperty::getPropertiesFile);
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (existed.contains(file) || this.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(file))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getIgnoredSuffixes() {
        return this.mySuffixes;
    }

    public List<PropertiesFile> getPropertiesFilesWithoutTranslation(ResourceBundle resourceBundle, String key) {
        return ContainerUtil.filter(resourceBundle.getPropertiesFiles(), propertiesFile -> propertiesFile.findPropertyByKey(key) == null && !this.getIgnoredSuffixes().contains(PropertiesUtil.getSuffix(propertiesFile)));
    }

    public void addSuffixes(Collection<String> suffixes) {
        this.mySuffixes.addAll(suffixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropertyGroupVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildPropertyGroupVisitor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildPropertyGroupVisitor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreLocalesQuickFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final ResourceBundle myResourceBundle;
        private final SmartPsiElementPointer<PsiElement> myElementPointer;

        IgnoreLocalesQuickFix(IProperty property, ResourceBundle bundle) {
            this.myElementPointer = SmartPointerManager.getInstance((Project)bundle.getProject()).createSmartPsiElementPointer(property.getPsiElement());
            this.myResourceBundle = bundle;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("incomplete.property.quick.fix.name", new Object[0]);
            if (string == null) {
                IgnoreLocalesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                IgnoreLocalesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                IgnoreLocalesQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = this.myElementPointer.getElement()) == null) {
                return;
            }
            IProperty property = PropertiesImplUtil.getProperty(element);
            if (property == null) {
                return;
            }
            IncompletePropertyInspection inspection = IncompletePropertyInspection.getInstance(element);
            List<PropertiesFile> allFilesWithoutTranslation = inspection.getPropertiesFilesWithoutTranslation(this.myResourceBundle, property.getKey());
            if (allFilesWithoutTranslation.isEmpty()) {
                return;
            }
            TreeSet<String> suffixesToIgnore = new TreeSet<String>(ContainerUtil.map(allFilesWithoutTranslation, PropertiesUtil::getSuffix));
            if (new IncompletePropertyInspectionOptionsPanel(suffixesToIgnore).showDialogAndGet(project)) {
                InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> ((IncompletePropertyInspection)it.getInspectionTool(IncompletePropertyInspection.TOOL_KEY, element).getTool()).addSuffixes(suffixesToIgnore));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/editor/inspections/incomplete/IncompletePropertyInspection$IgnoreLocalesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

