/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.BoolField;

public class FieldValueFeature
extends Feature {
    private String field;
    private Set<String> fieldAsSet;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        this.fieldAsSet = Collections.singleton(field);
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(1, 1.0f);
        params.put("field", this.field);
        return params;
    }

    @Override
    protected void validate() throws FeatureException {
        if (this.field == null || this.field.isEmpty()) {
            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + ": field must be provided");
        }
    }

    public FieldValueFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new FieldValueFeatureWeight(searcher, request, originalQuery, efi);
    }

    public class FieldValueFeatureWeight
    extends Feature.FeatureWeight {
        public FieldValueFeatureWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(FieldValueFeature.this, searcher, request, originalQuery, efi);
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            return new FieldValueFeatureScorer(this, context, DocIdSetIterator.all((int)Integer.MAX_VALUE));
        }

        public class FieldValueFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            LeafReaderContext context;

            public FieldValueFeatureScorer(Feature.FeatureWeight weight, LeafReaderContext context, DocIdSetIterator itr) {
                super(weight, itr);
                this.context = null;
                this.context = context;
            }

            @Override
            public float score() throws IOException {
                try {
                    Document document = this.context.reader().document(this.itr.docID(), FieldValueFeature.this.fieldAsSet);
                    IndexableField indexableField = document.getField(FieldValueFeature.this.field);
                    if (indexableField == null) {
                        return FieldValueFeatureWeight.this.getDefaultValue();
                    }
                    Number number = indexableField.numericValue();
                    if (number != null) {
                        return number.floatValue();
                    }
                    String string = indexableField.stringValue();
                    if (string.length() == 1) {
                        if (string.charAt(0) == BoolField.TRUE_TOKEN[0]) {
                            return 1.0f;
                        }
                        if (string.charAt(0) == BoolField.FALSE_TOKEN[0]) {
                            return 0.0f;
                        }
                    }
                }
                catch (IOException e) {
                    throw new FeatureException(e.toString() + ": Unable to extract feature for " + this.name, e);
                }
                return FieldValueFeatureWeight.this.getDefaultValue();
            }

            public float getMaxScore(int upTo) throws IOException {
                return Float.POSITIVE_INFINITY;
            }
        }
    }
}

