/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnapshotCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateSnapshotCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        String commitName = message.getStr("commitName");
        String asyncId = message.getStr("async");
        SolrZkClient zkClient = this.ocmh.zkStateReader.getZkClient();
        Date creationDate = new Date();
        if (SolrSnapshotManager.snapshotExists(zkClient, collectionName, commitName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " already exists for collection " + collectionName);
        }
        log.info("Creating a snapshot for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        SolrSnapshotManager.createCollectionLevelSnapshot(zkClient, collectionName, new CollectionSnapshotMetaData(commitName));
        log.info("Created a ZK path to store snapshot information for collection={} with commitName={}", (Object)collectionName, (Object)commitName);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        NamedList shardRequestResults = new NamedList();
        HashMap<String, Slice> shardByCoreName = new HashMap<String, Slice>();
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler(this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
        for (Slice slice : this.ocmh.zkStateReader.getClusterState().getCollection(collectionName).getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                if (replica.getState() != Replica.State.ACTIVE) {
                    log.info("Replica {} is not active. Hence not sending the createsnapshot request", (Object)replica.getCoreName());
                    continue;
                }
                String coreName = replica.getStr("core");
                ModifiableSolrParams modifiableSolrParams = new ModifiableSolrParams();
                modifiableSolrParams.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATESNAPSHOT.toString()});
                modifiableSolrParams.set("name", new String[]{slice.getName()});
                modifiableSolrParams.set("core", new String[]{coreName});
                modifiableSolrParams.set("commitName", new String[]{commitName});
                this.ocmh.sendShardRequest(replica.getNodeName(), modifiableSolrParams, shardHandler, asyncId, requestMap);
                log.debug("Sent createsnapshot request to core={} with commitName={}", (Object)coreName, (Object)commitName);
                shardByCoreName.put(coreName, slice);
            }
        }
        HashSet failedShards = new HashSet();
        this.ocmh.processResponses(shardRequestResults, shardHandler, false, null, asyncId, requestMap);
        NamedList success = (NamedList)shardRequestResults.get("success");
        ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData> replicas = new ArrayList<CollectionSnapshotMetaData.CoreSnapshotMetaData>();
        if (success != null) {
            for (int i = 0; i < success.size(); ++i) {
                NamedList resp = (NamedList)success.getVal(i);
                String string = (String)resp.get("core");
                Slice slice = (Slice)shardByCoreName.remove(string);
                boolean leader = slice.getLeader() != null && slice.getLeader().getCoreName().equals(string);
                resp.add("shard_id", (Object)slice.getName());
                resp.add("leader", (Object)leader);
                CollectionSnapshotMetaData.CoreSnapshotMetaData c = new CollectionSnapshotMetaData.CoreSnapshotMetaData(resp);
                replicas.add(c);
                log.info("Snapshot with commitName {} is created successfully for core {}", (Object)commitName, (Object)c.getCoreName());
            }
        }
        if (!shardByCoreName.isEmpty()) {
            log.warn("Unable to create a snapshot with name {} for following cores {}", (Object)commitName, shardByCoreName.keySet());
            HashMap<String, Integer> failuresByShardId = new HashMap<String, Integer>();
            for (Map.Entry entry : shardByCoreName.entrySet()) {
                int f = 0;
                if (failuresByShardId.get(((Slice)entry.getValue()).getName()) != null) {
                    f = (Integer)failuresByShardId.get(((Slice)entry.getValue()).getName());
                }
                failuresByShardId.put(((Slice)entry.getValue()).getName(), f + 1);
            }
            DocCollection collectionStatus = this.ocmh.zkStateReader.getClusterState().getCollection(collectionName);
            for (Map.Entry entry : failuresByShardId.entrySet()) {
                int replicaCount = collectionStatus.getSlice((String)entry.getKey()).getReplicas().size();
                if (replicaCount > (Integer)entry.getValue()) continue;
                failedShards.add(entry.getKey());
            }
        }
        if (!failedShards.isEmpty()) {
            log.warn("Failed to create a snapshot for collection {} with commitName = {}. Snapshot could not be captured for following shards {}", new Object[]{collectionName, commitName, failedShards});
            CollectionSnapshotMetaData meta = new CollectionSnapshotMetaData(commitName, CollectionSnapshotMetaData.SnapshotStatus.Failed, creationDate, replicas);
            SolrSnapshotManager.updateCollectionLevelSnapshot(zkClient, collectionName, meta);
            log.info("Saved following snapshot information for collection={} with commitName={} in Zookeeper : {}", new Object[]{collectionName, commitName, meta.toNamedList()});
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create snapshot on shards " + failedShards);
        }
        CollectionSnapshotMetaData meta = new CollectionSnapshotMetaData(commitName, CollectionSnapshotMetaData.SnapshotStatus.Successful, creationDate, replicas);
        SolrSnapshotManager.updateCollectionLevelSnapshot(zkClient, collectionName, meta);
        log.info("Saved following snapshot information for collection={} with commitName={} in Zookeeper : {}", new Object[]{collectionName, commitName, meta.toNamedList()});
    }
}

