/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.CollectionFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Repeater;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Traverser;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import java.util.Collection;

class CompositeInlineList
implements Repeater {
    private final CollectionFactory factory;
    private final Traverser root;
    private final String name;
    private final Type entry;
    private final Type type;

    public CompositeInlineList(Context context, Type type, Type type2, String string) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = type2;
        this.type = type;
        this.name = string;
    }

    public Object read(InputNode inputNode) {
        Object object = this.factory.getInstance();
        Collection collection = (Collection)object;
        if (collection != null) {
            return this.read(inputNode, collection);
        }
        return null;
    }

    public Object read(InputNode inputNode, Object object) {
        Collection collection = (Collection)object;
        if (collection != null) {
            return this.read(inputNode, collection);
        }
        return this.read(inputNode);
    }

    private Object read(InputNode inputNode, Collection collection) {
        InputNode inputNode2 = inputNode.getParent();
        String string = inputNode.getName();
        while (inputNode != null) {
            Class clazz = this.entry.getType();
            Object object = this.read(inputNode, clazz);
            if (object != null) {
                collection.add(object);
            }
            inputNode = inputNode2.getNext(string);
        }
        return collection;
    }

    private Object read(InputNode inputNode, Class clazz) {
        Object object = this.root.read(inputNode, clazz);
        Class<?> clazz2 = object.getClass();
        Class clazz3 = this.entry.getType();
        if (!clazz3.isAssignableFrom(clazz2)) {
            throw new PersistenceException("Entry %s does not match %s for %s", clazz2, this.entry, this.type);
        }
        return object;
    }

    public boolean validate(InputNode inputNode) {
        InputNode inputNode2 = inputNode.getParent();
        Class clazz = this.entry.getType();
        String string = inputNode.getName();
        while (inputNode != null) {
            boolean bl = this.root.validate(inputNode, clazz);
            if (!bl) {
                return false;
            }
            inputNode = inputNode2.getNext(string);
        }
        return true;
    }

    public void write(OutputNode outputNode, Object object) {
        Collection collection = (Collection)object;
        OutputNode outputNode2 = outputNode.getParent();
        if (!outputNode.isCommitted()) {
            outputNode.remove();
        }
        this.write(outputNode2, collection);
    }

    public void write(OutputNode outputNode, Collection collection) {
        for (Object e : collection) {
            Class<?> clazz;
            if (e == null) continue;
            Class clazz2 = this.entry.getType();
            if (!clazz2.isAssignableFrom(clazz = e.getClass())) {
                throw new PersistenceException("Entry %s does not match %s for %s", clazz, clazz2, this.type);
            }
            this.root.write(outputNode, e, clazz2, this.name);
        }
    }
}

