/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.CollapsingQParserPlugin;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpecParsing;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ExpandComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "expand";
    private static final int finishingStage = ResponseBuilder.STAGE_GET_FIELDS;
    private PluginInfo info = PluginInfo.EMPTY_INFO;

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.doExpand = true;
        }
    }

    @Override
    public void inform(SolrCore core) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        Object collector;
        String[] filters;
        Query query;
        List<Query> filters2;
        if (!rb.doExpand) {
            return;
        }
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String field = params.get("expand.field");
        String hint = null;
        if (field == null && (filters2 = rb.getFilters()) != null) {
            for (Query q : filters2) {
                if (!(q instanceof CollapsingQParserPlugin.CollapsingPostFilter)) continue;
                CollapsingQParserPlugin.CollapsingPostFilter cp = (CollapsingQParserPlugin.CollapsingPostFilter)q;
                field = cp.getField();
                hint = cp.hint;
            }
        }
        if (field == null) {
            throw new IOException("Expand field is null.");
        }
        String sortParam = params.get("expand.sort");
        String[] fqs = params.getParams("expand.fq");
        String qs = params.get("expand.q");
        int limit = params.getInt("expand.rows", 5);
        Sort sort = null;
        if (sortParam != null) {
            sort = SortSpecParsing.parseSortSpec(sortParam, rb.req).getSort();
        }
        if (qs == null) {
            query = rb.getQuery();
        } else {
            try {
                QParser parser = QParser.getParser(qs, req);
                query = parser.getQuery();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ArrayList<Query> newFilters = new ArrayList<Query>();
        if (fqs == null) {
            filters = rb.getFilters();
            if (filters != null) {
                for (Query query2 : filters) {
                    if (query2 instanceof CollapsingQParserPlugin.CollapsingPostFilter) continue;
                    newFilters.add(query2);
                }
            }
        } else {
            try {
                void var15_21;
                filters = fqs;
                int n = filters.length;
                boolean bl = false;
                while (var15_21 < n) {
                    String fq = filters[var15_21];
                    if (fq != null && fq.trim().length() != 0 && !fq.equals("*:*")) {
                        QParser fqp = QParser.getParser(fq, req);
                        newFilters.add(fqp.getQuery());
                    }
                    ++var15_21;
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        SolrIndexSearcher searcher = req.getSearcher();
        LeafReader reader = searcher.getSlowAtomicReader();
        SchemaField schemaField = searcher.getSchema().getField(field);
        FieldType fieldType = schemaField.getType();
        SortedDocValues values = null;
        long nullValue = 0L;
        if (fieldType instanceof StrField) {
            if ("top_fc".equals(hint)) {
                LeafReader uninvertingReader = CollapsingQParserPlugin.getTopFieldCacheReader(searcher, field);
                values = uninvertingReader.getSortedDocValues(field);
            } else {
                values = DocValues.getSorted((LeafReader)reader, (String)field);
            }
        } else {
            String defaultValue = searcher.getSchema().getField(field).getDefaultValue();
            NumberType numType = fieldType.getNumberType();
            if (defaultValue != null) {
                if (numType == NumberType.INTEGER) {
                    nullValue = Long.parseLong(defaultValue);
                } else if (numType == NumberType.FLOAT) {
                    nullValue = Float.floatToIntBits(Float.parseFloat(defaultValue));
                }
            } else if (NumberType.FLOAT.equals((Object)numType)) {
                nullValue = Float.floatToIntBits(0.0f);
            }
        }
        FixedBitSet groupBits = null;
        LongHashSet groupSet = null;
        DocList docList = rb.getResults().docList;
        IntHashSet collapsedSet = new IntHashSet(docList.size() * 2);
        DocIterator idit = docList.iterator();
        int[] globalDocs = new int[docList.size()];
        int docsIndex = -1;
        while (idit.hasNext()) {
            globalDocs[++docsIndex] = idit.nextDoc();
        }
        Arrays.sort(globalDocs);
        Query groupQuery = null;
        List contexts = searcher.getTopReaderContext().leaves();
        if (contexts.size() == 0) {
            return;
        }
        int currentContext = 0;
        int currentDocBase = ((LeafReaderContext)contexts.get((int)currentContext)).docBase;
        int nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
        IntObjectHashMap ordBytes = null;
        if (values != null) {
            groupBits = new FixedBitSet(values.getValueCount());
            OrdinalMap ordinalMap = null;
            SortedDocValues[] sortedDocValues = null;
            LongValues segmentOrdinalMap = null;
            SortedDocValues currentValues = null;
            if (values instanceof MultiDocValues.MultiSortedDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedDocValues)values).mapping;
                sortedDocValues = ((MultiDocValues.MultiSortedDocValues)values).values;
                currentValues = sortedDocValues[currentContext];
                segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
            }
            int count = 0;
            ordBytes = new IntObjectHashMap();
            for (int i = 0; i < globalDocs.length; ++i) {
                BytesRef ref;
                int ord;
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    int n = nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    if (ordinalMap == null) continue;
                    currentValues = sortedDocValues[currentContext];
                    segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (ordinalMap != null) {
                    if (contextDoc > currentValues.docID()) {
                        currentValues.advance(contextDoc);
                    }
                    if (contextDoc != currentValues.docID()) continue;
                    ord = currentValues.ordValue();
                    ++count;
                    ref = currentValues.lookupOrd(ord);
                    ord = (int)segmentOrdinalMap.get((long)ord);
                    ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                    groupBits.set(ord);
                    collapsedSet.add(globalDoc);
                    continue;
                }
                if (globalDoc > values.docID()) {
                    values.advance(globalDoc);
                }
                if (globalDoc != values.docID()) continue;
                ord = values.ordValue();
                ++count;
                ref = values.lookupOrd(ord);
                ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                groupBits.set(ord);
                collapsedSet.add(globalDoc);
            }
            if (count > 0 && count < 200) {
                try {
                    groupQuery = this.getGroupQuery(field, count, (IntObjectHashMap<BytesRef>)ordBytes);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        } else {
            groupSet = new LongHashSet(docList.size());
            NumericDocValues collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
            int count = 0;
            for (int i = 0; i < globalDocs.length; ++i) {
                long value;
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
                }
                int contextDoc = globalDoc - currentDocBase;
                int valueDocID = collapseValues.docID();
                if (valueDocID < contextDoc) {
                    valueDocID = collapseValues.advance(contextDoc);
                }
                if ((value = valueDocID == contextDoc ? collapseValues.longValue() : 0L) == nullValue) continue;
                ++count;
                groupSet.add(value);
                collapsedSet.add(globalDoc);
            }
            if (count > 0 && count < 200) {
                groupQuery = fieldType.isPointField() ? this.getPointGroupQuery(schemaField, count, groupSet) : this.getGroupQuery(field, fieldType, count, groupSet);
            }
        }
        if (sort != null) {
            sort = sort.rewrite((IndexSearcher)searcher);
        }
        GroupCollector groupExpandCollector = null;
        if (values != null) {
            if ("top_fc".equals(hint)) {
                LeafReader uninvertingReader = CollapsingQParserPlugin.getTopFieldCacheReader(searcher, field);
                values = uninvertingReader.getSortedDocValues(field);
            } else {
                values = DocValues.getSorted((LeafReader)reader, (String)field);
            }
            groupExpandCollector = new GroupExpandCollector(values, groupBits, collapsedSet, limit, sort);
        } else {
            groupExpandCollector = new NumericGroupExpandCollector(field, nullValue, groupSet, collapsedSet, limit, sort);
        }
        if (groupQuery != null) {
            newFilters.add(groupQuery);
        }
        SolrIndexSearcher.ProcessedFilter pfilter = searcher.getProcessedFilter(null, newFilters);
        if (pfilter.postFilter != null) {
            pfilter.postFilter.setLastDelegate(groupExpandCollector);
            collector = pfilter.postFilter;
        } else {
            collector = groupExpandCollector;
        }
        if (pfilter.filter == null) {
            searcher.search(query, (Collector)collector);
        } else {
            BooleanQuery q = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)pfilter.filter, BooleanClause.Occur.FILTER).build();
            searcher.search((Query)q, (Collector)collector);
        }
        LongObjectMap<Collector> groups = ((GroupCollector)groupExpandCollector).getGroups();
        SimpleOrderedMap outMap = new SimpleOrderedMap();
        CharsRefBuilder charsRef = new CharsRefBuilder();
        for (LongObjectCursor cursor : groups) {
            long groupValue = cursor.key;
            TopDocsCollector topDocsCollector = (TopDocsCollector)TopDocsCollector.class.cast(cursor.value);
            TopDocs topDocs = topDocsCollector.topDocs();
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (scoreDocs.length <= 0) continue;
            int[] docs = new int[scoreDocs.length];
            float[] scores = new float[scoreDocs.length];
            for (int i = 0; i < docs.length; ++i) {
                ScoreDoc scoreDoc = scoreDocs[i];
                docs[i] = scoreDoc.doc;
                scores[i] = scoreDoc.score;
            }
            assert (topDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
            DocSlice slice = new DocSlice(0, docs.length, docs, scores, topDocs.totalHits.value, Float.NaN);
            if (fieldType instanceof StrField) {
                BytesRef bytesRef = (BytesRef)ordBytes.get((int)groupValue);
                fieldType.indexedToReadable(bytesRef, charsRef);
                String group = charsRef.toString();
                outMap.add(group, (Object)slice);
                continue;
            }
            outMap.add(this.numericToString(fieldType, groupValue), (Object)slice);
        }
        rb.rsp.add("expanded", outMap);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.doExpand && rb.stage < finishingStage) {
            return finishingStage;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if (!rb.onePassDistributedQuery && (sreq.purpose & 0x40) == 0) {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"true"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doExpand) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            SolrQueryRequest req = rb.req;
            NamedList expanded = (NamedList)req.getContext().get("expanded");
            if (expanded == null) {
                expanded = new SimpleOrderedMap();
                req.getContext().put("expanded", expanded);
            }
            for (ShardResponse srsp : sreq.responses) {
                NamedList response = srsp.getSolrResponse().getResponse();
                NamedList ex = (NamedList)response.get("expanded");
                for (int i = 0; i < ex.size(); ++i) {
                    String name = ex.getName(i);
                    SolrDocumentList val = (SolrDocumentList)ex.getVal(i);
                    expanded.add(name, (Object)val);
                }
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doExpand) {
            return;
        }
        if (rb.stage != finishingStage) {
            return;
        }
        NamedList expanded = (NamedList)rb.req.getContext().get("expanded");
        if (expanded == null) {
            expanded = new SimpleOrderedMap();
        }
        rb.rsp.add("expanded", expanded);
    }

    private Query getGroupQuery(String fname, FieldType ft, int size, LongHashSet groupSet) {
        BytesRef[] bytesRefs = new BytesRef[size];
        BytesRefBuilder term = new BytesRefBuilder();
        Iterator it = groupSet.iterator();
        int index = -1;
        while (it.hasNext()) {
            LongCursor cursor = (LongCursor)it.next();
            String stringVal = this.numericToString(ft, cursor.value);
            ft.readableToIndexed(stringVal, term);
            bytesRefs[++index] = term.toBytesRef();
        }
        return new TermInSetQuery(fname, bytesRefs);
    }

    private Query getPointGroupQuery(SchemaField sf, int size, LongHashSet groupSet) {
        Iterator it = groupSet.iterator();
        ArrayList<String> values = new ArrayList<String>(size);
        FieldType ft = sf.getType();
        while (it.hasNext()) {
            LongCursor cursor = (LongCursor)it.next();
            values.add(this.numericToString(ft, cursor.value));
        }
        return sf.getType().getSetQuery(null, sf, values);
    }

    private String numericToString(FieldType fieldType, long val) {
        if (fieldType.getNumberType() != null) {
            switch (fieldType.getNumberType()) {
                case INTEGER: 
                case LONG: {
                    return Long.toString(val);
                }
                case FLOAT: {
                    return Float.toString(Float.intBitsToFloat((int)val));
                }
                case DOUBLE: {
                    return Double.toString(Double.longBitsToDouble(val));
                }
            }
        }
        throw new IllegalArgumentException("FieldType must be INT,LONG,FLOAT,DOUBLE found " + fieldType);
    }

    private Query getGroupQuery(String fname, int size, IntObjectHashMap<BytesRef> ordBytes) throws Exception {
        BytesRef[] bytesRefs = new BytesRef[size];
        int index = -1;
        for (IntObjectCursor cursor : ordBytes) {
            bytesRefs[++index] = (BytesRef)cursor.value;
        }
        return new TermInSetQuery(fname, bytesRefs);
    }

    @Override
    public String getDescription() {
        return "Expand Component";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    private static interface GroupCollector
    extends Collector {
        public LongObjectMap<Collector> getGroups();

        default public ScoreMode scoreMode() {
            LongObjectMap<Collector> groups = this.getGroups();
            if (groups.isEmpty()) {
                return ScoreMode.COMPLETE;
            }
            return ((Collector)((LongObjectCursor)groups.iterator().next()).value).scoreMode();
        }
    }

    private static class NumericGroupExpandCollector
    implements Collector,
    GroupCollector {
        private NumericDocValues docValues;
        private String field;
        private LongObjectHashMap<Collector> groups;
        private IntHashSet collapsedSet;
        private long nullValue;

        public NumericGroupExpandCollector(String field, long nullValue, LongHashSet groupSet, IntHashSet collapsedSet, int limit, Sort sort) throws IOException {
            int numGroups = collapsedSet.size();
            this.nullValue = nullValue;
            this.groups = new LongObjectHashMap(numGroups);
            for (LongCursor cursor : groupSet) {
                TopScoreDocCollector collector = sort == null ? TopScoreDocCollector.create((int)limit, (int)Integer.MAX_VALUE) : TopFieldCollector.create((Sort)sort, (int)limit, (int)Integer.MAX_VALUE);
                this.groups.put(cursor.value, (Object)collector);
            }
            this.field = field;
            this.collapsedSet = collapsedSet;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            this.docValues = context.reader().getNumericDocValues(this.field);
            final LongObjectHashMap leafCollectors = new LongObjectHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector(){

                public void setScorer(Scorable scorer) throws IOException {
                    for (ObjectCursor c : leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    int index;
                    long value = docValues.advanceExact(docId) ? docValues.longValue() : 0L;
                    if (value != nullValue && (index = leafCollectors.indexOf(value)) >= 0 && !collapsedSet.contains(docId + docBase)) {
                        ((LeafCollector)leafCollectors.indexGet(index)).collect(docId);
                    }
                }
            };
        }

        public LongObjectHashMap<Collector> getGroups() {
            return this.groups;
        }
    }

    private static class GroupExpandCollector
    implements Collector,
    GroupCollector {
        private SortedDocValues docValues;
        private OrdinalMap ordinalMap;
        private SortedDocValues segmentValues;
        private LongValues segmentOrdinalMap;
        private MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private LongObjectMap<Collector> groups;
        private FixedBitSet groupBits;
        private IntHashSet collapsedSet;

        public GroupExpandCollector(SortedDocValues docValues, FixedBitSet groupBits, IntHashSet collapsedSet, int limit, Sort sort) throws IOException {
            int group;
            int numGroups = collapsedSet.size();
            this.groups = new LongObjectHashMap(numGroups);
            BitSetIterator iterator = new BitSetIterator((BitSet)groupBits, 0L);
            while ((group = iterator.nextDoc()) != Integer.MAX_VALUE) {
                TopScoreDocCollector collector = sort == null ? TopScoreDocCollector.create((int)limit, (int)Integer.MAX_VALUE) : TopFieldCollector.create((Sort)sort, (int)limit, (int)Integer.MAX_VALUE);
                this.groups.put((long)group, (Object)collector);
            }
            this.collapsedSet = collapsedSet;
            this.groupBits = groupBits;
            this.docValues = docValues;
            if (docValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)docValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            int docBase = context.docBase;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            }
            LongObjectHashMap leafCollectors = new LongObjectHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector((LongObjectMap)leafCollectors, docBase){
                final /* synthetic */ LongObjectMap val$leafCollectors;
                final /* synthetic */ int val$docBase;
                {
                    this.val$leafCollectors = longObjectMap;
                    this.val$docBase = n;
                }

                public void setScorer(Scorable scorer) throws IOException {
                    for (ObjectCursor c : this.val$leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    int globalDoc = docId + this.val$docBase;
                    int ord = -1;
                    if (ordinalMap != null) {
                        if (docId > segmentValues.docID()) {
                            segmentValues.advance(docId);
                        }
                        ord = docId == segmentValues.docID() ? (int)segmentOrdinalMap.get((long)segmentValues.ordValue()) : -1;
                    } else {
                        ord = docValues.advanceExact(globalDoc) ? docValues.ordValue() : -1;
                    }
                    if (ord > -1 && groupBits.get(ord) && !collapsedSet.contains(globalDoc)) {
                        LeafCollector c = (LeafCollector)this.val$leafCollectors.get((long)ord);
                        c.collect(docId);
                    }
                }
            };
        }

        @Override
        public LongObjectMap<Collector> getGroups() {
            return this.groups;
        }
    }
}

