/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.AbstractSubTypeFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.LatLonValueSource;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialDistanceQuery;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.SpatialUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

@Deprecated
public class LatLonType
extends AbstractSubTypeFieldType
implements SpatialQueryable {
    protected static final int LAT = 0;
    protected static final int LON = 1;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.createSuffixCache(3);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value) {
        String externalVal = value.toString();
        ArrayList<IndexableField> f = new ArrayList<IndexableField>(3);
        if (field.indexed()) {
            Point point = SpatialUtils.parsePointSolrException(externalVal, SpatialContext.GEO);
            SchemaField subLatSF = this.subField(field, 0, this.schema);
            f.addAll(subLatSF.createFields(String.valueOf(point.getY())));
            SchemaField subLonSF = this.subField(field, 1, this.schema);
            f.addAll(subLonSF.createFields(String.valueOf(point.getX())));
        }
        if (field.stored()) {
            f.add(this.createField(field.getName(), externalVal, (IndexableFieldType)StoredField.TYPE));
        }
        return f;
    }

    @Override
    protected void checkSupportsDocValues() {
        if (!this.hasProperty(32768)) {
            throw new UnsupportedOperationException("LatLonType can't have docValues=true in the field definition, use docValues=true in the fieldType definition, or in subFieldType/subFieldSuffix");
        }
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        Point p1 = SpatialUtils.parsePointSolrException(part1, SpatialContext.GEO);
        Point p2 = SpatialUtils.parsePointSolrException(part2, SpatialContext.GEO);
        SchemaField latSF = this.subField(field, 0, parser.getReq().getSchema());
        SchemaField lonSF = this.subField(field, 1, parser.getReq().getSchema());
        BooleanQuery.Builder result = new BooleanQuery.Builder();
        result.add(latSF.getType().getRangeQuery(parser, latSF, Double.toString(p1.getY()), Double.toString(p2.getY()), minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        result.add(lonSF.getType().getRangeQuery(parser, lonSF, Double.toString(p1.getX()), Double.toString(p2.getX()), minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        return result.build();
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        Point p1 = SpatialUtils.parsePointSolrException(externalVal, SpatialContext.GEO);
        SchemaField latSF = this.subField(field, 0, parser.getReq().getSchema());
        SchemaField lonSF = this.subField(field, 1, parser.getReq().getSchema());
        BooleanQuery.Builder result = new BooleanQuery.Builder();
        result.add(latSF.getType().getFieldQuery(parser, latSF, Double.toString(p1.getY())), BooleanClause.Occur.MUST);
        result.add(lonSF.getType().getFieldQuery(parser, lonSF, Double.toString(p1.getX())), BooleanClause.Occur.MUST);
        return result.build();
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double lon2Max;
        double lon2Min;
        double lonMax;
        double lonMin;
        Point point = SpatialUtils.parsePointSolrException(options.pointStr, SpatialContext.GEO);
        double latCenter = point.getY();
        double lonCenter = point.getX();
        double distDeg = DistanceUtils.dist2Degrees((double)options.distance, (double)options.radius);
        Rectangle bbox = DistanceUtils.calcBoxByDistFromPtDEG((double)latCenter, (double)lonCenter, (double)distDeg, (SpatialContext)SpatialContext.GEO, null);
        double latMin = bbox.getMinY();
        double latMax = bbox.getMaxY();
        if (bbox.getCrossesDateLine()) {
            lonMin = -180.0;
            lonMax = bbox.getMaxX();
            lon2Min = bbox.getMinX();
            lon2Max = 180.0;
        } else {
            lonMin = bbox.getMinX();
            lonMax = bbox.getMaxX();
            lon2Min = -180.0;
            lon2Max = 180.0;
        }
        IndexSchema schema = parser.getReq().getSchema();
        SchemaField latSF = this.subField(options.field, 0, schema);
        SchemaField lonSF = this.subField(options.field, 1, schema);
        SpatialDistanceQuery spatial = new SpatialDistanceQuery();
        if (options.bbox) {
            BooleanQuery.Builder result = new BooleanQuery.Builder();
            Query latRange = latSF.getType().getRangeQuery(parser, latSF, String.valueOf(latMin), String.valueOf(latMax), true, true);
            result.add(latRange, BooleanClause.Occur.MUST);
            if (lonMin != -180.0 || lonMax != 180.0) {
                Query lonRange = lonSF.getType().getRangeQuery(parser, lonSF, String.valueOf(lonMin), String.valueOf(lonMax), true, true);
                if (lon2Min != -180.0 || lon2Max != 180.0) {
                    BooleanQuery.Builder bothLons = new BooleanQuery.Builder();
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = lonSF.getType().getRangeQuery(parser, lonSF, String.valueOf(lon2Min), String.valueOf(lon2Max), true, true);
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = bothLons.build();
                }
                result.add(lonRange, BooleanClause.Occur.MUST);
            }
            spatial.bboxQuery = result.build();
        }
        spatial.origField = options.field.getName();
        spatial.latSource = latSF.getType().getValueSource(latSF, parser);
        spatial.lonSource = lonSF.getType().getValueSource(lonSF, parser);
        spatial.latMin = latMin;
        spatial.latMax = latMax;
        spatial.lonMin = lonMin;
        spatial.lonMax = lonMax;
        spatial.lon2Min = lon2Min;
        spatial.lon2Max = lon2Max;
        spatial.lon2 = lon2Min != -180.0 || lon2Max != 180.0;
        spatial.latCenter = latCenter;
        spatial.lonCenter = lonCenter;
        spatial.dist = options.distance;
        spatial.planetRadius = options.radius;
        spatial.calcDist = !options.bbox;
        return spatial;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        ArrayList<ValueSource> vs = new ArrayList<ValueSource>(2);
        for (int i = 0; i < 2; ++i) {
            SchemaField sub = this.subField(field, i, this.schema);
            vs.add(sub.getType().getValueSource(sub, parser));
        }
        return new LatLonValueSource(field, vs);
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on LatLonType " + field.getName());
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        throw new UnsupportedOperationException("LatLonType uses multiple fields.  field=" + field.getName());
    }

    @Override
    public double getSphereRadius() {
        return 6371.0087714;
    }
}

