/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Winsvc;
import java.io.File;
import java.net.URISyntaxException;
import jnr.posix.POSIXFactory;

public abstract class WindowsService {
    private static final Advapi32 ADVAPI_32 = Advapi32.INSTANCE;
    private final Object waitObject = new Object();
    private String serviceName;
    private ServiceMain serviceMain;
    private ServiceControl serviceControl;
    private Winsvc.SERVICE_STATUS_HANDLE serviceStatusHandle;

    public WindowsService(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean install(String displayName, String description, String[] dependencies, String account, String password, String config) throws URISyntaxException {
        String javaHome = System.getProperty("java.home");
        String javaBinary = javaHome + "\\bin\\java.exe";
        File jar = new File(WindowsService.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        String command = javaBinary + " -Duser.dir=\"" + jar.getAbsolutePath() + "\" -jar \"" + jar.getParentFile().getAbsolutePath() + "\" --service \"" + config + "\"";
        boolean success = false;
        StringBuilder dep = new StringBuilder();
        if (dependencies != null) {
            for (String s : dependencies) {
                dep.append(s);
                dep.append("\u0000");
            }
        }
        dep.append("\u0000");
        Winsvc.SERVICE_DESCRIPTION desc = new Winsvc.SERVICE_DESCRIPTION();
        desc.lpDescription = description;
        Winsvc.SC_HANDLE serviceManager = this.openServiceControlManager(null, 983103);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = ADVAPI_32.CreateService(serviceManager, this.serviceName, displayName, 983551, 16, 2, 1, command, null, null, dep.toString(), account, password);
            if (service != null) {
                success = ADVAPI_32.ChangeServiceConfig2(service, 1, (Winsvc.ChangeServiceConfig2Info)desc);
                ADVAPI_32.CloseServiceHandle(service);
            }
            ADVAPI_32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean uninstall() {
        boolean success = false;
        Winsvc.SC_HANDLE serviceManager = this.openServiceControlManager(null, 983103);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = ADVAPI_32.OpenService(serviceManager, this.serviceName, 983551);
            if (service != null) {
                success = ADVAPI_32.DeleteService(service);
                ADVAPI_32.CloseServiceHandle(service);
            }
            ADVAPI_32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean start() {
        boolean success = false;
        Winsvc.SC_HANDLE serviceManager = this.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = ADVAPI_32.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                success = ADVAPI_32.StartService(service, 0, null);
                ADVAPI_32.CloseServiceHandle(service);
            }
            ADVAPI_32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean stop() {
        boolean success = false;
        Winsvc.SC_HANDLE serviceManager = this.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Winsvc.SC_HANDLE service = Advapi32.INSTANCE.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                Winsvc.SERVICE_STATUS serviceStatus = new Winsvc.SERVICE_STATUS();
                success = Advapi32.INSTANCE.ControlService(service, 1, serviceStatus);
                Advapi32.INSTANCE.CloseServiceHandle(service);
            }
            Advapi32.INSTANCE.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public void init() throws URISyntaxException {
        String path = new File(WindowsService.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        POSIXFactory.getPOSIX().chdir(path);
        this.serviceMain = new ServiceMain();
        Winsvc.SERVICE_TABLE_ENTRY entry = new Winsvc.SERVICE_TABLE_ENTRY();
        entry.lpServiceName = this.serviceName;
        entry.lpServiceProc = this.serviceMain;
        Advapi32.INSTANCE.StartServiceCtrlDispatcher((Winsvc.SERVICE_TABLE_ENTRY[])entry.toArray(2));
    }

    private Winsvc.SC_HANDLE openServiceControlManager(String machine, int access) {
        return ADVAPI_32.OpenSCManager(machine, null, access);
    }

    private void reportStatus(int status, int win32ExitCode, int waitHint) {
        Winsvc.SERVICE_STATUS serviceStatus = new Winsvc.SERVICE_STATUS();
        serviceStatus.dwServiceType = 16;
        serviceStatus.dwControlsAccepted = 5;
        serviceStatus.dwWin32ExitCode = win32ExitCode;
        serviceStatus.dwWaitHint = waitHint;
        serviceStatus.dwCurrentState = status;
        ADVAPI_32.SetServiceStatus(this.serviceStatusHandle, serviceStatus);
    }

    public abstract void run();

    private class ServiceControl
    implements Winsvc.HandlerEx {
        private ServiceControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int callback(int dwControl, int dwEventType, Pointer lpEventData, Pointer lpContext) {
            switch (dwControl) {
                case 1: 
                case 5: {
                    WindowsService.this.reportStatus(3, 0, 5000);
                    Object object = WindowsService.this.waitObject;
                    synchronized (object) {
                        WindowsService.this.waitObject.notifyAll();
                        break;
                    }
                }
            }
            return 0;
        }
    }

    private class ServiceMain
    implements Winsvc.SERVICE_MAIN_FUNCTION {
        private ServiceMain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(int dwArgc, Pointer lpszArgv) {
            WindowsService.this.serviceControl = new ServiceControl();
            WindowsService.this.serviceStatusHandle = ADVAPI_32.RegisterServiceCtrlHandlerEx(WindowsService.this.serviceName, (Winsvc.HandlerEx)WindowsService.this.serviceControl, null);
            WindowsService.this.reportStatus(2, 0, 3000);
            WindowsService.this.reportStatus(4, 0, 0);
            Thread.currentThread().setContextClassLoader(WindowsService.class.getClassLoader());
            WindowsService.this.run();
            try {
                Object object = WindowsService.this.waitObject;
                synchronized (object) {
                    WindowsService.this.waitObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            WindowsService.this.reportStatus(1, 0, 0);
            System.exit(0);
        }
    }
}

