/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.helper.DateUtil;
import org.traccar.model.Statistics;

public class StatisticsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);
    private static final int SPLIT_MODE = 5;
    private AtomicInteger lastUpdate = new AtomicInteger(Calendar.getInstance().get(5));
    private Set<Long> users = new HashSet<Long>();
    private Set<Long> devices = new HashSet<Long>();
    private int requests;
    private int messagesReceived;
    private int messagesStored;
    private int mailSent;
    private int smsSent;
    private int geocoderRequests;
    private int geolocationRequests;

    private void checkSplit() {
        int currentUpdate = Calendar.getInstance().get(5);
        if (this.lastUpdate.getAndSet(currentUpdate) != currentUpdate) {
            Statistics statistics = new Statistics();
            statistics.setCaptureTime(new Date());
            statistics.setActiveUsers(this.users.size());
            statistics.setActiveDevices(this.devices.size());
            statistics.setRequests(this.requests);
            statistics.setMessagesReceived(this.messagesReceived);
            statistics.setMessagesStored(this.messagesStored);
            statistics.setMailSent(this.mailSent);
            statistics.setSmsSent(this.smsSent);
            statistics.setGeocoderRequests(this.geocoderRequests);
            statistics.setGeolocationRequests(this.geolocationRequests);
            try {
                Context.getDataManager().addObject(statistics);
            }
            catch (SQLException e) {
                LOGGER.warn("Error saving statistics", (Throwable)e);
            }
            String url = Context.getConfig().getString("server.statistics");
            if (url != null) {
                String time = DateUtil.formatDate(statistics.getCaptureTime());
                Form form = new Form();
                form.param("version", Context.getAppVersion());
                form.param("captureTime", time);
                form.param("activeUsers", String.valueOf(statistics.getActiveUsers()));
                form.param("activeDevices", String.valueOf(statistics.getActiveDevices()));
                form.param("requests", String.valueOf(statistics.getRequests()));
                form.param("messagesReceived", String.valueOf(statistics.getMessagesReceived()));
                form.param("messagesStored", String.valueOf(statistics.getMessagesStored()));
                form.param("mailSent", String.valueOf(statistics.getMailSent()));
                form.param("smsSent", String.valueOf(statistics.getSmsSent()));
                form.param("geocoderRequests", String.valueOf(statistics.getGeocoderRequests()));
                form.param("geolocationRequests", String.valueOf(statistics.getGeolocationRequests()));
                Context.getClient().target(url).request().async().post(Entity.form((Form)form));
            }
            this.users.clear();
            this.devices.clear();
            this.requests = 0;
            this.messagesReceived = 0;
            this.messagesStored = 0;
            this.mailSent = 0;
            this.smsSent = 0;
            this.geocoderRequests = 0;
            this.geolocationRequests = 0;
        }
    }

    public synchronized void registerRequest(long userId) {
        this.checkSplit();
        ++this.requests;
        if (userId != 0L) {
            this.users.add(userId);
        }
    }

    public synchronized void registerMessageReceived() {
        this.checkSplit();
        ++this.messagesReceived;
    }

    public synchronized void registerMessageStored(long deviceId) {
        this.checkSplit();
        ++this.messagesStored;
        if (deviceId != 0L) {
            this.devices.add(deviceId);
        }
    }

    public synchronized void registerMail() {
        this.checkSplit();
        ++this.mailSent;
    }

    public synchronized void registerSms() {
        this.checkSplit();
        ++this.smsSent;
    }

    public synchronized void registerGeocoderRequest() {
        this.checkSplit();
        ++this.geocoderRequests;
    }

    public synchronized void registerGeolocationRequest() {
        this.checkSplit();
        ++this.geolocationRequests;
    }
}

