/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Invocation;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;

public abstract class EventForwarder {
    private final String url = Context.getConfig().getString("event.forward.url", "http://localhost/");
    private final String header = Context.getConfig().getString("event.forward.header");
    private static final String KEY_POSITION = "position";
    private static final String KEY_EVENT = "event";
    private static final String KEY_GEOFENCE = "geofence";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_MAINTENANCE = "maintenance";
    private static final String KEY_USERS = "users";

    public final void forwardEvent(Event event, Position position, Set<Long> users) {
        Invocation.Builder requestBuilder = Context.getClient().target(this.url).request();
        if (this.header != null && !this.header.isEmpty()) {
            for (Map.Entry entry : this.splitKeyValues(this.header, ":").entries()) {
                requestBuilder = requestBuilder.header((String)entry.getKey(), entry.getValue());
            }
        }
        this.executeRequest(event, position, users, requestBuilder.async());
    }

    protected MultiValuedMap<String, String> splitKeyValues(String params, String separator) {
        ArrayListValuedHashMap data = new ArrayListValuedHashMap();
        for (String line : params.split("\\r?\\n")) {
            String[] values = line.split(separator, 2);
            if (values.length != 2) continue;
            data.put((Object)values[0].trim(), (Object)values[1].trim());
        }
        return data;
    }

    protected Map<String, Object> preparePayload(Event event, Position position, Set<Long> users) {
        Maintenance maintenance;
        Geofence geofence;
        Device device;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_EVENT, event);
        if (position != null) {
            data.put(KEY_POSITION, position);
        }
        if ((device = Context.getIdentityManager().getById(event.getDeviceId())) != null) {
            data.put(KEY_DEVICE, device);
        }
        if (event.getGeofenceId() != 0L && (geofence = (Geofence)Context.getGeofenceManager().getById(event.getGeofenceId())) != null) {
            data.put(KEY_GEOFENCE, geofence);
        }
        if (event.getMaintenanceId() != 0L && (maintenance = (Maintenance)Context.getMaintenancesManager().getById(event.getMaintenanceId())) != null) {
            data.put(KEY_MAINTENANCE, maintenance);
        }
        data.put(KEY_USERS, Context.getUsersManager().getItems(users));
        return data;
    }

    protected abstract void executeRequest(Event var1, Position var2, Set<Long> var3, AsyncInvoker var4);
}

