/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class BoxProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("L,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").text("G,").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*),").number("(d+),").number("(d+)").any().compile();

    public BoxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("H,")) {
            int index = sentence.indexOf(44, 2) + 1;
            String id = sentence.substring(index, sentence.indexOf(44, index));
            this.getDeviceSession(channel, remoteAddress, id);
        } else if (sentence.startsWith("E,")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("A," + sentence.substring(2) + "\r", remoteAddress));
            }
        } else if (sentence.startsWith("L,")) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Parser parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(parser.nextDateTime());
            position.setLatitude(parser.nextDouble(0.0));
            position.setLongitude(parser.nextDouble(0.0));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.setCourse(parser.nextDouble(0.0));
            position.set("tripOdometer", parser.nextDouble(0.0) * 1000.0);
            position.set("event", parser.next());
            int status = parser.nextInt(0);
            position.setValid((status & 4) == 0);
            position.set("status", status);
            return position;
        }
        return null;
    }
}

