/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class UproProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_HEADER = new PatternBuilder().text("*").expression("(..20)").expression("([01])").number("(d+),").expression("(.)").expression("(.)").any().compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(dd)(dd)(dd)").number("(dd)(dd)(dddd)").number("(ddd)(dd)(dddd)").number("(d)").number("(dd)").number("(dd)").number("(dd)(dd)(dd)").compile();

    public UproProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeLocation(Position position, String data) {
        Parser parser = new Parser(PATTERN_LOCATION, data);
        if (parser.matches()) {
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setValid(true);
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            int flags = parser.nextInt(0);
            position.setValid(BitUtil.check(flags, 0));
            if (!BitUtil.check(flags, 1)) {
                position.setLatitude(-position.getLatitude());
            }
            if (!BitUtil.check(flags, 2)) {
                position.setLongitude(-position.getLongitude());
            }
            position.setSpeed(parser.nextInt(0) * 2);
            position.setCourse(parser.nextInt(0) * 10);
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String header;
        Parser parser;
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) != 42) {
            return null;
        }
        int headerIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
        if (headerIndex < 0) {
            headerIndex = buf.writerIndex();
        }
        if (!(parser = new Parser(PATTERN_HEADER, header = buf.readSlice(headerIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII))).matches()) {
            return null;
        }
        String head = parser.next();
        boolean reply = parser.next().equals("1");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = parser.next();
        String subtype = parser.next();
        if (reply && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("*" + head + "Y" + type + subtype + "#", remoteAddress));
        }
        while (buf.isReadable()) {
            buf.readByte();
            byte dataType = buf.readByte();
            int delimiterIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
            if (delimiterIndex < 0) {
                delimiterIndex = buf.writerIndex();
            }
            ByteBuf data = buf.readSlice(delimiterIndex - buf.readerIndex());
            switch (dataType) {
                case 65: {
                    this.decodeLocation(position, data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 66: {
                    position.set("status", data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 67: {
                    long odometer = 0L;
                    while (data.isReadable()) {
                        odometer <<= 4;
                        odometer += (long)(data.readByte() - 48);
                    }
                    position.set("odometer", odometer * 2L * 1852L / 3600L);
                    break;
                }
                case 70: {
                    position.setSpeed((double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 75: {
                    position.set("statusExtended", data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 80: {
                    if (data.readableBytes() < 16) break;
                    position.setNetwork(new Network(CellTower.from(Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16))));
                    break;
                }
                case 81: {
                    position.set("obdPid", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 82: {
                    if (head.startsWith("HQ")) {
                        position.set("rssi", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        position.set("sat", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        break;
                    }
                    position.set("odbTravel", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 83: {
                    position.set("obdTraffic", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 84: {
                    position.set("batteryLevel", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 86: {
                    position.set("power", (double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
            }
        }
        if (position.getLatitude() != 0.0 && position.getLongitude() != 0.0) {
            return position;
        }
        return null;
    }
}

