/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.arnx.jsonic.JSON;

public class GatewayFilter
implements Filter {
    public static final String GATEWAY_KEY = Config.class.getName();
    Map<Pattern, Config> locations = new LinkedHashMap<Pattern, Config>();
    ServletContext context;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        JSON json = new JSON();
        json.setContext(this);
        String configText = filterConfig.getInitParameter("config");
        if (configText == null) {
            configText = "";
        }
        Map map = json.parse((CharSequence)configText, Map.class);
        LinkedHashMap baseMap = new LinkedHashMap();
        for (Field field : Config.class.getFields()) {
            baseMap.put(field.getName(), map.get(field.getName()));
        }
        Config base = (Config)json.convert(baseMap, (Type)((Object)Config.class));
        for (Map.Entry entry : map.entrySet()) {
            if (baseMap.containsKey(entry.getKey()) || !(entry.getValue() instanceof Map)) continue;
            Map valueMap = (Map)entry.getValue();
            for (Map.Entry baseEntry : baseMap.entrySet()) {
                if (valueMap.get(baseEntry.getKey()) != null) continue;
                valueMap.put(baseEntry.getKey(), baseEntry.getValue());
            }
            Config config = (Config)json.convert(valueMap, (Type)((Object)Config.class));
            this.locations.put(Pattern.compile("^" + entry.getKey() + "$"), config);
        }
        this.locations.put(Pattern.compile(".*"), base);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(GATEWAY_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
        String path = request.getContextPath().equals("/") ? request.getRequestURI() : request.getRequestURI().substring(request.getContextPath().length());
        Matcher matcher = null;
        Config config = null;
        for (Map.Entry<Pattern, Config> entry : this.locations.entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher m = pattern.matcher(path);
            if (!m.matches()) continue;
            matcher = m;
            config = entry.getValue();
            break;
        }
        URI dest = null;
        if (config.access != null) {
            boolean access = false;
            for (String role : config.access) {
                if (!request.isUserInRole(role)) continue;
                access = true;
                break;
            }
            if (!access) {
                response.sendError(403, "Forbidden");
                return;
            }
        }
        if (config.encoding != null) {
            request.setCharacterEncoding(config.encoding);
            response.setCharacterEncoding(config.encoding);
        }
        if (config.locale != null) {
            response.setLocale(config.locale);
        }
        if (config.expire != null && config.expire.booleanValue()) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
        if (config.compression != null && config.compression.booleanValue()) {
            Enumeration<String> e = request.getHeaders("Accept-Encoding");
            while (e.hasMoreElements()) {
                String header = e.nextElement();
                if (header.indexOf("gzip") == -1) continue;
                response.setHeader("Content-Encoding", header.indexOf("x-gzip") != -1 ? "x-gzip" : "gzip");
                response = new GZIPResponse(response);
                break;
            }
        }
        if (config.forward != null) {
            try {
                dest = new URI(matcher.replaceAll(config.forward));
            }
            catch (URISyntaxException e) {
                throw new ServletException(e);
            }
        }
        request.setAttribute(GATEWAY_KEY, config);
        if (dest != null) {
            RequestDispatcher dispatcher = this.context.getRequestDispatcher(dest.toString());
            dispatcher.forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
        if (response instanceof GZIPResponse) {
            ((GZIPResponse)response).close();
        }
    }

    @Override
    public void destroy() {
        this.locations = null;
    }

    class GZIPResponse
    extends HttpServletResponseWrapper {
        ServletOutputStream out;
        PrintWriter writer;

        public GZIPResponse(HttpServletResponse response) {
            super(response);
            this.out = null;
            this.writer = null;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            if (this.out == null) {
                this.out = new ServletOutputStream(){
                    GZIPOutputStream cout;
                    {
                        this.cout = new GZIPOutputStream(GZIPResponse.super.getOutputStream());
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.cout.write(b, off, len);
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.cout.write(b);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.cout.write(b);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.cout.flush();
                    }

                    @Override
                    public void close() throws IOException {
                        this.cout.close();
                    }
                };
            }
            return this.out;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            } else if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }

    class Config {
        public String encoding = null;
        public Boolean compression = false;
        public Boolean expire = false;
        public String forward = null;
        public Set<String> access = null;
        public Locale locale = null;

        Config() {
        }
    }
}

