/***************************************************************************
                          cquerymanager.h  -  description
                             -------------------
    begin                : Sat Jun 8 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CQUERYMANAGER_H
#define CQUERYMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csocket.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/cstringlist.h>
#include <dclib/core/ccallback.h>

class CStringList;
class CMessageSearch;

class DLL_EXPORT CQueryObject : public CObject {
public:
	/** */
	CQueryObject()
	{
		pMessageSearch = 0;
	};
	/** */
	virtual ~CQueryObject()
	{
		if ( pMessageSearch )
			delete pMessageSearch;
	};

	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	CString sNick;
	/** */
	CMessageSearch * pMessageSearch;
	/** */
	time_t tTimeout;
};

class DLL_EXPORT CQueryResultObject : public CObject {
public:
	/** */
	CQueryResultObject() {};
	/** */
	virtual ~CQueryResultObject() {};

	/** */
	CString ID;
	/** */
	int iDepth;
};

class DLL_EXPORT CQuerySendObject : public CObject {
public:
	/** */
	CQuerySendObject() {
		m_pSocket = 0;
		m_pList   = new CStringList();
		m_nPort   = 0;
	}
	/** */
	virtual ~CQuerySendObject() {
		if ( m_pSocket )
			delete m_pSocket;
		if ( m_pList )
			delete m_pList;
	}

	/** */
	CSocket * m_pSocket;
	/** */
	CStringList * m_pList;
	/** */
	CString m_sSource;
	/** */
	int m_nPort;
};

class CQueryManager;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CQueryManager>;
template class DLL_EXPORT CCallback<CQueryManager>;
#endif

typedef enum eSearchStat {
	essCOUNTACTIVE=0,
	essCOUNTPASSIVE,
	essCOUNTREJECT,
	essCOUNTERROR,
	essRESULTCOUNT,
	essRESULTCOUNTERROR
};

class CFileBaseObject;

class DLL_EXPORT CQueryManager : public CSingleton<CQueryManager>, public CObject {
public:
	/** */
	CQueryManager();
	/** */
	virtual ~CQueryManager();

	/* */
	bool SearchQuery( CString hubname, CString hubhost, CString nick, CMessageSearch * msg );

	/** */
	ulonglong GetStat( enum eSearchStat e );
private:
	/** callbackfunction */
	int Callback( CObject *, CObject * );
	/** */
	void HandleQuery( CQueryObject * queryobject );
	/** */
	bool CheckSize( CQueryObject * queryobject, struct filebaseobject * fbo );
	/** */
	bool CheckType( CQueryObject * queryobject, struct filebaseobject * fbo );
	/** */
	bool AddResult( CQuerySendObject * querysendobject, CQueryObject * queryobject, 
		struct filebaseobject * fbo, CString filename, CString hash = "" );
	/** */
	void GetResults( CString s, CStringList * resultlist );
	/** */
	void SendResults();

	/** */
	friend class CSingleton<CQueryManager>;

	/** */
	_CCallback * m_pCallback;

	/** the search queue */
	CThreadList<CQueryObject> * m_pQueryQueue;
	/** */
	CThreadList<CQuerySendObject> * m_pQuerySendList;

	/** */
	ulonglong m_nSearchCountActive;
	/** */
	ulonglong m_nSearchCountPassive;
	/** */
	ulonglong m_nSearchCountReject;
	/** */
	ulonglong m_nSearchCountError;
	/** */
	ulonglong m_nResultCount;
	/** */
	ulonglong m_nResultCountError;
};

#endif
