/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.lang.CPStringBuilder;
import gnu.java.text.FormatBuffer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedFormatBuffer
implements FormatBuffer {
    private final CPStringBuilder buffer;
    private final ArrayList<Integer> ranges;
    private final ArrayList<Map<AttributedCharacterIterator.Attribute, Object>> attributes;
    private int[] aRanges;
    private List<Map<AttributedCharacterIterator.Attribute, Object>> aAttributes;
    private int startingRange;
    AttributedCharacterIterator.Attribute defaultAttr;

    public AttributedFormatBuffer(CPStringBuilder buffer) {
        this.buffer = new CPStringBuilder(buffer);
        this.ranges = new ArrayList();
        this.attributes = new ArrayList();
        this.defaultAttr = null;
        if (buffer.length() != 0) {
            this.startingRange = buffer.length();
            this.addAttribute(buffer.length(), null);
        } else {
            this.startingRange = -1;
        }
    }

    public AttributedFormatBuffer(int prebuffer) {
        this(new CPStringBuilder(prebuffer));
    }

    public AttributedFormatBuffer() {
        this(10);
    }

    private final void addAttribute(int newRange, AttributedCharacterIterator.Attribute attr) {
        if (attr != null) {
            HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute> map = new HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute>();
            map.put(attr, attr);
            this.attributes.add(map);
        } else {
            this.attributes.add(null);
        }
        this.ranges.add(newRange);
    }

    @Override
    public void append(String s) {
        if (this.startingRange < 0) {
            this.startingRange = 0;
        }
        this.buffer.append(s);
    }

    @Override
    public void append(String s, AttributedCharacterIterator.Attribute attr) {
        this.setDefaultAttribute(attr);
        this.startingRange = this.buffer.length();
        this.append(s);
        this.setDefaultAttribute(null);
    }

    @Override
    public void append(String s, int[] ranges, List<Map<AttributedCharacterIterator.Attribute, Object>> attrs) {
        int curPos = this.buffer.length();
        this.setDefaultAttribute(null);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.length) {
                this.ranges.add(ranges[i] + curPos);
                this.attributes.add(attrs.get(i));
                ++i;
            }
        }
        this.startingRange = this.buffer.length();
        this.buffer.append(s);
    }

    @Override
    public void append(char c) {
        if (this.startingRange < 0) {
            this.startingRange = this.buffer.length();
        }
        this.buffer.append(c);
    }

    @Override
    public void append(char c, AttributedCharacterIterator.Attribute attr) {
        this.setDefaultAttribute(attr);
        this.buffer.append(c);
        this.setDefaultAttribute(null);
    }

    @Override
    public void setDefaultAttribute(AttributedCharacterIterator.Attribute attr) {
        if (attr == this.defaultAttr) {
            return;
        }
        int currentPos = this.buffer.length();
        if (this.startingRange != currentPos && this.startingRange >= 0) {
            this.addAttribute(currentPos, this.defaultAttr);
        }
        this.defaultAttr = attr;
        this.startingRange = currentPos;
    }

    @Override
    public AttributedCharacterIterator.Attribute getDefaultAttribute() {
        return this.defaultAttr;
    }

    @Override
    public void cutTail(int length) {
        this.buffer.setLength(this.buffer.length() - length);
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public void clear() {
        this.buffer.setLength(0);
        this.ranges.clear();
        this.attributes.clear();
        this.defaultAttr = null;
        this.startingRange = -1;
    }

    public void sync() {
        if (this.startingRange < 0 || this.startingRange == this.buffer.length()) {
            return;
        }
        this.addAttribute(this.buffer.length(), this.defaultAttr);
        this.aRanges = new int[this.ranges.size()];
        int i = 0;
        while (i < this.aRanges.length) {
            this.aRanges[i] = this.ranges.get(i);
            ++i;
        }
        this.aAttributes = new ArrayList<Map<AttributedCharacterIterator.Attribute, Object>>(this.attributes);
    }

    public CPStringBuilder getBuffer() {
        return this.buffer;
    }

    public int[] getRanges() {
        return this.aRanges;
    }

    public List<Map<AttributedCharacterIterator.Attribute, Object>> getAttributes() {
        return this.aAttributes;
    }
}

