/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.BorderWidth;
import gnu.javax.swing.text.html.css.CSSColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;

class CSSBorder
implements Border {
    private static final int STYLE_NOT_SET = -1;
    private static final int STYLE_NONE = 0;
    private static final int STYLE_HIDDEN = 1;
    private static final int STYLE_DOTTED = 2;
    private static final int STYLE_DASHED = 3;
    private static final int STYLE_SOLID = 4;
    private static final int STYLE_DOUBLE = 5;
    private static final int STYLE_GROOVE = 6;
    private static final int STYLE_RIDGE = 7;
    private static final int STYLE_INSET = 8;
    private static final int STYLE_OUTSET = 9;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int leftStyle;
    private int rightStyle;
    private int topStyle;
    private Color topColor;
    private Color bottomColor;
    private Color leftColor;
    private Color rightColor;
    private int bottomStyle;

    CSSBorder(AttributeSet atts, StyleSheet ss) {
        int width;
        Color color;
        int style = this.getBorderStyle(atts, CSS.Attribute.BORDER_STYLE);
        if (style == -1) {
            style = 0;
        }
        this.leftStyle = this.rightStyle = style;
        this.bottomStyle = this.rightStyle;
        this.topStyle = this.rightStyle;
        style = this.getBorderStyle(atts, CSS.Attribute.BORDER_TOP_STYLE);
        if (style != -1) {
            this.topStyle = style;
        }
        if ((style = this.getBorderStyle(atts, CSS.Attribute.BORDER_BOTTOM_STYLE)) != -1) {
            this.bottomStyle = style;
        }
        if ((style = this.getBorderStyle(atts, CSS.Attribute.BORDER_LEFT_STYLE)) != -1) {
            this.leftStyle = style;
        }
        if ((style = this.getBorderStyle(atts, CSS.Attribute.BORDER_RIGHT_STYLE)) != -1) {
            this.rightStyle = style;
        }
        if ((color = this.getBorderColor(atts, CSS.Attribute.BORDER_COLOR)) == null) {
            color = Color.BLACK;
        }
        this.leftColor = this.rightColor = color;
        this.bottomColor = this.rightColor;
        this.topColor = this.rightColor;
        color = this.getBorderColor(atts, CSS.Attribute.BORDER_TOP_COLOR);
        if (color != null) {
            this.topColor = color;
        }
        if ((color = this.getBorderColor(atts, CSS.Attribute.BORDER_BOTTOM_COLOR)) != null) {
            this.bottomColor = color;
        }
        if ((color = this.getBorderColor(atts, CSS.Attribute.BORDER_LEFT_COLOR)) != null) {
            this.leftColor = color;
        }
        if ((color = this.getBorderColor(atts, CSS.Attribute.BORDER_RIGHT_COLOR)) != null) {
            this.rightColor = color;
        }
        if ((width = this.getBorderWidth(atts, CSS.Attribute.BORDER_WIDTH, ss)) == -1) {
            width = 0;
        }
        this.left = this.right = width;
        this.bottom = this.right;
        this.top = this.right;
        width = this.getBorderWidth(atts, CSS.Attribute.BORDER_TOP_WIDTH, ss);
        if (width >= 0) {
            this.top = width;
        }
        if ((width = this.getBorderWidth(atts, CSS.Attribute.BORDER_BOTTOM_WIDTH, ss)) >= 0) {
            this.bottom = width;
        }
        if ((width = this.getBorderWidth(atts, CSS.Attribute.BORDER_LEFT_WIDTH, ss)) >= 0) {
            this.left = width;
        }
        if ((width = this.getBorderWidth(atts, CSS.Attribute.BORDER_RIGHT_WIDTH, ss)) >= 0) {
            this.right = width;
        }
    }

    private int getBorderStyle(AttributeSet atts, CSS.Attribute key) {
        int style = -1;
        Object o = atts.getAttribute(key);
        if (o != null) {
            String cssStyle = o.toString();
            if (cssStyle.equals("none")) {
                style = 0;
            } else if (cssStyle.equals("hidden")) {
                style = 1;
            } else if (cssStyle.equals("dotted")) {
                style = 2;
            } else if (cssStyle.equals("dashed")) {
                style = 3;
            } else if (cssStyle.equals("solid")) {
                style = 4;
            } else if (cssStyle.equals("double")) {
                style = 5;
            } else if (cssStyle.equals("groove")) {
                style = 6;
            } else if (cssStyle.equals("ridge")) {
                style = 7;
            } else if (cssStyle.equals("inset")) {
                style = 8;
            } else if (cssStyle.equals("outset")) {
                style = 9;
            }
        }
        return style;
    }

    private Color getBorderColor(AttributeSet atts, CSS.Attribute key) {
        Object o = atts.getAttribute(key);
        Color color = null;
        if (o instanceof CSSColor) {
            CSSColor cssColor = (CSSColor)o;
            color = cssColor.getValue();
        }
        return color;
    }

    private int getBorderWidth(AttributeSet atts, CSS.Attribute key, StyleSheet ss) {
        int width = -1;
        Object o = atts.getAttribute(key);
        if (o instanceof BorderWidth) {
            BorderWidth w = (BorderWidth)o;
            w.setFontBases(ss.getEMBase(atts), ss.getEXBase(atts));
            width = (int)((BorderWidth)o).getValue();
        }
        return width;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorderLine(g, x, y + this.top / 2, x + width, y + this.top / 2, this.topStyle, this.top, this.topColor, false);
        this.paintBorderLine(g, x + this.left / 2, y, x + this.left / 2, y + height, this.leftStyle, this.left, this.leftColor, true);
        this.paintBorderLine(g, x, y + height - this.bottom / 2, x + width, y + height - this.bottom / 2, this.topStyle, this.bottom, this.bottomColor, false);
        this.paintBorderLine(g, x + width - this.right / 2, y, x + width - this.right / 2, y + height, this.topStyle, this.right, this.rightColor, true);
    }

    private void paintBorderLine(Graphics g, int x1, int y1, int x2, int y2, int style, int width, Color color, boolean vertical) {
        switch (style) {
            case 2: {
                this.paintDottedLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 3: {
                this.paintDashedLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 4: {
                this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 5: {
                this.paintDoubleLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 6: {
                this.paintGrooveLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 7: {
                this.paintRidgeLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 9: {
                this.paintOutsetLine(g, x1, y1, x2, y2, width, color, vertical);
                break;
            }
            case 8: {
                this.paintInsetLine(g, x1, y1, x2, y2, width, color, vertical);
            }
        }
    }

    private void paintDottedLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintDashedLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintSolidLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        int x = Math.min(x1, x2);
        int y = Math.min(y1, y1);
        int w = Math.abs(x2 - x1);
        int h = Math.abs(y2 - y1);
        if (vertical) {
            w = width;
            x -= width / 2;
        } else {
            h = width;
            y -= width / 2;
        }
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    private void paintDoubleLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintGrooveLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintRidgeLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintOutsetLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }

    private void paintInsetLine(Graphics g, int x1, int y1, int x2, int y2, int width, Color color, boolean vertical) {
        this.paintSolidLine(g, x1, y1, x2, y2, width, color, vertical);
    }
}

