#!/bin/sh
export PATH='/usr/obj/ports/hs-stringsearch-0.3.6.6/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: stringsearch
version: 0.3.6.6
id: stringsearch-0.3.6.6-5hTIUIGsWIKNxUQdkmLyz
key: stringsearch-0.3.6.6-5hTIUIGsWIKNxUQdkmLyz
license: BSD3
copyright: (c) 2007-2011
           Daniel Fischer, Chris Kuklewicz, Justin Bailey
maintainer: daniel.is.fischer@googlemail.com
homepage: https://bitbucket.org/dafis/stringsearch
synopsis: Fast searching, splitting and replacing of ByteStrings
description:
    This package provides several functions to quickly
    search for substrings in strict or lazy ByteStrings.
    It also provides functions for breaking or splitting
    on substrings and replacing all occurrences of a
    substring (the first in case of overlaps) with another.
    GHC before 6.10 are no longer supported, other compilers
    only if they support BangPatterns. If you need it to
    work with other compilers, send a feature request.
category: Text, Search
author: Daniel Fischer, Chris Kuklewicz, Justin Bailey
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Lazy.Search Data.ByteString.Lazy.Search.DFA
    Data.ByteString.Lazy.Search.KMP
    Data.ByteString.Lazy.Search.KarpRabin Data.ByteString.Search
    Data.ByteString.Search.BoyerMoore Data.ByteString.Search.DFA
    Data.ByteString.Search.KMP Data.ByteString.Search.KarpRabin
    Data.ByteString.Search.KnuthMorrisPratt
    Data.ByteString.Search.Substitution
hidden-modules: Data.ByteString.Search.Internal.BoyerMoore
                Data.ByteString.Search.Internal.KnuthMorrisPratt
                Data.ByteString.Search.Internal.Utils
                Data.ByteString.Lazy.Search.Internal.BoyerMoore
abi: 9abbf0911a35c60f0dbe1fe47725b17e
trusted: False
import-dirs: /usr/local/lib/ghc/stringsearch-0.3.6.6
library-dirs: /usr/local/lib/ghc/stringsearch-0.3.6.6
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-stringsearch-0.3.6.6
hs-libraries: HSstringsearch-0.3.6.6-5hTIUIGsWIKNxUQdkmLyz
depends:
    array-0.5.2.0 base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
abi-depends: array-0.5.2.0=697bb2e271f4abe8dd4fe94a4528e7cb
             base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=2a4bbfd60b4f148922e8caf44d9009f9
             containers-0.5.10.2=2ff387bb382d9f510ffcf8f3ed2013c5
haddock-interfaces: /usr/local/share/doc/hs-stringsearch-0.3.6.6/html/stringsearch.haddock
haddock-html: /usr/local/share/doc/hs-stringsearch-0.3.6.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

