#!/bin/sh
export PATH='/usr/obj/ports/hs-tf-random-0.5/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: tf-random
version: 0.5
id: tf-random-0.5-ABwehMmciu8CuAFbHLp6To
key: tf-random-0.5-ABwehMmciu8CuAFbHLp6To
license: BSD3
maintainer: Michał Pałka <michal.palka@chalmers.se>
synopsis: High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.
    .
    The package provides the following:
    .
    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.
    .
    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.
    .
    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.
    .
    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.
    .
    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.
    .
    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.
category: Random
author: Michał Pałka <michal.palka@chalmers.se>
exposed: True
indefinite: False
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances
abi: e332b2012c365e09d0cbf5aebb217985
trusted: False
import-dirs: /usr/local/lib/ghc/tf-random-0.5
library-dirs: /usr/local/lib/ghc/tf-random-0.5
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-tf-random-0.5
hs-libraries: HStf-random-0.5-ABwehMmciu8CuAFbHLp6To
depends:
    base-4.10.1.0 primitive-0.6.2.0-EI3NK1Xfv9zEcRtyXK2EwZ
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We time-1.8.0.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             primitive-0.6.2.0-EI3NK1Xfv9zEcRtyXK2EwZ=622abf4c3fd8efd3335672bab3510630
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=079775dbbb7035e99fa63cf766329cec
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
haddock-interfaces: /usr/local/share/doc/hs-tf-random-0.5/html/tf-random.haddock
haddock-html: /usr/local/share/doc/hs-tf-random-0.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

