/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.accessor.GetFieldAccessor;
import jd.core.model.classfile.accessor.GetStaticAccessor;
import jd.core.model.classfile.accessor.InvokeMethodAccessor;
import jd.core.model.classfile.accessor.PutFieldAccessor;
import jd.core.model.classfile.accessor.PutStaticAccessor;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.util.SignatureUtil;

public class AccessorAnalyzer {
    public static void Analyze(ClassFile classFile, Method method) {
        if (AccessorAnalyzer.SearchGetStaticAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.SearchPutStaticAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.SearchGetFieldAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.SearchPutFieldAccessor(classFile, method)) {
            return;
        }
        AccessorAnalyzer.SearchInvokeMethodAccessor(classFile, method);
    }

    private static boolean SearchGetStaticAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.opcode != 273) {
            return false;
        }
        instruction = ((ReturnInstruction)instruction).valueref;
        if (instruction.opcode != 178) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).index);
        if (cfr.class_index != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.descriptor_index);
        if (methodDescriptor.charAt(1) != ')') {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.name_index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        classFile.addAccessor(methodName, methodDescriptor, new GetStaticAccessor(1, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean SearchPutStaticAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 2) {
            return false;
        }
        if (list.get((int)1).opcode != 177) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.opcode != 179) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((PutStatic)instruction).index);
        if (cfr.class_index != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.descriptor_index);
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.GetParameterSignatureCount(methodDescriptor) != 1) {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.name_index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        classFile.addAccessor(methodName, methodDescriptor, new PutStaticAccessor(2, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean SearchGetFieldAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.opcode != 273) {
            return false;
        }
        instruction = ((ReturnInstruction)instruction).valueref;
        if (instruction.opcode != 180) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((GetField)instruction).index);
        if (cfr.class_index != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.descriptor_index);
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.GetParameterSignatureCount(methodDescriptor) != 1) {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.name_index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        classFile.addAccessor(methodName, methodDescriptor, new GetFieldAccessor(3, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean SearchPutFieldAccessor(ClassFile classFile, Method method) {
        PutField pf;
        List<Instruction> list = method.getInstructions();
        switch (list.size()) {
            case 2: {
                if (list.get((int)1).opcode != 177) {
                    return false;
                }
                Instruction instruction = list.get(0);
                if (instruction.opcode != 181) {
                    return false;
                }
                pf = (PutField)instruction;
                break;
            }
            case 3: {
                if (list.get((int)0).opcode != 264) {
                    return false;
                }
                if (list.get((int)2).opcode != 273) {
                    return false;
                }
                Instruction instruction = list.get(1);
                if (instruction.opcode != 181) {
                    return false;
                }
                pf = (PutField)instruction;
                break;
            }
            default: {
                return false;
            }
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(pf.index);
        if (cfr.class_index != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.descriptor_index);
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.GetParameterSignatureCount(methodDescriptor) != 2) {
            return false;
        }
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.name_and_type_index);
        String methodName = constants.getConstantUtf8(method.name_index);
        String fieldDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        String fieldName = constants.getConstantUtf8(cnat.name_index);
        classFile.addAccessor(methodName, methodDescriptor, new PutFieldAccessor(4, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean SearchInvokeMethodAccessor(ClassFile classFile, Method method) {
        InvokeInstruction ii;
        Instruction instruction;
        List<Instruction> list = method.getInstructions();
        switch (list.size()) {
            case 1: {
                instruction = list.get(0);
                if (instruction.opcode != 273) {
                    return false;
                }
                instruction = ((ReturnInstruction)instruction).valueref;
                break;
            }
            case 2: {
                instruction = list.get(1);
                if (instruction.opcode != 177) {
                    return false;
                }
                instruction = list.get(0);
                break;
            }
            default: {
                return false;
            }
        }
        switch (instruction.opcode) {
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (insi.objectref.opcode != 25 || ((ALoad)insi.objectref).index != 0) {
                    return false;
                }
                ii = insi;
                break;
            }
            case 184: {
                ii = (InvokeInstruction)instruction;
                break;
            }
            default: {
                return false;
            }
        }
        ConstantPool constants = classFile.getConstantPool();
        String methodName = constants.getConstantUtf8(method.name_index);
        String methodDescriptor = constants.getConstantUtf8(method.descriptor_index);
        ConstantMethodref cmr = constants.getConstantMethodref(ii.index);
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.name_and_type_index);
        String targetMethodName = constants.getConstantUtf8(cnat.name_index);
        String targetMethodDescriptor = constants.getConstantUtf8(cnat.descriptor_index);
        classFile.addAccessor(methodName, methodDescriptor, new InvokeMethodAccessor(5, classFile.getThisClassName(), ii.opcode, targetMethodName, targetMethodDescriptor, cmr.getListOfParameterSignatures(), cmr.getReturnedSignature()));
        return true;
    }
}

