/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoContent;
import com.sun.org.apache.xml.internal.security.utils.Signature11ElementProxy;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DEREncodedKeyValue
extends Signature11ElementProxy
implements KeyInfoContent {
    private static final String[] supportedKeyTypes = new String[]{"RSA", "DSA", "EC"};

    public DEREncodedKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public DEREncodedKeyValue(Document document, PublicKey publicKey) throws XMLSecurityException {
        super(document);
        this.addBase64Text(this.getEncodedDER(publicKey));
    }

    public DEREncodedKeyValue(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public void setId(String string) {
        if (string != null) {
            this.constructionElement.setAttributeNS(null, "Id", string);
            this.constructionElement.setIdAttributeNS(null, "Id", true);
        } else {
            this.constructionElement.removeAttributeNS(null, "Id");
        }
    }

    public String getId() {
        return this.constructionElement.getAttributeNS(null, "Id");
    }

    @Override
    public String getBaseLocalName() {
        return "DEREncodedKeyValue";
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        byte[] byArray = this.getBytesFromTextChild();
        for (String string : supportedKeyTypes) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                if (publicKey == null) continue;
                return publicKey;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
        }
        throw new XMLSecurityException("DEREncodedKeyValue.UnsupportedEncodedKey");
    }

    protected byte[] getEncodedDER(PublicKey publicKey) throws XMLSecurityException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            X509EncodedKeySpec x509EncodedKeySpec = keyFactory.getKeySpec(publicKey, X509EncodedKeySpec.class);
            return x509EncodedKeySpec.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{publicKey.getAlgorithm(), publicKey.getFormat(), publicKey.getClass().getName()};
            throw new XMLSecurityException("DEREncodedKeyValue.UnsupportedPublicKey", objectArray, noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Object[] objectArray = new Object[]{publicKey.getAlgorithm(), publicKey.getFormat(), publicKey.getClass().getName()};
            throw new XMLSecurityException("DEREncodedKeyValue.UnsupportedPublicKey", objectArray, invalidKeySpecException);
        }
    }
}

