/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync.diff;

import java.io.File;
import java.io.IOException;
import javax.swing.text.Document;
import org.netbeans.modules.php.project.connections.TmpLocalFile;
import org.netbeans.modules.php.project.connections.sync.diff.Bundle;
import org.netbeans.modules.php.project.connections.sync.diff.TmpLocalFileStreamSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;

public class EditableTmpLocalFileStreamSource
extends TmpLocalFileStreamSource {
    private final EditorCookie editorCookie;
    private final Document document;

    public EditableTmpLocalFileStreamSource(String name, TmpLocalFile tmpFile, String mimeType, String charsetName, boolean remote) throws IOException {
        super(name, tmpFile, mimeType, charsetName, remote);
        this.editorCookie = this.getEditorCookie(tmpFile);
        this.document = this.getDocument();
    }

    public boolean isEditable() {
        return true;
    }

    public Lookup getLookup() {
        if (this.document == null) {
            return super.getLookup();
        }
        return Lookups.fixed((Object[])new Object[]{this.document});
    }

    private Document getDocument() throws IOException {
        if (this.editorCookie == null) {
            return null;
        }
        try {
            return this.editorCookie.openDocument();
        }
        catch (UserQuestionException uqe) {
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)uqe.getLocalizedMessage(), Bundle.EditableTmpLocalFileStreamSource_open_confirm(), 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION)) {
                uqe.confirmed();
                return this.editorCookie.openDocument();
            }
            return null;
        }
    }

    public boolean save() throws IOException {
        if (this.editorCookie == null) {
            return false;
        }
        if (this.editorCookie.isModified()) {
            this.editorCookie.saveDocument();
            return true;
        }
        return false;
    }

    private EditorCookie getEditorCookie(TmpLocalFile tmpFile) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)new File(tmpFile.getAbsolutePath()));
        assert (fileObject != null) : "Fileobject for tmp local file not found: " + tmpFile;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
    }
}

