/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.ui.ProjectNameProvider;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ProjectFolder
extends JPanel
implements ItemListener,
DocumentListener,
ChangeListener {
    private static final long serialVersionUID = 7976754658427748L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ProjectNameProvider projectNameProvider;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton projectFolderBrowseButton;
    private JCheckBox projectFolderCheckBox;
    private JLabel projectFolderLabel;
    private JScrollPane projectFolderScrollPane;
    private JTextField projectFolderTextField;
    private JTextPane projectFolderTextPane;

    public ProjectFolder(ProjectNameProvider projectNameProvider, SourcesFolderProvider sourcesFolderProvider) {
        this.projectNameProvider = projectNameProvider;
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.projectFolderCheckBox.addItemListener(this);
        this.projectFolderTextField.getDocument().addDocumentListener(this);
        this.sourcesFolderProvider.addChangeListener(this);
    }

    void addProjectFolderListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeProjectFolderListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    boolean isProjectFolderUsed() {
        return this.projectFolderCheckBox.isSelected();
    }

    void setProjectFolderUsed(boolean used) {
        this.projectFolderCheckBox.setSelected(used);
        this.setState(used);
    }

    String getProjectFolder() {
        return this.projectFolderTextField.getText().trim();
    }

    void setProjectFolder(String projectFolder) {
        this.projectFolderTextField.setText(projectFolder);
    }

    void setState(boolean enabled) {
        this.projectFolderLabel.setEnabled(enabled);
        this.projectFolderTextField.setEnabled(enabled);
        this.projectFolderBrowseButton.setEnabled(enabled);
        this.setWarning(enabled);
    }

    private void setWarning(boolean enabled) {
        boolean visible;
        boolean bl = visible = enabled && this.isProjectDifferentFromSources();
        if (this.projectFolderScrollPane.isVisible() != visible) {
            this.projectFolderScrollPane.setVisible(visible);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isProjectDifferentFromSources() {
        File sources = FileUtil.normalizeFile((File)this.sourcesFolderProvider.getSourcesFolder());
        File project = FileUtil.normalizeFile((File)new File(this.getProjectFolder()));
        return !Utils.subdirectories(sources.getAbsolutePath(), project.getAbsolutePath());
    }

    private void initComponents() {
        this.projectFolderCheckBox = new JCheckBox();
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.projectFolderBrowseButton = new JButton();
        this.projectFolderScrollPane = new JScrollPane();
        this.projectFolderTextPane = new JTextPane();
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderCheckBox, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SeparateProjectFolder"));
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_MetadataFolder"));
        this.projectFolderLabel.setEnabled(false);
        this.projectFolderTextField.setColumns(20);
        this.projectFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderBrowseButton, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_BrowseProject"));
        this.projectFolderBrowseButton.setEnabled(false);
        this.projectFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectFolder.this.projectFolderBrowseButtonActionPerformed(evt);
            }
        });
        this.projectFolderScrollPane.setBorder(null);
        this.projectFolderTextPane.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.projectFolderTextPane.setBorder(null);
        this.projectFolderTextPane.setFont(new Font("Dialog", 1, 12));
        this.projectFolderTextPane.setText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderScrollPane.setViewportView(this.projectFolderTextPane);
        this.projectFolderTextPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextPane.AccessibleContext.accessibleName"));
        this.projectFolderTextPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextPane.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectFolderCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.projectFolderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderTextField, -1, 242, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderBrowseButton)).addComponent(this.projectFolderScrollPane, -1, 485, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.projectFolderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectFolderTextField, -2, -1, -2).addComponent(this.projectFolderLabel).addComponent(this.projectFolderBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectFolderScrollPane)));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleName"));
        this.projectFolderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderCheckBox.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleName"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleName"));
        this.projectFolderBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderBrowseButton.AccessibleContext.accessibleDescription"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane1.AccessibleContext.accessibleName"));
        this.projectFolderScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.projectFolderScrollPane1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectFolder.class, (String)"ProjectFolder.AccessibleContext.accessibleDescription"));
    }

    private void projectFolderBrowseButtonActionPerformed(ActionEvent evt) {
        File newLocation = Utils.browseLocationAction("nb.php.new.project", NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SelectProjectFolder"));
        if (newLocation != null) {
            this.setProjectFolder(new File(newLocation, this.projectNameProvider.getProjectName()).getAbsolutePath());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setState(e.getStateChange() == 1);
        this.changeSupport.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processUpdate();
    }

    private void processUpdate() {
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setState(this.projectFolderCheckBox.isSelected());
    }
}

