/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree.traversal;

import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class BuildingDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final DependencyNodeVisitor visitor;
    private final Stack<DependencyNode> parentNodes;
    private DependencyNode rootNode;

    public BuildingDependencyNodeVisitor() {
        this(null);
    }

    public BuildingDependencyNodeVisitor(DependencyNodeVisitor visitor) {
        this.visitor = visitor;
        this.parentNodes = new Stack();
    }

    public boolean visit(DependencyNode node) {
        DependencyNode newNode = new DependencyNode(node.getArtifact(), node.getState(), node.getRelatedArtifact());
        newNode.setOriginalScope(node.getOriginalScope());
        newNode.setFailedUpdateScope(node.getFailedUpdateScope());
        newNode.setPremanagedVersion(node.getPremanagedVersion());
        newNode.setPremanagedScope(node.getPremanagedScope());
        if (this.parentNodes.empty()) {
            this.rootNode = newNode;
        } else {
            DependencyNode parentNode = this.parentNodes.peek();
            parentNode.addChild(newNode);
        }
        this.parentNodes.push(newNode);
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        this.parentNodes.pop();
        if (this.parentNodes.empty() && this.visitor != null) {
            this.rootNode.accept(this.visitor);
        }
        return true;
    }

    public DependencyNodeVisitor getDependencyNodeVisitor() {
        return this.visitor;
    }

    public DependencyNode getDependencyTree() {
        return this.rootNode;
    }
}

