/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLock;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class StatusAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/show_changes.png";
    private static final int enabledForStatus = -2;

    public StatusAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ShowChanges";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -2;
    }

    @Override
    public void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = SvnUtils.getCurrentContext(nodes);
        SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
        stc.setContentTitle(this.getContextDisplayName(nodes));
        stc.setContext(ctx);
        stc.open();
        stc.requestActive();
        stc.performRefreshAction();
    }

    public static void executeStatus(Context context, SvnProgressSupport support, boolean contactServer) {
        if (context == null || context.getRoots().isEmpty()) {
            return;
        }
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(context, support);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            Subversion.getInstance().getStatusCache().refreshCached(context);
            File[] roots = context.getRootFiles();
            for (int i = 0; i < roots.length; ++i) {
                StatusAction.executeStatus(roots[i], client, support, contactServer);
                if (!support.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException ex) {
            if (!support.isCanceled()) {
                support.annotate(ex);
            }
            Subversion.LOG.log(Level.INFO, "Action canceled", ex);
        }
    }

    public static void executeStatus(File root, SvnClient client, SvnProgressSupport support, boolean contactServer) throws SVNClientException {
        ISVNStatus[] statuses;
        HashMap<File, ISVNLock> locks;
        block12: {
            if (support != null && support.isCanceled()) {
                return;
            }
            locks = new HashMap<File, ISVNLock>();
            try {
                statuses = client.getStatus(root, true, false, contactServer);
                if (!contactServer || !SvnModuleConfig.getDefault().isGetRemoteLocks()) break block12;
                try {
                    ISVNDirEntryWithLock[] entries;
                    ISVNInfo info = client.getInfoFromWorkingCopy(root);
                    if (info != null && info.getUrl() != null && !info.isCopied() && (entries = client.getListWithLocks(info.getUrl(), (SVNRevision)info.getRevision(), (SVNRevision)info.getRevision(), true)) != null) {
                        for (ISVNDirEntryWithLock entry : entries) {
                            if (entry.getLock() == null) continue;
                            locks.put(root.isFile() ? root : new File(root, entry.getDirEntry().getPath().replace("/", File.separator)), entry.getLock());
                        }
                    }
                }
                catch (SVNClientException ex) {
                    Subversion.LOG.log(SvnClientExceptionHandler.isNotUnderVersionControl(ex.getMessage()) || SvnClientExceptionHandler.isWrongUrl(ex.getMessage()) ? Level.FINE : Level.INFO, null, ex);
                }
            }
            catch (SVNClientException ex) {
                if (contactServer && SvnClientExceptionHandler.isNotUnderVersionControl(ex.getMessage())) {
                    Subversion.LOG.log(Level.INFO, "StatusAction.executeStatus: file under {0} not under version control, trying offline", root.getAbsolutePath());
                    statuses = client.getStatus(root, true, false, false);
                }
                throw ex;
            }
        }
        if (support != null && support.isCanceled()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int s = 0; s < statuses.length; ++s) {
            if (support != null && support.isCanceled()) {
                return;
            }
            ISVNStatus status = statuses[s];
            File file = status.getFile();
            if (file.isDirectory() && status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                cache.refreshRecursively(file);
                continue;
            }
            cache.refresh(file, new FileStatusCache.RepositoryStatus(status, (ISVNLock)locks.get(file)));
        }
    }
}

