/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.ui.wizard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.html.ojet.ui.wizard.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class NewJetModuleWizardPanelUi
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(NewJetModuleWizardPanelUi.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile String name;
    private volatile String jsFolder;
    private volatile String htmlFolder;
    private volatile String createdJsFile;
    private volatile String createdHtmlFile;
    @NullAllowed
    private Project project;
    private JLabel createdHtmlFileLabel;
    private JTextField createdHtmlFileTextField;
    private JLabel createdJsFileLabel;
    private JTextField createdJsFileTextField;
    private JButton htmlFolderBrowseButton;
    private JLabel htmlFolderLabel;
    private JTextField htmlFolderTextField;
    private JButton jsFolderBrowseButton;
    private JLabel jsFolderLabel;
    private JTextField jsFolderTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel projectLabel;
    private JTextField projectTextField;

    NewJetModuleWizardPanelUi() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setName(Bundle.NewJetModuleWizardPanelUi_name());
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.nameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.jsFolderTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.htmlFolderTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    String getFileName() {
        return this.name;
    }

    void setFileName(String fileName) {
        assert (EventQueue.isDispatchThread());
        assert (fileName != null);
        this.nameTextField.setText(fileName);
    }

    boolean hasProject() {
        assert (EventQueue.isDispatchThread());
        return this.project != null;
    }

    void setProject(Project project) {
        assert (EventQueue.isDispatchThread());
        this.project = project;
        this.setProjectName();
    }

    String getJsFolder() {
        return this.jsFolder;
    }

    void setJsFolder(String folder) {
        assert (EventQueue.isDispatchThread());
        assert (folder != null);
        this.jsFolderTextField.setText(folder);
    }

    String getHtmlFolder() {
        return this.htmlFolder;
    }

    void setHtmlFolder(String folder) {
        assert (EventQueue.isDispatchThread());
        assert (folder != null);
        this.htmlFolderTextField.setText(folder);
    }

    @CheckForNull
    public String getCreatedJsFile() {
        return this.createdJsFile;
    }

    @CheckForNull
    public String getCreatedHtmlFile() {
        return this.createdHtmlFile;
    }

    private void setProjectName() {
        assert (EventQueue.isDispatchThread());
        String projectName = this.project != null ? ProjectUtils.getInformation((Project)this.project).getDisplayName() : Bundle.NewJetModuleWizardPanelUi_project_none();
        this.projectTextField.setText(projectName);
    }

    void updateCreatedFiles() {
        assert (EventQueue.isDispatchThread());
        if (this.project == null || this.name == null || this.name.trim().isEmpty()) {
            this.createdJsFile = null;
            this.createdHtmlFile = null;
            this.createdJsFileTextField.setText("");
            this.createdHtmlFileTextField.setText("");
            return;
        }
        File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String jsPart = this.jsFolder + "/" + this.name + ".js";
        String htmlPart = this.htmlFolder + "/" + this.name + ".html";
        this.createdJsFile = new File(projectDir, jsPart.replace('/', File.separatorChar)).getAbsolutePath();
        this.createdHtmlFile = new File(projectDir, htmlPart.replace('/', File.separatorChar)).getAbsolutePath();
        this.createdJsFileTextField.setText(this.createdJsFile);
        this.createdHtmlFileTextField.setText(this.createdHtmlFile);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void selectFolder(JTextField component) {
        if (this.project == null) {
            LOGGER.log(Level.INFO, "Project is required");
            return;
        }
        FileObject projectDirectory = this.project.getProjectDirectory();
        File selectedDir = new FileChooserBuilder(NewJetModuleWizardPanelUi.class).setTitle(Bundle.NewJetModuleWizardPanelUi_chooser_folder_title()).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)projectDirectory)).forceUseOfDefaultWorkingDirectory(true).setDirectoriesOnly(true).setFileHiding(true).showOpenDialog();
        if (selectedDir == null) {
            return;
        }
        FileObject newDir = FileUtil.toFileObject((File)selectedDir);
        assert (newDir != null) : selectedDir;
        String relativePath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)newDir);
        if (relativePath == null) {
            component.setText(selectedDir.getAbsolutePath());
        } else {
            component.setText(relativePath);
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.jsFolderLabel = new JLabel();
        this.jsFolderTextField = new JTextField();
        this.jsFolderBrowseButton = new JButton();
        this.htmlFolderLabel = new JLabel();
        this.htmlFolderTextField = new JTextField();
        this.htmlFolderBrowseButton = new JButton();
        this.createdJsFileLabel = new JLabel();
        this.createdJsFileTextField = new JTextField();
        this.createdHtmlFileLabel = new JLabel();
        this.createdHtmlFileTextField = new JTextField();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.nameLabel.text"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.projectLabel.text"));
        this.projectTextField.setEditable(false);
        this.jsFolderLabel.setLabelFor(this.jsFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jsFolderLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.jsFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jsFolderBrowseButton, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.jsFolderBrowseButton.text"));
        this.jsFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewJetModuleWizardPanelUi.this.jsFolderBrowseButtonActionPerformed(evt);
            }
        });
        this.htmlFolderLabel.setLabelFor(this.htmlFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.htmlFolderLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.htmlFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.htmlFolderBrowseButton, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.htmlFolderBrowseButton.text"));
        this.htmlFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewJetModuleWizardPanelUi.this.htmlFolderBrowseButtonActionPerformed(evt);
            }
        });
        this.createdJsFileLabel.setLabelFor(this.createdJsFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdJsFileLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.createdJsFileLabel.text"));
        this.createdJsFileTextField.setEditable(false);
        this.createdHtmlFileLabel.setLabelFor(this.createdHtmlFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdHtmlFileLabel, (String)NbBundle.getMessage(NewJetModuleWizardPanelUi.class, (String)"NewJetModuleWizardPanelUi.createdHtmlFileLabel.text"));
        this.createdHtmlFileTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.htmlFolderLabel).addComponent(this.jsFolderLabel).addComponent(this.projectLabel).addComponent(this.nameLabel).addComponent(this.createdJsFileLabel).addComponent(this.createdHtmlFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.htmlFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.htmlFolderBrowseButton)).addComponent(this.createdHtmlFileTextField).addComponent(this.createdJsFileTextField).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectTextField).addComponent(this.jsFolderTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jsFolderBrowseButton)).addComponent(this.nameTextField, GroupLayout.Alignment.TRAILING))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jsFolderLabel).addComponent(this.jsFolderBrowseButton).addComponent(this.jsFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.htmlFolderLabel).addComponent(this.htmlFolderTextField, -2, -1, -2).addComponent(this.htmlFolderBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdJsFileTextField, -2, -1, -2).addComponent(this.createdJsFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdHtmlFileTextField, -2, -1, -2).addComponent(this.createdHtmlFileLabel))));
    }

    private void jsFolderBrowseButtonActionPerformed(ActionEvent evt) {
        this.selectFolder(this.jsFolderTextField);
    }

    private void htmlFolderBrowseButtonActionPerformed(ActionEvent evt) {
        this.selectFolder(this.htmlFolderTextField);
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            NewJetModuleWizardPanelUi.this.name = NewJetModuleWizardPanelUi.this.nameTextField.getText();
            NewJetModuleWizardPanelUi.this.jsFolder = NewJetModuleWizardPanelUi.this.jsFolderTextField.getText();
            NewJetModuleWizardPanelUi.this.htmlFolder = NewJetModuleWizardPanelUi.this.htmlFolderTextField.getText();
            NewJetModuleWizardPanelUi.this.updateCreatedFiles();
            NewJetModuleWizardPanelUi.this.fireChange();
        }
    }
}

