/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.clientproject.browser.ClientProjectEnhancedBrowserImpl;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.openide.filesystems.FileObject;

public class RefreshOnSaveListenerImpl
implements RefreshOnSaveListener {
    private final BrowserSupport support;
    private final Project project;
    private ClientProjectEnhancedBrowserImpl cfg;

    public RefreshOnSaveListenerImpl(Project project, BrowserSupport support, ClientProjectEnhancedBrowserImpl cfg) {
        this.support = support;
        this.project = project;
        this.cfg = cfg;
    }

    public void fileChanged(FileObject fo) {
        if (!this.cfg.isAutoRefresh()) {
            return;
        }
        if (this.support.ignoreChange(fo)) {
            return;
        }
        URL u = this.support.getBrowserURL(fo, true);
        if (u != null && this.support.canReload(u)) {
            this.support.reload(u);
        }
    }

    public void fileDeleted(FileObject fo) {
    }
}

